/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JFrame;
import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.Callback;
import org.bridj.Demangler;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.NativeLibrary;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ValuedEnum;
import org.bridj.ann.Convention;
import org.bridj.ann.Field;
import org.bridj.ann.Library;
import org.bridj.ann.Name;
import org.bridj.ann.Ptr;
import org.bridj.ann.Runtime;
import org.bridj.ann.Virtual;
import org.bridj.cpp.CPPObject;
import org.bridj.cpp.CPPRuntime;
import org.bridj.jawt.JAWTUtils;

@Library(value="test")
@Runtime(value=CPPRuntime.class)
public class TestCPP {
    static NativeLibrary library;

    public static void print(String name, long addr, int n, int minI) {
        System.out.println(name);
        for (int i = -1; i < n; ++i) {
            long v = TestCPP.getPtr(addr + (long)(i * Pointer.SIZE));
            Demangler.Symbol sym = BridJ.getSymbolByAddress(v);
            String sname = sym == null ? null : sym.getName();
            System.out.println("\tOffset " + i + ":\t" + TestCPP.hex(v) + " \t('" + sname + "')");
            if (v == 0L && i >= minI) break;
        }
        System.out.println();
    }

    public static native char test_incr_char(char var0);

    public static native int testAddDyncall(int var0, int var1);

    public static native ValuedEnum<ETest> testEnum(ValuedEnum<ETest> var0);

    static int[] createExpectedInts(int n) {
        int[] expected = new int[n];
        for (int i = 0; i < n; ++i) {
            expected[i] = i + 1;
        }
        return expected;
    }

    public static void testSetGetIntBuffer(int n) {
        int[] expected = TestCPP.createExpectedInts(n);
        Pointer<Integer> p = Pointer.pointerToInts(expected);
        long peer = p.getPeer();
        Iterator it = p.iterator();
        for (int i = 0; i < n; ++i) {
            Integer obVal = (Integer)it.next();
            int val = obVal;
            if (val == expected[i]) continue;
            throw new RuntimeException("at position i = " + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try {
            JFrame f = new JFrame();
            f.setVisible(true);
            long hwndVal = JAWTUtils.getNativePeerHandle(f);
            System.out.println("#\n# hwndVal = " + hwndVal + "\n#");
            BridJ.register();
            ValuedEnum<ETest> t = TestCPP.testEnum(ETest.eFirst);
            if (t != ETest.eFirst) {
                throw new RuntimeException();
            }
            TestCPP.testSetGetIntBuffer(10);
            BridJ.register(MyCallback.class);
            BridJ.register();
            int ra = TestCPP.testAddDyncall(10, 4);
            if (ra != 14) {
                throw new RuntimeException("Expected 14, got " + ra);
            }
            ra = TestCPP.testAddDyncall(10, 4);
            if (ra != 14) {
                throw new RuntimeException("Expected 14, got " + ra);
            }
            TestCPP.testNativeTargetCallbacks();
            TestCPP.testJavaTargetCallbacks();
            return;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            System.in.read();
        }
    }

    static String hex(long v) {
        return Long.toHexString(v);
    }

    static long getPtr(long peer) {
        Pointer<?> ptr = Pointer.pointerToAddress(peer);
        return ptr.getSizeT(0L);
    }

    public static void testJavaTargetCallbacks() {
        int res = TestCPP.forwardCall(new MyCallback(){

            @Override
            public int doSomething(int a, int b) {
                return a + b * 10;
            }
        }.toPointer(), 1, 2);
        if (res != 21) {
            throw new RuntimeException();
        }
        res = TestCPP.forwardCall(new MyCallback(){

            @Override
            public int doSomething(int a, int b) {
                return a + b;
            }
        }.toPointer(), 1, 2);
        if (res != 3) {
            throw new RuntimeException();
        }
    }

    public static void testNativeTargetCallbacks() {
        long rawadder = TestCPP.getAdder_raw();
        if (rawadder != 0L) {
            System.out.println("Returned non null raw adder, cool (" + Long.toHexString(rawadder) + ") !");
        } else {
            System.out.println("Returned null raw adder !");
        }
        long longadder = TestCPP.getAdder_long();
        if (longadder != 0L) {
            System.out.println("Returned non null longadder, cool (" + Long.toHexString(longadder) + ") !");
        } else {
            System.out.println("Returned null longadder !");
        }
        long getAdder_pvoid = TestCPP.getAdder_pvoid();
        if (getAdder_pvoid != 0L) {
            System.out.println("Returned non null getAdder_pvoid, cool (" + Long.toHexString(getAdder_pvoid) + ") !");
        } else {
            System.out.println("Returned null getAdder_pvoid !");
        }
        Pointer<MyCallback> ptr = TestCPP.getAdder();
        if (ptr == null) {
            throw new RuntimeException("getAdder returned null adder !!!");
        }
        MyCallback adder = ptr.getNativeObject(MyCallback.class);
        int res = adder.doSomething(1, 2);
        if (res != 3) {
            throw new RuntimeException("Expected 3, got " + res);
        }
    }

    static native int forwardCall(Pointer<MyCallback> var0, int var1, int var2);

    static native Pointer<MyCallback> getAdder();

    @Name(value="getAdder")
    @Ptr
    static native long getAdder_raw();

    @Ptr
    static native long getAdder_pvoid();

    static native long getAdder_long();

    public static abstract class MyCallback
    extends Callback {
        public abstract int doSomething(int var1, int var2);
    }

    @Library(value="test")
    static class Ctest
    extends CPPObject {
        Ctest() {
        }

        @Ptr
        static native long createTest();

        @Virtual
        public native int testVirtualAdd(int var1, int var2);

        public native int testAdd(int var1, int var2);

        @Virtual
        @Convention(value=Convention.Style.StdCall)
        public native int testVirtualAddStdCall(Pointer<?> var1, int var2, int var3);

        @Convention(value=Convention.Style.StdCall)
        public native int testAddStdCall(Pointer<?> var1, int var2, int var3);

        static {
            BridJ.register();
        }
    }

    public static class MyStruct
    extends StructObject {
        @Field(value=0)
        public native int a();

        public native void a(int var1);

        @Field(value=1)
        public native double b();

        public native void b(double var1);
    }

    public static enum ETest implements ValuedEnum<ETest>
    {
        eFirst(0),
        eSecond(1),
        eThird(2);

        final int value;

        private ETest(int value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Iterator<ETest> iterator() {
            return Collections.singleton(this).iterator();
        }

        public static ValuedEnum<ETest> fromValue(long value) {
            return FlagSet.fromValue((long)value, (Enum[])ETest.values());
        }
    }

    @Library(value="test")
    @Runtime(value=CRuntime.class)
    public static class FunctionTest {
        public FunctionTest() {
            BridJ.register(this.getClass());
        }

        public native int testAddDyncall(int var1, int var2);

        public void add() {
            int a = 10;
            int b = 4;
            int exp = a + b;
            int res = this.testAddDyncall(a, b);
            if (res != exp) {
                throw new RuntimeException("Got " + res + " (" + Integer.toHexString(res) + ") instead of " + exp + " (" + Integer.toHexString(exp));
            }
        }
    }

    public static enum Toto implements IntValuedEnum<Toto>
    {
        IBV_SYSFS_NAME_MAX(64),
        IBV_SYSFS_PATH_MAX(256);

        public final int value;

        private Toto(int value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Iterator<Toto> iterator() {
            return Collections.singleton(this).iterator();
        }

        public static ValuedEnum<Toto> fromValue(long value) {
            return FlagSet.fromValue((long)value, (Enum[])Toto.values());
        }
    }
}

