/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bridj.CommonPointerIOs;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.StructObject;
import org.bridj.TypedPointer;
import org.bridj.ValuedEnum;
import org.bridj.ann.Alignment;
import org.bridj.ann.Array;
import org.bridj.ann.Bits;
import org.bridj.ann.Field;
import org.bridj.ann.Struct;
import org.bridj.ann.Virtual;
import org.bridj.ann.Wide;

public class StructIO {
    static Map<Type, StructIO> structIOs = new HashMap<Type, StructIO>();
    protected PointerIO<?> pointerIO;
    protected volatile FieldDesc[] fields;
    private int structSize = -1;
    private int structAlignment = -1;
    protected final Class<?> structClass;
    protected final Type structType;
    SolidRanges solidRanges;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructIO getInstance(Class structClass, Type structType) {
        Map<Type, StructIO> map = structIOs;
        synchronized (map) {
            StructIO io = structIOs.get(structType == null ? structClass : structType);
            if (io == null) {
                io = new StructIO(structClass, structType);
                StructIO.registerStructIO(structClass, structType, io);
            }
            return io;
        }
    }

    public static synchronized StructIO registerStructIO(Class structClass, Type structType, StructIO io) {
        structIOs.put(structType, io);
        return io;
    }

    public StructIO(Class<?> structClass, Type structType) {
        this.structClass = structClass;
        this.structType = structType;
    }

    boolean isVirtual() {
        for (Method m : this.structClass.getMethods()) {
            if (m.getAnnotation(Virtual.class) == null) continue;
            return true;
        }
        return false;
    }

    public Class<?> getStructClass() {
        return this.structClass;
    }

    public Type getStructType() {
        return this.structType;
    }

    public synchronized PointerIO<?> getPointerIO() {
        if (this.pointerIO == null) {
            this.pointerIO = new CommonPointerIOs.StructPointerIO(this);
        }
        return this.pointerIO;
    }

    protected int alignSize(int size, int alignment) {
        int r;
        if (alignment != 1 && (r = size % alignment) != 0) {
            size += alignment - r;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build() {
        if (this.fields == null) {
            StructIO structIO = this;
            synchronized (structIO) {
                if (this.fields == null) {
                    this.fields = this.computeStructLayout();
                }
            }
        }
    }

    Object[] createRefreshableFieldsArray() {
        return new Object[this.fields.length];
    }

    public final int getStructSize() {
        return this.structSize;
    }

    public final int getStructAlignment() {
        return this.structAlignment;
    }

    protected void orderFields(List<FieldDecl> fields) {
        Collections.sort(fields, new Comparator<FieldDecl>(){

            @Override
            public int compare(FieldDecl o1, FieldDecl o2) {
                int d = o1.index - o2.index;
                if (d != 0) {
                    return d;
                }
                if (o1.declaringClass.isAssignableFrom(o2.declaringClass)) {
                    return -1;
                }
                if (o2.declaringClass.isAssignableFrom(o1.declaringClass)) {
                    return 1;
                }
                throw new RuntimeException("Failed to order fields " + o2.name + " and " + o2.name);
            }
        });
    }

    protected boolean acceptFieldGetter(Method method, boolean getter) {
        if (method.getParameterTypes().length != (getter ? 0 : 1)) {
            return false;
        }
        if (getter && method.getAnnotation(Field.class) == null) {
            return false;
        }
        int modifiers = method.getModifiers();
        return !Modifier.isStatic(modifiers);
    }

    protected FieldDecl createFieldDecl(Method getter) {
        FieldDecl field = new FieldDecl();
        field.getter = getter;
        field.valueType = getter.getGenericReturnType();
        field.valueClass = getter.getReturnType();
        field.declaringClass = getter.getDeclaringClass();
        String name = getter.getName();
        if (name.matches("get[A-Z].*")) {
            name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        field.name = name;
        Field fil = getter.getAnnotation(Field.class);
        Bits bits = getter.getAnnotation(Bits.class);
        Array arr = getter.getAnnotation(Array.class);
        if (fil != null) {
            field.index = fil.value();
        }
        if (bits != null) {
            field.desc.bitLength = bits.value();
        }
        if (arr != null) {
            long length = 1L;
            for (long dim : arr.value()) {
                length *= dim;
            }
            field.desc.arrayLength = length;
        }
        field.isWide = getter.getAnnotation(Wide.class) != null;
        return field;
    }

    protected List<FieldDecl> listFields() {
        ArrayList<FieldDecl> list = new ArrayList<FieldDecl>();
        for (Method method : this.structClass.getMethods()) {
            if (!this.acceptFieldGetter(method, true)) continue;
            FieldDecl io = this.createFieldDecl(method);
            try {
                Method setter = this.structClass.getMethod(method.getName(), io.valueClass);
                if (this.acceptFieldGetter(setter, false)) {
                    io.setter = setter;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (io == null) continue;
            list.add(io);
        }
        ArrayList classes = new ArrayList();
        Class<?> c = this.structClass;
        do {
            c = c.getSuperclass();
            classes.add(c);
        } while (Struct.class.isAssignableFrom(c));
        Collections.reverse(classes);
        for (Class clazz : classes) {
            for (java.lang.reflect.Field field : this.structClass.getDeclaredFields()) {
            }
        }
        return list;
    }

    protected int primTypeLength(Class<?> primType) {
        if (primType == Integer.TYPE) {
            return 4;
        }
        if (primType == Long.TYPE) {
            return 8;
        }
        if (primType == Short.TYPE) {
            return 2;
        }
        if (primType == Byte.TYPE) {
            return 1;
        }
        if (primType == Float.TYPE) {
            return 4;
        }
        if (primType == Double.TYPE) {
            return 8;
        }
        if (Pointer.class.isAssignableFrom(primType)) {
            return 8;
        }
        throw new UnsupportedOperationException("Field type " + primType.getName() + " not supported yet");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FieldDesc[] computeStructLayout() {
        List<FieldDecl> list = this.listFields();
        this.orderFields(list);
        Alignment alignment = this.structClass.getAnnotation(Alignment.class);
        this.structAlignment = alignment != null ? alignment.value() : 1;
        boolean refreshableFieldCount = false;
        this.structSize = 0;
        if (this.isVirtual()) {
            this.structSize += Pointer.SIZE;
        }
        int cumulativeBitOffset = 0;
        for (FieldDecl field : list) {
            field.desc.byteOffset = this.structSize;
            if (field.valueClass.isPrimitive()) {
                field.desc.byteLength = this.primTypeLength(field.valueClass);
            } else if (StructObject.class.isAssignableFrom(field.valueClass)) {
                field.desc.nativeTypeOrPointerTargetType = field.valueType;
                StructIO io = StructIO.getInstance(field.valueClass, field.valueType);
                field.desc.byteLength = io.getStructSize();
            } else if (ValuedEnum.class.isAssignableFrom(field.valueClass)) {
                field.desc.nativeTypeOrPointerTargetType = field.valueType instanceof ParameterizedType ? PointerIO.getClass(((ParameterizedType)field.valueType).getActualTypeArguments()[0]) : null;
                Class<?> c = PointerIO.getClass(field.desc.nativeTypeOrPointerTargetType);
                if (!IntValuedEnum.class.isAssignableFrom(c)) throw new RuntimeException("Enum type unknown : " + c);
                field.desc.byteLength = 4;
            } else if (TypedPointer.class.isAssignableFrom(field.valueClass)) {
                field.desc.nativeTypeOrPointerTargetType = field.valueType;
                field.desc.byteLength = Pointer.SIZE;
            } else if (Pointer.class.isAssignableFrom(field.valueClass)) {
                field.desc.nativeTypeOrPointerTargetType = field.valueType instanceof ParameterizedType ? ((ParameterizedType)field.valueType).getActualTypeArguments()[0] : null;
                field.desc.byteLength = Pointer.SIZE;
            } else if (Buffer.class.isAssignableFrom(field.valueClass)) {
                if (field.valueClass == IntBuffer.class) {
                    field.desc.byteLength = 4;
                } else if (field.valueClass == LongBuffer.class) {
                    field.desc.byteLength = 8;
                } else if (field.valueClass == ShortBuffer.class) {
                    field.desc.byteLength = 2;
                } else if (field.valueClass == ByteBuffer.class) {
                    field.desc.byteLength = 1;
                } else if (field.valueClass == FloatBuffer.class) {
                    field.desc.byteLength = 4;
                } else {
                    if (field.valueClass != DoubleBuffer.class) throw new UnsupportedOperationException("Field array type " + field.valueClass.getName() + " not supported yet");
                    field.desc.byteLength = 8;
                }
            } else if (field.valueClass.isArray() && field.valueClass.getComponentType().isPrimitive()) {
                field.desc.byteLength = this.primTypeLength(field.valueClass.getComponentType());
            } else {
                StructIO io = StructIO.getInstance(field.valueClass, field.valueType);
                int s = io.getStructSize();
                if (s <= 0) throw new UnsupportedOperationException("Field type " + field.valueClass.getName() + " not supported yet");
                field.desc.byteLength = s;
            }
            if (field.desc.bitLength < 0) {
                if (cumulativeBitOffset != 0) {
                    cumulativeBitOffset = 0;
                    ++this.structSize;
                }
                int fieldAlignment = field.desc.byteLength;
                this.structAlignment = Math.max(this.structAlignment, fieldAlignment);
                this.structSize = this.alignSize(this.structSize, fieldAlignment);
            }
            field.desc.byteOffset = this.structSize;
            field.desc.bitOffset = cumulativeBitOffset;
            if (field.desc.bitLength >= 0) {
                field.desc.byteLength = (field.desc.bitLength >>> 3) + ((field.desc.bitLength & 7) != 0 ? 1 : 0);
                this.structSize += (cumulativeBitOffset += field.desc.bitLength) >>> 3;
                cumulativeBitOffset &= 7;
                continue;
            }
            this.structSize = (int)((long)this.structSize + field.desc.arrayLength * (long)field.desc.byteLength);
        }
        if (cumulativeBitOffset > 0) {
            this.structSize = this.alignSize(this.structSize + 1, this.structAlignment);
        } else if (this.structSize > 0) {
            this.structSize = this.alignSize(this.structSize, this.structAlignment);
        }
        ArrayList<FieldDesc> filtered = new ArrayList<FieldDesc>();
        for (FieldDecl fio : list) {
            if (fio.declaringClass == null || !fio.declaringClass.equals(this.structClass)) continue;
            filtered.add(fio.desc);
        }
        SolidRanges.Builder b = new SolidRanges.Builder();
        for (FieldDesc f : filtered) {
            b.add(f);
        }
        this.solidRanges = b.toSolidRanges();
        return filtered.toArray(new FieldDesc[filtered.size()]);
    }

    public boolean equal(StructObject a, StructObject b) {
        return this.compare(a, b) == 0;
    }

    public int compare(StructObject a, StructObject b) {
        Pointer<StructObject> pA = Pointer.pointerTo(a);
        Pointer<StructObject> pB = Pointer.pointerTo(b);
        if (pA == null || pB == null) {
            return pA != null ? 1 : (pB != null ? -1 : 0);
        }
        long[] offsets = this.solidRanges.offsets;
        long[] lengths = this.solidRanges.lengths;
        int n = offsets.length;
        for (int i = 0; i < n; ++i) {
            long offset = offsets[i];
            long length = lengths[i];
            int cmp = pA.compareBytes(offset, pB, offset, length);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public final <T> Pointer<T> getPointerField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        Pointer p = struct.peer.getPointer((long)fd.byteOffset, fd.nativeTypeOrPointerTargetType);
        if (fd.arrayLength != 1L) {
            p = p.validElements(fd.arrayLength);
        }
        return p;
    }

    public final <T> void setPointerField(StructObject struct, int fieldIndex, Pointer<T> value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setPointer(fd.byteOffset, value);
    }

    public final <T extends TypedPointer> T getTypedPointerField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        PointerIO pio = PointerIO.getInstance(fd.nativeTypeOrPointerTargetType);
        return (T)((TypedPointer)pio.castTarget(struct.peer.getSizeT(fd.byteOffset)));
    }

    public final <O extends NativeObject> O getNativeObjectField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getNativeObject((long)fd.byteOffset, fd.nativeTypeOrPointerTargetType);
    }

    public final <E extends Enum<E>> ValuedEnum<E> getEnumField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return FlagSet.fromValue((long)struct.peer.getInt(fd.byteOffset), (Class)fd.nativeTypeOrPointerTargetType);
    }

    public final void setEnumField(StructObject struct, int fieldIndex, ValuedEnum<?> value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setInt(fd.byteOffset, (int)value.value());
    }

    public final void setIntField(StructObject struct, int fieldIndex, int value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setInt(fd.byteOffset, value);
    }

    public final int getIntField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getInt(fd.byteOffset);
    }

    public final void setLongField(StructObject struct, int fieldIndex, long value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setLong(fd.byteOffset, value);
    }

    public final long getLongField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getLong(fd.byteOffset);
    }

    public final void setShortField(StructObject struct, int fieldIndex, short value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setShort(fd.byteOffset, value);
    }

    public final short getShortField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getShort(fd.byteOffset);
    }

    public final void setByteField(StructObject struct, int fieldIndex, byte value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setByte(fd.byteOffset, value);
    }

    public final byte getByteField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getByte(fd.byteOffset);
    }

    public final void setCharField(StructObject struct, int fieldIndex, char value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setChar(fd.byteOffset, value);
    }

    public final char getCharField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getChar(fd.byteOffset);
    }

    public final void setFloatField(StructObject struct, int fieldIndex, float value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setFloat(fd.byteOffset, value);
    }

    public final float getFloatField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getFloat(fd.byteOffset);
    }

    public final void setDoubleField(StructObject struct, int fieldIndex, double value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setDouble(fd.byteOffset, value);
    }

    public final double getDoubleField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getDouble(fd.byteOffset);
    }

    public final void setBooleanField(StructObject struct, int fieldIndex, boolean value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setBoolean(fd.byteOffset, value);
    }

    public final boolean getBooleanField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getBoolean(fd.byteOffset);
    }

    public final void setSizeTField(StructObject struct, int fieldIndex, long value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setSizeT((long)fd.byteOffset, value);
    }

    public final long getSizeTField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getSizeT(fd.byteOffset);
    }

    public final void setCLongField(StructObject struct, int fieldIndex, long value) {
        FieldDesc fd = this.fields[fieldIndex];
        struct.peer.setCLong((long)fd.byteOffset, value);
    }

    public final long getCLongField(StructObject struct, int fieldIndex) {
        FieldDesc fd = this.fields[fieldIndex];
        return struct.peer.getCLong(fd.byteOffset);
    }

    static class SolidRanges {
        long[] offsets;
        long[] lengths;

        SolidRanges() {
        }

        static class Builder {
            List<Long> offsets = new ArrayList<Long>();
            List<Long> lengths = new ArrayList<Long>();
            long lastOffset = -1L;
            long nextOffset = 0L;
            int count;

            Builder() {
            }

            void add(FieldDesc f) {
                long offset = f.byteOffset;
                long length = f.byteLength;
                if (offset == this.lastOffset) {
                    this.lengths.set(this.count - 1, Math.max(this.lengths.get(this.count - 1), length));
                } else if (offset == this.nextOffset && this.count != 0) {
                    this.lengths.set(this.count - 1, this.lengths.get(this.count - 1) + length);
                } else {
                    this.offsets.add(offset);
                    this.lengths.add(length);
                    ++this.count;
                }
                this.lastOffset = offset;
                this.nextOffset = offset + length;
            }

            SolidRanges toSolidRanges() {
                SolidRanges r = new SolidRanges();
                r.offsets = new long[this.count];
                r.lengths = new long[this.count];
                for (int i = 0; i < this.count; ++i) {
                    r.offsets[i] = this.offsets.get(i);
                    r.lengths[i] = this.lengths.get(i);
                }
                return r;
            }
        }
    }

    protected static class FieldDecl {
        final FieldDesc desc = new FieldDesc();
        Method getter;
        Method setter;
        String name;
        int index = -1;
        Type valueType;
        Class<?> valueClass;
        Class<?> declaringClass;
        boolean isBitField;
        boolean isWide;

        protected FieldDecl() {
        }
    }

    public static class FieldDesc {
        public int byteOffset;
        public int byteLength;
        public int bitOffset;
        public int bitLength = -1;
        public long arrayLength = 1L;
        public Type nativeTypeOrPointerTargetType;
    }
}

