/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import org.bridj.CLong;
import org.bridj.Callback;
import org.bridj.CommonPointerIOs;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.TypedPointer;

public abstract class PointerIO<T> {
    final Type targetType;
    final Class<?> typedPointerClass;
    final int targetSize;
    final int targetAlignment = -1;
    static PointerIO pointerInstance;
    static Map<Type, PointerIO<?>> ios;
    static PointerIO<SizeT> sizeTInstance;
    static PointerIO<CLong> clongInstance;
    static PointerIO<Integer> intInstance;
    static PointerIO<Long> longInstance;
    static PointerIO<Short> shortInstance;
    static PointerIO<Byte> byteInstance;
    static PointerIO<Character> charInstance;
    static PointerIO<Float> floatInstance;
    static PointerIO<Double> doubleInstance;
    static PointerIO<Boolean> booleanInstance;
    static PointerIO stringInstance;

    public PointerIO(Type targetType, int targetSize, Class<?> typedPointerClass) {
        this.targetType = targetType;
        this.targetSize = targetSize;
        this.typedPointerClass = typedPointerClass;
    }

    abstract T get(Pointer<T> var1, long var2);

    abstract void set(Pointer<T> var1, long var2, T var4);

    public Object getArray(Pointer<T> pointer, long byteOffset, int length) {
        return pointer.offset(byteOffset).toArray(length);
    }

    public void setArray(Pointer<T> pointer, long byteOffset, Object array) {
        Object[] a = (Object[])array;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            this.set(pointer, i, a[i]);
        }
    }

    public T castTarget(long peer) {
        throw new UnsupportedOperationException("Cannot cast pointer to " + this.targetType);
    }

    PointerIO<Pointer<T>> getReferenceIO() {
        return new CommonPointerIOs.PointerPointerIO(this);
    }

    public long getTargetSize() {
        return this.targetSize;
    }

    public int getTargetAlignment() {
        return (int)this.getTargetSize();
    }

    public boolean isTypedPointer() {
        return this.typedPointerClass != null;
    }

    public Class<?> getTypedPointerClass() {
        return this.typedPointerClass;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return PointerIO.getClass(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    public static synchronized PointerIO<Pointer> getPointerInstance() {
        if (pointerInstance == null) {
            pointerInstance = PointerIO.getPointerInstance((PointerIO)null);
        }
        return pointerInstance;
    }

    public static <T> PointerIO<Pointer<T>> getPointerInstance(Type target) {
        return PointerIO.getPointerInstance(PointerIO.getInstance(target));
    }

    public static <T> PointerIO<Pointer<T>> getPointerInstance(PointerIO<T> targetIO) {
        return new CommonPointerIOs.PointerPointerIO<T>(targetIO);
    }

    public static <T> PointerIO<Pointer<T>> getArrayInstance(PointerIO<T> targetIO, long[] dimensions, int iDimension) {
        return new CommonPointerIOs.PointerArrayIO<T>(targetIO, dimensions, iDimension);
    }

    static <T> PointerIO<T> getArrayIO(Object array) {
        if (array instanceof int[]) {
            return PointerIO.getIntInstance();
        }
        if (array instanceof long[]) {
            return PointerIO.getLongInstance();
        }
        if (array instanceof short[]) {
            return PointerIO.getShortInstance();
        }
        if (array instanceof byte[]) {
            return PointerIO.getByteInstance();
        }
        if (array instanceof char[]) {
            return PointerIO.getCharInstance();
        }
        if (array instanceof float[]) {
            return PointerIO.getFloatInstance();
        }
        if (array instanceof double[]) {
            return PointerIO.getDoubleInstance();
        }
        if (array instanceof boolean[]) {
            return PointerIO.getBooleanInstance();
        }
        return PointerIO.getInstance(array.getClass().getComponentType());
    }

    public static synchronized <S extends StructObject> PointerIO<S> getInstance(StructIO s) {
        return new CommonPointerIOs.StructPointerIO(s);
    }

    public static synchronized <P> PointerIO<P> getInstance(Type type) {
        PointerIO<Object> io = ios.get(type);
        if (io == null) {
            Class cl;
            Class clazz = type instanceof Class ? (Class)type : (cl = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : null);
            if (type == Integer.TYPE || type == Integer.class) {
                io = CommonPointerIOs.intIO;
            } else if (type == Long.TYPE || type == Long.class) {
                io = CommonPointerIOs.longIO;
            } else if (type == Short.TYPE || type == Short.class) {
                io = CommonPointerIOs.shortIO;
            } else if (type == Byte.TYPE || type == Byte.class) {
                io = CommonPointerIOs.byteIO;
            } else if (type == Character.TYPE || type == Character.class) {
                io = CommonPointerIOs.charIO;
            } else if (type == Float.TYPE || type == Float.class) {
                io = CommonPointerIOs.floatIO;
            } else if (type == Double.TYPE || type == Double.class) {
                io = CommonPointerIOs.doubleIO;
            } else if (type == Boolean.TYPE || type == Boolean.class) {
                io = CommonPointerIOs.booleanIO;
            } else if (cl != null && Pointer.class.equals((Object)cl)) {
                io = PointerIO.getPointerInstance();
            } else if (cl != null && TypedPointer.class.isAssignableFrom(cl)) {
                io = new CommonPointerIOs.TypedPointerPointerIO(cl);
            } else if (cl != null && SizeT.class.isAssignableFrom(cl)) {
                io = CommonPointerIOs.sizeTIO;
            } else if (cl != null && CLong.class.isAssignableFrom(cl)) {
                io = CommonPointerIOs.clongIO;
            } else if (cl != null && StructObject.class.isAssignableFrom(cl)) {
                io = PointerIO.getInstance(StructIO.getInstance(cl, type));
            } else if (cl != null && Callback.class.isAssignableFrom(cl)) {
                io = new CommonPointerIOs.CallbackPointerIO(cl);
            }
            ios.put(type, io);
        }
        return io;
    }

    public static PointerIO<SizeT> getSizeTInstance() {
        if (sizeTInstance == null) {
            sizeTInstance = PointerIO.getInstance(SizeT.class);
        }
        return sizeTInstance;
    }

    public static PointerIO<CLong> getCLongInstance() {
        if (clongInstance == null) {
            clongInstance = PointerIO.getInstance(CLong.class);
        }
        return clongInstance;
    }

    public static PointerIO<Integer> getIntInstance() {
        if (intInstance == null) {
            intInstance = PointerIO.getInstance(Integer.class);
        }
        return intInstance;
    }

    public static PointerIO<Long> getLongInstance() {
        if (longInstance == null) {
            longInstance = PointerIO.getInstance(Long.class);
        }
        return longInstance;
    }

    public static PointerIO<Short> getShortInstance() {
        if (shortInstance == null) {
            shortInstance = PointerIO.getInstance(Short.class);
        }
        return shortInstance;
    }

    public static PointerIO<Byte> getByteInstance() {
        if (byteInstance == null) {
            byteInstance = PointerIO.getInstance(Byte.class);
        }
        return byteInstance;
    }

    public static PointerIO<Character> getCharInstance() {
        if (charInstance == null) {
            charInstance = PointerIO.getInstance(Character.class);
        }
        return charInstance;
    }

    public static PointerIO<Float> getFloatInstance() {
        if (floatInstance == null) {
            floatInstance = PointerIO.getInstance(Float.class);
        }
        return floatInstance;
    }

    public static PointerIO<Double> getDoubleInstance() {
        if (doubleInstance == null) {
            doubleInstance = PointerIO.getInstance(Double.class);
        }
        return doubleInstance;
    }

    public static PointerIO<Boolean> getBooleanInstance() {
        if (booleanInstance == null) {
            booleanInstance = PointerIO.getInstance(Boolean.class);
        }
        return booleanInstance;
    }

    public static <P> PointerIO<P> getBufferPrimitiveInstance(Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            return PointerIO.getIntInstance();
        }
        if (buffer instanceof LongBuffer) {
            return PointerIO.getLongInstance();
        }
        if (buffer instanceof ShortBuffer) {
            return PointerIO.getShortInstance();
        }
        if (buffer instanceof ByteBuffer) {
            return PointerIO.getByteInstance();
        }
        if (buffer instanceof CharBuffer) {
            return PointerIO.getCharInstance();
        }
        if (buffer instanceof FloatBuffer) {
            return PointerIO.getFloatInstance();
        }
        if (buffer instanceof DoubleBuffer) {
            return PointerIO.getDoubleInstance();
        }
        throw new UnsupportedOperationException();
    }

    public static synchronized PointerIO<String> getStringInstance() {
        if (stringInstance == null) {
            stringInstance = PointerIO.getInstance(String.class);
        }
        return stringInstance;
    }

    static {
        ios = new HashMap();
    }
}

