/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.bridj.BridJ;
import org.bridj.CLong;
import org.bridj.CRuntime;
import org.bridj.CommonPointerIOs;
import org.bridj.IntValuedEnum;
import org.bridj.JNI;
import org.bridj.NativeObject;
import org.bridj.PointerIO;
import org.bridj.SizeT;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.TypedPointer;
import org.bridj.Utils;
import org.bridj.util.DefaultParameterizedType;

public class Pointer<T>
implements Comparable<Pointer<?>>,
List<T> {
    public static final Pointer NULL = null;
    public static final int SIZE = JNI.POINTER_SIZE;
    private static long UNKNOWN_VALIDITY;
    private static long NO_PARENT;
    private final PointerIO<T> io;
    private final long peer;
    private final long offsetInParent;
    private final Pointer<?> parent;
    private Object sibling;
    private final long validStart;
    private final long validEnd;
    private final boolean ordered;
    static FreeReleaser freeReleaser;

    Pointer(PointerIO<T> io, long peer) {
        this(io, peer, true, UNKNOWN_VALIDITY, UNKNOWN_VALIDITY, null, 0L, null);
    }

    Pointer(PointerIO<T> io, long peer, boolean ordered, long validStart, long validEnd, Pointer<?> parent, long offsetInParent, Object sibling) {
        this.io = io;
        this.peer = peer;
        this.ordered = ordered;
        this.validStart = validStart;
        this.validEnd = validEnd;
        this.parent = parent;
        this.offsetInParent = offsetInParent;
        this.sibling = sibling;
    }

    public static Type pointerType(Type targetType) {
        return DefaultParameterizedType.paramType(Pointer.class, new Type[]{targetType});
    }

    public static <E extends Enum<E>> Type intEnumType(Class<? extends IntValuedEnum<E>> targetType) {
        return DefaultParameterizedType.paramType(IntValuedEnum.class, new Type[]{targetType});
    }

    public void release() {
        if (this.sibling instanceof Pointer) {
            ((Pointer)this.sibling).release();
        }
        this.sibling = null;
    }

    @Override
    public int compareTo(Pointer<?> p) {
        long p2;
        if (p == null) {
            return 1;
        }
        long p1 = this.getPeer();
        return p1 == (p2 = p.getPeer()) ? 0 : (p1 < p2 ? -1 : 1);
    }

    public int compareBytes(Pointer<?> other, long byteCount) {
        return this.compareBytes(0L, other, 0L, byteCount);
    }

    public int compareBytes(long byteOffset, Pointer<?> other, long otherByteOffset, long byteCount) {
        return JNI.memcmp(this.getCheckedPeer(byteOffset, byteCount), super.getCheckedPeer(otherByteOffset, byteCount), byteCount);
    }

    @Override
    public int hashCode() {
        int hc = new Long(this.getPeer()).hashCode();
        return hc;
    }

    private final long getCheckedPeer(long byteOffset, long validityCheckLength) {
        long offsetPeer = this.getPeer() + byteOffset;
        if (this.validStart != UNKNOWN_VALIDITY && (offsetPeer < this.validStart || offsetPeer + validityCheckLength > this.validEnd)) {
            throw new IndexOutOfBoundsException("Cannot access to memory data of length " + validityCheckLength + " at offset " + (offsetPeer - this.getPeer()) + " : valid memory start is " + this.validStart + ", valid memory size is " + (this.validEnd - this.validStart));
        }
        return offsetPeer;
    }

    public Pointer<T> offset(long byteOffset) {
        return this.offset(byteOffset, this.getIO());
    }

    <U> Pointer<U> offset(long byteOffset, PointerIO<U> pio) {
        Object newSibling;
        if (byteOffset == 0L) {
            return pio == this.io ? this : this.withIO(pio);
        }
        long newPeer = this.getPeer() + byteOffset;
        Object object = newSibling = this.getSibling() != null ? this.getSibling() : this;
        if (this.validStart == UNKNOWN_VALIDITY) {
            return Pointer.newPointer(pio, newPeer, this.ordered, UNKNOWN_VALIDITY, UNKNOWN_VALIDITY, null, NO_PARENT, null, newSibling);
        }
        if (newPeer >= this.validEnd || newPeer < this.validStart) {
            throw new IndexOutOfBoundsException("Invalid pointer offset !");
        }
        return Pointer.newPointer(pio, newPeer, this.ordered, this.validStart, this.validEnd, null, NO_PARENT, null, newSibling);
    }

    public Pointer<T> validBytes(long byteCount) {
        long peer = this.getPeer();
        long newValidEnd = peer + byteCount;
        if (this.validStart == 0L && this.validEnd == newValidEnd) {
            return this;
        }
        if (this.validEnd != UNKNOWN_VALIDITY && newValidEnd > this.validEnd) {
            throw new IndexOutOfBoundsException("Cannot extend validity of pointed memory from " + this.validEnd + " to " + newValidEnd);
        }
        Object newSibling = this.getSibling() != null ? this.getSibling() : this;
        return Pointer.newPointer(this.getIO(), peer, this.ordered, peer, newValidEnd, this.parent, this.offsetInParent, null, newSibling);
    }

    public Pointer<T> validElements(long elementCount) {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot define elements validity");
        }
        return this.validBytes(elementCount * io.getTargetSize());
    }

    public Pointer<Pointer<T>> getReference() {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot get reference to this pointer, it wasn't created from Pointer.getPointer(offset) or from a similar method.");
        }
        PointerIO<T> io = this.getIO();
        return this.parent.offset(this.offsetInParent).withIO(io == null ? null : io.getReferenceIO());
    }

    public final long getPeer() {
        return this.peer;
    }

    public <U> Pointer<U> withIO(PointerIO<U> newIO) {
        return this.cloneAs(this.isOrdered(), newIO);
    }

    public Pointer<T> order(ByteOrder order) {
        if (order.equals(ByteOrder.nativeOrder()) == this.isOrdered()) {
            return this;
        }
        return this.cloneAs(!this.isOrdered(), this.getIO());
    }

    public ByteOrder order() {
        return this.isOrdered() ? ByteOrder.nativeOrder() : (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    <U> Pointer<U> cloneAs(boolean ordered, PointerIO<U> newIO) {
        if (newIO == this.io && ordered == this.isOrdered()) {
            return this;
        }
        return Pointer.newPointer(newIO, this.getPeer(), ordered, this.getValidStart(), this.getValidEnd(), this.getParent(), this.getOffsetInParent(), null, this.getSibling() != null ? this.getSibling() : this);
    }

    public final PointerIO<T> getIO() {
        return this.io;
    }

    final boolean isOrdered() {
        return this.ordered;
    }

    final long getOffsetInParent() {
        return this.offsetInParent;
    }

    final Pointer<?> getParent() {
        return this.parent;
    }

    final Object getSibling() {
        return this.sibling;
    }

    final long getValidEnd() {
        return this.validEnd;
    }

    final long getValidStart() {
        return this.validStart;
    }

    public <U> Pointer<U> asPointerTo(Type type) {
        PointerIO pio = PointerIO.getInstance(type);
        return this.withIO(pio);
    }

    public <U> Pointer<U> as(Class<U> type) {
        return this.asPointerTo(type);
    }

    public long getValidBytes() {
        long ve = this.getValidEnd();
        return ve == UNKNOWN_VALIDITY ? -1L : ve - this.getPeer();
    }

    public long getValidElements() {
        long bytes = this.getValidBytes();
        long elementSize = this.getTargetSize();
        if (bytes < 0L || elementSize <= 0L) {
            return -1L;
        }
        return bytes / elementSize;
    }

    @Override
    public ListIterator<T> iterator() {
        return new ListIterator<T>(){
            Pointer<T> next;
            Pointer<T> previous;
            {
                this.next = Pointer.this.getValidElements() > 0L ? Pointer.this : null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object value = this.next.get();
                this.previous = this.next;
                this.next = this.next.getValidElements() > 1L ? this.next.next(1L) : null;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                long rem;
                return this.next != null && ((rem = this.next.getValidBytes()) < 0L || rem > 0L);
            }

            @Override
            public void add(T o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previous != null;
            }

            @Override
            public int nextIndex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public T previous() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int previousIndex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(T o) {
                if (this.previous == null) {
                    throw new NoSuchElementException("You haven't called next() prior to calling ListIterator.set(E)");
                }
                this.previous.set(o);
            }
        };
    }

    public static <N extends NativeObject> Pointer<N> pointerTo(N instance) {
        return Pointer.pointerTo(instance, null);
    }

    public static <R extends NativeObject> Pointer<R> pointerTo(NativeObject instance, Class<R> targetType) {
        return instance == null ? null : instance.peer;
    }

    public static long getAddress(NativeObject instance, Class targetType) {
        return Pointer.getPeer(Pointer.pointerTo(instance, targetType));
    }

    public <O extends NativeObject> O getNativeObject(long byteOffset, Type type) {
        return BridJ.createNativeObjectFromPointer(this, type);
    }

    public <O extends NativeObject> O getNativeObject(long byteOffset, Class<O> type) {
        return this.getNativeObject(byteOffset, (Type)type);
    }

    public <O extends NativeObject> O getNativeObject(Class<O> type) {
        return this.getNativeObject(0L, type);
    }

    public <O extends NativeObject> O getNativeObject(Type type) {
        O o = this.getNativeObject(0L, type);
        return o;
    }

    public boolean isAligned() {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot check alignment");
        }
        return this.isAligned(io.getTargetAlignment());
    }

    public boolean isAligned(int alignment) {
        return Pointer.isAligned(this.getPeer(), alignment);
    }

    protected static boolean isAligned(long address, int alignment) {
        switch (alignment) {
            case 1: {
                return true;
            }
            case 2: {
                return (address & 1L) == 0L;
            }
            case 4: {
                return (address & 3L) == 0L;
            }
            case 8: {
                return (address & 7L) == 0L;
            }
            case 16: {
                return (address & 0xFL) == 0L;
            }
            case 32: {
                return (address & 0x1FL) == 0L;
            }
            case 64: {
                return (address & 0x3FL) == 0L;
            }
        }
        return address % (long)alignment == 0L;
    }

    public T get() {
        return this.get(0);
    }

    public T get(long index) {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot get pointed value");
        }
        return io.get(this, index);
    }

    public T set(T value) {
        return this.set(0, value);
    }

    static void throwBecauseUntyped(String message) {
        throw new RuntimeException("Pointer is not typed (call Pointer.asPointerTo(Type) to create a typed pointer) : " + message);
    }

    static void throwUnexpected(Throwable ex) {
        throw new RuntimeException("Unexpected error", ex);
    }

    public T set(long index, T value) {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot set pointed value");
        }
        io.set(this, index, value);
        return value;
    }

    public static long getPeer(Pointer<?> pointer) {
        return pointer == null ? 0L : pointer.getPeer();
    }

    public long getTargetSize() {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot compute target size");
        }
        return io.getTargetSize();
    }

    public Pointer<T> next() {
        return this.next(1L);
    }

    public Pointer<T> next(long delta) {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot get pointers to next or previous targets");
        }
        return this.offset(io.getTargetSize() * delta);
    }

    public static void release(Pointer ... pointers) {
        for (Pointer pointer : pointers) {
            if (pointer == null) continue;
            pointer.release();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Pointer)) {
            return false;
        }
        Pointer p = (Pointer)obj;
        return this.getPeer() == p.getPeer();
    }

    @Deprecated
    public static Pointer<?> pointerToAddress(long peer) {
        return Pointer.newPointer(null, peer, true, UNKNOWN_VALIDITY, UNKNOWN_VALIDITY, null, NO_PARENT, null, null);
    }

    @Deprecated
    public static Pointer<?> pointerToAddress(long peer, long size) {
        return Pointer.newPointer(null, peer, true, peer, peer + size, null, NO_PARENT, null, null);
    }

    public static Pointer<?> pointerToAddress(long peer, Class<?> targetClass, Releaser releaser) {
        return Pointer.newPointer(PointerIO.getInstance(targetClass), peer, true, UNKNOWN_VALIDITY, UNKNOWN_VALIDITY, null, -1L, null, null);
    }

    static <P> Pointer<P> pointerToAddress(long peer, PointerIO<P> io) {
        return Pointer.newPointer(io, peer, true, UNKNOWN_VALIDITY, UNKNOWN_VALIDITY, null, NO_PARENT, null, null);
    }

    static <P> Pointer<P> pointerToAddress(long peer, PointerIO<P> io, Releaser releaser) {
        return Pointer.newPointer(io, peer, true, UNKNOWN_VALIDITY, UNKNOWN_VALIDITY, null, NO_PARENT, releaser, null);
    }

    @Deprecated
    public static Pointer<?> pointerToAddress(long peer, Releaser releaser) {
        return Pointer.newPointer(null, peer, true, UNKNOWN_VALIDITY, UNKNOWN_VALIDITY, null, NO_PARENT, releaser, null);
    }

    public static Pointer<?> pointerToAddress(long peer, long size, Releaser releaser) {
        return Pointer.newPointer(null, peer, true, peer, peer + size, null, NO_PARENT, releaser, null);
    }

    @Deprecated
    public static <P> Pointer<P> pointerToAddress(long peer, Class<P> targetClass) {
        return Pointer.newPointer(PointerIO.getInstance(targetClass), peer, true, UNKNOWN_VALIDITY, UNKNOWN_VALIDITY, null, -1L, null, null);
    }

    static <U> Pointer<U> pointerToAddress(long peer, long size, PointerIO<U> io) {
        return Pointer.newPointer(io, peer, true, peer, peer + size, null, NO_PARENT, null, null);
    }

    static <U> Pointer<U> newPointer(PointerIO<U> io, long peer, boolean ordered, long validStart, long validEnd, Pointer<?> parent, long offsetInParent, final Releaser releaser, Object sibling) {
        long size;
        if (peer == 0L) {
            return null;
        }
        if (validEnd != UNKNOWN_VALIDITY && (size = validEnd - validStart) <= 0L) {
            return null;
        }
        if (releaser == null) {
            return new Pointer<U>(io, peer, ordered, validStart, validEnd, parent, offsetInParent, sibling);
        }
        assert (sibling == null);
        return new Pointer<U>(io, peer, ordered, validStart, validEnd, parent, offsetInParent, sibling){
            private Releaser rel;
            {
                super(x0, x1, x2, x3, x4, x5, x6, x7);
                this.rel = releaser;
            }

            @Override
            public synchronized void release() {
                if (this.rel != null) {
                    this.rel.release(this);
                    this.rel = null;
                }
            }

            protected void finalize() {
                this.release();
            }
        };
    }

    public static <P extends TypedPointer> Pointer<P> allocateTypedPointer(Class<P> type) {
        return Pointer.allocate(PointerIO.getInstance(type));
    }

    public static <P extends TypedPointer> Pointer<P> allocateTypedPointers(Class<P> type, long arrayLength) {
        return Pointer.allocateArray(PointerIO.getInstance(type), arrayLength);
    }

    public static <P> Pointer<Pointer<P>> allocatePointer(Class<P> targetType) {
        return Pointer.allocate(PointerIO.getPointerInstance(targetType));
    }

    public static <P> Pointer<Pointer<P>> allocatePointer(Type targetType) {
        return Pointer.allocate(PointerIO.getPointerInstance(targetType));
    }

    public static <P> Pointer<Pointer<Pointer<P>>> allocatePointerPointer(Type targetType) {
        return Pointer.allocatePointer(Pointer.pointerType(targetType));
    }

    public static <P> Pointer<Pointer<Pointer<P>>> allocatePointerPointer(Class<P> targetType) {
        return Pointer.allocatePointerPointer(targetType);
    }

    public static <V> Pointer<Pointer<?>> allocatePointer() {
        return Pointer.allocate(PointerIO.getPointerInstance());
    }

    public static Pointer<Pointer<?>> allocatePointers(int arrayLength) {
        return Pointer.allocateArray(PointerIO.getPointerInstance(), (long)arrayLength);
    }

    public static <P> Pointer<Pointer<P>> allocatePointers(Class<P> targetType, int arrayLength) {
        return Pointer.allocateArray(PointerIO.getPointerInstance(targetType), (long)arrayLength);
    }

    public static <P> Pointer<Pointer<P>> allocatePointers(Type targetType, int arrayLength) {
        return Pointer.allocateArray(PointerIO.getPointerInstance(targetType), (long)arrayLength);
    }

    public static <V> Pointer<V> allocate(Class<V> elementClass) {
        return Pointer.allocateArray(elementClass, 1L);
    }

    public static <V> Pointer<V> allocate(PointerIO<V> io) {
        long targetSize = io.getTargetSize();
        if (targetSize < 0L) {
            Pointer.throwBecauseUntyped("Cannot allocate array ");
        }
        return Pointer.allocateBytes(io, targetSize, null);
    }

    public static <V> Pointer<V> allocateArray(PointerIO<V> io, long arrayLength) {
        long targetSize = io.getTargetSize();
        if (targetSize < 0L) {
            Pointer.throwBecauseUntyped("Cannot allocate array ");
        }
        return Pointer.allocateBytes(io, targetSize * arrayLength, null);
    }

    public static <V> Pointer<V> allocateArray(PointerIO<V> io, long arrayLength, Releaser beforeDeallocation) {
        long targetSize = io.getTargetSize();
        if (targetSize < 0L) {
            Pointer.throwBecauseUntyped("Cannot allocate array ");
        }
        return Pointer.allocateBytes(io, targetSize * arrayLength, beforeDeallocation);
    }

    public static <V> Pointer<V> allocateBytes(PointerIO<V> io, long byteSize, final Releaser beforeDeallocation) {
        if (byteSize == 0L) {
            return null;
        }
        if (byteSize < 0L) {
            throw new IllegalArgumentException("Cannot allocate a negative amount of memory !");
        }
        long address = JNI.mallocNulled(byteSize);
        if (address == 0L) {
            throw new RuntimeException("Failed to allocate " + byteSize);
        }
        return Pointer.newPointer(io, address, true, address, address + byteSize, null, NO_PARENT, beforeDeallocation == null ? freeReleaser : new Releaser(){

            @Override
            public void release(Pointer<?> p) {
                beforeDeallocation.release(p);
                freeReleaser.release(p);
            }
        }, null);
    }

    public static <V> Pointer<V> allocateArray(Class<V> elementClass, long arrayLength) {
        if (arrayLength == 0L) {
            return null;
        }
        if (elementClass == Integer.TYPE || elementClass == Integer.class) {
            return Pointer.allocateArray(PointerIO.getIntInstance(), arrayLength);
        }
        if (elementClass == Long.TYPE || elementClass == Long.class) {
            return Pointer.allocateArray(PointerIO.getLongInstance(), arrayLength);
        }
        if (elementClass == Short.TYPE || elementClass == Short.class) {
            return Pointer.allocateArray(PointerIO.getShortInstance(), arrayLength);
        }
        if (elementClass == Byte.TYPE || elementClass == Byte.class) {
            return Pointer.allocateArray(PointerIO.getByteInstance(), arrayLength);
        }
        if (elementClass == Character.TYPE || elementClass == Character.class) {
            return Pointer.allocateArray(PointerIO.getCharInstance(), arrayLength);
        }
        if (elementClass == Float.TYPE || elementClass == Float.class) {
            return Pointer.allocateArray(PointerIO.getFloatInstance(), arrayLength);
        }
        if (elementClass == Double.TYPE || elementClass == Double.class) {
            return Pointer.allocateArray(PointerIO.getDoubleInstance(), arrayLength);
        }
        if (elementClass == Boolean.TYPE || elementClass == Boolean.class) {
            return Pointer.allocateArray(PointerIO.getBooleanInstance(), arrayLength);
        }
        if (Pointer.class.isAssignableFrom(elementClass)) {
            return Pointer.allocateArray(PointerIO.getPointerInstance(elementClass), arrayLength);
        }
        if (SizeT.class.isAssignableFrom(elementClass)) {
            return Pointer.allocateArray(PointerIO.getSizeTInstance(), arrayLength);
        }
        if (CLong.class.isAssignableFrom(elementClass)) {
            return Pointer.allocateArray(PointerIO.getCLongInstance(), arrayLength);
        }
        if (StructObject.class.isAssignableFrom(elementClass)) {
            CRuntime runtime = (CRuntime)BridJ.getRuntime(elementClass);
            StructIO sio = StructIO.getInstance(elementClass, elementClass);
            PointerIO pio = PointerIO.getInstance(sio);
            return Pointer.allocateArray(pio, arrayLength);
        }
        throw new UnsupportedOperationException("Cannot allocate memory for type " + elementClass.getName());
    }

    public static Pointer<?> pointerToBuffer(Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer instanceof IntBuffer) {
            return Pointer.pointerToInts((IntBuffer)buffer);
        }
        if (buffer instanceof LongBuffer) {
            return Pointer.pointerToLongs((LongBuffer)buffer);
        }
        if (buffer instanceof ShortBuffer) {
            return Pointer.pointerToShorts((ShortBuffer)buffer);
        }
        if (buffer instanceof ByteBuffer) {
            return Pointer.pointerToBytes((ByteBuffer)buffer);
        }
        if (buffer instanceof CharBuffer) {
            return Pointer.pointerToChars((CharBuffer)buffer);
        }
        if (buffer instanceof FloatBuffer) {
            return Pointer.pointerToFloats((FloatBuffer)buffer);
        }
        if (buffer instanceof DoubleBuffer) {
            return Pointer.pointerToDoubles((DoubleBuffer)buffer);
        }
        throw new UnsupportedOperationException();
    }

    public static Pointer<Integer> pointerToInt(int value) {
        Pointer<Integer> mem = Pointer.allocate(PointerIO.getIntInstance());
        mem.setInt(0L, value);
        return mem;
    }

    public static Pointer<Integer> pointerToInts(int ... values) {
        if (values == null) {
            return null;
        }
        Pointer<Integer> mem = Pointer.allocateArray(PointerIO.getIntInstance(), (long)values.length);
        mem.setInts(0L, values, 0, values.length);
        return mem;
    }

    public static Pointer<Pointer<Integer>> pointerToInts(int[][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        Pointer<Pointer<Integer>> mem = Pointer.allocateInts(dim1, dim2);
        for (int i1 = 0; i1 < dim1; ++i1) {
            mem.setInts((long)(i1 * dim2 * 4), values[i1], 0, dim2);
        }
        return mem;
    }

    public static Pointer<Pointer<Pointer<Integer>>> pointerToInts(int[][][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        int dim3 = values[0][0].length;
        Pointer<Pointer<Pointer<Integer>>> mem = Pointer.allocateInts(dim1, dim2, dim3);
        for (int i1 = 0; i1 < dim1; ++i1) {
            int offset1 = i1 * dim2;
            for (int i2 = 0; i2 < dim2; ++i2) {
                int offset2 = (offset1 + i2) * dim3;
                mem.setInts((long)(offset2 * 4), values[i1][i2], 0, dim3);
            }
        }
        return mem;
    }

    public static Pointer<Integer> allocateInt() {
        return Pointer.allocate(PointerIO.getIntInstance());
    }

    public static Pointer<Integer> allocateInts(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getIntInstance(), arrayLength);
    }

    public static Pointer<Pointer<Integer>> allocateInts(long dim1, long dim2) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getIntInstance(), new long[]{dim1, dim2}, 0), dim1);
    }

    public static Pointer<Pointer<Pointer<Integer>>> allocateInts(long dim1, long dim2, long dim3) {
        long[] dims = new long[]{dim1, dim2, dim3};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getIntInstance(), dims, 1), dims, 0), dim1);
    }

    public static Pointer<Long> pointerToLong(long value) {
        Pointer<Long> mem = Pointer.allocate(PointerIO.getLongInstance());
        mem.setLong(0L, value);
        return mem;
    }

    public static Pointer<Long> pointerToLongs(long ... values) {
        if (values == null) {
            return null;
        }
        Pointer<Long> mem = Pointer.allocateArray(PointerIO.getLongInstance(), (long)values.length);
        mem.setLongs(0L, values, 0, values.length);
        return mem;
    }

    public static Pointer<Pointer<Long>> pointerToLongs(long[][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        Pointer<Pointer<Long>> mem = Pointer.allocateLongs(dim1, dim2);
        for (int i1 = 0; i1 < dim1; ++i1) {
            mem.setLongs((long)(i1 * dim2 * 8), values[i1], 0, dim2);
        }
        return mem;
    }

    public static Pointer<Pointer<Pointer<Long>>> pointerToLongs(long[][][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        int dim3 = values[0][0].length;
        Pointer<Pointer<Pointer<Long>>> mem = Pointer.allocateLongs(dim1, dim2, dim3);
        for (int i1 = 0; i1 < dim1; ++i1) {
            int offset1 = i1 * dim2;
            for (int i2 = 0; i2 < dim2; ++i2) {
                int offset2 = (offset1 + i2) * dim3;
                mem.setLongs((long)(offset2 * 8), values[i1][i2], 0, dim3);
            }
        }
        return mem;
    }

    public static Pointer<Long> allocateLong() {
        return Pointer.allocate(PointerIO.getLongInstance());
    }

    public static Pointer<Long> allocateLongs(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getLongInstance(), arrayLength);
    }

    public static Pointer<Pointer<Long>> allocateLongs(long dim1, long dim2) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getLongInstance(), new long[]{dim1, dim2}, 0), dim1);
    }

    public static Pointer<Pointer<Pointer<Long>>> allocateLongs(long dim1, long dim2, long dim3) {
        long[] dims = new long[]{dim1, dim2, dim3};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getLongInstance(), dims, 1), dims, 0), dim1);
    }

    public static Pointer<Short> pointerToShort(short value) {
        Pointer<Short> mem = Pointer.allocate(PointerIO.getShortInstance());
        mem.setShort(0L, value);
        return mem;
    }

    public static Pointer<Short> pointerToShorts(short ... values) {
        if (values == null) {
            return null;
        }
        Pointer<Short> mem = Pointer.allocateArray(PointerIO.getShortInstance(), (long)values.length);
        mem.setShorts(0L, values, 0, values.length);
        return mem;
    }

    public static Pointer<Pointer<Short>> pointerToShorts(short[][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        Pointer<Pointer<Short>> mem = Pointer.allocateShorts(dim1, dim2);
        for (int i1 = 0; i1 < dim1; ++i1) {
            mem.setShorts((long)(i1 * dim2 * 2), values[i1], 0, dim2);
        }
        return mem;
    }

    public static Pointer<Pointer<Pointer<Short>>> pointerToShorts(short[][][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        int dim3 = values[0][0].length;
        Pointer<Pointer<Pointer<Short>>> mem = Pointer.allocateShorts(dim1, dim2, dim3);
        for (int i1 = 0; i1 < dim1; ++i1) {
            int offset1 = i1 * dim2;
            for (int i2 = 0; i2 < dim2; ++i2) {
                int offset2 = (offset1 + i2) * dim3;
                mem.setShorts((long)(offset2 * 2), values[i1][i2], 0, dim3);
            }
        }
        return mem;
    }

    public static Pointer<Short> allocateShort() {
        return Pointer.allocate(PointerIO.getShortInstance());
    }

    public static Pointer<Short> allocateShorts(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getShortInstance(), arrayLength);
    }

    public static Pointer<Pointer<Short>> allocateShorts(long dim1, long dim2) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getShortInstance(), new long[]{dim1, dim2}, 0), dim1);
    }

    public static Pointer<Pointer<Pointer<Short>>> allocateShorts(long dim1, long dim2, long dim3) {
        long[] dims = new long[]{dim1, dim2, dim3};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getShortInstance(), dims, 1), dims, 0), dim1);
    }

    public static Pointer<Byte> pointerToByte(byte value) {
        Pointer<Byte> mem = Pointer.allocate(PointerIO.getByteInstance());
        mem.setByte(0L, value);
        return mem;
    }

    public static Pointer<Byte> pointerToBytes(byte ... values) {
        if (values == null) {
            return null;
        }
        Pointer<Byte> mem = Pointer.allocateArray(PointerIO.getByteInstance(), (long)values.length);
        mem.setBytes(0L, values, 0, values.length);
        return mem;
    }

    public static Pointer<Pointer<Byte>> pointerToBytes(byte[][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        Pointer<Pointer<Byte>> mem = Pointer.allocateBytes(dim1, dim2);
        for (int i1 = 0; i1 < dim1; ++i1) {
            mem.setBytes((long)(i1 * dim2 * 1), values[i1], 0, dim2);
        }
        return mem;
    }

    public static Pointer<Pointer<Pointer<Byte>>> pointerToBytes(byte[][][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        int dim3 = values[0][0].length;
        Pointer<Pointer<Pointer<Byte>>> mem = Pointer.allocateBytes(dim1, (long)dim2, dim3);
        for (int i1 = 0; i1 < dim1; ++i1) {
            int offset1 = i1 * dim2;
            for (int i2 = 0; i2 < dim2; ++i2) {
                int offset2 = (offset1 + i2) * dim3;
                mem.setBytes((long)(offset2 * 1), values[i1][i2], 0, dim3);
            }
        }
        return mem;
    }

    public static Pointer<Byte> allocateByte() {
        return Pointer.allocate(PointerIO.getByteInstance());
    }

    public static Pointer<Byte> allocateBytes(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getByteInstance(), arrayLength);
    }

    public static Pointer<Pointer<Byte>> allocateBytes(long dim1, long dim2) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getByteInstance(), new long[]{dim1, dim2}, 0), dim1);
    }

    public static Pointer<Pointer<Pointer<Byte>>> allocateBytes(long dim1, long dim2, long dim3) {
        long[] dims = new long[]{dim1, dim2, dim3};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getByteInstance(), dims, 1), dims, 0), dim1);
    }

    public static Pointer<Character> pointerToChar(char value) {
        Pointer<Character> mem = Pointer.allocate(PointerIO.getCharInstance());
        mem.setChar(0L, value);
        return mem;
    }

    public static Pointer<Character> pointerToChars(char ... values) {
        if (values == null) {
            return null;
        }
        Pointer<Character> mem = Pointer.allocateArray(PointerIO.getCharInstance(), (long)values.length);
        mem.setChars(0L, values, 0, values.length);
        return mem;
    }

    public static Pointer<Pointer<Character>> pointerToChars(char[][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        Pointer<Pointer<Character>> mem = Pointer.allocateChars(dim1, dim2);
        for (int i1 = 0; i1 < dim1; ++i1) {
            mem.setChars((long)(i1 * dim2 * 2), values[i1], 0, dim2);
        }
        return mem;
    }

    public static Pointer<Pointer<Pointer<Character>>> pointerToChars(char[][][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        int dim3 = values[0][0].length;
        Pointer<Pointer<Pointer<Character>>> mem = Pointer.allocateChars(dim1, dim2, dim3);
        for (int i1 = 0; i1 < dim1; ++i1) {
            int offset1 = i1 * dim2;
            for (int i2 = 0; i2 < dim2; ++i2) {
                int offset2 = (offset1 + i2) * dim3;
                mem.setChars((long)(offset2 * 2), values[i1][i2], 0, dim3);
            }
        }
        return mem;
    }

    public static Pointer<Character> allocateChar() {
        return Pointer.allocate(PointerIO.getCharInstance());
    }

    public static Pointer<Character> allocateChars(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getCharInstance(), arrayLength);
    }

    public static Pointer<Pointer<Character>> allocateChars(long dim1, long dim2) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getCharInstance(), new long[]{dim1, dim2}, 0), dim1);
    }

    public static Pointer<Pointer<Pointer<Character>>> allocateChars(long dim1, long dim2, long dim3) {
        long[] dims = new long[]{dim1, dim2, dim3};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getCharInstance(), dims, 1), dims, 0), dim1);
    }

    public static Pointer<Float> pointerToFloat(float value) {
        Pointer<Float> mem = Pointer.allocate(PointerIO.getFloatInstance());
        mem.setFloat(0L, value);
        return mem;
    }

    public static Pointer<Float> pointerToFloats(float ... values) {
        if (values == null) {
            return null;
        }
        Pointer<Float> mem = Pointer.allocateArray(PointerIO.getFloatInstance(), (long)values.length);
        mem.setFloats(0L, values, 0, values.length);
        return mem;
    }

    public static Pointer<Pointer<Float>> pointerToFloats(float[][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        Pointer<Pointer<Float>> mem = Pointer.allocateFloats(dim1, dim2);
        for (int i1 = 0; i1 < dim1; ++i1) {
            mem.setFloats((long)(i1 * dim2 * 4), values[i1], 0, dim2);
        }
        return mem;
    }

    public static Pointer<Pointer<Pointer<Float>>> pointerToFloats(float[][][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        int dim3 = values[0][0].length;
        Pointer<Pointer<Pointer<Float>>> mem = Pointer.allocateFloats(dim1, dim2, dim3);
        for (int i1 = 0; i1 < dim1; ++i1) {
            int offset1 = i1 * dim2;
            for (int i2 = 0; i2 < dim2; ++i2) {
                int offset2 = (offset1 + i2) * dim3;
                mem.setFloats((long)(offset2 * 4), values[i1][i2], 0, dim3);
            }
        }
        return mem;
    }

    public static Pointer<Float> allocateFloat() {
        return Pointer.allocate(PointerIO.getFloatInstance());
    }

    public static Pointer<Float> allocateFloats(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getFloatInstance(), arrayLength);
    }

    public static Pointer<Pointer<Float>> allocateFloats(long dim1, long dim2) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getFloatInstance(), new long[]{dim1, dim2}, 0), dim1);
    }

    public static Pointer<Pointer<Pointer<Float>>> allocateFloats(long dim1, long dim2, long dim3) {
        long[] dims = new long[]{dim1, dim2, dim3};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getFloatInstance(), dims, 1), dims, 0), dim1);
    }

    public static Pointer<Double> pointerToDouble(double value) {
        Pointer<Double> mem = Pointer.allocate(PointerIO.getDoubleInstance());
        mem.setDouble(0L, value);
        return mem;
    }

    public static Pointer<Double> pointerToDoubles(double ... values) {
        if (values == null) {
            return null;
        }
        Pointer<Double> mem = Pointer.allocateArray(PointerIO.getDoubleInstance(), (long)values.length);
        mem.setDoubles(0L, values, 0, values.length);
        return mem;
    }

    public static Pointer<Pointer<Double>> pointerToDoubles(double[][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        Pointer<Pointer<Double>> mem = Pointer.allocateDoubles(dim1, dim2);
        for (int i1 = 0; i1 < dim1; ++i1) {
            mem.setDoubles((long)(i1 * dim2 * 8), values[i1], 0, dim2);
        }
        return mem;
    }

    public static Pointer<Pointer<Pointer<Double>>> pointerToDoubles(double[][][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        int dim3 = values[0][0].length;
        Pointer<Pointer<Pointer<Double>>> mem = Pointer.allocateDoubles(dim1, dim2, dim3);
        for (int i1 = 0; i1 < dim1; ++i1) {
            int offset1 = i1 * dim2;
            for (int i2 = 0; i2 < dim2; ++i2) {
                int offset2 = (offset1 + i2) * dim3;
                mem.setDoubles((long)(offset2 * 8), values[i1][i2], 0, dim3);
            }
        }
        return mem;
    }

    public static Pointer<Double> allocateDouble() {
        return Pointer.allocate(PointerIO.getDoubleInstance());
    }

    public static Pointer<Double> allocateDoubles(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getDoubleInstance(), arrayLength);
    }

    public static Pointer<Pointer<Double>> allocateDoubles(long dim1, long dim2) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getDoubleInstance(), new long[]{dim1, dim2}, 0), dim1);
    }

    public static Pointer<Pointer<Pointer<Double>>> allocateDoubles(long dim1, long dim2, long dim3) {
        long[] dims = new long[]{dim1, dim2, dim3};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getDoubleInstance(), dims, 1), dims, 0), dim1);
    }

    public static Pointer<Boolean> pointerToBoolean(boolean value) {
        Pointer<Boolean> mem = Pointer.allocate(PointerIO.getBooleanInstance());
        mem.setBoolean(0L, value);
        return mem;
    }

    public static Pointer<Boolean> pointerToBooleans(boolean ... values) {
        if (values == null) {
            return null;
        }
        Pointer<Boolean> mem = Pointer.allocateArray(PointerIO.getBooleanInstance(), (long)values.length);
        mem.setBooleans(0L, values, 0, values.length);
        return mem;
    }

    public static Pointer<Pointer<Boolean>> pointerToBooleans(boolean[][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        Pointer<Pointer<Boolean>> mem = Pointer.allocateBooleans(dim1, dim2);
        for (int i1 = 0; i1 < dim1; ++i1) {
            mem.setBooleans(i1 * dim2 * 1, values[i1], 0, dim2);
        }
        return mem;
    }

    public static Pointer<Pointer<Pointer<Boolean>>> pointerToBooleans(boolean[][][] values) {
        if (values == null) {
            return null;
        }
        int dim1 = values.length;
        int dim2 = values[0].length;
        int dim3 = values[0][0].length;
        Pointer<Pointer<Pointer<Boolean>>> mem = Pointer.allocateBooleans(dim1, dim2, dim3);
        for (int i1 = 0; i1 < dim1; ++i1) {
            int offset1 = i1 * dim2;
            for (int i2 = 0; i2 < dim2; ++i2) {
                int offset2 = (offset1 + i2) * dim3;
                mem.setBooleans(offset2 * 1, values[i1][i2], 0, dim3);
            }
        }
        return mem;
    }

    public static Pointer<Boolean> allocateBoolean() {
        return Pointer.allocate(PointerIO.getBooleanInstance());
    }

    public static Pointer<Boolean> allocateBooleans(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getBooleanInstance(), arrayLength);
    }

    public static Pointer<Pointer<Boolean>> allocateBooleans(long dim1, long dim2) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getBooleanInstance(), new long[]{dim1, dim2}, 0), dim1);
    }

    public static Pointer<Pointer<Pointer<Boolean>>> allocateBooleans(long dim1, long dim2, long dim3) {
        long[] dims = new long[]{dim1, dim2, dim3};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getBooleanInstance(), dims, 1), dims, 0), dim1);
    }

    public static Pointer<Integer> pointerToInts(IntBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException("Cannot create pointers to indirect IntBuffer buffers");
        }
        long address = JNI.getDirectBufferAddress(buffer);
        long size = JNI.getDirectBufferCapacity(buffer);
        if (address == 0L || size == 0L) {
            return null;
        }
        PointerIO<Integer> io = CommonPointerIOs.intIO;
        boolean ordered = buffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(io, address, ordered, address, address + size, null, NO_PARENT, null, buffer);
    }

    public static Pointer<Long> pointerToLongs(LongBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException("Cannot create pointers to indirect LongBuffer buffers");
        }
        long address = JNI.getDirectBufferAddress(buffer);
        long size = JNI.getDirectBufferCapacity(buffer);
        if (address == 0L || size == 0L) {
            return null;
        }
        PointerIO<Long> io = CommonPointerIOs.longIO;
        boolean ordered = buffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(io, address, ordered, address, address + size, null, NO_PARENT, null, buffer);
    }

    public static Pointer<Short> pointerToShorts(ShortBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException("Cannot create pointers to indirect ShortBuffer buffers");
        }
        long address = JNI.getDirectBufferAddress(buffer);
        long size = JNI.getDirectBufferCapacity(buffer);
        if (address == 0L || size == 0L) {
            return null;
        }
        PointerIO<Short> io = CommonPointerIOs.shortIO;
        boolean ordered = buffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(io, address, ordered, address, address + size, null, NO_PARENT, null, buffer);
    }

    public static Pointer<Byte> pointerToBytes(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException("Cannot create pointers to indirect ByteBuffer buffers");
        }
        long address = JNI.getDirectBufferAddress(buffer);
        long size = JNI.getDirectBufferCapacity(buffer);
        if (address == 0L || size == 0L) {
            return null;
        }
        PointerIO<Byte> io = CommonPointerIOs.byteIO;
        boolean ordered = buffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(io, address, ordered, address, address + size, null, NO_PARENT, null, buffer);
    }

    public static Pointer<Character> pointerToChars(CharBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException("Cannot create pointers to indirect CharBuffer buffers");
        }
        long address = JNI.getDirectBufferAddress(buffer);
        long size = JNI.getDirectBufferCapacity(buffer);
        if (address == 0L || size == 0L) {
            return null;
        }
        PointerIO<Character> io = CommonPointerIOs.charIO;
        boolean ordered = buffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(io, address, ordered, address, address + size, null, NO_PARENT, null, buffer);
    }

    public static Pointer<Float> pointerToFloats(FloatBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException("Cannot create pointers to indirect FloatBuffer buffers");
        }
        long address = JNI.getDirectBufferAddress(buffer);
        long size = JNI.getDirectBufferCapacity(buffer);
        if (address == 0L || size == 0L) {
            return null;
        }
        PointerIO<Float> io = CommonPointerIOs.floatIO;
        boolean ordered = buffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(io, address, ordered, address, address + size, null, NO_PARENT, null, buffer);
    }

    public static Pointer<Double> pointerToDoubles(DoubleBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (!buffer.isDirect()) {
            throw new UnsupportedOperationException("Cannot create pointers to indirect DoubleBuffer buffers");
        }
        long address = JNI.getDirectBufferAddress(buffer);
        long size = JNI.getDirectBufferCapacity(buffer);
        if (address == 0L || size == 0L) {
            return null;
        }
        PointerIO<Double> io = CommonPointerIOs.doubleIO;
        boolean ordered = buffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(io, address, ordered, address, address + size, null, NO_PARENT, null, buffer);
    }

    public Type getTargetType() {
        PointerIO<T> io = this.getIO();
        return io == null ? null : io.getTargetType();
    }

    @Deprecated
    public Pointer<?> getPointer() {
        return this.getPointer(0L, (PointerIO)null);
    }

    public Pointer<?> getPointer(long byteOffset) {
        return this.getPointer(byteOffset, (PointerIO)null);
    }

    public <U> Pointer<U> getPointer(Class<U> c) {
        return this.getPointer(0L, PointerIO.getInstance(c));
    }

    public <U> Pointer<U> getPointer(PointerIO<U> pio) {
        return this.getPointer(0L, pio);
    }

    public <U> Pointer<U> getPointer(long byteOffset, Class<U> c) {
        return this.getPointer(byteOffset, PointerIO.getInstance(c));
    }

    public <U> Pointer<U> getPointer(long byteOffset, Type t) {
        return this.getPointer(byteOffset, t == null ? null : PointerIO.getInstance(t));
    }

    public <U> Pointer<U> getPointer(long byteOffset, PointerIO<U> pio) {
        long value = this.getSizeT(byteOffset);
        if (value == 0L) {
            return null;
        }
        return Pointer.newPointer(pio, value, this.isOrdered(), UNKNOWN_VALIDITY, UNKNOWN_VALIDITY, this, byteOffset, null, null);
    }

    public Pointer<T> setPointer(Pointer<?> value) {
        return this.setPointer(0L, value);
    }

    public Pointer<T> setPointer(long byteOffset, Pointer<?> value) {
        this.setSizeT(byteOffset, value == null ? 0L : value.getPeer());
        return this;
    }

    @Deprecated
    public Pointer<?>[] getPointers(long byteOffset, int arrayLength) {
        return this.getPointers(byteOffset, arrayLength, (PointerIO)null);
    }

    public <U> Pointer<U>[] getPointers(long byteOffset, int arrayLength, Type t) {
        return this.getPointers(byteOffset, arrayLength, t == null ? null : PointerIO.getInstance(t));
    }

    public <U> Pointer<U>[] getPointers(long byteOffset, int arrayLength, Class<U> t) {
        return this.getPointers(byteOffset, arrayLength, t == null ? null : PointerIO.getInstance(t));
    }

    public <U> Pointer<U>[] getPointers(long byteOffset, int arrayLength, PointerIO pio) {
        Pointer[] values = new Pointer[arrayLength];
        int s = JNI.POINTER_SIZE;
        for (int i = 0; i < arrayLength; ++i) {
            values[i] = this.getPointer((long)(i * s), pio);
        }
        return values;
    }

    public Pointer<T> setPointers(long byteOffset, Pointer<?> ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        int n = values.length;
        int s = JNI.POINTER_SIZE;
        for (int i = 0; i < n; ++i) {
            this.setPointer(i * s, values[i]);
        }
        return this;
    }

    public Object getArray(long byteOffset, int length) {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot create sublist");
        }
        return io.getArray(this, byteOffset, length);
    }

    public Object getArray(int length) {
        return this.getArray(0L, length);
    }

    public Object getArray() {
        return this.getArray(0L, (int)this.getValidElements());
    }

    public Pointer<T> setArray(long byteOffset, Object array) {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot create sublist");
        }
        io.setArray(this, byteOffset, array);
        return this;
    }

    public static <T> Pointer<T> pointerToArray(Object array) {
        if (array == null) {
            return null;
        }
        PointerIO io = PointerIO.getArrayIO(array);
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot create pointer to array");
        }
        Pointer ptr = Pointer.allocateArray(io, (long)Array.getLength(array));
        io.setArray(ptr, 0L, array);
        return ptr;
    }

    public Pointer<T> setArray(Object array) {
        return this.setArray(0L, array);
    }

    public static Pointer<SizeT> pointerToSizeT(long value) {
        Pointer<SizeT> p = Pointer.allocate(PointerIO.getSizeTInstance());
        p.setSizeT(0L, value);
        return p;
    }

    public static Pointer<SizeT> pointerToSizeTs(long ... values) {
        if (values == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getSizeTInstance(), (long)values.length).setSizeTs(0L, values);
    }

    public static Pointer<SizeT> pointerToSizeTs(SizeT[] values) {
        if (values == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getSizeTInstance(), (long)values.length).setSizeTs(0L, values);
    }

    public static Pointer<SizeT> pointerToSizeTs(int[] values) {
        if (values == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getSizeTInstance(), (long)values.length).setSizeTs(0L, values);
    }

    public static Pointer<SizeT> allocateSizeTs(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getSizeTInstance(), arrayLength);
    }

    public static Pointer<SizeT> allocateSizeT() {
        return Pointer.allocate(PointerIO.getSizeTInstance());
    }

    public long getSizeT() {
        return this.getSizeT(0L);
    }

    public long getSizeT(long byteOffset) {
        return SizeT.SIZE == 8 ? this.getLong(byteOffset) : 0xFFFFFFFFL & (long)this.getInt(byteOffset);
    }

    public long[] getSizeTs(int arrayLength) {
        return this.getSizeTs(0L, arrayLength);
    }

    public long[] getSizeTs(long byteOffset, int arrayLength) {
        if (SizeT.SIZE == 8) {
            return this.getLongs(byteOffset, arrayLength);
        }
        int[] values = this.getInts(byteOffset, arrayLength);
        long[] ret = new long[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            ret[i] = 0xFFFFFFFFL & (long)values[i];
        }
        return ret;
    }

    public Pointer<T> setSizeT(long value) {
        return this.setSizeT(0L, value);
    }

    public Pointer<T> setSizeT(SizeT value) {
        return this.setSizeT(0L, value);
    }

    public Pointer<T> setSizeT(long byteOffset, long value) {
        if (SizeT.SIZE == 8) {
            this.setLong(byteOffset, value);
        } else {
            this.setInt(byteOffset, SizeT.safeIntCast(value));
        }
        return this;
    }

    public Pointer<T> setSizeT(long byteOffset, SizeT value) {
        return this.setSizeT(byteOffset, value.longValue());
    }

    public Pointer<T> setSizeTs(long[] values) {
        return this.setSizeTs(0L, values);
    }

    public Pointer<T> setSizeTs(int[] values) {
        return this.setSizeTs(0L, values);
    }

    public Pointer<T> setSizeTs(SizeT[] values) {
        return this.setSizeTs(0L, values);
    }

    public Pointer<T> setSizeTs(long byteOffset, long[] values) {
        if (SizeT.SIZE == 8) {
            this.setLongs(byteOffset, values);
        } else {
            int n = values.length;
            int s = 4;
            for (int i = 0; i < n; ++i) {
                this.setInt(i * s, (int)values[i]);
            }
        }
        return this;
    }

    public Pointer<T> setSizeTs(long byteOffset, SizeT ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        int n = values.length;
        int s = 4;
        for (int i = 0; i < n; ++i) {
            this.setSizeT((long)(i * s), values[i].longValue());
        }
        return this;
    }

    public Pointer<T> setSizeTs(long byteOffset, int[] values) {
        if (SizeT.SIZE == 4) {
            this.setInts(byteOffset, values);
        } else {
            int n = values.length;
            int s = 8;
            for (int i = 0; i < n; ++i) {
                this.setLong(i * s, values[i]);
            }
        }
        return this;
    }

    public static Pointer<CLong> pointerToCLong(long value) {
        Pointer<CLong> p = Pointer.allocate(PointerIO.getCLongInstance());
        p.setCLong(0L, value);
        return p;
    }

    public static Pointer<CLong> pointerToCLongs(long ... values) {
        if (values == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getCLongInstance(), (long)values.length).setCLongs(0L, values);
    }

    public static Pointer<CLong> pointerToCLongs(CLong[] values) {
        if (values == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getCLongInstance(), (long)values.length).setCLongs(0L, values);
    }

    public static Pointer<CLong> pointerToCLongs(int[] values) {
        if (values == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getCLongInstance(), (long)values.length).setCLongs(0L, values);
    }

    public static Pointer<CLong> allocateCLongs(long arrayLength) {
        return Pointer.allocateArray(PointerIO.getCLongInstance(), arrayLength);
    }

    public static Pointer<CLong> allocateCLong() {
        return Pointer.allocate(PointerIO.getCLongInstance());
    }

    public long getCLong() {
        return this.getCLong(0L);
    }

    public long getCLong(long byteOffset) {
        return CLong.SIZE == 8 ? this.getLong(byteOffset) : 0xFFFFFFFFL & (long)this.getInt(byteOffset);
    }

    public long[] getCLongs(int arrayLength) {
        return this.getCLongs(0L, arrayLength);
    }

    public long[] getCLongs(long byteOffset, int arrayLength) {
        if (CLong.SIZE == 8) {
            return this.getLongs(byteOffset, arrayLength);
        }
        int[] values = this.getInts(byteOffset, arrayLength);
        long[] ret = new long[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            ret[i] = 0xFFFFFFFFL & (long)values[i];
        }
        return ret;
    }

    public Pointer<T> setCLong(long value) {
        return this.setCLong(0L, value);
    }

    public Pointer<T> setCLong(CLong value) {
        return this.setCLong(0L, value);
    }

    public Pointer<T> setCLong(long byteOffset, long value) {
        if (CLong.SIZE == 8) {
            this.setLong(byteOffset, value);
        } else {
            this.setInt(byteOffset, SizeT.safeIntCast(value));
        }
        return this;
    }

    public Pointer<T> setCLong(long byteOffset, CLong value) {
        return this.setCLong(byteOffset, value.longValue());
    }

    public Pointer<T> setCLongs(long[] values) {
        return this.setCLongs(0L, values);
    }

    public Pointer<T> setCLongs(int[] values) {
        return this.setCLongs(0L, values);
    }

    public Pointer<T> setCLongs(CLong[] values) {
        return this.setCLongs(0L, values);
    }

    public Pointer<T> setCLongs(long byteOffset, long[] values) {
        if (CLong.SIZE == 8) {
            this.setLongs(byteOffset, values);
        } else {
            int n = values.length;
            int s = 4;
            for (int i = 0; i < n; ++i) {
                this.setInt(i * s, (int)values[i]);
            }
        }
        return this;
    }

    public Pointer<T> setCLongs(long byteOffset, CLong ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        int n = values.length;
        int s = 4;
        for (int i = 0; i < n; ++i) {
            this.setCLong((long)(i * s), values[i].longValue());
        }
        return this;
    }

    public Pointer<T> setCLongs(long byteOffset, int[] values) {
        if (CLong.SIZE == 4) {
            this.setInts(byteOffset, values);
        } else {
            int n = values.length;
            int s = 8;
            for (int i = 0; i < n; ++i) {
                this.setLong(i * s, values[i]);
            }
        }
        return this;
    }

    public static <T> Pointer<Pointer<T>> pointerToPointer(Pointer<T> value) {
        Pointer<Pointer<T>> p = Pointer.allocate(PointerIO.getPointerInstance());
        p.setPointer(0L, value);
        return p;
    }

    public static <T> Pointer<Pointer<T>> pointerToPointers(Pointer<T> ... values) {
        if (values == null) {
            return null;
        }
        int n = values.length;
        int s = SIZE;
        PointerIO<Pointer> pio = PointerIO.getPointerInstance();
        Pointer<Pointer<T>> p = Pointer.allocateArray(pio, (long)n);
        for (int i = 0; i < n; ++i) {
            p.setPointer(i * s, values[i]);
        }
        return p;
    }

    static Class<?> getPrimitiveType(Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            return Integer.TYPE;
        }
        if (buffer instanceof LongBuffer) {
            return Long.TYPE;
        }
        if (buffer instanceof ShortBuffer) {
            return Short.TYPE;
        }
        if (buffer instanceof ByteBuffer) {
            return Byte.TYPE;
        }
        if (buffer instanceof CharBuffer) {
            return Character.TYPE;
        }
        if (buffer instanceof FloatBuffer) {
            return Float.TYPE;
        }
        if (buffer instanceof DoubleBuffer) {
            return Double.TYPE;
        }
        throw new UnsupportedOperationException();
    }

    public void setValues(long byteOffset, Buffer values, int valuesOffset, int length) {
        if (values instanceof IntBuffer) {
            this.setInts(byteOffset, (IntBuffer)values, (long)valuesOffset, (long)length);
            return;
        }
        if (values instanceof LongBuffer) {
            this.setLongs(byteOffset, (LongBuffer)values, (long)valuesOffset, (long)length);
            return;
        }
        if (values instanceof ShortBuffer) {
            this.setShorts(byteOffset, (ShortBuffer)values, (long)valuesOffset, (long)length);
            return;
        }
        if (values instanceof ByteBuffer) {
            this.setBytes(byteOffset, (ByteBuffer)values, (long)valuesOffset, (long)length);
            return;
        }
        if (values instanceof CharBuffer) {
            this.setChars(byteOffset, (CharBuffer)values, (long)valuesOffset, (long)length);
            return;
        }
        if (values instanceof FloatBuffer) {
            this.setFloats(byteOffset, (FloatBuffer)values, (long)valuesOffset, (long)length);
            return;
        }
        if (values instanceof DoubleBuffer) {
            this.setDoubles(byteOffset, (DoubleBuffer)values, (long)valuesOffset, (long)length);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void copyBytesTo(long byteOffset, Pointer<?> destination, long byteOffsetInDestination, long byteCount) {
        JNI.memcpy(super.getCheckedPeer(byteOffsetInDestination, byteCount), this.getCheckedPeer(byteOffset, byteCount), byteCount);
    }

    public void moveBytesTo(long byteOffset, Pointer<?> destination, long byteOffsetInDestination, long byteCount) {
        JNI.memmove(super.getCheckedPeer(byteOffsetInDestination, byteCount), this.getCheckedPeer(byteOffset, byteCount), byteCount);
    }

    public void copyTo(Pointer<?> destination) {
        this.copyBytesTo(0L, destination, 0L, this.getValidBytes());
    }

    public Pointer<T> setInt(int value) {
        return this.setInt(0L, value);
    }

    public Pointer<T> setInt(long byteOffset, int value) {
        if (!this.isOrdered()) {
            JNI.set_int_disordered(this.getCheckedPeer(byteOffset, 4L), value);
            return this;
        }
        JNI.set_int(this.getCheckedPeer(byteOffset, 4L), value);
        return this;
    }

    public Pointer<T> setInts(int[] values) {
        return this.setInts(0L, values, 0, values.length);
    }

    public Pointer<T> setInts(long byteOffset, int[] values) {
        return this.setInts(byteOffset, values, 0, values.length);
    }

    public Pointer<T> setInts(long byteOffset, int[] values, int valuesOffset, int length) {
        if (!this.isOrdered()) {
            JNI.set_int_array_disordered(this.getCheckedPeer(byteOffset, 4 * length), values, valuesOffset, length);
            return this;
        }
        JNI.set_int_array(this.getCheckedPeer(byteOffset, 4 * length), values, valuesOffset, length);
        return this;
    }

    public int getInt() {
        return this.getInt(0L);
    }

    public int getInt(long byteOffset) {
        if (!this.isOrdered()) {
            return JNI.get_int_disordered(this.getCheckedPeer(byteOffset, 4L));
        }
        return JNI.get_int(this.getCheckedPeer(byteOffset, 4L));
    }

    public int[] getInts(int length) {
        return this.getInts(0L, length);
    }

    public int[] getInts() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create array if remaining length is not known. Please use getInts(int length) instead.");
        }
        return this.getInts(0L, (int)rem);
    }

    public int[] getInts(long byteOffset, int length) {
        if (!this.isOrdered()) {
            return JNI.get_int_array_disordered(this.getCheckedPeer(byteOffset, 4 * length), length);
        }
        return JNI.get_int_array(this.getCheckedPeer(byteOffset, 4 * length), length);
    }

    public Pointer<T> setLong(long value) {
        return this.setLong(0L, value);
    }

    public Pointer<T> setLong(long byteOffset, long value) {
        if (!this.isOrdered()) {
            JNI.set_long_disordered(this.getCheckedPeer(byteOffset, 8L), value);
            return this;
        }
        JNI.set_long(this.getCheckedPeer(byteOffset, 8L), value);
        return this;
    }

    public Pointer<T> setLongs(long[] values) {
        return this.setLongs(0L, values, 0, values.length);
    }

    public Pointer<T> setLongs(long byteOffset, long[] values) {
        return this.setLongs(byteOffset, values, 0, values.length);
    }

    public Pointer<T> setLongs(long byteOffset, long[] values, int valuesOffset, int length) {
        if (!this.isOrdered()) {
            JNI.set_long_array_disordered(this.getCheckedPeer(byteOffset, 8 * length), values, valuesOffset, length);
            return this;
        }
        JNI.set_long_array(this.getCheckedPeer(byteOffset, 8 * length), values, valuesOffset, length);
        return this;
    }

    public long getLong() {
        return this.getLong(0L);
    }

    public long getLong(long byteOffset) {
        if (!this.isOrdered()) {
            return JNI.get_long_disordered(this.getCheckedPeer(byteOffset, 8L));
        }
        return JNI.get_long(this.getCheckedPeer(byteOffset, 8L));
    }

    public long[] getLongs(int length) {
        return this.getLongs(0L, length);
    }

    public long[] getLongs() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create array if remaining length is not known. Please use getLongs(int length) instead.");
        }
        return this.getLongs(0L, (int)rem);
    }

    public long[] getLongs(long byteOffset, int length) {
        if (!this.isOrdered()) {
            return JNI.get_long_array_disordered(this.getCheckedPeer(byteOffset, 8 * length), length);
        }
        return JNI.get_long_array(this.getCheckedPeer(byteOffset, 8 * length), length);
    }

    public Pointer<T> setShort(short value) {
        return this.setShort(0L, value);
    }

    public Pointer<T> setShort(long byteOffset, short value) {
        if (!this.isOrdered()) {
            JNI.set_short_disordered(this.getCheckedPeer(byteOffset, 2L), value);
            return this;
        }
        JNI.set_short(this.getCheckedPeer(byteOffset, 2L), value);
        return this;
    }

    public Pointer<T> setShorts(short[] values) {
        return this.setShorts(0L, values, 0, values.length);
    }

    public Pointer<T> setShorts(long byteOffset, short[] values) {
        return this.setShorts(byteOffset, values, 0, values.length);
    }

    public Pointer<T> setShorts(long byteOffset, short[] values, int valuesOffset, int length) {
        if (!this.isOrdered()) {
            JNI.set_short_array_disordered(this.getCheckedPeer(byteOffset, 2 * length), values, valuesOffset, length);
            return this;
        }
        JNI.set_short_array(this.getCheckedPeer(byteOffset, 2 * length), values, valuesOffset, length);
        return this;
    }

    public short getShort() {
        return this.getShort(0L);
    }

    public short getShort(long byteOffset) {
        if (!this.isOrdered()) {
            return JNI.get_short_disordered(this.getCheckedPeer(byteOffset, 2L));
        }
        return JNI.get_short(this.getCheckedPeer(byteOffset, 2L));
    }

    public short[] getShorts(int length) {
        return this.getShorts(0L, length);
    }

    public short[] getShorts() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create array if remaining length is not known. Please use getShorts(int length) instead.");
        }
        return this.getShorts(0L, (int)rem);
    }

    public short[] getShorts(long byteOffset, int length) {
        if (!this.isOrdered()) {
            return JNI.get_short_array_disordered(this.getCheckedPeer(byteOffset, 2 * length), length);
        }
        return JNI.get_short_array(this.getCheckedPeer(byteOffset, 2 * length), length);
    }

    public Pointer<T> setByte(byte value) {
        return this.setByte(0L, value);
    }

    public Pointer<T> setByte(long byteOffset, byte value) {
        JNI.set_byte(this.getCheckedPeer(byteOffset, 1L), value);
        return this;
    }

    public Pointer<T> setBytes(byte[] values) {
        return this.setBytes(0L, values, 0, values.length);
    }

    public Pointer<T> setBytes(long byteOffset, byte[] values) {
        return this.setBytes(byteOffset, values, 0, values.length);
    }

    public Pointer<T> setBytes(long byteOffset, byte[] values, int valuesOffset, int length) {
        JNI.set_byte_array(this.getCheckedPeer(byteOffset, 1 * length), values, valuesOffset, length);
        return this;
    }

    public byte getByte() {
        return this.getByte(0L);
    }

    public byte getByte(long byteOffset) {
        return JNI.get_byte(this.getCheckedPeer(byteOffset, 1L));
    }

    public byte[] getBytes(int length) {
        return this.getBytes(0L, length);
    }

    public byte[] getBytes() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create array if remaining length is not known. Please use getBytes(int length) instead.");
        }
        return this.getBytes(0L, (int)rem);
    }

    public byte[] getBytes(long byteOffset, int length) {
        return JNI.get_byte_array(this.getCheckedPeer(byteOffset, 1 * length), length);
    }

    public Pointer<T> setChar(char value) {
        return this.setChar(0L, value);
    }

    public Pointer<T> setChar(long byteOffset, char value) {
        if (!this.isOrdered()) {
            JNI.set_char_disordered(this.getCheckedPeer(byteOffset, 2L), value);
            return this;
        }
        JNI.set_char(this.getCheckedPeer(byteOffset, 2L), value);
        return this;
    }

    public Pointer<T> setChars(char[] values) {
        return this.setChars(0L, values, 0, values.length);
    }

    public Pointer<T> setChars(long byteOffset, char[] values) {
        return this.setChars(byteOffset, values, 0, values.length);
    }

    public Pointer<T> setChars(long byteOffset, char[] values, int valuesOffset, int length) {
        if (!this.isOrdered()) {
            JNI.set_char_array_disordered(this.getCheckedPeer(byteOffset, 2 * length), values, valuesOffset, length);
            return this;
        }
        JNI.set_char_array(this.getCheckedPeer(byteOffset, 2 * length), values, valuesOffset, length);
        return this;
    }

    public char getChar() {
        return this.getChar(0L);
    }

    public char getChar(long byteOffset) {
        if (!this.isOrdered()) {
            return JNI.get_char_disordered(this.getCheckedPeer(byteOffset, 2L));
        }
        return JNI.get_char(this.getCheckedPeer(byteOffset, 2L));
    }

    public char[] getChars(int length) {
        return this.getChars(0L, length);
    }

    public char[] getChars() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create array if remaining length is not known. Please use getChars(int length) instead.");
        }
        return this.getChars(0L, (int)rem);
    }

    public char[] getChars(long byteOffset, int length) {
        if (!this.isOrdered()) {
            return JNI.get_char_array_disordered(this.getCheckedPeer(byteOffset, 2 * length), length);
        }
        return JNI.get_char_array(this.getCheckedPeer(byteOffset, 2 * length), length);
    }

    public Pointer<T> setFloat(float value) {
        return this.setFloat(0L, value);
    }

    public Pointer<T> setFloat(long byteOffset, float value) {
        if (!this.isOrdered()) {
            JNI.set_float_disordered(this.getCheckedPeer(byteOffset, 4L), value);
            return this;
        }
        JNI.set_float(this.getCheckedPeer(byteOffset, 4L), value);
        return this;
    }

    public Pointer<T> setFloats(float[] values) {
        return this.setFloats(0L, values, 0, values.length);
    }

    public Pointer<T> setFloats(long byteOffset, float[] values) {
        return this.setFloats(byteOffset, values, 0, values.length);
    }

    public Pointer<T> setFloats(long byteOffset, float[] values, int valuesOffset, int length) {
        if (!this.isOrdered()) {
            JNI.set_float_array_disordered(this.getCheckedPeer(byteOffset, 4 * length), values, valuesOffset, length);
            return this;
        }
        JNI.set_float_array(this.getCheckedPeer(byteOffset, 4 * length), values, valuesOffset, length);
        return this;
    }

    public float getFloat() {
        return this.getFloat(0L);
    }

    public float getFloat(long byteOffset) {
        if (!this.isOrdered()) {
            return JNI.get_float_disordered(this.getCheckedPeer(byteOffset, 4L));
        }
        return JNI.get_float(this.getCheckedPeer(byteOffset, 4L));
    }

    public float[] getFloats(int length) {
        return this.getFloats(0L, length);
    }

    public float[] getFloats() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create array if remaining length is not known. Please use getFloats(int length) instead.");
        }
        return this.getFloats(0L, (int)rem);
    }

    public float[] getFloats(long byteOffset, int length) {
        if (!this.isOrdered()) {
            return JNI.get_float_array_disordered(this.getCheckedPeer(byteOffset, 4 * length), length);
        }
        return JNI.get_float_array(this.getCheckedPeer(byteOffset, 4 * length), length);
    }

    public Pointer<T> setDouble(double value) {
        return this.setDouble(0L, value);
    }

    public Pointer<T> setDouble(long byteOffset, double value) {
        if (!this.isOrdered()) {
            JNI.set_double_disordered(this.getCheckedPeer(byteOffset, 8L), value);
            return this;
        }
        JNI.set_double(this.getCheckedPeer(byteOffset, 8L), value);
        return this;
    }

    public Pointer<T> setDoubles(double[] values) {
        return this.setDoubles(0L, values, 0, values.length);
    }

    public Pointer<T> setDoubles(long byteOffset, double[] values) {
        return this.setDoubles(byteOffset, values, 0, values.length);
    }

    public Pointer<T> setDoubles(long byteOffset, double[] values, int valuesOffset, int length) {
        if (!this.isOrdered()) {
            JNI.set_double_array_disordered(this.getCheckedPeer(byteOffset, 8 * length), values, valuesOffset, length);
            return this;
        }
        JNI.set_double_array(this.getCheckedPeer(byteOffset, 8 * length), values, valuesOffset, length);
        return this;
    }

    public double getDouble() {
        return this.getDouble(0L);
    }

    public double getDouble(long byteOffset) {
        if (!this.isOrdered()) {
            return JNI.get_double_disordered(this.getCheckedPeer(byteOffset, 8L));
        }
        return JNI.get_double(this.getCheckedPeer(byteOffset, 8L));
    }

    public double[] getDoubles(int length) {
        return this.getDoubles(0L, length);
    }

    public double[] getDoubles() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create array if remaining length is not known. Please use getDoubles(int length) instead.");
        }
        return this.getDoubles(0L, (int)rem);
    }

    public double[] getDoubles(long byteOffset, int length) {
        if (!this.isOrdered()) {
            return JNI.get_double_array_disordered(this.getCheckedPeer(byteOffset, 8 * length), length);
        }
        return JNI.get_double_array(this.getCheckedPeer(byteOffset, 8 * length), length);
    }

    public Pointer<T> setBoolean(boolean value) {
        return this.setBoolean(0L, value);
    }

    public Pointer<T> setBoolean(long byteOffset, boolean value) {
        JNI.set_boolean(this.getCheckedPeer(byteOffset, 1L), value);
        return this;
    }

    public Pointer<T> setBooleans(boolean[] values) {
        return this.setBooleans(0L, values, 0, values.length);
    }

    public Pointer<T> setBooleans(long byteOffset, boolean[] values) {
        return this.setBooleans(byteOffset, values, 0, values.length);
    }

    public Pointer<T> setBooleans(long byteOffset, boolean[] values, int valuesOffset, int length) {
        JNI.set_boolean_array(this.getCheckedPeer(byteOffset, 1 * length), values, valuesOffset, length);
        return this;
    }

    public boolean getBoolean() {
        return this.getBoolean(0L);
    }

    public boolean getBoolean(long byteOffset) {
        return JNI.get_boolean(this.getCheckedPeer(byteOffset, 1L));
    }

    public boolean[] getBooleans(int length) {
        return this.getBooleans(0L, length);
    }

    public boolean[] getBooleans() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create array if remaining length is not known. Please use getBooleans(int length) instead.");
        }
        return this.getBooleans(0L, (int)rem);
    }

    public boolean[] getBooleans(long byteOffset, int length) {
        return JNI.get_boolean_array(this.getCheckedPeer(byteOffset, 1 * length), length);
    }

    public void getInts(int[] dest) {
        this.getIntBuffer().get(dest);
    }

    public void getInts(long byteOffset, int[] dest, int destOffset, int length) {
        this.getIntBuffer(byteOffset).get(dest, destOffset, length);
    }

    public Pointer<T> setInts(IntBuffer values) {
        return this.setInts(0L, values, 0L, (long)values.capacity());
    }

    public Pointer<T> setInts(long byteOffset, IntBuffer values, long valuesOffset, long length) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (values.isDirect()) {
            long len = length * 4L;
            long off = valuesOffset * 4L;
            long cap = JNI.getDirectBufferCapacity(values);
            if (cap < off + len) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + cap + " bytes) smaller than the requested write operation (" + len + " bytes starting at byte offset " + off + ")");
            }
            JNI.memcpy(this.getCheckedPeer(byteOffset, 4L * length), JNI.getDirectBufferAddress(values) + off, len);
        } else if (values.isReadOnly()) {
            this.getIntBuffer(byteOffset, length).put(values.duplicate());
        } else {
            this.setInts(byteOffset, values.array(), (int)((long)values.arrayOffset() + valuesOffset), (int)length);
        }
        return this;
    }

    public IntBuffer getIntBuffer(long length) {
        return this.getIntBuffer(0L, length);
    }

    public IntBuffer getIntBuffer() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create buffer if remaining length is not known. Please use getIntBuffer(long length) instead.");
        }
        return this.getIntBuffer(0L, rem);
    }

    public IntBuffer getIntBuffer(long byteOffset, long length) {
        long blen = 4L * length;
        ByteBuffer buffer = JNI.newDirectByteBuffer(this.getCheckedPeer(byteOffset, blen), blen);
        buffer.order(this.order());
        return buffer.asIntBuffer();
    }

    public void getLongs(long[] dest) {
        this.getLongBuffer().get(dest);
    }

    public void getLongs(long byteOffset, long[] dest, int destOffset, int length) {
        this.getLongBuffer(byteOffset).get(dest, destOffset, length);
    }

    public Pointer<T> setLongs(LongBuffer values) {
        return this.setLongs(0L, values, 0L, (long)values.capacity());
    }

    public Pointer<T> setLongs(long byteOffset, LongBuffer values, long valuesOffset, long length) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (values.isDirect()) {
            long len = length * 8L;
            long off = valuesOffset * 8L;
            long cap = JNI.getDirectBufferCapacity(values);
            if (cap < off + len) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + cap + " bytes) smaller than the requested write operation (" + len + " bytes starting at byte offset " + off + ")");
            }
            JNI.memcpy(this.getCheckedPeer(byteOffset, 8L * length), JNI.getDirectBufferAddress(values) + off, len);
        } else if (values.isReadOnly()) {
            this.getLongBuffer(byteOffset, length).put(values.duplicate());
        } else {
            this.setLongs(byteOffset, values.array(), (int)((long)values.arrayOffset() + valuesOffset), (int)length);
        }
        return this;
    }

    public LongBuffer getLongBuffer(long length) {
        return this.getLongBuffer(0L, length);
    }

    public LongBuffer getLongBuffer() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create buffer if remaining length is not known. Please use getLongBuffer(long length) instead.");
        }
        return this.getLongBuffer(0L, rem);
    }

    public LongBuffer getLongBuffer(long byteOffset, long length) {
        long blen = 8L * length;
        ByteBuffer buffer = JNI.newDirectByteBuffer(this.getCheckedPeer(byteOffset, blen), blen);
        buffer.order(this.order());
        return buffer.asLongBuffer();
    }

    public void getShorts(short[] dest) {
        this.getShortBuffer().get(dest);
    }

    public void getShorts(long byteOffset, short[] dest, int destOffset, int length) {
        this.getShortBuffer(byteOffset).get(dest, destOffset, length);
    }

    public Pointer<T> setShorts(ShortBuffer values) {
        return this.setShorts(0L, values, 0L, (long)values.capacity());
    }

    public Pointer<T> setShorts(long byteOffset, ShortBuffer values, long valuesOffset, long length) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (values.isDirect()) {
            long len = length * 2L;
            long off = valuesOffset * 2L;
            long cap = JNI.getDirectBufferCapacity(values);
            if (cap < off + len) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + cap + " bytes) smaller than the requested write operation (" + len + " bytes starting at byte offset " + off + ")");
            }
            JNI.memcpy(this.getCheckedPeer(byteOffset, 2L * length), JNI.getDirectBufferAddress(values) + off, len);
        } else if (values.isReadOnly()) {
            this.getShortBuffer(byteOffset, length).put(values.duplicate());
        } else {
            this.setShorts(byteOffset, values.array(), (int)((long)values.arrayOffset() + valuesOffset), (int)length);
        }
        return this;
    }

    public ShortBuffer getShortBuffer(long length) {
        return this.getShortBuffer(0L, length);
    }

    public ShortBuffer getShortBuffer() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create buffer if remaining length is not known. Please use getShortBuffer(long length) instead.");
        }
        return this.getShortBuffer(0L, rem);
    }

    public ShortBuffer getShortBuffer(long byteOffset, long length) {
        long blen = 2L * length;
        ByteBuffer buffer = JNI.newDirectByteBuffer(this.getCheckedPeer(byteOffset, blen), blen);
        buffer.order(this.order());
        return buffer.asShortBuffer();
    }

    public void getBytes(byte[] dest) {
        this.getByteBuffer().get(dest);
    }

    public void getBytes(long byteOffset, byte[] dest, int destOffset, int length) {
        this.getByteBuffer(byteOffset).get(dest, destOffset, length);
    }

    public Pointer<T> setBytes(ByteBuffer values) {
        return this.setBytes(0L, values, 0L, (long)values.capacity());
    }

    public Pointer<T> setBytes(long byteOffset, ByteBuffer values, long valuesOffset, long length) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (values.isDirect()) {
            long len = length * 1L;
            long off = valuesOffset * 1L;
            long cap = JNI.getDirectBufferCapacity(values);
            if (cap < off + len) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + cap + " bytes) smaller than the requested write operation (" + len + " bytes starting at byte offset " + off + ")");
            }
            JNI.memcpy(this.getCheckedPeer(byteOffset, 1L * length), JNI.getDirectBufferAddress(values) + off, len);
        } else if (values.isReadOnly()) {
            this.getByteBuffer(byteOffset, length).put(values.duplicate());
        } else {
            this.setBytes(byteOffset, values.array(), (int)((long)values.arrayOffset() + valuesOffset), (int)length);
        }
        return this;
    }

    public ByteBuffer getByteBuffer(long length) {
        return this.getByteBuffer(0L, length);
    }

    public ByteBuffer getByteBuffer() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create buffer if remaining length is not known. Please use getByteBuffer(long length) instead.");
        }
        return this.getByteBuffer(0L, rem);
    }

    public ByteBuffer getByteBuffer(long byteOffset, long length) {
        long blen = 1L * length;
        ByteBuffer buffer = JNI.newDirectByteBuffer(this.getCheckedPeer(byteOffset, blen), blen);
        buffer.order(this.order());
        return buffer;
    }

    public void getChars(char[] dest) {
        this.getCharBuffer().get(dest);
    }

    public void getChars(long byteOffset, char[] dest, int destOffset, int length) {
        this.getCharBuffer(byteOffset).get(dest, destOffset, length);
    }

    public Pointer<T> setChars(CharBuffer values) {
        return this.setChars(0L, values, 0L, (long)values.capacity());
    }

    public Pointer<T> setChars(long byteOffset, CharBuffer values, long valuesOffset, long length) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (values.isDirect()) {
            long len = length * 2L;
            long off = valuesOffset * 2L;
            long cap = JNI.getDirectBufferCapacity(values);
            if (cap < off + len) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + cap + " bytes) smaller than the requested write operation (" + len + " bytes starting at byte offset " + off + ")");
            }
            JNI.memcpy(this.getCheckedPeer(byteOffset, 2L * length), JNI.getDirectBufferAddress(values) + off, len);
        } else if (values.isReadOnly()) {
            this.getCharBuffer(byteOffset, length).put(values.duplicate());
        } else {
            this.setChars(byteOffset, values.array(), (int)((long)values.arrayOffset() + valuesOffset), (int)length);
        }
        return this;
    }

    public CharBuffer getCharBuffer(long length) {
        return this.getCharBuffer(0L, length);
    }

    public CharBuffer getCharBuffer() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create buffer if remaining length is not known. Please use getCharBuffer(long length) instead.");
        }
        return this.getCharBuffer(0L, rem);
    }

    public CharBuffer getCharBuffer(long byteOffset, long length) {
        long blen = 2L * length;
        ByteBuffer buffer = JNI.newDirectByteBuffer(this.getCheckedPeer(byteOffset, blen), blen);
        buffer.order(this.order());
        return buffer.asCharBuffer();
    }

    public void getFloats(float[] dest) {
        this.getFloatBuffer().get(dest);
    }

    public void getFloats(long byteOffset, float[] dest, int destOffset, int length) {
        this.getFloatBuffer(byteOffset).get(dest, destOffset, length);
    }

    public Pointer<T> setFloats(FloatBuffer values) {
        return this.setFloats(0L, values, 0L, (long)values.capacity());
    }

    public Pointer<T> setFloats(long byteOffset, FloatBuffer values, long valuesOffset, long length) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (values.isDirect()) {
            long len = length * 4L;
            long off = valuesOffset * 4L;
            long cap = JNI.getDirectBufferCapacity(values);
            if (cap < off + len) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + cap + " bytes) smaller than the requested write operation (" + len + " bytes starting at byte offset " + off + ")");
            }
            JNI.memcpy(this.getCheckedPeer(byteOffset, 4L * length), JNI.getDirectBufferAddress(values) + off, len);
        } else if (values.isReadOnly()) {
            this.getFloatBuffer(byteOffset, length).put(values.duplicate());
        } else {
            this.setFloats(byteOffset, values.array(), (int)((long)values.arrayOffset() + valuesOffset), (int)length);
        }
        return this;
    }

    public FloatBuffer getFloatBuffer(long length) {
        return this.getFloatBuffer(0L, length);
    }

    public FloatBuffer getFloatBuffer() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create buffer if remaining length is not known. Please use getFloatBuffer(long length) instead.");
        }
        return this.getFloatBuffer(0L, rem);
    }

    public FloatBuffer getFloatBuffer(long byteOffset, long length) {
        long blen = 4L * length;
        ByteBuffer buffer = JNI.newDirectByteBuffer(this.getCheckedPeer(byteOffset, blen), blen);
        buffer.order(this.order());
        return buffer.asFloatBuffer();
    }

    public void getDoubles(double[] dest) {
        this.getDoubleBuffer().get(dest);
    }

    public void getDoubles(long byteOffset, double[] dest, int destOffset, int length) {
        this.getDoubleBuffer(byteOffset).get(dest, destOffset, length);
    }

    public Pointer<T> setDoubles(DoubleBuffer values) {
        return this.setDoubles(0L, values, 0L, (long)values.capacity());
    }

    public Pointer<T> setDoubles(long byteOffset, DoubleBuffer values, long valuesOffset, long length) {
        if (values == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (values.isDirect()) {
            long len = length * 8L;
            long off = valuesOffset * 8L;
            long cap = JNI.getDirectBufferCapacity(values);
            if (cap < off + len) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + cap + " bytes) smaller than the requested write operation (" + len + " bytes starting at byte offset " + off + ")");
            }
            JNI.memcpy(this.getCheckedPeer(byteOffset, 8L * length), JNI.getDirectBufferAddress(values) + off, len);
        } else if (values.isReadOnly()) {
            this.getDoubleBuffer(byteOffset, length).put(values.duplicate());
        } else {
            this.setDoubles(byteOffset, values.array(), (int)((long)values.arrayOffset() + valuesOffset), (int)length);
        }
        return this;
    }

    public DoubleBuffer getDoubleBuffer(long length) {
        return this.getDoubleBuffer(0L, length);
    }

    public DoubleBuffer getDoubleBuffer() {
        long rem = this.getValidElements();
        if (rem < 0L) {
            Pointer.throwBecauseUntyped("Cannot create buffer if remaining length is not known. Please use getDoubleBuffer(long length) instead.");
        }
        return this.getDoubleBuffer(0L, rem);
    }

    public DoubleBuffer getDoubleBuffer(long byteOffset, long length) {
        long blen = 8L * length;
        ByteBuffer buffer = JNI.newDirectByteBuffer(this.getCheckedPeer(byteOffset, blen), blen);
        buffer.order(this.order());
        return buffer.asDoubleBuffer();
    }

    private static void notAString(StringType type, String reason) {
        throw new RuntimeException("There is no " + (Object)((Object)type) + " String here ! (" + reason + ")");
    }

    private void checkIntRefCount(StringType type, long byteOffset) {
        int refCount = this.getInt(byteOffset);
        if (refCount <= 0) {
            Pointer.notAString(type, "invalid refcount: " + refCount);
        }
    }

    public String getString(StringType type) {
        return this.getString(0L, null, type);
    }

    String getSTLString(long byteOffset, Charset charset, StringType type) {
        char endChar;
        Pointer<?> p;
        long pOff;
        boolean wide = type == StringType.WideSTL;
        int fixedBuffLength = 16;
        int fixedBuffSize = wide ? fixedBuffLength * 2 : fixedBuffLength;
        long length = this.getSizeT(byteOffset + (long)fixedBuffSize + (long)SIZE);
        if (length < (long)(fixedBuffLength - 1)) {
            pOff = byteOffset;
            p = this;
        } else {
            pOff = 0L;
            p = this.getPointer(byteOffset + (long)fixedBuffSize + (long)SIZE);
        }
        char c = endChar = wide ? p.getChar(pOff + length * 2L) : p.getByte(pOff + length);
        if (endChar != '\u0000') {
            Pointer.notAString(type, "STL string format is not recognized : did not find a NULL char at the expected end of string of expected length " + length);
        }
        return p.getString(pOff, charset, wide ? StringType.WideC : StringType.C);
    }

    static <U> Pointer<U> setSTLString(Pointer<U> pointer, long byteOffset, String s, Charset charset, StringType type) {
        char endChar;
        Pointer<Object> p;
        long pOff;
        boolean wide = type == StringType.WideSTL;
        int fixedBuffLength = 16;
        int fixedBuffSize = wide ? fixedBuffLength * 2 : fixedBuffLength;
        long lengthOffset = byteOffset + (long)fixedBuffSize + (long)SIZE;
        long capacityOffset = lengthOffset + (long)SIZE;
        long length = s.length();
        if (pointer == null) {
            throw new UnsupportedOperationException("Cannot create STL strings (yet)");
        }
        long currentLength = pointer.getSizeT(lengthOffset);
        long currentCapacity = pointer.getSizeT(capacityOffset);
        if (currentLength < 0L || currentCapacity < 0L || currentLength > currentCapacity) {
            Pointer.notAString(type, "STL string format not recognized : currentLength = " + currentLength + ", currentCapacity = " + currentCapacity);
        }
        if (length > currentCapacity) {
            throw new RuntimeException("The target STL string is not large enough to write a string of length " + length + " (current capacity = " + currentCapacity + ")");
        }
        pointer.setSizeT(lengthOffset, length);
        if (length < (long)(fixedBuffLength - 1)) {
            pOff = byteOffset;
            p = pointer;
        } else {
            pOff = 0L;
            p = pointer.getPointer(byteOffset + (long)fixedBuffSize + (long)SizeT.SIZE);
        }
        char c = endChar = wide ? p.getChar(pOff + currentLength * 2L) : p.getByte(pOff + currentLength);
        if (endChar != '\u0000') {
            Pointer.notAString(type, "STL string format is not recognized : did not find a NULL char at the expected end of string of expected length " + currentLength);
        }
        p.setString(pOff, s, charset, wide ? StringType.WideC : StringType.C);
        return pointer;
    }

    public String getString(long byteOffset, Charset charset, StringType type) {
        try {
            switch (type) {
                case PascalShort: {
                    long len = this.getByte(byteOffset) & 0xFF;
                    return new String(this.getBytes(byteOffset + 1L, SizeT.safeIntCast(len)), Pointer.charset(charset));
                }
                case PascalWide: {
                    this.checkIntRefCount(type, byteOffset - 8L);
                }
                case BSTR: {
                    long len = this.getInt(byteOffset - 4L);
                    if (len < 0L || (len & 1L) == 1L) {
                        Pointer.notAString(type, "invalid byte length: " + len);
                    }
                    if (this.getChar(byteOffset + len) != '\u0000') {
                        Pointer.notAString(type, "no null short after the " + len + " declared bytes");
                    }
                    return new String(this.getChars(byteOffset, SizeT.safeIntCast(len / 2L)));
                }
                case PascalAnsi: {
                    this.checkIntRefCount(type, byteOffset - 8L);
                    long len = this.getInt(byteOffset - 4L);
                    if (len < 0L) {
                        Pointer.notAString(type, "invalid byte length: " + len);
                    }
                    if (this.getByte(byteOffset + len) != 0) {
                        Pointer.notAString(type, "no null short after the " + len + " declared bytes");
                    }
                    return new String(this.getBytes(byteOffset, SizeT.safeIntCast(len)), Pointer.charset(charset));
                }
                case C: {
                    long len = this.strlen(byteOffset);
                    return new String(this.getBytes(byteOffset, SizeT.safeIntCast(len)), Pointer.charset(charset));
                }
                case WideC: {
                    long len = this.wcslen(byteOffset);
                    return new String(this.getChars(byteOffset, SizeT.safeIntCast(len)));
                }
                case STL: 
                case WideSTL: {
                    return this.getSTLString(byteOffset, charset, type);
                }
            }
            throw new RuntimeException("Unhandled string type : " + (Object)((Object)type));
        }
        catch (UnsupportedEncodingException ex) {
            Pointer.throwUnexpected(ex);
            return null;
        }
    }

    public Pointer<T> setString(String s, StringType type) {
        return Pointer.setString(this, 0L, s, null, type);
    }

    public Pointer<T> setString(long byteOffset, String s, Charset charset, StringType type) {
        return Pointer.setString(this, byteOffset, s, charset, type);
    }

    private static String charset(Charset charset) {
        return (charset == null ? Charset.defaultCharset() : charset).name();
    }

    static <U> Pointer<U> setString(Pointer<U> pointer, long byteOffset, String s, Charset charset, StringType type) {
        try {
            if (s == null) {
                return null;
            }
            switch (type) {
                case PascalShort: {
                    byte[] bytes = s.getBytes(Pointer.charset(charset));
                    int bytesCount = bytes.length;
                    if (pointer == null) {
                        pointer = Pointer.allocateBytes(bytesCount + 1);
                    }
                    if (bytesCount > 255) {
                        throw new IllegalArgumentException("Pascal strings cannot be more than 255 chars long (tried to write string of byte length " + bytesCount + ")");
                    }
                    pointer.setByte(byteOffset, (byte)bytesCount);
                    pointer.setBytes(byteOffset + 1L, bytes, 0, bytesCount);
                    break;
                }
                case C: {
                    byte[] bytes = s.getBytes(Pointer.charset(charset));
                    int bytesCount = bytes.length;
                    if (pointer == null) {
                        pointer = Pointer.allocateBytes(bytesCount + 1);
                    }
                    pointer.setBytes(byteOffset, bytes, 0, bytesCount);
                    pointer.setByte(byteOffset + (long)bytesCount, (byte)0);
                    break;
                }
                case WideC: {
                    char[] chars = s.toCharArray();
                    int bytesCount = chars.length * 2;
                    if (pointer == null) {
                        pointer = Pointer.allocateChars(bytesCount + 2);
                    }
                    pointer.setChars(byteOffset, chars);
                    pointer.setChar(byteOffset + (long)bytesCount, '\u0000');
                    break;
                }
                case PascalWide: {
                    int headerShift;
                    int headerBytes = 8;
                    char[] chars = s.toCharArray();
                    int bytesCount = chars.length * 2;
                    if (pointer == null) {
                        pointer = Pointer.allocateChars(headerBytes + bytesCount + 2);
                        headerShift = headerBytes;
                        byteOffset = headerShift;
                    } else {
                        headerShift = 0;
                    }
                    pointer.setInt(byteOffset - 8L, 1);
                    pointer.setInt(byteOffset - 4L, bytesCount);
                    pointer.setChars(byteOffset, chars);
                    pointer.setChar(byteOffset + (long)bytesCount, '\u0000');
                    return pointer.offset(headerShift);
                }
                case PascalAnsi: {
                    int headerShift;
                    int headerBytes = 8;
                    byte[] bytes = s.getBytes(Pointer.charset(charset));
                    int bytesCount = bytes.length;
                    if (pointer == null) {
                        pointer = Pointer.allocateBytes(headerBytes + bytesCount + 1);
                        headerShift = headerBytes;
                        byteOffset = headerShift;
                    } else {
                        headerShift = 0;
                    }
                    pointer.setInt(byteOffset - 8L, 1);
                    pointer.setInt(byteOffset - 4L, bytesCount);
                    pointer.setBytes(byteOffset, bytes);
                    pointer.setByte(byteOffset + (long)bytesCount, (byte)0);
                    return pointer.offset(headerShift);
                }
                case BSTR: {
                    int headerShift;
                    int headerBytes = 4;
                    char[] chars = s.toCharArray();
                    int bytesCount = chars.length * 2;
                    if (pointer == null) {
                        pointer = Pointer.allocateChars(headerBytes + bytesCount + 2);
                        headerShift = headerBytes;
                        byteOffset = headerShift;
                    } else {
                        headerShift = 0;
                    }
                    pointer.setInt(byteOffset - 4L, bytesCount);
                    pointer.setChars(byteOffset, chars);
                    pointer.setChar(byteOffset + (long)bytesCount, '\u0000');
                    return pointer.offset(headerShift);
                }
                case STL: 
                case WideSTL: {
                    return Pointer.setSTLString(pointer, byteOffset, s, charset, type);
                }
                default: {
                    throw new RuntimeException("Unhandled string type : " + (Object)((Object)type));
                }
            }
            return pointer;
        }
        catch (UnsupportedEncodingException ex) {
            Pointer.throwUnexpected(ex);
            return null;
        }
    }

    public static Pointer<?> pointerToString(String string, Charset charset, StringType type) {
        return Pointer.setString(null, 0L, string, charset, type);
    }

    public static Pointer<Byte> pointerToCString(String string) {
        return Pointer.setString(null, 0L, string, null, StringType.C);
    }

    public static Pointer<Pointer<Byte>> pointerToCStrings(final String ... strings) {
        if (strings == null) {
            return null;
        }
        final int len = strings.length;
        final Pointer[] pointers = new Pointer[len];
        Pointer<Pointer<Byte>> mem = Pointer.allocateArray(PointerIO.getPointerInstance(Byte.class), len, new Releaser(){

            @Override
            public void release(Pointer<?> p) {
                Pointer<?> mem = p;
                for (int i = 0; i < len; ++i) {
                    Pointer pp = (Pointer)mem.get(i);
                    if (pp != null) {
                        strings[i] = pp.getCString();
                    }
                    if ((pp = pointers[i]) == null) continue;
                    pp.release();
                }
            }
        });
        for (int i = 0; i < len; ++i) {
            pointers[i] = Pointer.pointerToCString(strings[i]);
            mem.set(i, pointers[i]);
        }
        return mem;
    }

    public static Pointer<Character> pointerToWideCString(String string) {
        return Pointer.setString(null, 0L, string, null, StringType.WideC);
    }

    public static Pointer<Pointer<Character>> pointerToWideCStrings(final String ... strings) {
        if (strings == null) {
            return null;
        }
        final int len = strings.length;
        final Pointer[] pointers = new Pointer[len];
        Pointer<Pointer<Character>> mem = Pointer.allocateArray(PointerIO.getPointerInstance(Character.class), len, new Releaser(){

            @Override
            public void release(Pointer<?> p) {
                Pointer<?> mem = p;
                for (int i = 0; i < len; ++i) {
                    Pointer pp = (Pointer)mem.get(i);
                    if (pp != null) {
                        strings[i] = pp.getWideCString();
                    }
                    if ((pp = pointers[i]) == null) continue;
                    pp.release();
                }
            }
        });
        for (int i = 0; i < len; ++i) {
            pointers[i] = Pointer.pointerToWideCString(strings[i]);
            mem.set(i, pointers[i]);
        }
        return mem;
    }

    public String getCString() {
        return this.getCString(0L);
    }

    public String getCString(long byteOffset) {
        return this.getString(byteOffset, null, StringType.C);
    }

    public Pointer<T> setCString(String s) {
        return this.setCString(0L, s);
    }

    public Pointer<T> setCString(long byteOffset, String s) {
        return this.setString(byteOffset, s, null, StringType.C);
    }

    public String getWideCString() {
        return this.getWideCString(0L);
    }

    public String getWideCString(long byteOffset) {
        return this.getString(byteOffset, null, StringType.WideC);
    }

    public Pointer<T> setWideCString(String s) {
        return this.setWideCString(0L, s);
    }

    public Pointer<T> setWideCString(long byteOffset, String s) {
        return this.setString(byteOffset, s, null, StringType.WideC);
    }

    protected long strlen(long byteOffset) {
        return JNI.strlen(this.getCheckedPeer(byteOffset, 1L));
    }

    protected long wcslen(long byteOffset) {
        long len = 0L;
        while (this.getShort(byteOffset + len * 2L) != 0) {
            ++len;
        }
        return len;
    }

    public void clearBytes(long length) {
        this.clearBytes(0L, length, (byte)0);
    }

    public void clearBytes(long byteOffset, long length, byte value) {
        JNI.memset(this.getCheckedPeer(byteOffset, length), value, length);
    }

    public Pointer<T> findByte(long byteOffset, byte value, long searchLength) {
        long ptr = this.getCheckedPeer(byteOffset, searchLength);
        long found = JNI.memchr(ptr, value, searchLength);
        return found == 0L ? null : this.offset(found - ptr);
    }

    @Override
    @Deprecated
    public boolean add(T item) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final T get(int index) {
        return this.get((long)index);
    }

    public final T apply(long index) {
        return this.get(index);
    }

    @Override
    @Deprecated
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.getValidElements() == 0L;
    }

    @Override
    @Deprecated
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.iterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.next(index).listIterator();
    }

    @Override
    @Deprecated
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final T set(int index, T element) {
        this.set((long)index, element);
        return element;
    }

    public final void update(long index, T element) {
        this.set(index, element);
    }

    @Override
    public int size() {
        long size = this.getValidElements();
        if (size > Integer.MAX_VALUE) {
            throw new RuntimeException("Size is greater than Integer.MAX_VALUE, cannot convert to int in Pointer.size()");
        }
        return (int)size;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot create sublist");
        }
        return this.next(fromIndex).validElements(toIndex - fromIndex);
    }

    @Override
    public T[] toArray() {
        PointerIO<T> io = this.getIO();
        if (io == null) {
            Pointer.throwBecauseUntyped("Cannot create array");
        }
        if (this.validEnd == UNKNOWN_VALIDITY) {
            throw new IndexOutOfBoundsException("Length of pointed memory is unknown, cannot create array out of this pointer");
        }
        return this.toArray((int)this.getValidElements());
    }

    T[] toArray(int length) {
        Class c = Utils.getClass(this.io.getTargetType());
        return this.toArray((U[])((Object[])Array.newInstance(c, length)));
    }

    @Override
    public <U> U[] toArray(U[] array) {
        int n = (int)this.getValidElements();
        if (n < 0) {
            Pointer.throwBecauseUntyped("Cannot create array");
        }
        if (array.length != n) {
            return this.toArray();
        }
        for (int i = 0; i < n; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    static {
        JNI.initLibrary();
        UNKNOWN_VALIDITY = -1L;
        NO_PARENT = 0L;
        freeReleaser = new FreeReleaser();
    }

    public static enum StringType {
        C(false, true),
        WideC(true, true),
        PascalShort(false, true),
        PascalWide(true, true),
        PascalAnsi(false, true),
        BSTR(true, true),
        STL(false, false),
        WideSTL(true, false);

        final boolean isWide;
        final boolean canCreate;

        private StringType(boolean isWide, boolean canCreate) {
            this.isWide = isWide;
            this.canCreate = canCreate;
        }
    }

    static class FreeReleaser
    implements Releaser {
        FreeReleaser() {
        }

        @Override
        public void release(Pointer<?> p) {
            assert (p.getSibling() == null);
            assert (((Pointer)p).validStart == p.getPeer());
            JNI.free(p.getPeer());
        }
    }

    public static interface Releaser {
        public void release(Pointer<?> var1);
    }
}

