/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bridj.BridJ;
import org.bridj.Demangler;
import org.bridj.JNI;
import org.bridj.NativeEntities;
import org.bridj.ann.Symbol;
import org.bridj.cpp.GCC4Demangler;
import org.bridj.cpp.VC9Demangler;

public class NativeLibrary {
    long handle;
    long symbols;
    String path;
    NativeEntities nativeEntities = new NativeEntities();
    Map<Long, Demangler.Symbol> addrToName;
    Map<String, Demangler.Symbol> nameToSym;

    protected NativeLibrary(String path, long handle, long symbols) {
        this.path = path;
        this.handle = handle;
        this.symbols = symbols;
    }

    long getSymbolsHandle() {
        return this.symbols;
    }

    NativeEntities getNativeEntities() {
        return this.nativeEntities;
    }

    public static NativeLibrary load(String path) {
        long handle = JNI.loadLibrary(path);
        if (handle == 0L) {
            return null;
        }
        long symbols = JNI.loadLibrarySymbols(handle);
        return new NativeLibrary(path, handle, symbols);
    }

    long getHandle() {
        if (this.handle == 0L) {
            throw new RuntimeException("Library was released and cannot be used anymore");
        }
        return this.handle;
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public synchronized void release() {
        if (this.handle == 0L) {
            return;
        }
        this.nativeEntities.release();
        JNI.freeLibrary(this.handle);
        JNI.freeLibrarySymbols(this.symbols);
        this.handle = 0L;
    }

    public long getSymbolAddress(String name) {
        Demangler.Symbol addr;
        if (this.nameToSym != null && (addr = this.nameToSym.get(name)) != null) {
            return addr.getAddress();
        }
        long address = JNI.findSymbolInLibrary(this.getHandle(), name);
        if (address == 0L) {
            address = JNI.findSymbolInLibrary(this.getHandle(), "_" + name);
        }
        return address;
    }

    public synchronized Demangler.Symbol getSymbol(AnnotatedElement member) throws FileNotFoundException {
        Symbol mg = BridJ.getAnnotation(Symbol.class, false, member, new Annotation[0]);
        String name = null;
        if (member instanceof Member) {
            name = ((Member)((Object)member)).getName();
        }
        if (mg != null) {
            for (String n : mg.value()) {
                Demangler.Symbol handle = this.getSymbol(n);
                if (handle == null) {
                    handle = this.getSymbol("_" + n);
                }
                if (handle == null) continue;
                return handle;
            }
        }
        if (name != null) {
            Demangler.Symbol handle = this.getSymbol(name);
            if (handle == null) {
                handle = this.getSymbol("_" + name);
            }
            if (handle != null) {
                return handle;
            }
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            for (Demangler.Symbol symbol : this.getSymbols()) {
                if (!symbol.matches(method)) continue;
                return symbol;
            }
        }
        return null;
    }

    public boolean isMSVC() {
        return JNI.isWindows();
    }

    public Demangler.Symbol getFirstMatchingSymbol(SymbolAccepter accepter) {
        for (Demangler.Symbol symbol : this.getSymbols()) {
            if (!accepter.accept(symbol)) continue;
            return symbol;
        }
        return null;
    }

    public Collection<Demangler.Symbol> getSymbols() {
        block2: {
            try {
                this.scanSymbols();
            }
            catch (Exception ex) {
                if ($assertionsDisabled || BridJ.log(Level.SEVERE, "Failed to scan symbols of library '" + this.path + "'", ex)) break block2;
                throw new AssertionError();
            }
        }
        return Collections.unmodifiableCollection(this.nameToSym.values());
    }

    public String getSymbolName(long address) {
        if (this.addrToName == null && this.getSymbolsHandle() != 0L) {
            return JNI.findSymbolName(this.getHandle(), this.getSymbolsHandle(), address);
        }
        Demangler.Symbol symbol = this.getSymbol(address);
        return symbol == null ? null : symbol.symbol;
    }

    public Demangler.Symbol getSymbol(long address) {
        try {
            this.scanSymbols();
            Demangler.Symbol symbol = this.addrToName.get(address);
            return symbol;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get name of address " + address, ex);
        }
    }

    public Demangler.Symbol getSymbol(String name) {
        try {
            long addr;
            this.scanSymbols();
            Demangler.Symbol symbol = this.nameToSym.get(name);
            if (this.addrToName == null && symbol == null && (addr = JNI.findSymbolInLibrary(this.getHandle(), name)) != 0L) {
                symbol = new Demangler.Symbol(name, this);
                symbol.address = addr;
                this.nameToSym.put(name, symbol);
            }
            return symbol;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    void scanSymbols() throws Exception {
        if (this.addrToName != null) {
            return;
        }
        this.nameToSym = new HashMap<String, Demangler.Symbol>();
        String[] symbs = null;
        if (symbs == null) {
            symbs = JNI.getLibrarySymbols(this.getHandle(), this.getSymbolsHandle());
        }
        if (symbs == null) {
            return;
        }
        this.addrToName = new HashMap<Long, Demangler.Symbol>();
        boolean is32 = JNI.is64Bits() == false;
        for (String name : symbs) {
            if (name == null) continue;
            long addr = JNI.findSymbolInLibrary(this.getHandle(), name);
            if (addr == 0L && name.startsWith("_")) {
                String n2 = name.substring(1);
                addr = JNI.findSymbolInLibrary(this.getHandle(), n2);
                if (addr == 0L) {
                    n2 = "_" + name;
                    addr = JNI.findSymbolInLibrary(this.getHandle(), n2);
                }
                if (addr != 0L) {
                    name = n2;
                }
            }
            if (addr == 0L) {
                System.err.println("Symbol '" + name + "' not found.");
                continue;
            }
            Demangler.Symbol sym = new Demangler.Symbol(name, this);
            sym.address = addr;
            this.addrToName.put(addr, sym);
            this.nameToSym.put(name, sym);
        }
    }

    Demangler.MemberRef parseSymbol(String symbol) throws Demangler.DemanglingException {
        Demangler demangler = JNI.isWindows() ? new VC9Demangler(this, symbol) : new GCC4Demangler(this, symbol);
        return demangler.parseSymbol();
    }

    public static interface SymbolAccepter {
        public boolean accept(Demangler.Symbol var1);
    }
}

