/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.bridj.BridJ;
import org.bridj.CallIO;
import org.bridj.Callback;
import org.bridj.Dyncall;
import org.bridj.JNI;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.ValuedEnum;
import org.bridj.ann.CLong;
import org.bridj.ann.Constructor;
import org.bridj.ann.Convention;
import org.bridj.ann.Ptr;
import org.bridj.ann.Virtual;
import org.bridj.cpp.CPPObject;

public class MethodCallInfo {
    List<CallIO> callIOs;
    private Class<?> declaringClass;
    long nativeClass;
    int returnValueType;
    int[] paramsValueTypes;
    private Method method;
    String methodName;
    String symbolName;
    private long forwardedPointer;
    String dcSignature;
    String javaSignature;
    String asmSignature;
    Callback javaCallback;
    int virtualIndex = -1;
    int virtualTableOffset = 0;
    private int dcCallingConvention = 0;
    boolean isVarArgs = false;
    boolean isStatic;
    boolean isCPlusPlus;
    boolean direct;
    boolean startsWithThis;
    boolean bNeedsThisPointer;

    public MethodCallInfo(Method method) throws FileNotFoundException {
        Convention cc;
        this.setMethod(method);
        this.setDeclaringClass(method.getDeclaringClass());
        this.methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramsAnnotations = method.getParameterAnnotations();
        int modifiers = method.getModifiers();
        this.isStatic = Modifier.isStatic(modifiers);
        this.isVarArgs = method.isVarArgs();
        int nParams = parameterTypes.length;
        this.paramsValueTypes = new int[nParams];
        this.direct = true;
        this.isCPlusPlus = CPPObject.class.isAssignableFrom(method.getDeclaringClass());
        StringBuilder javaSig = new StringBuilder(64);
        StringBuilder asmSig = new StringBuilder(64);
        StringBuilder dcSig = new StringBuilder(16);
        javaSig.append('(');
        asmSig.append('(');
        dcSig.append('p').append('p');
        for (int iParam = 0; iParam < nParams; ++iParam) {
            Class<?> parameterType = parameterTypes[iParam];
            Type genericParameterType = genericParameterTypes[iParam];
            Dyncall.ValueType paramValueType = this.getValueType(iParam, nParams, parameterType, genericParameterType, null, paramsAnnotations[iParam]);
            this.paramsValueTypes[iParam] = paramValueType.ordinal();
            this.appendToSignature(iParam, paramValueType, parameterType, genericParameterType, javaSig, dcSig, asmSig);
        }
        javaSig.append(')');
        asmSig.append(')');
        dcSig.append(')');
        Dyncall.ValueType retType = this.getValueType(-1, nParams, method.getReturnType(), method.getGenericReturnType(), method, new Annotation[0]);
        this.appendToSignature(-1, retType, method.getReturnType(), method.getGenericReturnType(), javaSig, dcSig, asmSig);
        this.returnValueType = retType.ordinal();
        this.javaSignature = javaSig.toString();
        this.asmSignature = asmSig.toString();
        this.dcSignature = dcSig.toString();
        Virtual virtual = BridJ.getAnnotation(Virtual.class, false, method, new Annotation[0]);
        boolean bl = this.isCPlusPlus = this.isCPlusPlus || virtual != null;
        if (this.isCPlusPlus && !this.isStatic) {
            if (!this.startsWithThis) {
                this.direct = false;
            }
            this.bNeedsThisPointer = true;
            if (JNI.isWindows() && !JNI.is64Bits().booleanValue()) {
                this.setDcCallingConvention(5);
            }
        }
        if ((cc = BridJ.getAnnotation(Convention.class, true, method, new Annotation[0])) != null && JNI.isWindows() && !JNI.is64Bits().booleanValue()) {
            switch (cc.value()) {
                case FastCall: {
                    this.direct = false;
                    this.setDcCallingConvention(JNI.isWindows() ? 3 : 0);
                    break;
                }
                case Pascal: 
                case StdCall: {
                    this.direct = false;
                    this.setDcCallingConvention(2);
                    break;
                }
                case ThisCall: {
                    this.direct = false;
                    this.setDcCallingConvention(JNI.isWindows() ? 6 : 0);
                }
            }
        }
        if (nParams > JNI.getMaxDirectMappingArgCount()) {
            this.direct = false;
        }
        this.symbolName = this.methodName;
        if (!BridJ.isDirectModeEnabled()) {
            this.direct = false;
        }
        assert (BridJ.log(Level.INFO, (this.direct ? "[mappable as direct] " : "[not mappable as direct] ") + method));
    }

    void addCallIO(CallIO handler) {
        if (this.callIOs == null) {
            this.callIOs = new ArrayList<CallIO>();
        }
        this.callIOs.add(handler);
    }

    public CallIO[] getCallIOs() {
        if (this.callIOs == null) {
            return new CallIO[0];
        }
        return this.callIOs.toArray(new CallIO[this.callIOs.size()]);
    }

    public String getDcSignature() {
        return this.dcSignature;
    }

    public String getJavaSignature() {
        return this.javaSignature;
    }

    public String getASMSignature() {
        return this.asmSignature;
    }

    boolean getBoolAnnotation(Class<? extends Annotation> ac, boolean inherit, AnnotatedElement element, Annotation ... directAnnotations) {
        Annotation ann = BridJ.getAnnotation(ac, inherit, element, directAnnotations);
        return ann != null;
    }

    public Dyncall.ValueType getValueType(int iParam, int nParams, Class<?> c, Type t, AnnotatedElement element, Annotation ... directAnnotations) {
        Ptr sz = BridJ.getAnnotation(Ptr.class, true, element, directAnnotations);
        Constructor cons = this.method.getAnnotation(Constructor.class);
        CLong cl = BridJ.getAnnotation(CLong.class, true, element, directAnnotations);
        if (sz != null || cons != null || cl != null) {
            if (c != Long.class && c != Long.TYPE) {
                throw new RuntimeException("Annotation should only be used on a long parameter, not on a " + c.getName());
            }
            if (sz != null) {
                if (!JNI.is64Bits().booleanValue()) {
                    this.direct = false;
                }
            } else if (cl != null) {
                if (JNI.CLONG_SIZE != 8) {
                    this.direct = false;
                }
            } else if (cons != null) {
                this.isCPlusPlus = true;
                this.startsWithThis = true;
                if (iParam != 0) {
                    throw new RuntimeException("Annotation " + Constructor.class.getName() + " cannot have more than one (long) argument");
                }
            }
            return Dyncall.ValueType.eSizeTValue;
        }
        if (c == null || c.equals(Void.TYPE)) {
            return Dyncall.ValueType.eVoidValue;
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return Dyncall.ValueType.eIntValue;
        }
        if (c == Long.class || c == Long.TYPE) {
            return Dyncall.ValueType.eLongValue;
        }
        if (c == Short.class || c == Short.TYPE) {
            return Dyncall.ValueType.eShortValue;
        }
        if (c == Byte.class || c == Byte.TYPE) {
            return Dyncall.ValueType.eByteValue;
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return Dyncall.ValueType.eBooleanValue;
        }
        if (c == Float.class || c == Float.TYPE) {
            this.usesFloats();
            return Dyncall.ValueType.eFloatValue;
        }
        if (c == Character.TYPE || c == Character.TYPE) {
            if (JNI.WCHAR_T_SIZE != 2) {
                this.direct = false;
            }
            return Dyncall.ValueType.eWCharValue;
        }
        if (c == Double.class || c == Double.TYPE) {
            this.usesFloats();
            return Dyncall.ValueType.eDoubleValue;
        }
        if (Pointer.class.isAssignableFrom(c)) {
            this.direct = false;
            this.addCallIO(CallIO.Utils.createPointerCallIO(c, t));
            return Dyncall.ValueType.ePointerValue;
        }
        if (c.isArray() && iParam == nParams - 1) {
            this.direct = false;
            return Dyncall.ValueType.eEllipsis;
        }
        if (c == ValuedEnum.class) {
            this.direct = false;
            return Dyncall.ValueType.eIntFlagSet;
        }
        if (NativeObject.class.isAssignableFrom(c)) {
            this.addCallIO(new CallIO.NativeObjectHandler(c, t));
            this.direct = false;
            return Dyncall.ValueType.eNativeObjectValue;
        }
        throw new NoSuchElementException("No " + Dyncall.ValueType.class.getSimpleName() + " for class " + c.getName());
    }

    void usesFloats() {
        if (this.direct && JNI.isMacOSX()) {
            this.direct = false;
            assert (BridJ.log(Level.WARNING, "[unstable direct] FIXME Disable direct call due to float/double usage in " + this.method));
        }
    }

    public void appendToSignature(int iParam, Dyncall.ValueType type, Class<?> parameterType, Type genericParameterType, StringBuilder javaSig, StringBuilder dcSig, StringBuilder asmSig) {
        ParameterizedType pt;
        Type[] ts;
        String javaChar;
        char dcChar;
        String asmChar = null;
        switch (type) {
            case eVoidValue: {
                dcChar = 'v';
                javaChar = "V";
                break;
            }
            case eIntValue: {
                dcChar = 'i';
                javaChar = "I";
                break;
            }
            case eLongValue: {
                dcChar = 'l';
                javaChar = "J";
                break;
            }
            case eSizeTValue: {
                javaChar = "J";
                if (JNI.SIZE_T_SIZE == 8) {
                    dcChar = 'l';
                    break;
                }
                dcChar = 'i';
                this.direct = false;
                break;
            }
            case eShortValue: {
                dcChar = 's';
                javaChar = "S";
                break;
            }
            case eDoubleValue: {
                dcChar = 'd';
                javaChar = "D";
                break;
            }
            case eFloatValue: {
                dcChar = 'f';
                javaChar = "F";
                break;
            }
            case eByteValue: {
                dcChar = 'c';
                javaChar = "B";
                break;
            }
            case eBooleanValue: {
                dcChar = 'B';
                javaChar = "Z";
                break;
            }
            case eWCharValue: {
                switch (JNI.WCHAR_T_SIZE) {
                    case 1: {
                        dcChar = 'c';
                        this.direct = false;
                        break;
                    }
                    case 2: {
                        dcChar = 's';
                        break;
                    }
                    case 4: {
                        dcChar = 'i';
                        this.direct = false;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled sizeof(wchar_t) in GetJavaTypeSignature: " + JNI.WCHAR_T_SIZE);
                    }
                }
                javaChar = "C";
                break;
            }
            case eIntFlagSet: {
                dcChar = 'i';
                javaChar = "Lorg/bridj/ValuedEnum;";
                this.direct = false;
                break;
            }
            case ePointerValue: {
                dcChar = 'p';
                javaChar = "L" + parameterType.getName().replace('.', '/') + ";";
                this.direct = false;
                break;
            }
            case eNativeObjectValue: {
                if (parameterType.equals(this.method.getDeclaringClass())) {
                    dcChar = 'p';
                    javaChar = "L" + parameterType.getName().replace('.', '/') + ";";
                    this.direct = false;
                    break;
                }
            }
            default: {
                this.direct = false;
                throw new RuntimeException("Unhandled " + Dyncall.ValueType.class.getSimpleName() + ": " + (Object)((Object)type));
            }
        }
        if (genericParameterType instanceof ParameterizedType && iParam < 0 && (ts = (pt = (ParameterizedType)genericParameterType).getActualTypeArguments()) != null && ts.length == 1) {
            Type t = ts[0];
            if (t instanceof ParameterizedType) {
                t = ((ParameterizedType)t).getRawType();
            }
            if (t instanceof Class) {
                Class c = (Class)t;
                if (javaChar.endsWith(";")) {
                    asmChar = javaChar.substring(0, javaChar.length() - 1) + "<*L" + c.getName().replace('.', '/') + ";>";
                }
            }
        }
        if (javaSig != null) {
            javaSig.append(javaChar);
        }
        if (asmChar == null) {
            asmChar = javaChar;
        }
        if (asmSig != null) {
            asmSig.append(asmChar);
        }
        if (dcSig != null) {
            dcSig.append(dcChar);
        }
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setDeclaringClass(Class<?> declaringClass) {
        this.declaringClass = declaringClass;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public void setForwardedPointer(long forwardedPointer) {
        this.forwardedPointer = forwardedPointer;
    }

    public long getForwardedPointer() {
        return this.forwardedPointer;
    }

    public void setVirtualIndex(int virtualIndex) {
        this.virtualIndex = virtualIndex;
    }

    public int getVirtualIndex() {
        return this.virtualIndex;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    public void setDcCallingConvention(int dcCallingConvention) {
        this.dcCallingConvention = dcCallingConvention;
    }

    public int getDcCallingConvention() {
        return this.dcCallingConvention;
    }

    public Callback getJavaCallback() {
        return this.javaCallback;
    }

    public void setJavaCallback(Callback javaCallback) {
        this.javaCallback = javaCallback;
    }

    public void setNativeClass(long nativeClass) {
        this.nativeClass = nativeClass;
    }
}

