/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.bridj.BridJ;
import org.bridj.MethodCallInfo;

public class JNI {
    private static boolean inited;
    static final String osName;
    static final String BridJLibraryName = "bridj";
    public static int POINTER_SIZE;
    public static int WCHAR_T_SIZE;
    public static int SIZE_T_SIZE;
    public static int CLONG_SIZE;

    public static boolean isLinux() {
        return JNI.isUnix() && osName.toLowerCase().contains("linux");
    }

    public static boolean isMacOSX() {
        return JNI.isUnix() && (osName.startsWith("Mac") || osName.startsWith("Darwin"));
    }

    public static boolean isSolaris() {
        return JNI.isUnix() && (osName.startsWith("SunOS") || osName.startsWith("Solaris"));
    }

    public static boolean isBSD() {
        return JNI.isUnix() && (osName.contains("BSD") || JNI.isMacOSX());
    }

    public static boolean isUnix() {
        return File.separatorChar == '/';
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isWindows7() {
        return osName.equals("Windows 7");
    }

    public static Boolean is64Bits() {
        String arch = System.getProperty("sun.arch.data.model");
        if (arch == null) {
            arch = System.getProperty("os.arch");
        }
        return arch.contains("64") || arch.equalsIgnoreCase("sparcv9");
    }

    static String getEmbeddedLibraryResource(String name) {
        if (JNI.isWindows()) {
            return (JNI.is64Bits() != false ? "win64/" : "win32/") + name + ".dll";
        }
        if (JNI.isMacOSX()) {
            return "darwin_universal/lib" + name + ".dylib";
        }
        if (JNI.isLinux()) {
            return (JNI.is64Bits() != false ? "linux_x64/" : "linux_x86/") + name + ".so";
        }
        throw new RuntimeException("Platform not supported ! (os.name='" + osName + "', os.arch='" + System.getProperty("os.arch") + "')");
    }

    public static File extractEmbeddedLibraryResource(String name) throws IOException {
        int len;
        String libraryResource = JNI.getEmbeddedLibraryResource(name);
        int i = libraryResource.lastIndexOf(46);
        String ext = i < 0 ? "" : libraryResource.substring(i);
        byte[] b = new byte[8196];
        InputStream in = JNI.class.getClassLoader().getResourceAsStream(libraryResource);
        if (in == null) {
            File f = new File(libraryResource);
            if (!f.exists()) {
                f = new File(f.getName());
            }
            if (f.exists()) {
                return f.getCanonicalFile();
            }
            throw new FileNotFoundException(libraryResource);
        }
        File libFile = File.createTempFile(new File(libraryResource).getName(), ext);
        libFile.deleteOnExit();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(libFile));
        while ((len = in.read(b)) > 0) {
            ((OutputStream)out).write(b, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
        return libFile;
    }

    public static void initLibrary() {
        if (inited) {
            return;
        }
        try {
            String forceLibFile = System.getenv("FORCE_BRIDJ_LIBRARY");
            File libFile = forceLibFile == null ? JNI.extractEmbeddedLibraryResource(BridJLibraryName) : new File(forceLibFile);
            BridJ.log(Level.INFO, "Loading library " + libFile);
            System.load(libFile.toString());
            JNI.init();
            POINTER_SIZE = JNI.sizeOf_ptrdiff_t();
            WCHAR_T_SIZE = JNI.sizeOf_wchar_t();
            CLONG_SIZE = JNI.sizeOf_long();
            SIZE_T_SIZE = JNI.sizeOf_size_t();
            inited = true;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to initialize " + BridJ.class.getSimpleName(), ex);
        }
    }

    private static native void init();

    static native int sizeOf_size_t();

    static native int sizeOf_wchar_t();

    static native int sizeOf_ptrdiff_t();

    static native int sizeOf_long();

    @Deprecated
    public static native long getEnv();

    static native long loadLibrary(String var0);

    static native void freeLibrary(long var0);

    static native long loadLibrarySymbols(long var0);

    static native void freeLibrarySymbols(long var0);

    static native long findSymbolInLibrary(long var0, String var2);

    static native String[] getLibrarySymbols(long var0, long var2);

    static native String findSymbolName(long var0, long var2, long var4);

    public static native long newGlobalRef(Object var0);

    public static native void deleteGlobalRef(long var0);

    public static native long newWeakGlobalRef(Object var0);

    public static native void deleteWeakGlobalRef(long var0);

    public static native ByteBuffer newDirectByteBuffer(long var0, long var2);

    public static native long getDirectBufferAddress(Buffer var0);

    public static native long getDirectBufferCapacity(Buffer var0);

    @Deprecated
    static native long getIntegerArrayElements(int[] var0, boolean[] var1);

    @Deprecated
    static native void releaseIntegerArrayElements(int[] var0, long var1, int var3);

    @Deprecated
    static native int get_int(long var0);

    @Deprecated
    static native void set_int(long var0, int var2);

    @Deprecated
    static native int[] get_int_array(long var0, int var2);

    @Deprecated
    static native void set_int_array(long var0, int[] var2, int var3, int var4);

    @Deprecated
    static native int get_int_disordered(long var0);

    @Deprecated
    static native void set_int_disordered(long var0, int var2);

    @Deprecated
    static native int[] get_int_array_disordered(long var0, int var2);

    @Deprecated
    static native void set_int_array_disordered(long var0, int[] var2, int var3, int var4);

    @Deprecated
    static native long getLongArrayElements(long[] var0, boolean[] var1);

    @Deprecated
    static native void releaseLongArrayElements(long[] var0, long var1, int var3);

    @Deprecated
    static native long get_long(long var0);

    @Deprecated
    static native void set_long(long var0, long var2);

    @Deprecated
    static native long[] get_long_array(long var0, int var2);

    @Deprecated
    static native void set_long_array(long var0, long[] var2, int var3, int var4);

    @Deprecated
    static native long get_long_disordered(long var0);

    @Deprecated
    static native void set_long_disordered(long var0, long var2);

    @Deprecated
    static native long[] get_long_array_disordered(long var0, int var2);

    @Deprecated
    static native void set_long_array_disordered(long var0, long[] var2, int var3, int var4);

    @Deprecated
    static native long getShortArrayElements(short[] var0, boolean[] var1);

    @Deprecated
    static native void releaseShortArrayElements(short[] var0, long var1, int var3);

    @Deprecated
    static native short get_short(long var0);

    @Deprecated
    static native void set_short(long var0, short var2);

    @Deprecated
    static native short[] get_short_array(long var0, int var2);

    @Deprecated
    static native void set_short_array(long var0, short[] var2, int var3, int var4);

    @Deprecated
    static native short get_short_disordered(long var0);

    @Deprecated
    static native void set_short_disordered(long var0, short var2);

    @Deprecated
    static native short[] get_short_array_disordered(long var0, int var2);

    @Deprecated
    static native void set_short_array_disordered(long var0, short[] var2, int var3, int var4);

    @Deprecated
    static native long getByteArrayElements(byte[] var0, boolean[] var1);

    @Deprecated
    static native void releaseByteArrayElements(byte[] var0, long var1, int var3);

    @Deprecated
    static native byte get_byte(long var0);

    @Deprecated
    static native void set_byte(long var0, byte var2);

    @Deprecated
    static native byte[] get_byte_array(long var0, int var2);

    @Deprecated
    static native void set_byte_array(long var0, byte[] var2, int var3, int var4);

    @Deprecated
    static native long getCharacterArrayElements(char[] var0, boolean[] var1);

    @Deprecated
    static native void releaseCharacterArrayElements(char[] var0, long var1, int var3);

    @Deprecated
    static native char get_char(long var0);

    @Deprecated
    static native void set_char(long var0, char var2);

    @Deprecated
    static native char[] get_char_array(long var0, int var2);

    @Deprecated
    static native void set_char_array(long var0, char[] var2, int var3, int var4);

    @Deprecated
    static native char get_char_disordered(long var0);

    @Deprecated
    static native void set_char_disordered(long var0, char var2);

    @Deprecated
    static native char[] get_char_array_disordered(long var0, int var2);

    @Deprecated
    static native void set_char_array_disordered(long var0, char[] var2, int var3, int var4);

    @Deprecated
    static native long getFloatArrayElements(float[] var0, boolean[] var1);

    @Deprecated
    static native void releaseFloatArrayElements(float[] var0, long var1, int var3);

    @Deprecated
    static native float get_float(long var0);

    @Deprecated
    static native void set_float(long var0, float var2);

    @Deprecated
    static native float[] get_float_array(long var0, int var2);

    @Deprecated
    static native void set_float_array(long var0, float[] var2, int var3, int var4);

    @Deprecated
    static native float get_float_disordered(long var0);

    @Deprecated
    static native void set_float_disordered(long var0, float var2);

    @Deprecated
    static native float[] get_float_array_disordered(long var0, int var2);

    @Deprecated
    static native void set_float_array_disordered(long var0, float[] var2, int var3, int var4);

    @Deprecated
    static native long getDoubleArrayElements(double[] var0, boolean[] var1);

    @Deprecated
    static native void releaseDoubleArrayElements(double[] var0, long var1, int var3);

    @Deprecated
    static native double get_double(long var0);

    @Deprecated
    static native void set_double(long var0, double var2);

    @Deprecated
    static native double[] get_double_array(long var0, int var2);

    @Deprecated
    static native void set_double_array(long var0, double[] var2, int var3, int var4);

    @Deprecated
    static native double get_double_disordered(long var0);

    @Deprecated
    static native void set_double_disordered(long var0, double var2);

    @Deprecated
    static native double[] get_double_array_disordered(long var0, int var2);

    @Deprecated
    static native void set_double_array_disordered(long var0, double[] var2, int var3, int var4);

    @Deprecated
    static native long getBooleanArrayElements(boolean[] var0, boolean[] var1);

    @Deprecated
    static native void releaseBooleanArrayElements(boolean[] var0, long var1, int var3);

    @Deprecated
    static native boolean get_boolean(long var0);

    @Deprecated
    static native void set_boolean(long var0, boolean var2);

    @Deprecated
    static native boolean[] get_boolean_array(long var0, int var2);

    @Deprecated
    static native void set_boolean_array(long var0, boolean[] var2, int var3, int var4);

    public static native void callSinglePointerArgVoidFunction(long var0, long var2, int var4);

    static native long createCToJavaCallback(MethodCallInfo var0);

    static native long getActualCToJavaCallback(long var0);

    static native long bindJavaMethodsToObjCMethods(MethodCallInfo ... var0);

    static native long bindJavaToCCallbacks(MethodCallInfo ... var0);

    static native long bindJavaMethodsToCFunctions(MethodCallInfo ... var0);

    static native long bindJavaMethodsToVirtualMethods(MethodCallInfo ... var0);

    static native void freeCToJavaCallback(long var0);

    static native void freeObjCMethodBindings(long var0, int var2);

    static native void freeJavaToCCallbacks(long var0, int var2);

    static native void freeCFunctionBindings(long var0, int var2);

    static native void freeVirtualMethodBindings(long var0, int var2);

    static native long createCallTempStruct();

    static native void deleteCallTempStruct(long var0);

    static native int getMaxDirectMappingArgCount();

    static native long mallocNulled(long var0);

    static native long malloc(long var0);

    static native void free(long var0);

    static native long strlen(long var0);

    static native long wcslen(long var0);

    static native void memcpy(long var0, long var2, long var4);

    static native void memmove(long var0, long var2, long var4);

    static native long memchr(long var0, byte var2, long var3);

    static native int memcmp(long var0, long var2, long var4);

    static native void memset(long var0, byte var2, long var3);

    static {
        osName = System.getProperty("os.name", "");
        try {
            JNI.initLibrary();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }
}

