/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.bridj.ValuedEnum;

public class FlagSet<E extends Enum<E>>
implements ValuedEnum<E> {
    private final long value;
    private final Class<E> enumClass;
    private E[] enumClassValues;
    private static Map<Class<?>, Object[]> enumsCache = new WeakHashMap();

    protected FlagSet(long value, Class<E> enumClass, E[] enumClassValues) {
        this.enumClass = enumClass;
        this.value = value;
        this.enumClassValues = enumClassValues;
    }

    private static synchronized <EE extends Enum<EE>> EE[] getValues(Class<EE> enumClass) {
        Enum[] values = (Enum[])enumsCache.get(enumClass);
        if (values == null) {
            try {
                Method valuesMethod = enumClass.getMethod("values", new Class[0]);
                Class<?> valuesType = valuesMethod.getReturnType();
                if (!valuesType.isArray() || !ValuedEnum.class.isAssignableFrom(valuesType.getComponentType())) {
                    throw new RuntimeException();
                }
                values = (Enum[])valuesMethod.invoke(null, new Object[0]);
                enumsCache.put(enumClass, values);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Class " + enumClass + " does not have a public static " + ValuedEnum.class.getName() + "[] values() method.", ex);
            }
        }
        return values;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getMatchingEnums().iterator();
    }

    public static <EE extends Enum<EE>> FlagSet<EE> fromValue(long value, Class<EE> enumClass) {
        return new FlagSet(value, enumClass, null);
    }

    public static <EE extends Enum<EE>> FlagSet<EE> fromValue(long value, EE[] enumValue) {
        return new FlagSet(value, null, enumValue);
    }

    public static List<Long> getBits(long value) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < 64; ++i) {
            long bit = 1L << i;
            if ((value & bit) == 0L) continue;
            list.add(bit);
        }
        return list;
    }

    @Override
    public long value() {
        return this.value;
    }

    protected E[] getEnumClassValues() {
        return this.enumClassValues == null ? (this.enumClassValues = FlagSet.getValues(this.enumClass)) : this.enumClassValues;
    }

    protected List<E> getMatchingEnums() {
        ArrayList<Enum> ret = new ArrayList<Enum>();
        if (this.enumClass != null) {
            for (Enum e : this.getEnumClassValues()) {
                long eMask = ((ValuedEnum)((Object)e)).value();
                if ((this.value & eMask) != eMask) continue;
                ret.add(e);
            }
        }
        return ret;
    }

    public static <E extends Enum<E>> FlagSet<E> fromValues(E ... enumValues) {
        long value = 0L;
        Class<?> cl = null;
        for (E enumValue : enumValues) {
            if (cl == null) {
                cl = enumValue.getClass();
            }
            value |= ((ValuedEnum)enumValue).value();
        }
        return new FlagSet(value, cl, enumValues);
    }
}

