/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bridj.Dyncall;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.SizeT;

class EllipsisHelper {
    static ThreadLocal<IntBuffer[]> holders = new ThreadLocal<IntBuffer[]>(){

        @Override
        protected IntBuffer[] initialValue() {
            return new IntBuffer[1];
        }
    };

    EllipsisHelper() {
    }

    public static IntBuffer unrollEllipsis(Object[] args) {
        IntBuffer[] holder = holders.get();
        int n = args.length;
        IntBuffer buf = holder[0];
        if (buf == null || buf.capacity() < n) {
            buf = ByteBuffer.allocateDirect(n * 4).asIntBuffer();
        }
        for (int i = 0; i < n; ++i) {
            Dyncall.ValueType type;
            Object arg = args[i];
            if (arg == null || arg instanceof Pointer) {
                type = Dyncall.ValueType.ePointerValue;
            } else if (arg instanceof Integer) {
                type = Dyncall.ValueType.eIntValue;
            } else if (arg instanceof Long) {
                type = Dyncall.ValueType.eLongValue;
            } else if (arg instanceof Short) {
                type = Dyncall.ValueType.eShortValue;
            } else if (arg instanceof Double) {
                type = Dyncall.ValueType.eDoubleValue;
            } else if (arg instanceof Float) {
                type = Dyncall.ValueType.eFloatValue;
            } else if (arg instanceof Byte) {
                type = Dyncall.ValueType.eByteValue;
            } else if (arg instanceof Boolean) {
                type = Dyncall.ValueType.eBooleanValue;
            } else if (arg instanceof Character) {
                type = Dyncall.ValueType.eWCharValue;
            } else if (arg instanceof SizeT) {
                type = Dyncall.ValueType.eSizeTValue;
                args[i] = arg = Long.valueOf(((SizeT)arg).longValue());
            } else if (arg instanceof NativeObject) {
                type = Dyncall.ValueType.eNativeObjectValue;
            } else {
                throw new IllegalArgumentException("Argument type not handled in variable argument calls  : " + arg + " (" + arg.getClass().getName() + ")");
            }
            buf.put(i, type.ordinal());
        }
        return buf;
    }
}

