/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.FlagSet;
import org.bridj.JNI;
import org.bridj.NativeLibrary;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.ValuedEnum;
import org.bridj.ann.CLong;
import org.bridj.ann.Convention;
import org.bridj.ann.Ptr;
import org.bridj.util.DefaultParameterizedType;

public abstract class Demangler {
    protected final String str;
    protected final int length;
    protected int position = 0;
    protected final NativeLibrary library;

    static Annotations annotations(final Annotation[] aa) {
        return new Annotations(){

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> c) {
                for (Annotation a : aa) {
                    if (!c.isInstance(a)) continue;
                    return (A)a;
                }
                return null;
            }
        };
    }

    static Annotations annotations(final AnnotatedElement e) {
        return new Annotations(){

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> c) {
                return e.getAnnotation(c);
            }
        };
    }

    public abstract MemberRef parseSymbol() throws DemanglingException;

    public Demangler(NativeLibrary library, String str) {
        this.str = str;
        this.length = str.length();
        this.library = library;
    }

    public String getString() {
        return this.str;
    }

    protected void expectChars(char ... cs) throws DemanglingException {
        for (char c : cs) {
            char cc = this.consumeChar();
            if (cc == c) continue;
            throw this.error("Expected char '" + c + "', found '" + cc + "'");
        }
    }

    protected void expectAnyChar(char ... cs) throws DemanglingException {
        char cc = this.consumeChar();
        for (char c : cs) {
            if (cc != c) continue;
            return;
        }
        throw this.error("Expected any of " + Arrays.toString(cs) + ", found '" + cc + "'");
    }

    public static StringBuilder implode(StringBuilder b, Object[] items, String sep) {
        return Demangler.implode(b, Arrays.asList(items), sep);
    }

    public static StringBuilder implode(StringBuilder b, Iterable<?> items, String sep) {
        boolean first = true;
        for (Object item : items) {
            if (first) {
                first = false;
            } else {
                b.append(sep);
            }
            b.append(item);
        }
        return b;
    }

    protected char peekChar() {
        return this.position >= this.length ? (char)'\u0000' : this.str.charAt(this.position);
    }

    protected char lastChar() {
        return this.position == 0 ? (char)'\u0000' : this.str.charAt(this.position - 1);
    }

    protected char consumeChar() {
        char c = this.peekChar();
        if (c != '\u0000') {
            ++this.position;
        }
        return c;
    }

    protected boolean consumeCharsIf(char ... nextChars) {
        int initialPosition = this.position;
        for (char c : nextChars) {
            char cc = this.consumeChar();
            if (cc == c) continue;
            this.position = initialPosition;
            return false;
        }
        return true;
    }

    protected boolean consumeCharIf(char ... allowedChars) {
        char c = this.peekChar();
        for (char allowedChar : allowedChars) {
            if (allowedChar != c) continue;
            ++this.position;
            return true;
        }
        return false;
    }

    protected DemanglingException error(int deltaPosition) {
        return this.error(null, deltaPosition);
    }

    protected DemanglingException error(String mess) {
        return this.error(mess, -1);
    }

    protected DemanglingException error(String mess, int deltaPosition) {
        StringBuilder err = new StringBuilder(this.position + 1);
        int position = this.position + deltaPosition;
        for (int i = 0; i < position; ++i) {
            err.append(' ');
        }
        err.append('^');
        return new DemanglingException("Parsing error at position " + position + (mess == null ? "" : ": " + mess) + " \n\t" + this.str + "\n\t" + err);
    }

    protected static TypeRef pointerType(TypeRef tr) {
        return new PointerTypeRef(tr);
    }

    protected static TypeRef classType(Class<?> c, Class<? extends Annotation> ... annotations) {
        return Demangler.classType(c, null, annotations);
    }

    protected static TypeRef classType(Class<?> c, Type[] genericTypes, Class<? extends Annotation> ... annotations) {
        JavaTypeRef tr = new JavaTypeRef();
        tr.type = genericTypes == null ? c : new DefaultParameterizedType(c, genericTypes);
        tr.annotations = annotations;
        return tr;
    }

    protected static TypeRef simpleType(String name) {
        return new ClassRef(name);
    }

    static Class<?> getTypeClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Class<Integer> c = (Class<Integer>)pt.getRawType();
            if (ValuedEnum.class.isAssignableFrom(c)) {
                Type[] types = pt.getActualTypeArguments();
                c = types == null || types.length != 1 ? Integer.TYPE : Demangler.getTypeClass(pt.getActualTypeArguments()[0]);
            }
            return c;
        }
        throw new UnsupportedOperationException("Unknown type type : " + type.getClass().getName());
    }

    static void appendTemplateArgs(StringBuilder b, Object[] params) {
        if (params == null || params.length == 0) {
            return;
        }
        Demangler.appendArgs(b, '<', '>', params);
    }

    static void appendArgs(StringBuilder b, char pre, char post, Object[] params) {
        b.append(pre);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(params[i]);
            }
        }
        b.append(post);
    }

    public static class MemberRef {
        private Integer argumentsStackSize;
        private TypeRef enclosingType;
        private TypeRef valueType;
        private Object memberName;
        Boolean isStatic;
        Boolean isProtected;
        Boolean isPrivate;
        public int modifiers;
        public TypeRef[] paramTypes;
        public TypeRef[] throwTypes;
        TemplateArg[] templateArguments;
        public Convention.Style callingConvention;

        public Integer getArgumentsStackSize() {
            return this.argumentsStackSize;
        }

        public void setArgumentsStackSize(Integer argumentsStackSize) {
            this.argumentsStackSize = argumentsStackSize;
        }

        public boolean matchesSingleThisPointerVoidMethod(Class<?> type) {
            if (this.getEnclosingType() != null && !this.getEnclosingType().matches(type, Demangler.annotations(type))) {
                return false;
            }
            if (this.getValueType() != null && !this.getValueType().matches(Void.TYPE, null)) {
                return false;
            }
            Type[] methodArgTypes = new Type[]{Long.TYPE};
            return this.matchesArgs(methodArgTypes, null, true);
        }

        protected boolean matchesVirtualTable(Class<?> type) {
            return this.memberName == SpecialName.VFTable && this.getEnclosingType() != null && this.getEnclosingType().matches(type, Demangler.annotations(type));
        }

        protected boolean matchesConstructor(Class<?> type) {
            return this.memberName == SpecialName.Constructor && this.matchesSingleThisPointerVoidMethod(type);
        }

        protected boolean matchesDestructor(Class<?> type) {
            return this.memberName == SpecialName.Destructor && this.matchesSingleThisPointerVoidMethod(type);
        }

        static boolean hasInstance(Object[] array, Class<?> ... cs) {
            for (Object o : array) {
                for (Class<?> c : cs) {
                    if (!c.isInstance(o)) continue;
                    return true;
                }
            }
            return false;
        }

        static int getArgumentsStackSize(Method method) {
            int total = 0;
            Type[] paramTypes = method.getGenericParameterTypes();
            Annotation[][] anns = method.getParameterAnnotations();
            int nArgs = paramTypes.length;
            for (int iArg = 0; iArg < nArgs; ++iArg) {
                Class<?> paramType = Demangler.getTypeClass(paramTypes[iArg]);
                if (paramType == Integer.TYPE) {
                    total += 4;
                    continue;
                }
                if (paramType == Long.TYPE) {
                    if (MemberRef.hasInstance(anns[iArg], Ptr.class, CLong.class)) {
                        total += Pointer.SIZE;
                        continue;
                    }
                    total += 8;
                    continue;
                }
                if (paramType == Float.TYPE) {
                    total += 4;
                    continue;
                }
                if (paramType == Double.TYPE) {
                    total += 8;
                    continue;
                }
                if (paramType == Byte.TYPE) {
                    ++total;
                    continue;
                }
                if (paramType == Character.TYPE) {
                    total += JNI.WCHAR_T_SIZE;
                    continue;
                }
                if (paramType == Short.TYPE) {
                    total += 2;
                    continue;
                }
                if (paramType == Boolean.TYPE) {
                    ++total;
                    continue;
                }
                if (Pointer.class.isAssignableFrom(paramType)) {
                    total += Pointer.SIZE;
                    continue;
                }
                if (NativeObject.class.isAssignableFrom(paramType)) {
                    total += ((CRuntime)BridJ.getRuntime(paramType)).sizeOf(paramTypes[iArg], null);
                    continue;
                }
                if (FlagSet.class.isAssignableFrom(paramType)) {
                    total += 4;
                    continue;
                }
                throw new RuntimeException("Type not handled : " + paramType.getName());
            }
            return total;
        }

        protected boolean matches(Method method) {
            boolean hasThisAsFirstArgument;
            if (this.memberName instanceof SpecialName) {
                return false;
            }
            if (this.getArgumentsStackSize() != null && this.getArgumentsStackSize() != MemberRef.getArgumentsStackSize(method)) {
                return false;
            }
            if (this.getEnclosingType() != null && !this.getEnclosingType().matches(method.getDeclaringClass(), Demangler.annotations(method))) {
                return false;
            }
            if (this.getMemberName() != null && !this.getMemberName().equals(method.getName())) {
                return false;
            }
            if (this.getValueType() != null && !this.getValueType().matches(method.getReturnType(), Demangler.annotations(method))) {
                return false;
            }
            Annotation[][] anns = method.getParameterAnnotations();
            Type[] parameterTypes = method.getGenericParameterTypes();
            return this.matchesArgs(parameterTypes, anns, hasThisAsFirstArgument = BridJ.hasThisAsFirstArgument(method));
        }

        private boolean matchesArgs(Type[] parameterTypes, Annotation[][] anns, boolean hasThisAsFirstArgument) {
            int i;
            int n;
            int totalArgs = 0;
            int n2 = n = this.templateArguments == null ? 0 : this.templateArguments.length;
            for (i = 0; i < n; ++i) {
                if (totalArgs >= parameterTypes.length) {
                    return false;
                }
                Type paramType = parameterTypes[i];
                TemplateArg arg = this.templateArguments[i];
                if (arg instanceof TypeRef) {
                    if (!paramType.equals(Class.class)) {
                        return false;
                    }
                } else if (arg instanceof Constant) {
                    try {
                        Demangler.getTypeClass(paramType).cast(((Constant)arg).value);
                    }
                    catch (ClassCastException ex) {
                        return false;
                    }
                }
                ++totalArgs;
            }
            if (hasThisAsFirstArgument) {
                ++totalArgs;
            }
            int n3 = n = this.paramTypes == null ? 0 : this.paramTypes.length;
            for (i = 0; i < n; ++i) {
                if (totalArgs >= parameterTypes.length) {
                    return false;
                }
                if (!this.paramTypes[i].matches(parameterTypes[totalArgs], Demangler.annotations(anns[i]))) {
                    return false;
                }
                ++totalArgs;
            }
            return totalArgs == parameterTypes.length;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.valueType).append(' ');
            boolean nameWritten = false;
            if (this.enclosingType != null) {
                b.append(this.enclosingType);
                b.append('.');
                if (this.memberName instanceof SpecialName) {
                    switch ((SpecialName)((Object)this.memberName)) {
                        case Destructor: {
                            b.append('~');
                        }
                        case Constructor: {
                            b.append(((ClassRef)this.enclosingType).simpleName);
                            nameWritten = true;
                        }
                    }
                }
            }
            if (!nameWritten) {
                b.append(this.memberName);
            }
            Demangler.appendTemplateArgs(b, this.templateArguments);
            Demangler.appendArgs(b, '(', ')', this.paramTypes);
            return b.toString();
        }

        public void setMemberName(Object memberName) {
            this.memberName = memberName;
        }

        public Object getMemberName() {
            return this.memberName;
        }

        public void setValueType(TypeRef valueType) {
            this.valueType = valueType;
        }

        public TypeRef getValueType() {
            return this.valueType;
        }

        public void setEnclosingType(TypeRef enclosingType) {
            this.enclosingType = enclosingType;
        }

        public TypeRef getEnclosingType() {
            return this.enclosingType;
        }
    }

    public static enum SpecialName {
        Constructor("", true, true),
        SpecialConstructor("", true, true),
        Destructor("", true, true),
        SelfishDestructor("", true, true),
        DeletingDestructor("", true, true),
        New("new", true, true),
        Delete("delete", true, true),
        VFTable("vftable", false, true),
        VBTable("vbtable", false, true),
        VCall("vcall", false, false),
        TypeOf("typeof", false, false),
        ScalarDeletingDestructor("'scalar deleting destructor'", true, true),
        VectorDeletingDestructor("'vector deleting destructor'", true, true),
        OperatorAssign("operator=", true, true),
        OperatorRShift("operator>>", true, true),
        OperatorDivideAssign("operator/=", true, true),
        OperatorModuloAssign("operator%=", true, true),
        OperatorRShiftAssign("operator>>=", true, true),
        OperatorLShiftAssign("operator<<=", true, true),
        OperatorBitAndAssign("operator&=", true, true),
        OperatorBitOrAssign("operator|=", true, true),
        OperatorXORAssign("operator^=", true, true),
        OperatorLShift("operator<<", true, true),
        OperatorLogicNot("operator!", true, true),
        OperatorEquals("operator==", true, true),
        OperatorDifferent("operator!=", true, true),
        OperatorSquareBrackets("operator[]", true, true),
        OperatorCast("'some cast operator'", true, true),
        OperatorArrow("operator->", true, true),
        OperatorMultiply("operator*", true, true),
        OperatorIncrement("operator++", true, true),
        OperatorDecrement("operator--", true, true),
        OperatorSubstract("operator-", true, true),
        OperatorAdd("operator+", true, true),
        OperatorBitAnd("operator&=", true, true),
        OperatorArrowStar("operator->*", true, true),
        OperatorDivide("operator/", true, true),
        OperatorModulo("operator%", true, true),
        OperatorLower("operator<", true, true),
        OperatorLowerEquals("operator<=", true, true),
        OperatorGreater("operator>", true, true),
        OperatorGreaterEquals("operator>=", true, true),
        OperatorComma("operator,", true, true),
        OperatorParenthesis("operator()", true, true),
        OperatorBitNot("operator~", true, true),
        OperatorXOR("operator^", true, true),
        OperatorBitOr("operator|", true, true),
        OperatorLogicAnd("operator&&", true, true),
        OperatorLogicOr("operator||", true, true),
        OperatorMultiplyAssign("operator*=", true, true),
        OperatorAddAssign("operator+=", true, true),
        OperatorSubstractAssign("operator-=", true, true);

        final String name;
        final boolean isFunction;
        final boolean isMember;

        private SpecialName(String name, boolean isFunction, boolean isMember) {
            this.name = name;
            this.isFunction = isFunction;
            this.isMember = isMember;
        }

        public String toString() {
            return this.name;
        }

        public boolean isFunction() {
            return this.isFunction;
        }

        public boolean isMember() {
            return this.isMember;
        }
    }

    public static class FunctionTypeRef
    extends TypeRef {
        MemberRef function;

        public FunctionTypeRef(MemberRef function) {
            this.function = function;
        }

        @Override
        public StringBuilder getQualifiedName(StringBuilder b, boolean generic) {
            return null;
        }

        public String toString() {
            return this.function.toString();
        }
    }

    public static class ClassRef
    extends TypeRef {
        private TypeRef enclosingType;
        private Object simpleName;
        TemplateArg[] templateArguments;

        public ClassRef() {
        }

        public ClassRef(String simpleName) {
            this.simpleName = simpleName;
        }

        @Override
        public StringBuilder getQualifiedName(StringBuilder b, boolean generic) {
            if (this.getEnclosingType() instanceof ClassRef) {
                this.getEnclosingType().getQualifiedName(b, generic).append('$');
            } else if (this.getEnclosingType() instanceof NamespaceRef) {
                this.getEnclosingType().getQualifiedName(b, generic).append('.');
            }
            b.append(this.getSimpleName());
            if (generic && this.templateArguments != null) {
                int args = 0;
                for (TemplateArg arg : this.templateArguments) {
                    if (!(arg instanceof TypeRef)) continue;
                    if (args == 0) {
                        b.append('<');
                    } else {
                        b.append(", ");
                    }
                    ((TypeRef)arg).getQualifiedName(b, generic);
                    ++args;
                }
                if (args > 0) {
                    b.append('>');
                }
            }
            return b;
        }

        public void setSimpleName(Object simpleName) {
            this.simpleName = simpleName;
        }

        public Object getSimpleName() {
            return this.simpleName;
        }

        public void setEnclosingType(TypeRef enclosingType) {
            this.enclosingType = enclosingType;
        }

        public TypeRef getEnclosingType() {
            return this.enclosingType;
        }

        public void setTemplateArguments(TemplateArg[] templateArguments) {
            this.templateArguments = templateArguments;
        }

        public TemplateArg[] getTemplateArguments() {
            return this.templateArguments;
        }

        @Override
        public boolean matches(Type type, Annotations annotations) {
            return Demangler.getTypeClass(type).getSimpleName().equals(this.simpleName);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (this.enclosingType != null) {
                b.append(this.enclosingType).append('.');
            }
            b.append(this.simpleName);
            Demangler.appendTemplateArgs(b, this.templateArguments);
            return b.toString();
        }
    }

    public static class JavaTypeRef
    extends TypeRef {
        Type type;
        Class<? extends Annotation>[] annotations;

        @Override
        public StringBuilder getQualifiedName(StringBuilder b, boolean generic) {
            return b.append(Demangler.getTypeClass(this.type).getName());
        }

        @Override
        public boolean matches(Type type, Annotations annotations) {
            Class<?> typec;
            Class<?> tc = Demangler.getTypeClass(this.type);
            if (tc == (typec = Demangler.getTypeClass(type))) {
                return true;
            }
            if (type == Long.TYPE && Pointer.class.isAssignableFrom(tc) || Pointer.class.isAssignableFrom(typec) && tc == Long.TYPE) {
                return true;
            }
            if (type == Long.TYPE && annotations != null) {
                boolean isCLong;
                boolean isPtr = annotations.getAnnotation(Ptr.class) != null;
                boolean bl = isCLong = annotations.getAnnotation(CLong.class) != null;
                if (isPtr || isCLong) {
                    return true;
                }
            }
            if (tc == CLong.class ? (typec == Integer.TYPE || typec == Integer.class) && JNI.CLONG_SIZE == 4 || typec == Long.TYPE || typec == Long.class : tc == SizeT.class && ((typec == Integer.TYPE || typec == Integer.class) && JNI.SIZE_T_SIZE == 4 || typec == Long.TYPE || typec == Long.class)) {
                return true;
            }
            if (!(tc != Character.TYPE && tc != Character.class && tc != Short.TYPE && tc != Short.class || typec != Short.class && typec != Short.TYPE && typec != Character.TYPE && typec != Character.class)) {
                return true;
            }
            if ((tc == Integer.class || tc == Integer.TYPE) && ValuedEnum.class.isAssignableFrom(typec)) {
                return true;
            }
            return typec.equals(tc);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (Class<? extends Annotation> ann : this.annotations) {
                b.append(ann.getSimpleName()).append(' ');
            }
            b.append(this.type instanceof Class ? ((Class)this.type).getSimpleName() : this.type.toString());
            return b.toString();
        }
    }

    public static class PointerTypeRef
    extends TypeRef {
        public TypeRef pointedType;

        public PointerTypeRef(TypeRef pointedType) {
            this.pointedType = pointedType;
        }

        @Override
        public StringBuilder getQualifiedName(StringBuilder b, boolean generic) {
            return b.append("org.bridj.Pointer");
        }
    }

    public static class NamespaceRef
    extends TypeRef {
        Object[] namespace;

        public NamespaceRef(Object[] namespace) {
            this.namespace = namespace;
        }

        @Override
        public StringBuilder getQualifiedName(StringBuilder b, boolean generic) {
            return Demangler.implode(b, this.namespace, ".");
        }

        public String toString() {
            return this.getQualifiedName(new StringBuilder(), true).toString();
        }
    }

    public static class Constant
    implements TemplateArg {
        Object value;

        public Constant(Object value) {
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static abstract class TypeRef
    implements TemplateArg {
        public abstract StringBuilder getQualifiedName(StringBuilder var1, boolean var2);

        public boolean matches(Type type, Annotations annotations) {
            return this.getQualifiedName(new StringBuilder(), false).toString().equals(Demangler.getTypeClass(type).getName());
        }
    }

    public static class Symbol {
        final String symbol;
        long address;
        MemberRef ref;
        boolean refParsed;
        final NativeLibrary library;

        public Symbol(String symbol, NativeLibrary library) {
            this.symbol = symbol;
            this.library = library;
        }

        public String toString() {
            return this.symbol + (this.ref == null ? "" : " (" + this.ref + ")");
        }

        public long getAddress() {
            if (this.address == 0L) {
                this.address = this.library.getSymbolAddress(this.symbol);
            }
            return this.address;
        }

        public boolean matches(Method method) {
            if (!this.symbol.contains(method.getName())) {
                return false;
            }
            this.parse();
            try {
                if (this.ref != null) {
                    boolean res = this.ref.matches(method);
                    if (!res) {
                        System.err.println("Symbol " + this.symbol + " was a good candidate but expected demangled signature " + this.ref + " did not match the method " + method);
                    }
                    return res;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        public MemberRef getParsedRef() {
            this.parse();
            return this.ref;
        }

        void parse() {
            if (!this.refParsed) {
                try {
                    this.ref = this.library.parseSymbol(this.symbol);
                }
                catch (DemanglingException ex) {
                    System.err.println(ex);
                }
                this.refParsed = true;
            }
        }

        public String getName() {
            return this.symbol;
        }

        public boolean matchesVirtualTable(Class<?> type) {
            if (!this.symbol.contains(type.getSimpleName())) {
                return false;
            }
            this.parse();
            try {
                if (this.ref != null) {
                    return this.ref.matchesVirtualTable(type);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        public boolean matchesConstructor(Class<?> type) {
            if (!this.symbol.contains(type.getSimpleName())) {
                return false;
            }
            this.parse();
            try {
                if (this.ref != null) {
                    return this.ref.matchesConstructor(type);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        public boolean matchesDestructor(Class<?> type) {
            if (!this.symbol.contains(type.getSimpleName())) {
                return false;
            }
            this.parse();
            try {
                if (this.ref != null) {
                    return this.ref.matchesDestructor(type);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        public boolean isVirtualTable() {
            return false;
        }
    }

    public static interface TemplateArg {
    }

    public static class DemanglingException
    extends Exception {
        public DemanglingException(String mess) {
            super(mess);
        }
    }

    static interface Annotations {
        public <A extends Annotation> A getAnnotation(Class<A> var1);
    }
}

