/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.bridj.CLong;
import org.bridj.Callback;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.SizeT;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.TypedPointer;
import org.bridj.util.DefaultParameterizedType;

class CommonPointerIOs {
    public static final PointerIO<Integer> intIO = new PointerIO<Integer>(Integer.class, 4, null){

        @Override
        public Integer get(Pointer<Integer> pointer, long index) {
            return pointer.getInt(index * 4L);
        }

        @Override
        public void set(Pointer<Integer> pointer, long index, Integer value) {
            pointer.setInt(index * 4L, value);
        }

        @Override
        public Object getArray(Pointer<Integer> pointer, long byteOffset, int length) {
            return pointer.getInts(byteOffset, length);
        }

        @Override
        public void setArray(Pointer<Integer> pointer, long byteOffset, Object array) {
            if (array instanceof int[]) {
                pointer.setInts(byteOffset, (int[])array);
            } else {
                super.setArray(pointer, byteOffset, array);
            }
        }
    };
    public static final PointerIO<Long> longIO = new PointerIO<Long>(Long.class, 8, null){

        @Override
        public Long get(Pointer<Long> pointer, long index) {
            return pointer.getLong(index * 8L);
        }

        @Override
        public void set(Pointer<Long> pointer, long index, Long value) {
            pointer.setLong(index * 8L, value);
        }

        @Override
        public Object getArray(Pointer<Long> pointer, long byteOffset, int length) {
            return pointer.getLongs(byteOffset, length);
        }

        @Override
        public void setArray(Pointer<Long> pointer, long byteOffset, Object array) {
            if (array instanceof long[]) {
                pointer.setLongs(byteOffset, (long[])array);
            } else {
                super.setArray(pointer, byteOffset, array);
            }
        }
    };
    public static final PointerIO<Short> shortIO = new PointerIO<Short>(Short.class, 2, null){

        @Override
        public Short get(Pointer<Short> pointer, long index) {
            return pointer.getShort(index * 2L);
        }

        @Override
        public void set(Pointer<Short> pointer, long index, Short value) {
            pointer.setShort(index * 2L, value);
        }

        @Override
        public Object getArray(Pointer<Short> pointer, long byteOffset, int length) {
            return pointer.getShorts(byteOffset, length);
        }

        @Override
        public void setArray(Pointer<Short> pointer, long byteOffset, Object array) {
            if (array instanceof short[]) {
                pointer.setShorts(byteOffset, (short[])array);
            } else {
                super.setArray(pointer, byteOffset, array);
            }
        }
    };
    public static final PointerIO<Byte> byteIO = new PointerIO<Byte>(Byte.class, 1, null){

        @Override
        public Byte get(Pointer<Byte> pointer, long index) {
            return pointer.getByte(index * 1L);
        }

        @Override
        public void set(Pointer<Byte> pointer, long index, Byte value) {
            pointer.setByte(index * 1L, value);
        }

        @Override
        public Object getArray(Pointer<Byte> pointer, long byteOffset, int length) {
            return pointer.getBytes(byteOffset, length);
        }

        @Override
        public void setArray(Pointer<Byte> pointer, long byteOffset, Object array) {
            if (array instanceof byte[]) {
                pointer.setBytes(byteOffset, (byte[])array);
            } else {
                super.setArray(pointer, byteOffset, array);
            }
        }
    };
    public static final PointerIO<Character> charIO = new PointerIO<Character>(Character.class, 2, null){

        @Override
        public Character get(Pointer<Character> pointer, long index) {
            return Character.valueOf(pointer.getChar(index * 2L));
        }

        @Override
        public void set(Pointer<Character> pointer, long index, Character value) {
            pointer.setChar(index * 2L, value.charValue());
        }

        @Override
        public Object getArray(Pointer<Character> pointer, long byteOffset, int length) {
            return pointer.getChars(byteOffset, length);
        }

        @Override
        public void setArray(Pointer<Character> pointer, long byteOffset, Object array) {
            if (array instanceof char[]) {
                pointer.setChars(byteOffset, (char[])array);
            } else {
                super.setArray(pointer, byteOffset, array);
            }
        }
    };
    public static final PointerIO<Float> floatIO = new PointerIO<Float>(Float.class, 4, null){

        @Override
        public Float get(Pointer<Float> pointer, long index) {
            return Float.valueOf(pointer.getFloat(index * 4L));
        }

        @Override
        public void set(Pointer<Float> pointer, long index, Float value) {
            pointer.setFloat(index * 4L, value.floatValue());
        }

        @Override
        public Object getArray(Pointer<Float> pointer, long byteOffset, int length) {
            return pointer.getFloats(byteOffset, length);
        }

        @Override
        public void setArray(Pointer<Float> pointer, long byteOffset, Object array) {
            if (array instanceof float[]) {
                pointer.setFloats(byteOffset, (float[])array);
            } else {
                super.setArray(pointer, byteOffset, array);
            }
        }
    };
    public static final PointerIO<Double> doubleIO = new PointerIO<Double>(Double.class, 8, null){

        @Override
        public Double get(Pointer<Double> pointer, long index) {
            return pointer.getDouble(index * 8L);
        }

        @Override
        public void set(Pointer<Double> pointer, long index, Double value) {
            pointer.setDouble(index * 8L, value);
        }

        @Override
        public Object getArray(Pointer<Double> pointer, long byteOffset, int length) {
            return pointer.getDoubles(byteOffset, length);
        }

        @Override
        public void setArray(Pointer<Double> pointer, long byteOffset, Object array) {
            if (array instanceof double[]) {
                pointer.setDoubles(byteOffset, (double[])array);
            } else {
                super.setArray(pointer, byteOffset, array);
            }
        }
    };
    public static final PointerIO<Boolean> booleanIO = new PointerIO<Boolean>(Boolean.class, 1, null){

        @Override
        public Boolean get(Pointer<Boolean> pointer, long index) {
            return pointer.getBoolean(index * 1L);
        }

        @Override
        public void set(Pointer<Boolean> pointer, long index, Boolean value) {
            pointer.setBoolean(index * 1L, value);
        }

        @Override
        public Object getArray(Pointer<Boolean> pointer, long byteOffset, int length) {
            return pointer.getBooleans(byteOffset, length);
        }

        @Override
        public void setArray(Pointer<Boolean> pointer, long byteOffset, Object array) {
            if (array instanceof boolean[]) {
                pointer.setBooleans(byteOffset, (boolean[])array);
            } else {
                super.setArray(pointer, byteOffset, array);
            }
        }
    };
    public static final PointerIO<SizeT> sizeTIO = new PointerIO<SizeT>(SizeT.class, SizeT.SIZE, null){

        @Override
        public SizeT get(Pointer<SizeT> pointer, long index) {
            return new SizeT(pointer.getSizeT(index * (long)SizeT.SIZE));
        }

        @Override
        public void set(Pointer<SizeT> pointer, long index, SizeT value) {
            pointer.setSizeT(index * (long)SizeT.SIZE, value == null ? 0L : value.longValue());
        }
    };
    public static final PointerIO<CLong> clongIO = new PointerIO<CLong>(CLong.class, CLong.SIZE, null){

        @Override
        public CLong get(Pointer<CLong> pointer, long index) {
            return new CLong(pointer.getCLong(index * (long)CLong.SIZE));
        }

        @Override
        public void set(Pointer<CLong> pointer, long index, CLong value) {
            pointer.setCLong(index * (long)CLong.SIZE, value == null ? 0L : value.longValue());
        }
    };

    CommonPointerIOs() {
    }

    static class TypedPointerPointerIO<P extends TypedPointer>
    extends PointerIO<P> {
        final Constructor cons;
        final Class<P> pointerClass;

        public TypedPointerPointerIO(Class<P> pointerClass) {
            super(pointerClass, Pointer.SIZE, null);
            this.pointerClass = pointerClass;
            try {
                this.cons = pointerClass.getConstructor(Long.TYPE);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot find constructor for " + pointerClass.getName(), ex);
            }
        }

        @Override
        public P castTarget(long peer) {
            try {
                return (P)((TypedPointer)this.cons.newInstance(peer));
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot create pointer of type " + this.pointerClass.getName(), ex);
            }
        }

        @Override
        public P get(Pointer<P> pointer, long index) {
            try {
                return (P)((TypedPointer)this.cons.newInstance(pointer.getSizeT(index * (long)Pointer.SIZE)));
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot create pointer of type " + this.pointerClass.getName(), ex);
            }
        }

        @Override
        public void set(Pointer<P> pointer, long index, P value) {
            pointer.setPointer(index * (long)Pointer.SIZE, (Pointer<?>)value);
        }
    }

    static class CallbackPointerIO<T extends Callback>
    extends PointerIO<T> {
        final Class<T> callbackClass;

        public CallbackPointerIO(Class<T> callbackClass) {
            super(callbackClass, Pointer.SIZE, null);
            this.callbackClass = callbackClass;
        }

        @Override
        public T get(Pointer<T> pointer, long index) {
            if (index != 0L) {
                throw new UnsupportedOperationException("Cannot get function pointer at index different from 0");
            }
            return (T)((Callback)pointer.getNativeObject(0L, this.callbackClass));
        }

        @Override
        public void set(Pointer<T> pointer, long index, T value) {
            throw new UnsupportedOperationException("Cannot write to body of function");
        }
    }

    static class PointerArrayIO<T>
    extends PointerIO<Pointer<T>> {
        final PointerIO<T> underlyingIO;
        final long[] dimensions;
        final long totalRemainingDims;
        final int iDimension;

        static Type arrayPtrType(Type elementType, long ... dimensions) {
            Type type = elementType;
            for (int i = 0; i < dimensions.length; ++i) {
                type = DefaultParameterizedType.paramType(Pointer.class, new Type[]{type});
            }
            return type;
        }

        static long getTotalRemainingDims(long[] dimensions, int iDimension) {
            long d = 1L;
            for (int i = iDimension + 1; i < dimensions.length; ++i) {
                d *= dimensions[i];
            }
            return d;
        }

        public PointerArrayIO(PointerIO<T> underlyingIO, long[] dimensions, int iDimension) {
            super(underlyingIO == null ? null : PointerArrayIO.arrayPtrType(underlyingIO.getTargetType(), dimensions), -1, null);
            this.underlyingIO = iDimension >= dimensions.length - 2 ? underlyingIO : new PointerArrayIO<T>(underlyingIO, dimensions, iDimension + 1);
            this.dimensions = dimensions;
            this.iDimension = iDimension;
            this.totalRemainingDims = PointerArrayIO.getTotalRemainingDims(dimensions, iDimension);
        }

        @Override
        public long getTargetSize() {
            return this.underlyingIO.getTargetSize() * this.totalRemainingDims;
        }

        @Override
        public Pointer<T> get(Pointer<Pointer<T>> pointer, long index) {
            long offset = this.getOffset(index);
            return pointer.offset(offset * this.underlyingIO.getTargetSize()).withIO(this.underlyingIO);
        }

        long getOffset(long index) {
            assert (this.iDimension < this.dimensions.length);
            return index * this.totalRemainingDims;
        }

        @Override
        public void set(Pointer<Pointer<T>> pointer, long index, Pointer<T> value) {
            throw new RuntimeException("Cannot set a multi-dimensional array's sub-arrays pointers !");
        }
    }

    static class PointerPointerIO<T>
    extends PointerIO<Pointer<T>> {
        final PointerIO<T> underlyingIO;

        public PointerPointerIO(PointerIO<T> underlyingIO) {
            super(underlyingIO == null ? null : DefaultParameterizedType.paramType(Pointer.class, new Type[]{underlyingIO.getTargetType()}), Pointer.SIZE, null);
            this.underlyingIO = underlyingIO;
        }

        @Override
        public Pointer<T> get(Pointer<Pointer<T>> pointer, long index) {
            return pointer.getPointer(index * (long)Pointer.SIZE, this.underlyingIO);
        }

        @Override
        public void set(Pointer<Pointer<T>> pointer, long index, Pointer<T> value) {
            pointer.setPointer(index * (long)Pointer.SIZE, value);
        }
    }

    static class StructPointerIO<S extends StructObject>
    extends PointerIO<S> {
        final StructIO structIO;

        public StructPointerIO(StructIO structIO) {
            super(structIO.getStructType(), -1, null);
            this.structIO = structIO;
        }

        @Override
        public long getTargetSize() {
            this.structIO.build();
            return this.structIO.getStructSize();
        }

        @Override
        public S get(Pointer<S> pointer, long index) {
            return (S)((StructObject)pointer.getNativeObject(index * this.getTargetSize(), this.structIO.getStructType()));
        }

        @Override
        public void set(Pointer<S> pointer, long index, S value) {
            Pointer<S> ps = Pointer.pointerTo(value);
            pointer.getByteBuffer(index * this.getTargetSize()).put(ps.getByteBuffer(0L));
        }

        @Override
        public int getTargetAlignment() {
            return this.structIO.getStructAlignment();
        }
    }
}

