/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bridj.AbstractBridJRuntime;
import org.bridj.BridJ;
import org.bridj.BridJRuntime;
import org.bridj.Callback;
import org.bridj.CallbackNativeImplementer;
import org.bridj.Demangler;
import org.bridj.JNI;
import org.bridj.MethodCallInfo;
import org.bridj.NativeEntities;
import org.bridj.NativeLibrary;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.Utils;
import org.bridj.ann.Optional;
import org.bridj.util.AutoHashMap;

public class CRuntime
extends AbstractBridJRuntime {
    final Set<Type> registeredTypes = new HashSet<Type>();
    final CallbackNativeImplementer callbackNativeImplementer = new CallbackNativeImplementer(BridJ.getOrphanEntities(), this);
    static final int defaultObjectSize = 128;
    public static final String PROPERTY_bridj_c_defaultObjectSize = "bridj.c.defaultObjectSize";

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public <T extends NativeObject> Class<? extends T> getActualInstanceClass(Pointer<T> pInstance, Type officialType) {
        return Utils.getClass(officialType);
    }

    @Override
    public <T extends NativeObject> BridJRuntime.TypeInfo<T> getTypeInfo(Type type) {
        return new CTypeInfo(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Type type) {
        if (!this.registeredTypes.add(type)) {
            return;
        }
        Class typeClass = Utils.getClass(type);
        assert (this.log(Level.INFO, "Registering type " + typeClass.getName()));
        int typeModifiers = typeClass.getModifiers();
        AutoHashMap builders = new AutoHashMap(NativeEntities.Builder.class);
        try {
            HashSet<Method> handledMethods = new HashSet<Method>();
            if (Callback.class.isAssignableFrom(typeClass)) {
                if (Callback.class == type) {
                    return;
                }
                if (Modifier.isAbstract(typeModifiers)) {
                    this.callbackNativeImplementer.getCallbackImplType((Class)type);
                }
            }
            try {
                NativeLibrary typeLibrary = this.getNativeLibrary(typeClass);
                for (Method method : typeClass.getDeclaredMethods()) {
                    if (handledMethods.contains(method)) continue;
                    try {
                        int modifiers = method.getModifiers();
                        if (!Modifier.isNative(modifiers)) continue;
                        NativeEntities.Builder builder = builders.get(BridJ.getNativeEntities(method));
                        NativeLibrary methodLibrary = BridJ.getNativeLibrary(method);
                        this.registerNativeMethod(typeClass, typeLibrary, method, methodLibrary, builder);
                        handledMethods.add(method);
                    }
                    catch (Exception ex) {
                        assert (this.log(Level.SEVERE, "Method " + method.toGenericString() + " cannot be mapped : " + ex, ex));
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to register class " + typeClass.getName(), ex);
            }
        }
        finally {
            for (Map.Entry e : builders.entrySet()) {
                ((NativeEntities)e.getKey()).addDefinitions(typeClass, (NativeEntities.Builder)e.getValue());
            }
            if ((typeClass = typeClass.getSuperclass()) != null && typeClass != Object.class) {
                this.register(typeClass);
            }
        }
    }

    protected NativeLibrary getNativeLibrary(Class<?> type) throws FileNotFoundException {
        return BridJ.getNativeLibrary(type);
    }

    protected void registerNativeMethod(Class<?> type, NativeLibrary typeLibrary, Method method, NativeLibrary methodLibrary, NativeEntities.Builder builder) throws FileNotFoundException {
        MethodCallInfo mci = new MethodCallInfo(method);
        if (Callback.class.isAssignableFrom(type)) {
            this.log(Level.INFO, "Registering java -> native callback : " + method);
            builder.addJavaToNativeCallback(mci);
        } else {
            Demangler.Symbol symbol;
            Demangler.Symbol symbol2 = symbol = methodLibrary == null ? null : methodLibrary.getSymbol(method);
            if (symbol == null) {
                boolean isOptional = method.getAnnotation(Optional.class) != null;
                this.log(isOptional ? Level.INFO : Level.SEVERE, "Failed to get address of method " + method);
                return;
            }
            mci.setForwardedPointer(symbol.getAddress());
            builder.addFunction(mci);
            this.log(Level.INFO, "Registering " + method + " as C function " + symbol.getName());
        }
    }

    public <T extends NativeObject> Pointer<T> allocate(Class<T> type, int constructorId, Object ... args) {
        if (Callback.class.isAssignableFrom(type)) {
            if (constructorId != -1 || args.length != 0) {
                throw new RuntimeException("Callback should have a constructorId == -1 and no constructor args !");
            }
            return null;
        }
        throw new RuntimeException("Cannot allocate instance of type " + type.getName() + " (unhandled NativeObject subclass)");
    }

    public int getDefaultStructSize() {
        String s = System.getProperty(PROPERTY_bridj_c_defaultObjectSize);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Throwable th) {
                this.log(Level.SEVERE, "Invalid value for property bridj.c.defaultObjectSize : '" + s + "'");
            }
        }
        return 128;
    }

    protected int sizeOf(Type structType, StructIO io) {
        int size;
        if (io == null) {
            io = StructIO.getInstance(Utils.getClass(structType), structType);
        }
        if (io == null || (size = io.getStructSize()) == 0) {
            return this.getDefaultStructSize();
        }
        return size;
    }

    static Method getUniqueAbstractCallbackMethod(Class type) {
        Class parent = null;
        while ((parent = type.getSuperclass()) != null && parent != Callback.class) {
            type = parent;
        }
        Method method = null;
        for (Method dm : type.getDeclaredMethods()) {
            int modifiers = dm.getModifiers();
            if (!Modifier.isAbstract(modifiers)) continue;
            method = dm;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Type doesn't have any abstract method : " + type.getName());
        }
        return method;
    }

    public <T extends NativeObject> Class<? extends T> getTypeForCast(Type type) {
        Class typeClass = Utils.getClass(type);
        if (Callback.class.isAssignableFrom(typeClass)) {
            return this.callbackNativeImplementer.getCallbackImplType(typeClass);
        }
        return typeClass;
    }

    private <T extends Callback<?>> Pointer<T> registerCallbackInstance(T instance) {
        try {
            Class<?> c = instance.getClass();
            MethodCallInfo mci = new MethodCallInfo(CRuntime.getUniqueAbstractCallbackMethod(c));
            mci.setDeclaringClass(c);
            mci.setJavaCallback(instance);
            long handle = JNI.createCToJavaCallback(mci);
            long peer = JNI.getActualCToJavaCallback(handle);
            return Pointer.pointerToAddress(peer, c, new Pointer.Releaser(){

                @Override
                public void release(Pointer<?> pointer) {
                    JNI.freeCToJavaCallback(pointer.getPeer());
                }
            });
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to register callback instance of type " + instance.getClass().getName(), e);
        }
    }

    protected void setNativeObjectPeer(NativeObject instance, Pointer<? extends NativeObject> peer) {
        instance.peer = peer;
    }

    public class CTypeInfo<T extends NativeObject>
    implements BridJRuntime.TypeInfo<T> {
        protected final Type type;
        protected final Class<T> typeClass;
        protected final StructIO structIO;
        protected final PointerIO<T> pointerIO;
        protected Class<?> castClass;

        public CTypeInfo(Type type) {
            this.type = type;
            this.typeClass = Utils.getClass(type);
            this.structIO = StructIO.getInstance(this.typeClass, this.typeClass);
            if (this.structIO != null) {
                this.structIO.build();
            }
            this.pointerIO = PointerIO.getInstance(this.structIO);
            CRuntime.this.register(this.typeClass);
        }

        @Override
        public long sizeOf(T instance) {
            return this.structIO.getStructSize();
        }

        @Override
        public boolean equal(T instance, T other) {
            if (this.structIO != null) {
                if (((StructObject)instance).io != this.structIO) {
                    throw new IllegalArgumentException("This is not this instance's StructIO");
                }
                if (((StructObject)other).io != this.structIO) {
                    return false;
                }
                return this.structIO.equal((StructObject)instance, (StructObject)other);
            }
            return ((NativeObject)instance).peer.equals(((NativeObject)other).peer);
        }

        @Override
        public int compare(T instance, T other) {
            if (this.structIO != null) {
                if (((StructObject)instance).io != this.structIO) {
                    throw new IllegalArgumentException("This is not this instance's StructIO");
                }
                if (((StructObject)other).io != this.structIO) {
                    return 1;
                }
                return this.structIO.compare((StructObject)instance, (StructObject)other);
            }
            return ((NativeObject)instance).peer.compareTo(((NativeObject)other).peer);
        }

        @Override
        public BridJRuntime getRuntime() {
            return CRuntime.this;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        synchronized Class<?> getCastClass() {
            if (this.castClass == null) {
                this.castClass = CRuntime.this.getTypeForCast(this.typeClass);
            }
            return this.castClass;
        }

        @Override
        public T cast(Pointer peer) {
            try {
                NativeObject instance = (NativeObject)this.getCastClass().newInstance();
                this.initialize(instance, peer);
                return (T)instance;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to cast pointer " + peer + " to instance of type " + this.typeClass.getName(), ex);
            }
        }

        @Override
        public void initialize(T instance) {
            if (!BridJ.isCastingNativeObjectInCurrentThread()) {
                if (instance instanceof Callback) {
                    CRuntime.this.setNativeObjectPeer((NativeObject)instance, CRuntime.this.registerCallbackInstance((Callback)instance));
                } else {
                    this.initialize(instance, -1, this.structIO);
                }
            } else if (instance instanceof StructObject) {
                ((StructObject)instance).io = this.structIO;
            }
        }

        @Override
        public void initialize(T instance, Pointer peer) {
            ((NativeObject)instance).peer = peer;
            if (instance instanceof StructObject) {
                ((StructObject)instance).io = this.structIO;
            }
        }

        @Override
        public void initialize(T instance, int constructorId, Object ... args) {
            StructObject s = (StructObject)instance;
            if (constructorId >= 0) {
                throw new UnsupportedOperationException("TODO implement structs constructors !");
            }
            s.io = this.structIO;
            ((NativeObject)instance).peer = Pointer.allocate(this.pointerIO);
        }

        @Override
        public T clone(T instance) throws CloneNotSupportedException {
            if (instance == null) {
                return null;
            }
            try {
                NativeObject clone = (NativeObject)this.typeClass.newInstance();
                Pointer<T> p = Pointer.allocate(this.pointerIO);
                Pointer.pointerTo(instance).copyTo(p);
                this.initialize(clone, p);
                return (T)clone;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to clone instance of type " + this.getType());
            }
        }

        @Override
        public void destroy(T instance) {
            if (instance instanceof Callback) {
                return;
            }
        }
    }
}

