/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridj.BridJRuntime;
import org.bridj.Demangler;
import org.bridj.HeadersReconstructor;
import org.bridj.JNI;
import org.bridj.NativeEntities;
import org.bridj.NativeLibrary;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.Utils;
import org.bridj.ann.Constructor;
import org.bridj.ann.Library;
import org.bridj.ann.Runtime;

public class BridJ {
    static final Map<AnnotatedElement, NativeLibrary> librariesByClass = new HashMap<AnnotatedElement, NativeLibrary>();
    static final Map<String, File> librariesFilesByName = new HashMap<String, File>();
    static final Map<File, NativeLibrary> librariesByFile = new HashMap<File, NativeLibrary>();
    private static NativeEntities orphanEntities = new NativeEntities();
    static final Map<Class<?>, BridJRuntime> classRuntimes = new HashMap();
    static final Map<Long, NativeObject> strongNativeObjects = new HashMap<Long, NativeObject>();
    static final Map<Long, NativeObject> weakNativeObjects = new WeakHashMap<Long, NativeObject>();
    static ThreadLocal<Stack<Boolean>> currentlyCastingNativeObject;
    private static Map<Class<? extends BridJRuntime>, BridJRuntime> runtimes;
    static Map<Type, BridJRuntime.TypeInfo<?>> typeInfos;
    static final boolean verbose;
    static final int minLogLevel;
    static Map<String, NativeLibrary> libHandles;
    static List<String> paths;
    static Map<String, String> libraryActualNames;
    static Boolean directModeEnabled;

    public static long sizeOf(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof NativeObject) {
            NativeObject no = (NativeObject)o;
            return no.typeInfo.sizeOf(no);
        }
        throw new RuntimeException("Unable to compute size for object " + o + " of type " + o.getClass().getName());
    }

    static synchronized void registerNativeObject(NativeObject ob) {
        weakNativeObjects.put(Pointer.getAddress(ob, null), ob);
    }

    static synchronized NativeObject getNativeObject(long peer) {
        NativeObject ob = weakNativeObjects.get(peer);
        if (ob == null) {
            ob = strongNativeObjects.get(peer);
        }
        return ob;
    }

    static synchronized void unregisterNativeObject(NativeObject ob) {
        long peer = Pointer.getAddress(ob, null);
        weakNativeObjects.remove(peer);
        strongNativeObjects.remove(peer);
    }

    public static synchronized void protectFromGC(NativeObject ob) {
        long peer = Pointer.getAddress(ob, null);
        if (weakNativeObjects.remove(peer) != null) {
            strongNativeObjects.put(peer, ob);
        }
    }

    public static synchronized void unprotectFromGC(NativeObject ob) {
        long peer = Pointer.getAddress(ob, null);
        if (strongNativeObjects.remove(peer) != null) {
            weakNativeObjects.put(peer, ob);
        }
    }

    static boolean hasThisAsFirstArgument(Method method) {
        return method.getAnnotation(Constructor.class) != null;
    }

    public static void delete(NativeObject nativeObject) {
        BridJ.unregisterNativeObject(nativeObject);
        Pointer.pointerTo(nativeObject, null).release();
    }

    public static synchronized void register() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        if (stackTrace.length < 2) {
            throw new RuntimeException("No useful stack trace : cannot register with register(), please use register(Class) instead.");
        }
        String name = stackTrace[1].getClassName();
        try {
            Class<?> type = Class.forName(name);
            BridJ.register(type);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to register class " + name, ex);
        }
    }

    static boolean isCastingNativeObjectInCurrentThread() {
        return currentlyCastingNativeObject.get().peek();
    }

    public static <O extends NativeObject> O createNativeObjectFromPointer(Pointer<? super O> pointer, Type type) {
        Stack<Boolean> s = currentlyCastingNativeObject.get();
        s.push(true);
        try {
            Object instance;
            BridJRuntime.TypeInfo typeInfo = BridJ.getTypeInfo(type);
            Object t = instance = typeInfo.cast(pointer);
            return (O)t;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to cast pointer to native object of type " + Utils.getClass(type).getName(), ex);
        }
        finally {
            s.pop();
        }
    }

    public static synchronized <R extends BridJRuntime> R getRuntimeByRuntimeClass(Class<R> runtimeClass) {
        BridJRuntime r = runtimes.get(runtimeClass);
        if (r == null) {
            try {
                r = (BridJRuntime)runtimeClass.newInstance();
                runtimes.put(runtimeClass, r);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate runtime " + runtimeClass.getName(), e);
            }
        }
        return (R)r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BridJRuntime getRuntime(Class<?> type) {
        Map<Class<?>, BridJRuntime> map = classRuntimes;
        synchronized (map) {
            BridJRuntime runtime = classRuntimes.get(type);
            if (runtime == null) {
                Runtime runtimeAnn = BridJ.getAnnotation(Runtime.class, true, type, new Annotation[0]);
                if (runtimeAnn == null) {
                    throw new IllegalArgumentException("Class " + type.getName() + " has no " + Runtime.class.getName() + " annotation. Unable to guess the corresponding " + BridJRuntime.class.getName() + " implementation.");
                }
                runtime = BridJ.getRuntimeByRuntimeClass(runtimeAnn.value());
                classRuntimes.put(type, runtime);
            }
            return runtime;
        }
    }

    public static BridJRuntime register(Class<?> type) {
        BridJRuntime runtime = BridJ.getRuntime(type);
        runtime.register(type);
        return runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends NativeObject> BridJRuntime.TypeInfo<T> getTypeInfo(Type t) {
        Map<Type, BridJRuntime.TypeInfo<?>> map = typeInfos;
        synchronized (map) {
            BridJRuntime.TypeInfo<Object> info = typeInfos.get(t);
            if (info == null) {
                info = BridJ.getRuntime(Utils.getClass(t)).getTypeInfo(t);
                typeInfos.put(t, info);
            }
            return info;
        }
    }

    static boolean shouldLog(Level level) {
        return verbose || level.intValue() >= minLogLevel;
    }

    static boolean log(Level level, String message, Throwable ex) {
        if (!BridJ.shouldLog(level)) {
            return true;
        }
        Logger.getLogger(BridJ.class.getName()).log(level, message, ex);
        return true;
    }

    static boolean log(Level level, String message) {
        BridJ.log(level, message, null);
        return true;
    }

    public static synchronized NativeEntities getNativeEntities(AnnotatedElement type) throws FileNotFoundException {
        NativeLibrary lib = BridJ.getNativeLibrary(type);
        if (lib != null) {
            return lib.getNativeEntities();
        }
        return BridJ.getOrphanEntities();
    }

    public static synchronized NativeLibrary getNativeLibrary(AnnotatedElement type) throws FileNotFoundException {
        String name;
        NativeLibrary lib = librariesByClass.get(type);
        if (lib == null && (lib = BridJ.getNativeLibrary(name = BridJ.getNativeLibraryName(type))) != null) {
            librariesByClass.put(type, lib);
        }
        return lib;
    }

    public static synchronized void releaseAll() {
        strongNativeObjects.clear();
        weakNativeObjects.clear();
        System.gc();
        for (NativeLibrary lib : librariesByFile.values()) {
            lib.release();
        }
        librariesByFile.clear();
        librariesByClass.clear();
        BridJ.getOrphanEntities().release();
        System.gc();
    }

    public static synchronized void releaseLibrary(String name) {
        File file = librariesFilesByName.remove(name);
        if (file != null) {
            BridJ.releaseLibrary(file);
        }
    }

    public static synchronized void releaseLibrary(File library) {
        NativeLibrary lib = librariesByFile.remove(library);
        if (lib != null) {
            lib.release();
        }
    }

    static synchronized List<String> getNativeLibraryPaths() {
        if (paths == null) {
            paths = new ArrayList<String>();
            paths.add(null);
            paths.add(".");
            String env = System.getenv("LD_LIBRARY_PATH");
            if (env != null) {
                paths.addAll(Arrays.asList(env.split(File.pathSeparator)));
            }
            if ((env = System.getenv("DYLD_LIBRARY_PATH")) != null) {
                paths.addAll(Arrays.asList(env.split(File.pathSeparator)));
            }
            if ((env = System.getenv("PATH")) != null) {
                paths.addAll(Arrays.asList(env.split(File.pathSeparator)));
            }
            if ((env = System.getProperty("java.library.path")) != null) {
                paths.addAll(Arrays.asList(env.split(File.pathSeparator)));
            }
        }
        return paths;
    }

    public static void setNativeLibraryActualName(String name, String actualName) {
        libraryActualNames.put(name, actualName);
    }

    public static File getNativeLibraryFile(String name) {
        if (name == null) {
            return null;
        }
        String actualName = libraryActualNames.get(name);
        if (actualName != null) {
            name = actualName;
        }
        for (String path : BridJ.getNativeLibraryPaths()) {
            File pathFile;
            try {
                pathFile = path == null ? null : new File(path).getCanonicalFile();
            }
            catch (IOException ex) {
                BridJ.log(Level.SEVERE, null, ex);
                continue;
            }
            File f = new File(name);
            if (pathFile != null) {
                if (JNI.isWindows()) {
                    if (!f.exists()) {
                        f = new File(pathFile, name + ".dll");
                    }
                    if (!f.exists()) {
                        f = new File(pathFile, name + ".drv");
                    }
                } else if (JNI.isUnix()) {
                    if (JNI.isMacOSX()) {
                        if (!f.exists()) {
                            f = new File(pathFile, "lib" + name + ".dylib");
                        }
                    } else {
                        if (!f.exists()) {
                            f = new File(pathFile, "lib" + name + ".so");
                        }
                        if (!f.exists()) {
                            f = new File(pathFile, name + ".so");
                        }
                    }
                    if (!f.exists()) {
                        f = new File(pathFile, "lib" + name + ".jnilib");
                    }
                }
            }
            if (!f.exists()) continue;
            try {
                return f.getCanonicalFile();
            }
            catch (IOException ex) {
                BridJ.log(Level.SEVERE, null, ex);
            }
        }
        if (JNI.isMacOSX()) {
            for (String s : new String[]{"/System/Library/Frameworks", new File(System.getProperty("user.home"), "Library/Frameworks").toString()}) {
                try {
                    File f = new File(new File(s, name + ".framework"), name);
                    if (!f.exists() || f.isDirectory()) continue;
                    return f.getCanonicalFile();
                }
                catch (IOException ex) {
                    return null;
                }
            }
        }
        try {
            return JNI.extractEmbeddedLibraryResource(name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean isDirectModeEnabled() {
        if (directModeEnabled == null) {
            String prop = System.getProperty("bridj.direct");
            String env = System.getenv("BRIDJ_DIRECT");
            directModeEnabled = !"false".equalsIgnoreCase(prop) && !"false".equalsIgnoreCase(env) && !"0".equals(env) && !"no".equalsIgnoreCase(env);
            BridJ.log(Level.INFO, "directModeEnabled = " + directModeEnabled + " (" + System.getProperty("bridj.direct") + ")");
        }
        return directModeEnabled;
    }

    static void setDirectModeEnabled(boolean v) {
        directModeEnabled = v;
    }

    public static synchronized NativeLibrary getNativeLibrary(String name) throws FileNotFoundException {
        if (name == null) {
            return null;
        }
        NativeLibrary l = libHandles.get(name);
        if (l != null) {
            return l;
        }
        File f = BridJ.getNativeLibraryFile(name);
        if (f == null) {
            throw new FileNotFoundException("Couldn't find library file for library '" + name + "'");
        }
        return BridJ.getNativeLibrary(name, f);
    }

    public static NativeLibrary getNativeLibrary(String name, File f) throws FileNotFoundException {
        NativeLibrary ll = NativeLibrary.load(f.toString());
        if (ll == null) {
            throw new FileNotFoundException("Library '" + name + "' was not found in path '" + BridJ.getNativeLibraryPaths() + "'" + (f.exists() ? " (failed to load " + f + ")" : ""));
        }
        libHandles.put(name, ll);
        return ll;
    }

    public static String getNativeLibraryName(AnnotatedElement m) {
        Library lib = BridJ.getAnnotation(Library.class, true, m, new Annotation[0]);
        return lib == null ? null : lib.value();
    }

    static <A extends Annotation> A getAnnotation(Class<A> ac, boolean inherit, AnnotatedElement m, Annotation ... directAnnotations) {
        if (directAnnotations != null) {
            for (Annotation ann : directAnnotations) {
                if (!ac.isInstance(ann)) continue;
                return (A)((Annotation)ac.cast(ann));
            }
        }
        if (m == null) {
            return null;
        }
        A a = m.getAnnotation(ac);
        if (a != null) {
            return a;
        }
        if (inherit) {
            Class c;
            Class<?> dc;
            if (m instanceof Member) {
                return BridJ.getAnnotation(ac, inherit, ((Member)((Object)m)).getDeclaringClass(), new Annotation[0]);
            }
            if (m instanceof Class && (dc = (c = (Class)m).getDeclaringClass()) != null) {
                return BridJ.getAnnotation(ac, inherit, dc, new Annotation[0]);
            }
        }
        return null;
    }

    public static Demangler.Symbol getSymbolByAddress(long peer) {
        for (NativeLibrary lib : libHandles.values()) {
            Demangler.Symbol symbol = lib.getSymbol(peer);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public static void setOrphanEntities(NativeEntities orphanEntities) {
        BridJ.orphanEntities = orphanEntities;
    }

    public static NativeEntities getOrphanEntities() {
        return orphanEntities;
    }

    static void initialize(NativeObject instance) {
        BridJRuntime.TypeInfo<NativeObject> typeInfo;
        instance.typeInfo = typeInfo = BridJ.getTypeInfo(instance.getClass());
        typeInfo.initialize(instance);
    }

    static void initialize(NativeObject instance, Pointer peer) {
        BridJRuntime.TypeInfo<NativeObject> typeInfo;
        instance.typeInfo = typeInfo = BridJ.getTypeInfo(instance.getClass());
        typeInfo.initialize(instance, peer);
    }

    static void initialize(NativeObject instance, int constructorId, Object[] args) {
        BridJRuntime.TypeInfo<NativeObject> typeInfo;
        instance.typeInfo = typeInfo = BridJ.getTypeInfo(instance.getClass());
        typeInfo.initialize(instance, constructorId, args);
    }

    public static <T extends NativeObject> T clone(T instance) throws CloneNotSupportedException {
        return instance.typeInfo.clone(instance);
    }

    public static void main(String[] args) {
        ArrayList<NativeLibrary> libraries = new ArrayList<NativeLibrary>();
        try {
            for (String arg : args) {
                NativeLibrary lib = BridJ.getNativeLibrary(arg);
                libraries.add(lib);
            }
            String file = "out.h";
            PrintWriter out = new PrintWriter(new File(file));
            HeadersReconstructor.reconstructHeaders(libraries, out);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static final void open(URL url) throws NoSuchMethodException {
        if (url.getProtocol().equals("file")) {
            BridJ.open(new File(url.getFile()));
        } else if (JNI.isMacOSX()) {
            BridJ.execArgs("open", url.toString());
        } else if (JNI.isWindows()) {
            BridJ.execArgs("rundll32", "url.dll,FileProtocolHandler", url.toString());
        } else if (JNI.isUnix() && BridJ.hasUnixCommand("gnome-open")) {
            BridJ.execArgs("gnome-open", url.toString());
        } else if (JNI.isUnix() && BridJ.hasUnixCommand("konqueror")) {
            BridJ.execArgs("konqueror", url.toString());
        } else if (JNI.isUnix() && BridJ.hasUnixCommand("mozilla")) {
            BridJ.execArgs("mozilla", url.toString());
        } else {
            throw new NoSuchMethodException("Cannot open urls on this platform");
        }
    }

    public static final void open(File file) throws NoSuchMethodException {
        if (JNI.isMacOSX()) {
            BridJ.execArgs("open", file.getAbsolutePath());
        } else if (JNI.isWindows()) {
            if (file.isDirectory()) {
                BridJ.execArgs("explorer", file.getAbsolutePath());
            } else {
                BridJ.execArgs("start", file.getAbsolutePath());
            }
        }
        if (JNI.isUnix() && BridJ.hasUnixCommand("gnome-open")) {
            BridJ.execArgs("gnome-open", file.toString());
        } else if (JNI.isUnix() && BridJ.hasUnixCommand("konqueror")) {
            BridJ.execArgs("konqueror", file.toString());
        } else if (JNI.isSolaris() && file.isDirectory()) {
            BridJ.execArgs("/usr/dt/bin/dtfile", "-folder", file.getAbsolutePath());
        } else {
            throw new NoSuchMethodException("Cannot open files on this platform");
        }
    }

    public static final void show(File file) throws NoSuchMethodException, IOException {
        if (JNI.isWindows()) {
            BridJ.exec("explorer /e,/select,\"" + file.getCanonicalPath() + "\"");
        } else {
            BridJ.open(file.getAbsoluteFile().getParentFile());
        }
    }

    static final void execArgs(String ... cmd) throws NoSuchMethodException {
        try {
            java.lang.Runtime.getRuntime().exec(cmd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NoSuchMethodException(ex.toString());
        }
    }

    static final void exec(String cmd) throws NoSuchMethodException {
        try {
            java.lang.Runtime.getRuntime().exec(cmd).waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NoSuchMethodException(ex.toString());
        }
    }

    static final boolean hasUnixCommand(String name) {
        try {
            Process p = java.lang.Runtime.getRuntime().exec(new String[]{"which", name});
            return p.waitFor() == 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    static {
        java.lang.Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BridJ.releaseAll();
            }
        });
        currentlyCastingNativeObject = new ThreadLocal<Stack<Boolean>>(){

            @Override
            protected Stack<Boolean> initialValue() {
                Stack<Boolean> s = new Stack<Boolean>();
                s.push(false);
                return s;
            }
        };
        runtimes = new HashMap<Class<? extends BridJRuntime>, BridJRuntime>();
        typeInfos = new HashMap();
        verbose = "true".equals(System.getProperty("bridj.verbose"));
        minLogLevel = Level.WARNING.intValue();
        libHandles = new HashMap<String, NativeLibrary>();
        libraryActualNames = new HashMap<String, String>();
    }
}

