/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridj.BridJ;
import org.bridj.BridJRuntime;
import org.bridj.ann.Constructor;

public abstract class AbstractBridJRuntime
implements BridJRuntime {
    protected boolean log(Level level, String message, Throwable ex) {
        if (!BridJ.shouldLog(level)) {
            return true;
        }
        Logger.getLogger(this.getClass().getName()).log(level, message, ex);
        return true;
    }

    protected boolean log(Level level, String message) {
        return this.log(level, message, null);
    }

    protected Method getConstructor(Class<?> type, int constructorId, Object[] args) throws SecurityException, NoSuchMethodException {
        for (Method c : type.getDeclaredMethods()) {
            Constructor ca = c.getAnnotation(Constructor.class);
            if (ca == null) continue;
            if (constructorId < 0) {
                Class<?>[] params = c.getParameterTypes();
                int n = params.length;
                if (n != args.length + 1) continue;
                boolean matches = true;
                for (int i = 0; i < n; ++i) {
                    Class<?> param = params[i];
                    if (i == 0) {
                        if (param == Long.TYPE) continue;
                        matches = false;
                        break;
                    }
                    Object arg = args[i - 1];
                    if ((arg != null || !param.isPrimitive()) && param.isInstance(arg)) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                return c;
            }
            if (ca == null || ca.value() != constructorId) continue;
            return c;
        }
        throw new NoSuchMethodException("Cannot find constructor with index " + constructorId);
    }
}

