/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.PrintStream;
import java.util.EnumSet;
import org.anarres.cpp.Feature;
import org.anarres.cpp.FileLexerSource;
import org.anarres.cpp.InputLexerSource;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.PreprocessorListener;
import org.anarres.cpp.Source;
import org.anarres.cpp.StringLexerSource;
import org.anarres.cpp.Token;
import org.anarres.cpp.Version;
import org.anarres.cpp.Warning;

public class Main {
    private static final Option[] OPTS = new Option[]{new Option("help", 0, 104, null, "Displays help and usage information."), new Option("define", 1, 68, "name=definition", "Defines the given macro."), new Option("undefine", 1, 85, "name", "Undefines the given macro, previously either builtin or defined using -D."), new Option("include", 1, 1, "file", "Process file as if \"#include \"file\"\" appeared as the first line of the primary source file."), new Option("incdir", 1, 73, "dir", "Adds the directory dir to the list of directories to be searched for header files."), new Option("iquote", 1, 0, "dir", "Adds the directory dir to the list of directories to be searched for header files included using \"\"."), new Option("warning", 1, 87, "type", "Enables the named warning class (" + Main.getWarnings() + ")."), new Option("no-warnings", 0, 119, null, "Disables ALL warnings."), new Option("verbose", 0, 118, null, "Operates incredibly verbosely."), new Option("debug", 0, 3, null, "Operates incredibly verbosely."), new Option("version", 0, 2, null, "Prints jcpp's version number (" + Version.getVersion() + ")")};

    private static CharSequence getWarnings() {
        StringBuilder buf = new StringBuilder();
        for (Warning w : Warning.values()) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            String name = w.name().toLowerCase();
            buf.append(name.replace('_', '-'));
        }
        return buf;
    }

    public static void main(String[] args) throws Exception {
        new Main().run(args);
    }

    public void run(String[] args) throws Exception {
        int c;
        LongOpt[] opts = OPTS;
        String sopts = Main.getShortOpts((Option[])opts);
        Getopt g = new Getopt("jcpp", args, sopts, opts);
        Preprocessor pp = new Preprocessor();
        pp.addFeature(Feature.DIGRAPHS);
        pp.addFeature(Feature.TRIGRAPHS);
        pp.addFeature(Feature.LINEMARKERS);
        pp.addWarning(Warning.IMPORT);
        pp.setListener(new PreprocessorListener());
        pp.addMacro("__JCPP__");
        pp.getSystemIncludePath().add("/usr/local/include");
        pp.getSystemIncludePath().add("/usr/include");
        pp.getFrameworksPath().add("/System/Library/Frameworks");
        pp.getFrameworksPath().add("/Library/Frameworks");
        pp.getFrameworksPath().add("/Local/Library/Frameworks");
        block16: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 68: {
                    String arg = g.getOptarg();
                    int idx = arg.indexOf(61);
                    if (idx == -1) {
                        pp.addMacro(arg);
                        continue block16;
                    }
                    pp.addMacro(arg.substring(0, idx), arg.substring(idx + 1));
                    continue block16;
                }
                case 85: {
                    pp.getMacros().remove(g.getOptarg());
                    continue block16;
                }
                case 73: {
                    pp.getSystemIncludePath().add(g.getOptarg());
                    continue block16;
                }
                case 0: {
                    pp.getQuoteIncludePath().add(g.getOptarg());
                    continue block16;
                }
                case 87: {
                    String arg = g.getOptarg().toUpperCase();
                    arg = arg.replace('-', '_');
                    if (arg.equals("ALL")) {
                        pp.addWarnings(EnumSet.allOf(Warning.class));
                        continue block16;
                    }
                    pp.addWarning(Enum.valueOf(Warning.class, arg));
                    continue block16;
                }
                case 119: {
                    pp.getWarnings().clear();
                    continue block16;
                }
                case 1: {
                    pp.addInput(new StringLexerSource("#include \"" + g.getOptarg() + "\"\n"));
                    continue block16;
                }
                case 2: {
                    this.version(System.out);
                    return;
                }
                case 118: {
                    pp.addFeature(Feature.VERBOSE);
                    continue block16;
                }
                case 3: {
                    pp.addFeature(Feature.DEBUG);
                    continue block16;
                }
                case 104: {
                    Main.usage(this.getClass().getName(), (Option[])opts);
                    return;
                }
                default: {
                    throw new Exception("Illegal option " + (char)c);
                }
                case 63: 
            }
        }
        for (int i = g.getOptind(); i < args.length; ++i) {
            pp.addInput(new FileLexerSource(new File(args[i])));
        }
        if (g.getOptind() == args.length) {
            pp.addInput(new InputLexerSource(System.in));
        }
        if (pp.getFeature(Feature.VERBOSE)) {
            System.err.println("#include \"...\" search starts here:");
            for (String dir : pp.getQuoteIncludePath()) {
                System.err.println("  " + dir);
            }
            System.err.println("#include <...> search starts here:");
            for (String dir : pp.getSystemIncludePath()) {
                System.err.println("  " + dir);
            }
            System.err.println("End of search list.");
        }
        try {
            Token tok;
            while ((tok = pp.token()) != null && tok.getType() != 265) {
                System.out.print(tok.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            for (Source s = pp.getSource(); s != null; s = s.getParent()) {
                System.err.println(" -> " + s);
            }
        }
    }

    private void version(PrintStream out) {
        out.println("Anarres Java C Preprocessor version " + Version.getVersion());
        out.println("Copyright (C) 2008 Shevek (http://www.anarres.org/).");
        out.println("This is free software; see the source for copying conditions.  There is NO");
        out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
    }

    private static String getShortOpts(Option[] opts) throws Exception {
        StringBuilder buf = new StringBuilder();
        block5: for (int i = 0; i < opts.length; ++i) {
            char c = (char)opts[i].getVal();
            if (!Character.isLetterOrDigit(c)) continue;
            for (int j = 0; j < buf.length(); ++j) {
                if (buf.charAt(j) != c) continue;
                throw new Exception("Duplicate short option " + c);
            }
            buf.append(c);
            switch (opts[i].getHasArg()) {
                case 0: {
                    continue block5;
                }
                case 2: {
                    buf.append("::");
                    continue block5;
                }
                case 1: {
                    buf.append(":");
                }
            }
        }
        return buf.toString();
    }

    private static String wrap(String in, String prefix, int indent, int width) {
        StringBuilder buf = new StringBuilder(prefix);
        while (buf.length() < indent) {
            buf.append(' ');
        }
        int start = 0;
        while (start < in.length()) {
            while (start < in.length() && Character.isWhitespace(in.charAt(start))) {
                ++start;
            }
            int end2 = start + width - indent;
            if (end2 > in.length()) {
                buf.append(in.substring(start));
                break;
            }
            int idx = end2;
            while (!Character.isWhitespace(in.charAt(idx))) {
                --idx;
            }
            if (idx == start) {
                idx = end2 - 1;
                buf.append(in.substring(start, idx));
                buf.append('-');
            } else {
                buf.append(in.substring(start, idx));
                start = idx;
            }
            start = idx;
        }
        return buf.toString();
    }

    private static void usage(String command, Option[] options) {
        StringBuilder text = new StringBuilder("Usage: ");
        text.append(command).append('\n');
        for (int i = 0; i < options.length; ++i) {
            StringBuilder line = new StringBuilder();
            Option opt = options[i];
            line.append("    --").append(opt.getName());
            switch (opt.getHasArg()) {
                case 0: {
                    break;
                }
                case 2: {
                    line.append("[=").append(opt.eg).append(']');
                    break;
                }
                case 1: {
                    line.append('=').append(opt.eg);
                }
            }
            if (Character.isLetterOrDigit(opt.getVal())) {
                line.append(" (-").append((char)opt.getVal()).append(")");
            }
            if (line.length() < 30) {
                while (line.length() < 30) {
                    line.append(' ');
                }
            } else {
                line.append('\n');
                for (int j = 0; j < 30; ++j) {
                    line.append(' ');
                }
            }
            line.append(opt.help);
            line.append('\n');
            text.append((CharSequence)line);
        }
        System.out.println(text);
    }

    private static class Option
    extends LongOpt {
        private String eg;
        private String help;

        public Option(String word, int arg, int ch, String eg, String help) {
            super(word, arg, null, ch);
            this.eg = eg;
            this.help = help;
        }
    }
}

