/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.HashSet;

public class DeferredFileReader
extends Reader {
    Reader in;
    File file;
    static HashSet<File> files = new HashSet();

    public DeferredFileReader(File file) throws FileNotFoundException {
        this.file = file;
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (!files.add(file)) {
            this.in = new StringReader("");
        }
    }

    protected void open() throws FileNotFoundException {
        if (this.in == null) {
            this.in = new FileReader(this.file);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void mark(int readAheadLimit) throws IOException {
        this.open();
        this.in.mark(readAheadLimit);
    }

    public boolean markSupported() {
        try {
            this.open();
            return this.in.markSupported();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean ready() throws IOException {
        this.open();
        return this.in.ready();
    }

    public void reset() throws IOException {
        this.open();
        this.in.reset();
    }

    public long skip(long n) throws IOException {
        this.open();
        return this.in.skip(n);
    }

    public String toString() {
        return this.getClass().getName() + "[file=" + this.getFile() + "]";
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public int read(CharBuffer target) throws IOException {
        this.open();
        return this.in.read(target);
    }

    public int read(char[] cbuf) throws IOException {
        this.open();
        return this.in.read(cbuf);
    }

    public int read() throws IOException {
        this.open();
        return this.in.read();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        this.open();
        return this.in.read(cbuf, off, len);
    }
}

