/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.Token;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CppTask
extends Task {
    private File input;
    private File output;
    private Preprocessor cpp = new Preprocessor();

    public void setInput(File input) {
        this.input = input;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void addMacro(Macro macro) {
        try {
            this.cpp.addMacro(macro.getName(), macro.getValue());
        }
        catch (LexerException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void execute() {
        OutputStreamWriter writer = null;
        try {
            Token tok;
            if (this.input == null) {
                throw new BuildException("Input not specified");
            }
            if (this.output == null) {
                throw new BuildException("Output not specified");
            }
            this.cpp.addInput(this.input);
            writer = new FileWriter(this.output);
            while ((tok = this.cpp.token()) == null || tok.getType() != 265) {
                writer.write(tok.getText());
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class Macro {
        private String name;
        private String value;

        private Macro() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

