/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.swing.candy;

import com.ochafik.xml.XMLUtils;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class JLinkLabel
extends JLabel {
    private static final long serialVersionUID = -2619802894792618038L;
    Runnable linkAction;
    boolean actInNewThread = false;
    String actualText;

    public JLinkLabel(String text) {
        super(text);
        this.init(null);
    }

    public JLinkLabel(String text, int orientation) {
        super(text, orientation);
        this.init(null);
    }

    public JLinkLabel(String text, int orientation, Runnable linkAction) {
        this(text, orientation, linkAction, false);
    }

    public JLinkLabel(String text, int orientation, Runnable linkAction, boolean actInNewThread) {
        super(text, orientation);
        this.init(linkAction);
        this.setActInNewThread(actInNewThread);
    }

    public JLinkLabel(String text, Runnable linkAction) {
        this(text, linkAction, false);
    }

    public JLinkLabel(String text, Runnable linkAction, boolean actInNewThread) {
        super(text);
        this.init(linkAction);
        this.setActInNewThread(actInNewThread);
    }

    public void setActInNewThread(boolean actInNewThread) {
        this.actInNewThread = actInNewThread;
    }

    public boolean isActInNewThread() {
        return this.actInNewThread;
    }

    protected void enabledChanged() {
        String text = this.actualText;
        if (this.getLinkAction() == null) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (this.isEnabled()) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            if (!this.actualText.startsWith("<html>")) {
                text = "<html><body width='100%'><a href='#'>" + XMLUtils.escapeEntities(this.actualText) + "</a></body></html>";
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (!this.actualText.startsWith("<html>")) {
                text = "<html><body width='100%'><u>" + XMLUtils.escapeEntities(this.actualText) + "</u></body></html>";
            }
        }
        super.setText(text);
        this.setMaximumSize(this.getMinimumSize());
    }

    @Override
    public void setText(String text) {
        this.actualText = text;
        this.enabledChanged();
    }

    private void init(Runnable linkAction2) {
        this.setLinkAction(linkAction2);
        this.enabledChanged();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                JLinkLabel.this.action();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (JLinkLabel.this.isEnabled() && JLinkLabel.this.getLinkAction() != null) {
                    JLinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    JLinkLabel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    public boolean action() {
        Runnable linkAction = this.getLinkAction();
        if (!this.isEnabled() || linkAction == null) {
            return false;
        }
        if (this.isActInNewThread()) {
            new Thread(linkAction).start();
        } else {
            linkAction.run();
        }
        return true;
    }

    public void setLinkAction(Runnable linkAction) {
        this.linkAction = linkAction;
        this.enabledChanged();
    }

    public Runnable getLinkAction() {
        return this.linkAction;
    }
}

