/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.swing;

import com.ochafik.beans.BeansController;
import com.ochafik.swing.FormElement;
import com.ochafik.swing.UndoRedoUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class FormUtils {
    public static Action createUndoAction(final UndoManager undoManager, String name) {
        return new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        };
    }

    public static Action createRedoAction(final UndoManager undoManager, String name) {
        return new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        };
    }

    public static void registerUndoRedoActions(JComponent jtc, Action undoAction, Action redoAction) {
        InputMap inputMap = jtc.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke("pressed UNDO"), "undo");
        inputMap.put(KeyStroke.getKeyStroke("ctrl pressed Z"), "undo");
        inputMap.put(KeyStroke.getKeyStroke("meta pressed Z"), "undo");
        inputMap.put(KeyStroke.getKeyStroke("pressed REDO"), "redo");
        inputMap.put(KeyStroke.getKeyStroke("ctrl pressed Y"), "redo");
        inputMap.put(KeyStroke.getKeyStroke("meta pressed Y"), "redo");
        ActionMap actionMap = jtc.getActionMap();
        actionMap.put("undo", undoAction);
        actionMap.put("redo", redoAction);
    }

    public static final void addUndoRedoSupport(final JTextComponent jtc) {
        jtc.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UndoRedoUtils.registerNewUndoManager(jtc);
            }
        });
        UndoRedoUtils.registerNewUndoManager(jtc);
    }

    public static final JPanel makeEntriesPanel(BeansController<?> beansController, int widthMin, FormElement[] formElements) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        JPanel panel = new JPanel(gbl);
        int space = 5;
        int pad = 1;
        Insets labelsInsets = new Insets(pad, space, pad, space);
        Insets editorsInsets = new Insets(pad, pad, pad, pad);
        for (int i = 0; i < formElements.length; ++i) {
            gbc.gridy = i;
            FormElement formElement = formElements[i];
            JLabel label = new JLabel(formElement.name, 4);
            gbc.fill = 0;
            gbc.anchor = 12;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.insets = labelsInsets;
            gbl.setConstraints(label, gbc);
            panel.add(label);
            Component editor = formElement.editorComponent == null ? beansController.createScrollableViewComponent(formElement.propertyName, null, formElement.title, formElement.toolTip, formElement.largeComponent) : formElement.editorComponent;
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.weightx = 6.0;
            gbc.insets = editorsInsets;
            gbl.setConstraints(editor, gbc);
            panel.add(editor);
        }
        JPanel ret = new JPanel(new BorderLayout());
        ret.add("Center", panel);
        ret.add("South", Box.createHorizontalStrut(widthMin));
        return ret;
    }
}

