/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.studio;

import com.ochafik.io.JTextAreaOutputStream;
import com.ochafik.io.ReadText;
import com.ochafik.io.WriteText;
import com.ochafik.lang.SyntaxUtils;
import com.ochafik.lang.compiler.MemoryFileManager;
import com.ochafik.lang.jnaerator.ClassOutputter;
import com.ochafik.lang.jnaerator.JNAerator;
import com.ochafik.lang.jnaerator.JNAeratorCommandLineArgs;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.studio.AbstractNode;
import com.ochafik.lang.jnaerator.studio.ElementNode;
import com.ochafik.lang.jnaerator.studio.ResultContent;
import com.ochafik.swing.SimpleDocumentAdapter;
import com.ochafik.swing.UndoRedoUtils;
import com.ochafik.swing.syntaxcoloring.CCTokenMarker;
import com.ochafik.swing.syntaxcoloring.JEditTextArea;
import com.ochafik.swing.syntaxcoloring.JavaTokenMarker;
import com.ochafik.swing.syntaxcoloring.TokenMarker;
import com.ochafik.util.SystemUtils;
import com.ochafik.util.listenable.ListenableCollections;
import com.ochafik.util.listenable.ListenableComboModel;
import com.ochafik.util.listenable.ListenableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class JNAeratorStudio
extends JPanel {
    private static final long serialVersionUID = -6061806156049213635L;
    private static final String PREF_RADIX = "JNAeratorStudio.";
    JEditTextArea sourceArea = JNAeratorStudio.textArea(new JavaTokenMarker());
    JEditTextArea resultArea = JNAeratorStudio.textArea(new CCTokenMarker());
    JTextField libraryName = new JTextField("test");
    JLabel classCountLabel = new JLabel("JNAerated class :");
    JComboBox resultsListCombo = new JComboBox();
    JCheckBox directCallingCb = new JCheckBox("Direct Calling (experimental)", false);
    JCheckBox structsAsTopLevelClassesCb = new JCheckBox("Structs as Top-Level classes", true);
    JCheckBox charPtrAsString = new JCheckBox("char*/wchar_t* as (W)String", false);
    JCheckBox reificationCb = new JCheckBox("Reification", false);
    JCheckBox scalaSetters = new JCheckBox("Scala struct field setters", false);
    JCheckBox noCommentNoManglingCb = new JCheckBox("No comment & no mangling", false);
    JComboBox runtimeCombo;
    JTextArea errorsArea = new JTextArea();
    JSplitPane sp;
    ListenableList<ResultContent> results = ListenableCollections.listenableList(new ArrayList());
    MemoryFileManager memoryFileManager;
    static MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JEditTextArea ta = SyntaxUtils.as(e.getSource(), JEditTextArea.class);
            if (ta == null) {
                return;
            }
            int line = ta.getFirstLine();
            if (e.getScrollType() == 0) {
                int u = e.getUnitsToScroll();
                if ((line += u > 0 ? 1 : -1) < 0) {
                    line = 0;
                } else if (line >= ta.getLineCount()) {
                    line = ta.getLineCount() - 1;
                }
                ta.setFirstLine(line);
            }
        }
    };
    JTabbedPane sourceTabs = new JTabbedPane(1);
    JTabbedPane resultTabs = new JTabbedPane(1);
    Action switchOrientationAction = new AbstractAction("Switch Orientation"){

        @Override
        public void actionPerformed(ActionEvent e) {
            JNAeratorStudio.this.switchOrientation();
        }
    };
    Action donateAction = new AbstractAction("Donate to the author"){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SystemUtils.runSystemOpenURL(new URL("http://sourceforge.net/donate/index.php?group_id=266856"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    Action generateAction = new AbstractAction("JNAerate !"){

        @Override
        public void actionPerformed(ActionEvent e) {
            JNAeratorStudio.this.generate();
            JNAeratorStudio.this.generateButton.requestFocus();
        }
    };
    Action aboutJNAeratorAction = this.aboutLink("About JNAerator", "http://code.google.com/p/jnaerator/wiki/AboutJNAerator");
    Action aboutRococoaAction = this.aboutLink("About Rococoa", "http://code.google.com/p/rococoa");
    Action aboutBridJAction = this.aboutLink("About BridJ", "http://code.google.com/p/bridj/wiki");
    Action aboutJNAAction = this.aboutLink("About JNA", "http://jna.dev.java.net/");
    Action showExampleAction = new AbstractAction("Open Example"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JNAeratorStudio.this.sourceArea.getText().trim().length() > 0) {
                if (JOptionPane.showConfirmDialog(JNAeratorStudio.this, "This is going to overwrite the contents of your source text area.\nProceed ?", "Open Example", 2) != 0) {
                    return;
                }
                JNAeratorStudio.this.doShowExample(true);
            }
        }
    };
    Object lastJNAeratedArtifact;
    JButton showJarButton;
    JPanel errorsPane = new JPanel(new BorderLayout());
    JProgressBar statusBar = new JProgressBar();
    private JButton generateButton;

    public void error(String title, String message, Throwable th) {
        JNAeratorStudio.error(this, title, message, th);
    }

    public static void error(Component parent, String title, String message, Throwable th) {
        StringWriter sw = new StringWriter();
        th.printStackTrace(new PrintWriter(sw));
        JScrollPane jsp = new JScrollPane(new JTextArea(sw.toString())){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(500, 500);
            }
        };
        JOptionPane.showMessageDialog(parent, new Object[]{message, jsp}, title == null ? "JNAerator Error" : title, -1);
    }

    public File getDir(String name) {
        File dir = new File(this.getDir(), name);
        dir.mkdirs();
        return dir;
    }

    public File getDir() {
        File dir = new File(System.getProperty("user.home"));
        dir = new File(dir, ".jnaeratorStudio");
        dir = new File(dir, "pad");
        dir.mkdirs();
        return dir;
    }

    public File getInputFile() {
        return new File(this.getDir(), "input.h");
    }

    public File getOutputJarFile() {
        String lib = this.libraryName.getText().trim();
        if (lib.length() == 0) {
            lib = "out";
        }
        return new File(this.getDir(), lib + ".jar");
    }

    void save() throws IOException {
        WriteText.writeText(this.sourceArea.getText(), this.getInputFile());
    }

    static JEditTextArea textArea(TokenMarker marker) {
        JEditTextArea ta = new JEditTextArea(){
            private static final long serialVersionUID = 1L;

            @Override
            public void processKeyEvent(KeyEvent evt) {
                int m;
                if (SystemUtils.isMacOSX() && ((m = evt.getModifiers()) & 4) != 0) {
                    m = m & 0xFFFFFFFB | 2;
                    if ((evt = new KeyEvent(evt.getComponent(), evt.getID(), evt.getWhen(), m, evt.getKeyCode(), evt.getKeyChar(), evt.getKeyLocation())).getID() == 400) {
                        return;
                    }
                }
                super.processKeyEvent(evt);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(100, 100);
            }
        };
        ta.setBorder(BorderFactory.createLoweredBevelBorder());
        ta.setFocusTraversalKeysEnabled(false);
        ta.addMouseWheelListener(mouseWheelListener);
        ta.setPreferredSize(new Dimension(200, 300));
        ta.setTokenMarker(marker);
        return ta;
    }

    public void close(JFrame f) {
        try {
            this.save();
            JNAeratorStudio.setPref("window.width", f.getWidth());
            JNAeratorStudio.setPref("window.height", f.getHeight());
            JNAeratorStudio.setPref("window.extendedState", f.getExtendedState());
            JNAeratorStudio.setPref("options.libraryName", this.libraryName.getText());
            JNAeratorStudio.setPref("options.direct", this.directCallingCb.isSelected());
            JNAeratorStudio.setPref("options.topLevelStructs", this.structsAsTopLevelClassesCb.isSelected());
            JNAeratorStudio.setPref("options.reification", this.reificationCb.isSelected());
            JNAeratorStudio.setPref("options.scalaSetters", this.scalaSetters.isSelected());
            JNAeratorStudio.setPref("options.charPtrAsString", this.charPtrAsString.isSelected());
            JNAeratorStudio.setPref("options.targetRuntime", ((JNAeratorConfig.Runtime)((Object)this.runtimeCombo.getSelectedItem())).name());
            JNAeratorStudio.setPref("options.noCommentNoMangling", this.noCommentNoManglingCb.isSelected());
            JNAeratorStudio.setPref("splitPane.orientation", this.sp.getOrientation());
            JNAeratorStudio.setPref("splitPane.dividedLocation", JNAeratorStudio.getProportionalDividerLocation(this.sp));
            JNAeratorStudio.prefNode().flush();
            System.exit(0);
        }
        catch (Throwable ex) {
            this.error(null, "Error while closing", ex);
        }
    }

    void switchOrientation() {
        boolean hor = this.sp.getOrientation() == 1;
        int l = this.sp.getDividerLocation();
        int d = hor ? this.sp.getWidth() : this.sp.getHeight();
        this.sp.setOrientation(hor ? 0 : 1);
        if (d != 0) {
            this.sp.setDividerLocation((double)l / (double)d);
        }
    }

    AbstractAction aboutLink(final String title, final String urlString) {
        return new AbstractAction(title){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = new URL(urlString);
                    System.out.println(title + ": " + url);
                    SystemUtils.runSystemOpenURL(url);
                }
                catch (Exception ex) {
                    JNAeratorStudio.this.error(null, "Error while opening page '" + title + "'", ex);
                }
            }
        };
    }

    public JNAeratorStudio() {
        super(new BorderLayout());
        ArrayList<JNAeratorConfig.Runtime> runtimeValues = new ArrayList<JNAeratorConfig.Runtime>();
        for (JNAeratorConfig.Runtime runtime : JNAeratorConfig.Runtime.values()) {
            runtimeValues.add(runtime);
        }
        this.runtimeCombo = new JComboBox(runtimeValues.toArray()){
            {
                this.setToolTipText("Target runtime library");
                this.setSelectedItem((Object)JNAeratorConfig.Runtime.JNAerator);
            }
        };
        this.resultsListCombo.setModel(new ListenableComboModel<ResultContent>(this.results));
        JToolBar tb = new JToolBar();
        this.generateButton = tb.add(this.generateAction);
        tb.add(this.donateAction);
        tb.add(this.showExampleAction);
        tb.add(this.switchOrientationAction);
        tb.addSeparator();
        tb.add(this.aboutJNAeratorAction);
        tb.addSeparator();
        tb.add(this.aboutBridJAction);
        tb.add(this.aboutJNAAction);
        tb.add(this.aboutRococoaAction);
        this.add("North", tb);
        this.sourceArea.getDocument().addDocumentListener(new SimpleDocumentAdapter(){

            @Override
            public void updated(DocumentEvent e) {
                JNAeratorStudio.this.setReadyToJNAerate();
            }
        });
        this.add("South", this.statusBar);
        JPanel sourcePane = new JPanel(new BorderLayout());
        JPanel resultPane = new JPanel(new BorderLayout());
        Box libBox = Box.createHorizontalBox();
        this.showJarButton = new JButton("Show JAR");
        this.showJarButton.setEnabled(false);
        this.showJarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JNAeratorStudio.this.lastJNAeratedArtifact == null || !(JNAeratorStudio.this.lastJNAeratedArtifact instanceof File)) {
                    return;
                }
                File file = (File)JNAeratorStudio.this.lastJNAeratedArtifact;
                try {
                    if (file.isDirectory()) {
                        SystemUtils.runSystemOpenDirectory(file);
                    } else {
                        SystemUtils.runSystemOpenFileParent(file);
                    }
                }
                catch (Exception e1) {
                    JNAeratorStudio.this.showJarButton.setEnabled(false);
                    JNAeratorStudio.this.showJarButton.setToolTipText(e1.toString());
                }
            }
        });
        this.statusBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JNAeratorStudio.this.lastJNAeratedArtifact != null && JNAeratorStudio.this.lastJNAeratedArtifact instanceof Throwable) {
                    JNAeratorStudio.this.error(null, null, (Throwable)JNAeratorStudio.this.lastJNAeratedArtifact);
                } else {
                    JNAeratorStudio.this.generateAction.actionPerformed(null);
                }
            }
        });
        libBox.add(new JLabel("Runtime"));
        libBox.add(this.runtimeCombo);
        libBox.add(new JLabel("Library Name :", 4));
        libBox.add(this.libraryName);
        Box optBox = Box.createVerticalBox();
        optBox.add(libBox);
        JPanel optPanel = new JPanel(new GridLayout(2, 3));
        optPanel.add(this.directCallingCb);
        optPanel.add(this.noCommentNoManglingCb);
        optPanel.add(this.structsAsTopLevelClassesCb);
        optPanel.add(this.charPtrAsString);
        optPanel.add(this.scalaSetters);
        optPanel.add(this.reificationCb);
        optBox.add(optPanel);
        for (Component c : optBox.getComponents()) {
            ((JComponent)c).setAlignmentX(0.0f);
        }
        sourcePane.add("North", optBox);
        sourcePane.add("Center", this.sourceArea);
        this.sourceTabs.addTab("Source", sourcePane);
        Box resChoiceBox = Box.createHorizontalBox();
        resChoiceBox.add(this.classCountLabel);
        resChoiceBox.add(this.resultsListCombo);
        resChoiceBox.add(this.showJarButton);
        resultPane.add("North", resChoiceBox);
        resultPane.add("Center", this.resultArea);
        this.sp = new JSplitPane(1, this.sourceTabs, this.resultTabs);
        this.sp.setOneTouchExpandable(true);
        this.sp.setResizeWeight(0.5);
        this.errorsPane.add("Center", new JScrollPane(this.errorsArea));
        this.resultTabs.add("JNAeration Results", resultPane);
        this.resultTabs.add("Logs", this.errorsPane);
        this.add("Center", this.sp);
        this.resultsListCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ResultContent c = (ResultContent)JNAeratorStudio.this.resultsListCombo.getSelectedItem();
                JNAeratorStudio.this.resultArea.setText(c == null ? "" : c.getContent());
                JNAeratorStudio.this.resultArea.scrollTo(0, 0);
            }
        });
        try {
            this.sourceArea.setText(ReadText.readText(this.getInputFile()));
            this.sourceArea.scrollTo(0, 0);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.sourceArea.getText().trim().length() == 0) {
            this.doShowExample(false);
        }
        UndoRedoUtils.registerNewUndoManager(this.sourceArea, this.sourceArea.getDocument());
    }

    void setReadyToJNAerate() {
        this.statusBar.setToolTipText("Click to JNAerate !");
        this.statusBar.setMaximum(1);
        this.statusBar.setMinimum(0);
        this.statusBar.setValue(0);
        this.statusBar.setStringPainted(true);
        this.statusBar.setString("Ready to JNAerate");
        this.statusBar.setIndeterminate(false);
    }

    private void doShowExample(boolean generate) {
        try {
            this.sourceArea.setText(ReadText.readText(this.getClass().getClassLoader().getResourceAsStream("com/ochafik/lang/jnaerator/examples/example.h")));
            this.sourceArea.scrollTo(0, 0);
            if (generate) {
                this.generate();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected void generate() {
        try {
            this.save();
        }
        catch (IOException e1) {
            this.error(null, "Error while saving file", e1);
            return;
        }
        this.setEnabled(false);
        this.errorsArea.setText("");
        this.results.clear();
        this.resultArea.setText("");
        this.generateAction.setEnabled(false);
        this.showJarButton.setEnabled(false);
        this.showJarButton.setToolTipText(null);
        this.statusBar.setIndeterminate(true);
        this.statusBar.setToolTipText("JNAerating...");
        this.lastJNAeratedArtifact = null;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JNAeratorConfig config = new JNAeratorConfig();
                config.outputJar = JNAeratorStudio.this.getOutputJarFile();
                config.compile = true;
                config.useJNADirectCalls = JNAeratorStudio.this.directCallingCb.isSelected();
                config.putTopStructsInSeparateFiles = JNAeratorStudio.this.structsAsTopLevelClassesCb.isSelected();
                config.reification = JNAeratorStudio.this.reificationCb.isSelected();
                config.scalaStructSetters = JNAeratorStudio.this.scalaSetters.isSelected();
                config.stringifyConstCStringReturnValues = config.charPtrAsString = JNAeratorStudio.this.charPtrAsString.isSelected();
                config.runtime = (JNAeratorConfig.Runtime)((Object)JNAeratorStudio.this.runtimeCombo.getSelectedItem());
                config.noComments = config.noMangling = JNAeratorStudio.this.noCommentNoManglingCb.isSelected();
                config.defaultLibrary = JNAeratorStudio.this.libraryName.getText();
                config.libraryForElementsInNullFile = JNAeratorStudio.this.libraryName.getText();
                config.preprocessorConfig.includeStrings.add(JNAeratorStudio.this.sourceArea.getText());
                config.genCPlusPlus = config.runtime == JNAeratorConfig.Runtime.BridJ ? true : config.genCPlusPlus || JNAeratorStudio.this.sourceArea.getText().contains("//@" + JNAeratorCommandLineArgs.OptionDef.CPlusPlusGen.clSwitch);
                config.cacheDir = JNAeratorStudio.this.getDir("cache");
                PrintStream out = System.out;
                PrintStream err = System.err;
                JTextAreaOutputStream to = new JTextAreaOutputStream(JNAeratorStudio.this.errorsArea);
                PrintStream pto = new PrintStream(to);
                System.setOut(pto);
                System.setErr(pto);
                JNAerator.Feedback feedback = new JNAerator.Feedback(){

                    @Override
                    public void setStatus(final String string) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JNAeratorStudio.this.statusBar.setString(string);
                                JNAeratorStudio.this.statusBar.setToolTipText(string);
                            }
                        });
                    }

                    @Override
                    public void setFinished(final File toOpen) {
                        JNAeratorStudio.this.lastJNAeratedArtifact = toOpen;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JNAeratorStudio.this.statusBar.setToolTipText("Click to re-JNAerate !");
                                JNAeratorStudio.this.statusBar.setString("JNAeration completed");
                                JNAeratorStudio.this.showJarButton.setEnabled(true);
                                JNAeratorStudio.this.showJarButton.setToolTipText(toOpen.getAbsolutePath());
                                JNAeratorStudio.this.statusBar.setValue(JNAeratorStudio.this.statusBar.getMaximum());
                                JNAeratorStudio.this.statusBar.setIndeterminate(false);
                            }
                        });
                    }

                    @Override
                    public void setFinished(Throwable e) {
                        JNAeratorStudio.this.statusBar.setToolTipText("Click to examine the JNAeration error report");
                        JNAeratorStudio.this.lastJNAeratedArtifact = e;
                        this.setStatus("JNAeration failed : " + e.toString());
                        JNAeratorStudio.this.statusBar.setValue(JNAeratorStudio.this.statusBar.getMinimum());
                        JNAeratorStudio.this.statusBar.setIndeterminate(false);
                    }

                    @Override
                    public void wrappersGenerated(Result result) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (JNAeratorStudio.this.resultsListCombo.getItemCount() > 0) {
                                    JNAeratorStudio.this.resultsListCombo.setSelectedIndex(0);
                                }
                            }
                        });
                    }

                    @Override
                    public void sourcesParsed(SourceFiles sourceFiles) {
                        final SourceFiles sourceFilesClone = sourceFiles;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String title = "Parsing Tree";
                                int i = JNAeratorStudio.this.sourceTabs.getTabCount();
                                while (i-- != 0) {
                                    if (!title.equals(JNAeratorStudio.this.sourceTabs.getTitleAt(i))) continue;
                                    JNAeratorStudio.this.sourceTabs.removeTabAt(i);
                                    break;
                                }
                                final JTree parsedTree = new JTree(new ElementNode(null, "ROOT", sourceFilesClone));
                                final JEditTextArea selectionContent = JNAeratorStudio.textArea(new CCTokenMarker());
                                parsedTree.addTreeSelectionListener(new TreeSelectionListener(){

                                    @Override
                                    public void valueChanged(TreeSelectionEvent e) {
                                        TreePath selectionPath = parsedTree.getSelectionPath();
                                        AbstractNode c = selectionPath == null ? null : (AbstractNode)selectionPath.getLastPathComponent();
                                        selectionContent.setText(c == null ? "" : c.getContent());
                                        selectionContent.scrollTo(0, 0);
                                    }
                                });
                                JPanel parsePane = new JPanel(new BorderLayout());
                                parsePane.add("West", new JScrollPane(parsedTree));
                                parsePane.add("Center", selectionContent);
                                JNAeratorStudio.this.sourceTabs.addTab(title, parsePane);
                            }
                        });
                    }
                };
                try {
                    new JNAerator(config){

                        @Override
                        public PrintWriter getClassSourceWriter(final ClassOutputter outputter, final String className) throws IOException {
                            ResultContent c = new ResultContent(className){

                                @Override
                                protected void closed() {
                                    try {
                                        PrintWriter w = outputter.getClassSourceWriter(className);
                                        w.write(this.getContent());
                                        w.close();
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            };
                            JNAeratorStudio.this.results.add(c);
                            return c.getPrintWriter();
                        }
                    }.jnaerate(feedback);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(out, err){
                        final /* synthetic */ PrintStream val$out;
                        final /* synthetic */ PrintStream val$err;
                        {
                            this.val$out = printStream;
                            this.val$err = printStream2;
                        }

                        @Override
                        public void run() {
                            JNAeratorStudio.this.generateAction.setEnabled(true);
                            JNAeratorStudio.this.sourceArea.scrollTo(0, 0);
                            JNAeratorStudio.this.setEnabled(true);
                            System.setOut(this.val$out);
                            System.setErr(this.val$err);
                            JNAeratorStudio.this.classCountLabel.setText("JNAerated classes (" + JNAeratorStudio.this.results.size() + ") :");
                            JNAeratorStudio.setTabTitle(JNAeratorStudio.this.resultTabs, JNAeratorStudio.this.errorsPane, "Logs (" + (JNAeratorStudio.this.errorsArea.getLineCount() - 1) + " lines)");
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }.start();
    }

    private static void setTabTitle(JTabbedPane tabs, Component c, String string) {
        int i = tabs.getTabCount();
        while (i-- != 0) {
            Component tc = tabs.getComponent(i);
            if (tc != c) continue;
            tabs.setTitleAt(i, string);
            return;
        }
    }

    static Preferences prefNode() {
        return Preferences.userNodeForPackage(JNAeratorStudio.class);
    }

    public static String getPref(String name, String defaultValue) {
        return JNAeratorStudio.prefNode().get(PREF_RADIX + name, defaultValue);
    }

    public static void setPref(String name, String value) {
        JNAeratorStudio.prefNode().put(PREF_RADIX + name, value);
    }

    public static void setPref(String name, boolean value) {
        JNAeratorStudio.prefNode().putBoolean(PREF_RADIX + name, value);
    }

    public static boolean getPref(String name, boolean defaultValue) {
        return JNAeratorStudio.prefNode().getBoolean(PREF_RADIX + name, defaultValue);
    }

    public static void setPref(String name, double value) {
        JNAeratorStudio.prefNode().putDouble(PREF_RADIX + name, value);
    }

    public static double getPref(String name, double defaultValue) {
        return JNAeratorStudio.prefNode().getDouble(PREF_RADIX + name, defaultValue);
    }

    public static void setPref(String name, int value) {
        JNAeratorStudio.prefNode().putInt(PREF_RADIX + name, value);
    }

    public static int getPref(String name, int defaultValue) {
        return JNAeratorStudio.prefNode().getInt(PREF_RADIX + name, defaultValue);
    }

    public static void main(String[] args) {
        String[] prefArgs = JNAerator.getJNAeratorArgsFromPref();
        if (args.length > 0 || prefArgs != null) {
            String[] nargs = null;
            if (prefArgs != null) {
                nargs = new String[]{};
            } else if (args.length == 1) {
                nargs = new String[]{"@", args[0], "-gui"};
            } else if (args.length == 2 && args[0].equals("-open")) {
                nargs = new String[]{"@", args[1], "-gui"};
            }
            if (nargs != null) {
                JNAerator.main(nargs);
                return;
            }
        }
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting native LAF: " + e);
        }
        String ver = "";
        try {
            ver = " " + ReadText.readText(JNAeratorStudio.class.getClassLoader().getResourceAsStream("VERSION"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        final JFrame f = new JFrame((JNAeratorStudio.class.getSimpleName() + ver).trim());
        final JNAeratorStudio js = new JNAeratorStudio();
        f.getContentPane().add("Center", js);
        try {
            js.libraryName.setText(JNAeratorStudio.getPref("options.libraryName", "test"));
            js.directCallingCb.setSelected(JNAeratorStudio.getPref("options.direct", false));
            js.structsAsTopLevelClassesCb.setSelected(JNAeratorStudio.getPref("options.topLevelStructs", true));
            js.reificationCb.setSelected(JNAeratorStudio.getPref("options.reification", false));
            js.charPtrAsString.setSelected(JNAeratorStudio.getPref("options.charPtrAsString", false));
            js.scalaSetters.setSelected(JNAeratorStudio.getPref("options.scalaSetters", false));
            js.noCommentNoManglingCb.setSelected(JNAeratorStudio.getPref("options.noCommentNoMangling", false));
            js.sp.setOrientation(JNAeratorStudio.getPref("splitPane.orientation", 1));
            js.sp.setDividerLocation(JNAeratorStudio.getPref("splitPane.dividedLocation", 0.5));
            f.setSize(JNAeratorStudio.getPref("window.width", 800), JNAeratorStudio.getPref("height", 600));
            f.setExtendedState(JNAeratorStudio.getPref("window.extendedState", 0));
            js.runtimeCombo.setSelectedItem((Object)JNAeratorConfig.Runtime.valueOf(JNAeratorStudio.getPref("options.targetRuntime", JNAeratorConfig.Runtime.JNAerator.name())));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            f.setExtendedState(6);
            f.setSize(800, 800);
        }
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                js.close(f);
            }
        });
        f.setVisible(true);
    }

    protected static double getProportionalDividerLocation(JSplitPane sp) {
        boolean hor = sp.getOrientation() == 1;
        int l = sp.getDividerLocation();
        int d = hor ? sp.getWidth() : sp.getHeight();
        sp.setOrientation(hor ? 0 : 1);
        return d != 0 ? (double)l / (double)d : 0.5;
    }

    public static class SyntaxException
    extends Exception {
        public SyntaxException(String message) {
            super(message);
        }
    }
}

