/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.studio;

import com.ochafik.util.IteratorEnumeration;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

abstract class AbstractNode
implements TreeNode {
    protected final String name;
    protected final TreeNode parent;
    protected List<TreeNode> children;

    public AbstractNode(TreeNode parent, String name) {
        this.name = name;
        this.parent = parent;
    }

    public Enumeration children() {
        this.buildChildren();
        return new IteratorEnumeration(this.children.iterator());
    }

    @Override
    public boolean getAllowsChildren() {
        this.buildChildren();
        return !this.children.isEmpty();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.buildChildren();
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        this.buildChildren();
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        this.buildChildren();
        return this.children.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        this.buildChildren();
        return this.children.isEmpty();
    }

    public abstract void buildChildren();

    public String toString() {
        return this.name;
    }

    public abstract String getContent();
}

