/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.TypeRef;

public abstract class TypeMutator {
    public static TypeMutator CONST_STAR = new TypeMutator(){

        @Override
        public TypeRef mutateType(TypeRef type) {
            type = new TypeRef.Pointer(type, Declarator.PointerStyle.Pointer);
            type.addModifiers(Modifier.Const);
            return type;
        }
    };
    public static TypeMutator STAR = new TypeMutator(){

        @Override
        public TypeRef mutateType(TypeRef type) {
            return new TypeRef.Pointer(type, Declarator.PointerStyle.Pointer);
        }
    };
    public static TypeMutator HAT = new TypeMutator(){

        @Override
        public TypeRef mutateType(TypeRef type) {
            return new TypeRef.Pointer(type, Declarator.PointerStyle.HatPointer);
        }
    };
    public static TypeMutator AMPERSTAND = new TypeMutator(){

        @Override
        public TypeRef mutateType(TypeRef type) {
            return new TypeRef.Pointer(type, Declarator.PointerStyle.Reference);
        }
    };
    public static TypeMutator CONST = new TypeMutator(){

        @Override
        public TypeRef mutateType(TypeRef type) {
            type.addModifiers(Modifier.Const);
            return type;
        }
    };
    public static TypeMutator BRACKETS = new TypeMutator(){

        @Override
        public TypeRef mutateType(TypeRef type) {
            return new TypeRef.ArrayRef(type, new Expression.EmptyArraySize());
        }
    };

    public abstract TypeRef mutateType(TypeRef var1);

    public static TypeMutator array(final Expression expression) {
        return new TypeMutator(){

            @Override
            public TypeRef mutateType(TypeRef type) {
                return new TypeRef.ArrayRef(type, expression);
            }
        };
    }
}

