/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Struct
extends TypeRef.TaggedTypeRef
implements DeclarationsHolder {
    Type type;
    MemberVisibility nextMemberVisibility = MemberVisibility.Public;
    final List<TypeRef.SimpleTypeRef> parents = new ArrayList<TypeRef.SimpleTypeRef>();
    final List<TypeRef.SimpleTypeRef> protocols = new ArrayList<TypeRef.SimpleTypeRef>();
    String categoryName;
    final List<Declaration> declarations = new ArrayList<Declaration>();

    @Override
    public Struct addModifiers(Modifier ... mds) {
        return (Struct)super.addModifiers(mds);
    }

    @Override
    public Element getNextChild(Element child) {
        Element e = super.getNextChild(child);
        if (e != null) {
            return e;
        }
        e = Struct.getNextSibling(this.protocols, child);
        if (e != null) {
            return e;
        }
        return Struct.getNextSibling(this.declarations, child);
    }

    @Override
    public Element getPreviousChild(Element child) {
        Element e = super.getPreviousChild(child);
        if (e != null) {
            return e;
        }
        e = Struct.getPreviousSibling(this.protocols, child);
        if (e != null) {
            return e;
        }
        return Struct.getPreviousSibling(this.declarations, child);
    }

    @Override
    public boolean replaceChild(Element child, Element by) {
        if (super.replaceChild(child, by)) {
            return true;
        }
        if (Struct.replaceChild(this.protocols, TypeRef.SimpleTypeRef.class, this, child, by)) {
            return true;
        }
        if (Struct.replaceChild(this.parents, TypeRef.SimpleTypeRef.class, this, child, by)) {
            return true;
        }
        return Struct.replaceChild(this.declarations, Declaration.class, this, child, by);
    }

    public static Struct forwardDecl(Identifier.SimpleIdentifier name, Type type) {
        Struct s = new Struct();
        s.setForwardDeclaration(true);
        s.setTag(name);
        s.setType(type);
        return s;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public List<TypeRef.SimpleTypeRef> getParents() {
        return this.unmodifiableList(this.parents);
    }

    public void addParent(Identifier parent) {
        this.addParent(ElementsHelper.typeRef(parent));
    }

    public void addParent(TypeRef.SimpleTypeRef parent) {
        if (parent == null) {
            return;
        }
        parent.setParentElement(this);
        this.parents.add(parent);
    }

    public void setParents(List<TypeRef.SimpleTypeRef> parents) {
        Struct.changeValue((Element)this, this.parents, parents);
    }

    public List<TypeRef.SimpleTypeRef> getProtocols() {
        return this.unmodifiableList(this.protocols);
    }

    public void addProtocol(Identifier parent) {
        this.addProtocol(ElementsHelper.typeRef(parent));
    }

    public void addProtocol(TypeRef.SimpleTypeRef protocol) {
        if (protocol == null) {
            return;
        }
        protocol.setParentElement(this);
        this.protocols.add(protocol);
    }

    public void addProtocols(TypeRef.SimpleTypeRef ... protocols) {
        ArrayList<TypeRef.SimpleTypeRef> l = new ArrayList<TypeRef.SimpleTypeRef>(this.getProtocols());
        l.addAll(Arrays.asList(protocols));
        this.setProtocols(l);
    }

    public void setProtocols(List<TypeRef.SimpleTypeRef> protocols) {
        Struct.changeValue((Element)this, this.protocols, protocols);
    }

    public Struct setType(Type type) {
        this.type = type;
        switch (type) {
            case ObjCClass: 
            case ObjCProtocol: {
                break;
            }
            case CPPClass: {
                this.setNextMemberVisibility(MemberVisibility.Private);
                break;
            }
            case CStruct: 
            case JavaClass: 
            case JavaInterface: {
                this.setNextMemberVisibility(MemberVisibility.Public);
                break;
            }
        }
        return this;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public List<Declaration> getDeclarations() {
        return this.unmodifiableList(this.declarations);
    }

    @Override
    public void addDeclaration(Declaration d) {
        if (d == null) {
            return;
        }
        d.setVisibility(this.getNextMemberVisibility());
        d.setParentElement(this);
        this.declarations.add(d);
    }

    public void addDeclarations(Collection<? extends Declaration> ds) {
        if (ds == null) {
            return;
        }
        for (Declaration declaration : ds) {
            this.addDeclaration(declaration);
        }
    }

    public void setDeclarations(List<Declaration> declarations) {
        Struct.changeValue((Element)this, this.declarations, declarations);
    }

    public void setNextMemberVisibility(MemberVisibility nextVisibility) {
        this.nextMemberVisibility = nextVisibility;
    }

    public MemberVisibility getNextMemberVisibility() {
        return this.nextMemberVisibility;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitStruct(this);
    }

    public void setParents(TypeRef.SimpleTypeRef ... ns) {
        this.setParents(Arrays.asList(ns));
    }

    public static enum Type {
        CStruct,
        CPPClass,
        ObjCClass,
        ObjCProtocol,
        CUnion,
        JavaClass,
        JavaInterface;

    }

    public static enum MemberVisibility {
        Public,
        Private,
        Protected;

    }
}

