/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SourceFile
extends Element
implements DeclarationsHolder {
    final List<Declaration> declarations = new ArrayList<Declaration>();
    String framework;
    String library;
    private static Pattern frameworkPathPattern = Pattern.compile(".*/(\\w+)\\.framework/(?:.*/)?Headers/(?:.*/)?([^/]+)\\.[^/.]+$");
    private static Pattern bridgesupportFrameworkPattern = Pattern.compile("(?:^|/)(\\w+?)(?:Full)?\\.bridgesupport$");

    @Override
    public SourceFile clone() {
        return (SourceFile)super.clone();
    }

    @Override
    public Element getNextChild(Element child) {
        return SourceFile.getNextSibling(this.declarations, child);
    }

    @Override
    public Element getPreviousChild(Element child) {
        return SourceFile.getPreviousSibling(this.declarations, child);
    }

    @Override
    public boolean replaceChild(Element child, Element by) {
        return SourceFile.replaceChild(this.declarations, Declaration.class, this, child, by);
    }

    @Override
    public void setElementFile(String file) {
        super.setElementFile(file);
        this.framework = null;
    }

    public String guessFramework() {
        Matcher matcher;
        if (this.framework == null && this.getElementFile() != null && ((matcher = frameworkPathPattern.matcher(this.getElementFile())).find() || (matcher = bridgesupportFrameworkPattern.matcher(this.getElementFile())).find())) {
            this.framework = matcher.group(1);
        }
        return this.framework;
    }

    @Override
    public List<Declaration> getDeclarations() {
        return this.unmodifiableList(this.declarations);
    }

    public void setDeclarations(List<Declaration> declarations) {
        SourceFile.changeValue((Element)this, this.declarations, declarations);
    }

    @Override
    public void addDeclaration(Declaration d) {
        if (d == null) {
            return;
        }
        this.declarations.add(d);
        d.setParentElement(this);
    }

    public void addDeclarations(Collection<? extends Declaration> ds) {
        for (Declaration declaration : ds) {
            this.addDeclaration(declaration);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSourceFile(this);
    }

    public void setLibrary(String library) {
        this.library = library;
    }

    public String getLibrary() {
        return this.library;
    }
}

