/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.EmptyDeclaration;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.ExternDeclarations;
import com.ochafik.lang.jnaerator.parser.FriendDeclaration;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.FunctionPointerDeclaration;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Property;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.Template;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.util.listenable.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Scanner
implements Visitor {
    @Override
    public void visitArg(Arg arg) {
        this.visitDeclaration(arg);
        this.visit(arg.getDefaultValue());
        this.visit(arg.getDeclarator());
    }

    @Override
    public void visitConstant(Expression.Constant constant) {
        this.visitExpression(constant);
    }

    protected void visitExpression(Expression expression) {
        this.visitElement(expression);
    }

    @Override
    public void visitEnum(Enum enum1) {
        this.visitTaggedTypeRef(enum1);
        this.visit(enum1.getItems());
        this.visit(enum1.getInterfaces());
        this.visit(enum1.getBody());
    }

    @Override
    public void visitFunction(Function function) {
        this.visitDeclaration(function);
        this.visit(function.getArgs());
        this.visit(function.getThrown());
        this.visit(function.getInitializers());
        this.visit(function.getBody());
        this.visit(function.getName());
    }

    @Override
    public void visitFunctionPointerDeclaration(FunctionPointerDeclaration f) {
        this.visitDeclaration(f);
        this.visit(f.getDefaultValue());
    }

    protected void visitDeclaration(Declaration d) {
        this.visitModifiableElement(d);
        this.visit(d.getValueType());
    }

    protected void visitElement(Element d) {
    }

    @Override
    public void visitStruct(Struct struct) {
        if (struct.getType() != null) {
            switch (struct.getType()) {
                case CPPClass: {
                    this.visitCPPClass(struct);
                    break;
                }
                case CStruct: {
                    this.visitCStruct(struct);
                    break;
                }
                case ObjCClass: {
                    this.visitObjCClass(struct);
                    break;
                }
                case ObjCProtocol: {
                    this.visitObjCProtocol(struct);
                    break;
                }
                case JavaClass: {
                    this.visitJavaClass(struct);
                    break;
                }
                case JavaInterface: {
                    this.visitJavaInterface(struct);
                    break;
                }
                default: {
                    this.doVisitStruct(struct);
                    break;
                }
            }
        } else {
            this.doVisitStruct(struct);
        }
    }

    public void visitJavaClass(Struct struct) {
        this.doVisitStruct(struct);
    }

    public void visitJavaInterface(Struct struct) {
        this.doVisitStruct(struct);
    }

    protected void visitStoredDeclarations(StoredDeclarations d) {
        this.visitDeclaration(d);
        this.visit(d.getDeclarators());
    }

    protected void visitCPPClass(Struct struct) {
        this.doVisitStruct(struct);
    }

    protected void doVisitStruct(Struct struct) {
        this.visitTaggedTypeRef(struct);
        this.visit(struct.getDeclarations());
        this.visit(struct.getProtocols());
        this.visit(struct.getParents());
    }

    protected void visitCStruct(Struct struct) {
        this.doVisitStruct(struct);
    }

    protected void visitObjCClass(Struct struct) {
        this.doVisitStruct(struct);
    }

    protected void visitObjCProtocol(Struct struct) {
        this.doVisitStruct(struct);
    }

    @Override
    public void visitTypeDef(StoredDeclarations.TypeDef typeDef) {
        this.visitStoredDeclarations(typeDef);
    }

    @Override
    public void visitArray(TypeRef.ArrayRef array) {
        this.visitTargettedTypeRef(array);
        this.visit(array.getDimensions());
    }

    protected void visitTypeRef(TypeRef array) {
        this.visitModifiableElement(array);
    }

    protected void visitTargettedTypeRef(TypeRef.TargettedTypeRef targettedTypeRef) {
        this.visitTypeRef(targettedTypeRef);
        this.visit(targettedTypeRef.getTarget());
    }

    @Override
    public void visitFunctionSignature(TypeRef.FunctionSignature functionSignature) {
        this.visitTypeRef(functionSignature);
        if (functionSignature != null) {
            this.visit(functionSignature.getFunction());
        }
    }

    @Override
    public void visitPointer(TypeRef.Pointer pointer) {
        this.visitTargettedTypeRef(pointer);
    }

    @Override
    public void visitPrimitive(TypeRef.Primitive primitive) {
        this.visitSimpleTypeRef(primitive);
    }

    @Override
    public void visitSimpleTypeRef(TypeRef.SimpleTypeRef simpleTypeRef) {
        this.visitTypeRef(simpleTypeRef);
        this.visit(simpleTypeRef.getName());
    }

    static <T> Collection<T> copy(Collection<T> col) {
        return new ArrayList<T>(col);
    }

    @Override
    public void visitSourceFile(SourceFile header) {
        this.visitElement(header);
        this.visit(header.getDeclarations());
    }

    @Override
    public void visitEnumItem(Enum.EnumItem enumItem) {
        this.visitElement(enumItem);
        this.visit(enumItem.getArguments());
        this.visit(enumItem.getBody());
    }

    @Override
    public void visitUnaryOp(Expression.UnaryOp unaryOp) {
        this.visitExpression(unaryOp);
        this.visit(unaryOp.getOperand());
    }

    @Override
    public void visitVariableRef(Expression.VariableRef variableRef) {
        this.visitExpression(variableRef);
        this.visit(variableRef.getName());
    }

    @Override
    public void visitBinaryOp(Expression.BinaryOp binaryOp) {
        this.visitExpression(binaryOp);
        this.visit(binaryOp.getFirstOperand());
        this.visit(binaryOp.getSecondOperand());
    }

    @Override
    public void visitFunctionCall(Expression.FunctionCall functionCall) {
        this.visitMemberRef(functionCall);
        this.visit(functionCall.getTarget());
        this.visit(functionCall.getFunction());
        for (Pair<String, Expression> x : Scanner.copy(functionCall.getArguments())) {
            if (x == null) continue;
            this.visit(x.getSecond());
        }
    }

    @Override
    public void visitMemberRef(Expression.MemberRef memberRef) {
        this.visitExpression(memberRef);
        this.visit(memberRef.getTarget());
        this.visit(memberRef.getName());
    }

    @Override
    public void visitCast(Expression.Cast cast) {
        this.visitExpression(cast);
        this.visit(cast.getType());
        this.visit(cast.getTarget());
    }

    @Override
    public void visitDeclarator(Declarator declarator) {
        this.visitModifiableElement(declarator);
        this.visit(declarator.getDefaultValue());
    }

    @Override
    public void visitVariablesDeclaration(VariablesDeclaration v) {
        this.visitDeclaration(v);
        this.visit(v.getDeclarators());
    }

    @Override
    public void visitTaggedTypeRefDeclaration(TaggedTypeRefDeclaration taggedTypeRefDeclaration) {
        this.visitDeclaration(taggedTypeRefDeclaration);
        this.visit(taggedTypeRefDeclaration.getTaggedTypeRef());
    }

    @Override
    public void visitEmptyArraySize(Expression.EmptyArraySize emptyArraySize) {
        this.visitExpression(emptyArraySize);
    }

    @Override
    public void visitDefine(Define define) {
        this.visitDeclaration(define);
        this.visit(define.getValue());
    }

    @Override
    public void visitTypeRefExpression(Expression.TypeRefExpression typeRefExpression) {
        this.visitExpression(typeRefExpression);
        this.visit(typeRefExpression.getType());
    }

    @Override
    public void visitNew(Expression.New new1) {
        this.visitExpression(new1);
        this.visit(new1.getType());
        this.visit(new1.getConstruction());
    }

    @Override
    public void visitAnnotation(Annotation annotation) {
        this.visitElement(annotation);
        this.visit(annotation.getAnnotationClass());
        this.visit(annotation.getArguments());
    }

    @Override
    public void visitEmptyDeclaration(EmptyDeclaration emptyDeclaration) {
        this.visitDeclaration(emptyDeclaration);
    }

    @Override
    public void visitNewArray(Expression.NewArray newArray) {
        this.visitExpression(newArray);
        this.visit(newArray.getType());
        this.visit(newArray.getDimensions());
    }

    @Override
    public void visitArrayDeclarator(Declarator.ArrayDeclarator arrayDeclarator) {
        this.visitTargettedDeclarator(arrayDeclarator);
        this.visit(arrayDeclarator.getDimensions());
    }

    @Override
    public void visitDirectDeclarator(Declarator.DirectDeclarator directDeclarator) {
        this.visitDeclarator(directDeclarator);
    }

    @Override
    public void visitFunctionDeclarator(Declarator.FunctionDeclarator functionDeclarator) {
        this.visitTargettedDeclarator(functionDeclarator);
        this.visit(functionDeclarator.getArgs());
    }

    @Override
    public void visitPointerDeclarator(Declarator.PointerDeclarator pointerDeclarator) {
        this.visitTargettedDeclarator(pointerDeclarator);
    }

    private void visitTargettedDeclarator(Declarator.TargettedDeclarator targettedDeclarator) {
        this.visitDeclarator(targettedDeclarator);
        this.visit(targettedDeclarator.getTarget());
    }

    @Override
    public void visitModifiableElement(ModifiableElement modifiableElement) {
        this.visitElement(modifiableElement);
        this.visit(modifiableElement.getAnnotations());
    }

    @Override
    public void visitTaggedTypeRef(TypeRef.TaggedTypeRef taggedTypeRef) {
        this.visitTypeRef(taggedTypeRef);
        this.visit(taggedTypeRef.getTag());
        this.visit(taggedTypeRef.getOriginalTag());
    }

    @Override
    public void visitBlock(Statement.Block block) {
        this.visitStatement(block);
        this.visit(block.getStatements());
    }

    @Override
    public void visitExpressionStatement(Statement.ExpressionStatement expressionStatement) {
        this.visitStatement(expressionStatement);
        this.visit(expressionStatement.getExpression());
    }

    public void visitStatement(Statement statement) {
        this.visitElement(statement);
    }

    @Override
    public void visitIf(Statement.If if1) {
        this.visitStatement(if1);
        this.visit(if1.getCondition());
        this.visit(if1.getThenBranch());
        this.visit(if1.getElseBranch());
    }

    @Override
    public void visitNullExpression(Expression.NullExpression nullExpression) {
        this.visitExpression(nullExpression);
    }

    @Override
    public void visitReturn(Statement.Return return1) {
        this.visitStatement(return1);
        this.visit(return1.getValue());
    }

    @Override
    public void visitExternDeclarations(ExternDeclarations externDeclarations) {
        this.visitDeclaration(externDeclarations);
        this.visit(externDeclarations.getDeclarations());
    }

    @Override
    public void visitOpaqueExpression(Expression.OpaqueExpression opaqueExpression) {
        this.visitExpression(opaqueExpression);
    }

    @Override
    public void visitArrayAccess(Expression.ArrayAccess arrayAccess) {
        this.visitExpression(arrayAccess);
        this.visit(arrayAccess.getTarget());
        this.visit(arrayAccess.getIndex());
    }

    @Override
    public void visitAssignmentOp(Expression.AssignmentOp assignment) {
        this.visitExpression(assignment);
        this.visit(assignment.getTarget());
        this.visit(assignment.getValue());
    }

    @Override
    public void visitConditionalExpression(Expression.ConditionalExpression conditionalExpression) {
        this.visitExpression(conditionalExpression);
        this.visit(conditionalExpression.getTest());
        this.visit(conditionalExpression.getThenValue());
        this.visit(conditionalExpression.getElseValue());
    }

    @Override
    public void visitExpressionSequence(Expression.ExpressionSequence expressionSequence) {
        this.visitExpression(expressionSequence);
        this.visit(expressionSequence.getSequence());
    }

    @Override
    public void visitSimpleIdentifier(Identifier.SimpleIdentifier simpleIdentifier) {
        this.visitIdentifier(simpleIdentifier);
        this.visit(simpleIdentifier.getTemplateArguments());
    }

    public void visitIdentifier(Identifier identifier) {
        this.visitElement(identifier);
    }

    @Override
    public void visitQualifiedIdentifier(Identifier.QualifiedIdentifier qualifiedIdentifier) {
        this.visitIdentifier(qualifiedIdentifier);
        this.visit(qualifiedIdentifier.getIdentifiers());
    }

    @Override
    public void visitDeclarationStatement(Statement.DeclarationStatement declarationStatement) {
        this.visitStatement(declarationStatement);
        this.visit(declarationStatement.getDeclaration());
    }

    protected Scanner visit(Element e) {
        if (e != null) {
            try {
                e.accept(this);
            }
            catch (StackOverflowError err) {
                throw new RuntimeException("Overflow while visiting :\n" + e, err);
            }
        }
        return this;
    }

    protected Scanner visit(List<? extends Element> list) {
        if (list != null) {
            for (Element element : Scanner.copy(list)) {
                if (element == null) continue;
                element.accept(this);
            }
        }
        return this;
    }

    @Override
    public void visitThrow(Statement.Throw t) {
        this.visitStatement(t);
        this.visit(t.getExpression());
    }

    @Override
    public void visitProperty(Property property) {
        this.visitDeclaration(property);
        this.visit(property.getDeclaration());
    }

    @Override
    public void visitFriendDeclaration(FriendDeclaration friendDeclaration) {
        this.visitDeclaration(friendDeclaration);
        this.visit(friendDeclaration.getFriend());
    }

    @Override
    public void visitTry(Statement.Try tr) {
        this.visitStatement(tr);
        this.visit(tr.getTryStatement());
        this.visit(tr.getFinallyStatement());
        this.visit(tr.getCatches());
    }

    @Override
    public void visitCatch(Statement.Catch ca) {
        this.visitStatement(ca);
        this.visit(ca.getDeclaration());
        this.visit(ca.getBody());
    }

    @Override
    public void visitTemplate(Template template) {
        this.visitDeclaration(template);
        this.visit(template.getArgs());
        this.visit(template.getDeclaration());
    }
}

