/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.util.string.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class PrintScanner
extends Scanner {
    StringWriter sout = new StringWriter();
    protected PrintWriter out = new PrintWriter(this.sout);
    protected final MessageFormat invalidFormat;
    protected List<Exception> exceptions = new ArrayList<Exception>();
    String indent = "";

    public PrintScanner(String invalidFormatString) {
        this(new MessageFormat(invalidFormatString));
    }

    public PrintScanner(MessageFormat invalidFormat) {
        this.invalidFormat = invalidFormat;
    }

    public PrintScanner() {
        this("/*\nErrors occurred :\n{0}\n{1}\n*/");
    }

    public String getIndent() {
        return this.indent;
    }

    public String setIndent(String indent) {
        this.indent = indent;
        return this.indent;
    }

    public String incrIndent() {
        return this.setIndent(this.getIndent() + "\t");
    }

    public String decrIndent() {
        String s = this.getIndent();
        int len = s.length();
        if (len > 0 && s.charAt(len - 1) == '\t') {
            return s.substring(0, len - 1);
        }
        return s;
    }

    protected void println(Object ... os) {
        if (os.length == 0) {
            this.out.println();
        }
        for (Object o : os) {
            this.out.println(o);
        }
    }

    protected void print(Object ... os) {
        for (Object o : os) {
            this.out.print(o);
        }
    }

    protected void addException(Exception ex) {
        this.exceptions.add(ex);
    }

    public String toString() {
        String s = this.sout.toString();
        if (this.exceptions.isEmpty()) {
            return s;
        }
        return this.invalidFormat.format(new Object[]{StringUtils.implode(this.exceptions, (Object)"\n").replace("*/", "* /"), s.replace("*/", "* /")}, new StringBuffer(), (FieldPosition)null).toString();
    }
}

