/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.ModifierKind;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Modifier {
    __cdecl(EnumSet.of(ModifierKind.CallingConvention)),
    _cdecl(__cdecl),
    __stdcall(EnumSet.of(ModifierKind.CallingConvention)),
    _stdcall(__stdcall),
    __fastcall(EnumSet.of(ModifierKind.CallingConvention)),
    _fastcall(__fastcall),
    __thiscall(EnumSet.of(ModifierKind.CallingConvention)),
    _thiscall(__thiscall),
    __pascal(EnumSet.of(ModifierKind.CallingConvention)),
    _pascal(__pascal),
    __pre(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __valid(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __reserved(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __checkReturn(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __fallthrough(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __readonly(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __null(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __in(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __out(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __inout(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __refparam(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    __exceptthat(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    _opt(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    _deref(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    _deref_opt(EnumSet.of(ModifierKind.VCAnnotationNoArg)),
    _ecount(EnumSet.of(ModifierKind.VCAnnotation1Arg)),
    _bcount(EnumSet.of(ModifierKind.VCAnnotation1Arg)),
    _full(EnumSet.of(ModifierKind.VCAnnotation1Arg)),
    _part(EnumSet.of(ModifierKind.VCAnnotation2Args)),
    __ptr64(EnumSet.of(ModifierKind.TypeQualifier)),
    __maybenull(EnumSet.of(ModifierKind.TypeQualifier)),
    __nullterminated(EnumSet.of(ModifierKind.TypeQualifier, ModifierKind.StringAnnotation)),
    __nullnullterminated(EnumSet.of(ModifierKind.TypeQualifier, ModifierKind.StringAnnotation)),
    __possibly_notnullterminated(EnumSet.of(ModifierKind.TypeQualifier, ModifierKind.StringAnnotation)),
    Auto(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Register(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Static(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Virtual(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Extern(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Pascal(__pascal, EnumSet.of(ModifierKind.StorageClassSpecifier)),
    __const(EnumSet.of(ModifierKind.TypeQualifier)),
    Const(__const),
    Volatile(EnumSet.of(ModifierKind.TypeQualifier)),
    Mutable(EnumSet.of(ModifierKind.TypeQualifier)),
    __unsigned(EnumSet.of(ModifierKind.NumericTypeQualifier, ModifierKind.SignModifier)),
    __signed(EnumSet.of(ModifierKind.NumericTypeQualifier, ModifierKind.SignModifier)),
    Unsigned(__unsigned),
    Signed(__signed),
    Long(EnumSet.of(ModifierKind.NumericTypeQualifier, ModifierKind.SizeModifier)),
    Short(EnumSet.of(ModifierKind.NumericTypeQualifier, ModifierKind.SizeModifier)),
    Typename(EnumSet.of(ModifierKind.ReferenceQualifier)),
    Struct(EnumSet.of(ModifierKind.ReferenceQualifier)),
    Class(EnumSet.of(ModifierKind.ReferenceQualifier)),
    Public(EnumSet.of(ModifierKind.Publicity)),
    Abstract(EnumSet.of(ModifierKind.Publicity)),
    Final(EnumSet.of(ModifierKind.Publicity)),
    Private(EnumSet.of(ModifierKind.Publicity)),
    Protected(EnumSet.of(ModifierKind.Publicity)),
    Inline(EnumSet.of(ModifierKind.C, ModifierKind.StorageClassSpecifier)),
    __inline(Inline),
    __inline__(Inline),
    In(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    Out(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    InOut(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    OneWay(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    ByCopy(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    ByRef(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    Package(EnumSet.of(ModifierKind.ObjectiveC)),
    Optional(EnumSet.of(ModifierKind.ObjectiveC)),
    Required(EnumSet.of(ModifierKind.ObjectiveC)),
    Align(EnumSet.of(ModifierKind.Declspec, ModifierKind.HasArguments)),
    Allocate(EnumSet.of(ModifierKind.Declspec, ModifierKind.HasArguments)),
    AppDomain(EnumSet.of(ModifierKind.Declspec)),
    Deprecated(EnumSet.of(ModifierKind.Declspec, ModifierKind.Attribute)),
    DllExport(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    DllImport(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    JITIntrinsic(EnumSet.of(ModifierKind.Declspec)),
    Naked(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier, ModifierKind.Attribute)),
    NoAlias(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    NoInline(EnumSet.of(ModifierKind.Declspec)),
    NoReturn(EnumSet.of(ModifierKind.Declspec)),
    NoThrow(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    NoVTable(EnumSet.of(ModifierKind.Declspec)),
    Process(EnumSet.of(ModifierKind.Declspec)),
    Property(EnumSet.of(ModifierKind.Declspec, ModifierKind.HasArguments, ModifierKind.StorageClassSpecifier, ModifierKind.COMSpecific)),
    Restrict(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    __restrict(Restrict),
    SelectAny(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier, ModifierKind.COMSpecific)),
    Thread(EnumSet.of(ModifierKind.Declspec)),
    UUID(EnumSet.of(ModifierKind.Declspec, ModifierKind.HasArguments, ModifierKind.StorageClassSpecifier, ModifierKind.COMSpecific)),
    Alias(EnumSet.of(ModifierKind.Attribute)),
    Always_inline(EnumSet.of(ModifierKind.Attribute)),
    Cdecl(__cdecl, EnumSet.of(ModifierKind.Attribute)),
    Constructor(EnumSet.of(ModifierKind.Attribute)),
    Destructor(EnumSet.of(ModifierKind.Attribute)),
    Dllexport(EnumSet.of(ModifierKind.Attribute)),
    Weak_import(EnumSet.of(ModifierKind.Attribute)),
    Dllimport(EnumSet.of(ModifierKind.Attribute)),
    Eightbit_data(EnumSet.of(ModifierKind.Attribute)),
    Exception(EnumSet.of(ModifierKind.Attribute)),
    Far(EnumSet.of(ModifierKind.Attribute)),
    Fastcall(__fastcall, EnumSet.of(ModifierKind.Attribute)),
    Format(EnumSet.of(ModifierKind.Attribute)),
    Format_arg(EnumSet.of(ModifierKind.Attribute)),
    Function_vector(EnumSet.of(ModifierKind.Attribute)),
    Interrupt(EnumSet.of(ModifierKind.Attribute)),
    Interrupt_handler(EnumSet.of(ModifierKind.Attribute)),
    Long_call(EnumSet.of(ModifierKind.Attribute)),
    Short_call(EnumSet.of(ModifierKind.Attribute)),
    Longcall(EnumSet.of(ModifierKind.Attribute)),
    Shortcall(EnumSet.of(ModifierKind.Attribute)),
    Malloc(EnumSet.of(ModifierKind.Attribute)),
    Model(EnumSet.of(ModifierKind.Attribute)),
    Near(EnumSet.of(ModifierKind.Attribute)),
    No_check_memory_usage(EnumSet.of(ModifierKind.Attribute)),
    No_instrument_function(EnumSet.of(ModifierKind.Attribute)),
    Noinline(EnumSet.of(ModifierKind.Attribute)),
    Nonnull(EnumSet.of(ModifierKind.Attribute)),
    Noreturn(EnumSet.of(ModifierKind.Attribute)),
    Nothrow(EnumSet.of(ModifierKind.Attribute)),
    Pure(EnumSet.of(ModifierKind.Attribute)),
    Regparm(EnumSet.of(ModifierKind.Attribute)),
    Saveall(EnumSet.of(ModifierKind.Attribute)),
    Section(EnumSet.of(ModifierKind.Attribute)),
    Signal(EnumSet.of(ModifierKind.Attribute)),
    Sp_switch(EnumSet.of(ModifierKind.Attribute)),
    Stdcall(__stdcall, EnumSet.of(ModifierKind.Attribute)),
    Tiny_data(EnumSet.of(ModifierKind.Attribute)),
    Trap_exit(EnumSet.of(ModifierKind.Attribute)),
    Unused(EnumSet.of(ModifierKind.Attribute)),
    Used(EnumSet.of(ModifierKind.Attribute)),
    Visibility(EnumSet.of(ModifierKind.Attribute)),
    Warn_unused_result(EnumSet.of(ModifierKind.Attribute)),
    Weak(EnumSet.of(ModifierKind.Attribute)),
    __kernel(EnumSet.of(ModifierKind.OpenCL)),
    __global(EnumSet.of(ModifierKind.OpenCL)),
    __read_only(EnumSet.of(ModifierKind.OpenCL)),
    __write_only(EnumSet.of(ModifierKind.OpenCL)),
    __local(EnumSet.of(ModifierKind.OpenCL)),
    __constant(EnumSet.of(ModifierKind.OpenCL)),
    __private(EnumSet.of(ModifierKind.OpenCL)),
    Synchronized(EnumSet.of(ModifierKind.Java)),
    Native(EnumSet.of(ModifierKind.Java));

    EnumSet<ModifierKind> kinds;
    Modifier alias;
    static Map<String, Modifier> mods;

    private Modifier(Modifier alias) {
        this.kinds = alias.kinds;
        this.alias = alias;
    }

    private Modifier(EnumSet<ModifierKind> kinds) {
        this.kinds = kinds;
    }

    private Modifier(Modifier alias, EnumSet<ModifierKind> kinds) {
        this.alias = alias;
        this.kinds = kinds;
    }

    public Modifier resolveAlias() {
        if (this.alias == null) {
            return this;
        }
        return this.alias.resolveAlias();
    }

    public boolean isContainedBy(Collection<Modifier> modifiers) {
        Modifier alias = this.resolveAlias();
        for (Modifier modifier : modifiers) {
            if (!modifier.resolveAlias().equals((Object)alias)) continue;
            return true;
        }
        return false;
    }

    public int countIn(Collection<Modifier> modifiers) {
        Modifier alias = this.resolveAlias();
        int c = 0;
        for (Modifier modifier : modifiers) {
            if (!modifier.resolveAlias().equals((Object)alias)) continue;
            ++c;
        }
        return c;
    }

    public Modifier getAlias() {
        return this.alias;
    }

    public static Modifier parseModifier(String name, ModifierKind ... kinds) {
        try {
            Modifier modifier = mods.get(name);
            if (kinds.length == 0 || modifier == null) {
                return modifier;
            }
            for (ModifierKind kind : kinds) {
                if (!modifier.isA(kind)) continue;
                return modifier;
            }
            return kinds.length > 0 ? null : modifier;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public boolean isA(ModifierKind k) {
        if (k == ModifierKind.Plain && !this.kinds.contains((Object)ModifierKind.Attribute) && !this.kinds.contains((Object)ModifierKind.Declspec)) {
            return true;
        }
        if (k == ModifierKind.Extended && (this.kinds.contains((Object)ModifierKind.Attribute) || this.kinds.contains((Object)ModifierKind.Declspec))) {
            return true;
        }
        if ((k == ModifierKind.CPlusPlus || k == ModifierKind.CPlusPlusCLI || k == ModifierKind.ObjectiveC) && this.kinds.contains((Object)ModifierKind.C)) {
            return true;
        }
        return this.kinds.contains((Object)k);
    }

    public boolean isAnyOf(ModifierKind ... kinds) {
        for (ModifierKind kind : kinds) {
            if (!this.isA(kind)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllOf(ModifierKind ... kinds) {
        for (ModifierKind kind : kinds) {
            if (this.isA(kind)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Compiler compiler) {
        String low = super.toString().toLowerCase();
        if (this.kinds.contains((Object)ModifierKind.Declspec) && (compiler == null || compiler == Compiler.MSVC)) {
            return "__declspec(" + low + ")";
        }
        if (this.kinds.contains((Object)ModifierKind.Attribute) && (compiler == null || compiler == Compiler.GCC)) {
            return "__attribute__((" + low + "))";
        }
        return low;
    }

    static {
        mods = new HashMap<String, Modifier>();
        for (Modifier m : Modifier.values()) {
            mods.put(m.toString(), m);
        }
    }

    public static enum Compiler {
        GCC,
        MSVC,
        Intel;

    }
}

