/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.util.listenable.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Expression
extends Element {
    private static final long MAX_UINT_VALUE = 0xFFFFFFFEL;
    boolean parenthesis;
    static final Map<String, AssignmentOperator> assignOps = new HashMap<String, AssignmentOperator>();
    static final Map<String, BinaryOperator> binOps = new HashMap<String, BinaryOperator>();
    static final Map<String, UnaryOperator> unOps = new HashMap<String, UnaryOperator>();
    static final Map<AssignmentOperator, String> assignOpsRev = new HashMap<AssignmentOperator, String>();
    static final Map<BinaryOperator, String> binOpsRev = new HashMap<BinaryOperator, String>();
    static final Map<UnaryOperator, String> unOpsRev = new HashMap<UnaryOperator, String>();

    public Expression setParenthesis(boolean parenthesis) {
        this.parenthesis = parenthesis;
        return this;
    }

    public boolean getParenthesis() {
        return this.parenthesis;
    }

    public boolean isParenthesis() {
        return this.parenthesis;
    }

    @Override
    public Expression clone() {
        return (Expression)super.clone();
    }

    public static MemberRefStyle parseMemberRefStyle(String s) {
        if (s.equals("->")) {
            return MemberRefStyle.Arrow;
        }
        if (s.equals(".")) {
            return MemberRefStyle.Dot;
        }
        if (s.equals("::")) {
            return MemberRefStyle.Colons;
        }
        return null;
    }

    static <K, V> void map(Map<K, V> m, Map<V, K> r, K k, V v) {
        m.put(k, v);
        r.put(v, k);
    }

    public static BinaryOperator getBinaryOperator(String s) {
        return binOps.get(s);
    }

    public static AssignmentOperator getAssignmentOperator(String s) {
        return assignOps.get(s);
    }

    public static UnaryOperator getUnaryOperator(String s) {
        return unOps.get(s);
    }

    public static Enum<?> getAnyOperator(String s) {
        Enum e = Expression.getBinaryOperator(s);
        if (e != null) {
            return e;
        }
        e = Expression.getUnaryOperator(s);
        if (e != null) {
            return e;
        }
        return Expression.getAssignmentOperator(s);
    }

    static {
        for (AssignmentOperator assignmentOperator : AssignmentOperator.values()) {
            Expression.map(assignOps, assignOpsRev, assignmentOperator.toString(), assignmentOperator);
        }
        for (Enum enum_ : UnaryOperator.values()) {
            Expression.map(unOps, unOpsRev, ((UnaryOperator)enum_).toString(), enum_);
        }
        for (Enum enum_ : BinaryOperator.values()) {
            Expression.map(binOps, binOpsRev, ((BinaryOperator)enum_).toString(), enum_);
        }
    }

    public static class Constant
    extends Expression {
        Type type;
        IntForm intForm;
        Object value;

        public Constant(Type type, IntForm intForm, Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.setType(type);
            this.setIntForm(intForm);
            this.setValue(value);
            this.checkType();
        }

        void checkType() {
            if (this.type == null) {
                return;
            }
            Object value = this.getValue();
            switch (this.type) {
                case Int: 
                case UInt: 
                case IntegerString: {
                    value = (Integer)value;
                    break;
                }
                case ULong: 
                case Long: 
                case LongString: {
                    value = (Long)value;
                    break;
                }
                case Char: {
                    value = (Character)value;
                    break;
                }
                case Double: {
                    value = (Double)value;
                    break;
                }
                case Float: {
                    value = (Float)value;
                    break;
                }
                case String: {
                    value = (String)value;
                    break;
                }
                case Bool: {
                    value = (Boolean)value;
                }
            }
        }

        public Constant(Type type, Object value) {
            this.setType(type);
            this.setValue(value);
            this.checkType();
        }

        public void setIntForm(IntForm intForm) {
            this.intForm = intForm;
        }

        public IntForm getIntForm() {
            return this.intForm;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Constant() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        static String intStr(int intVal) {
            return String.valueOf((char)(0xFF & intVal >> 24)) + (char)(0xFF & intVal >> 16) + (char)(0xFF & intVal >> 8) + (char)(0xFF & intVal);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitConstant(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            return false;
        }

        public Integer asInteger() {
            switch (this.getType()) {
                case Int: 
                case IntegerString: {
                    return (Integer)this.value;
                }
            }
            throw new ClassCastException("Constant " + this.getValue() + " is not an integer, but a " + (Object)((Object)this.getType()));
        }

        public static Constant parseCharOrStringInteger(String string) {
            int len = string.length();
            if (len <= 2 || string.charAt(0) != '\'' || string.charAt(len - 1) != '\'') {
                throw new IllegalArgumentException("Expecting char or integer string, got " + string);
            }
            string = string.substring(1, len - 1);
            if ((len -= 2) == 4) {
                boolean isIntegerString = true;
                int i = len;
                while (i-- != 0) {
                    if (string.charAt(i) != '\\') continue;
                    isIntegerString = false;
                    break;
                }
                if (isIntegerString) {
                    long result = 0L;
                    for (int i2 = 0; i2 < len; ++i2) {
                        result = result << 8 | (long)string.charAt(i2);
                    }
                    if (len == 4) {
                        return new Constant(Type.IntegerString, IntForm.String, (int)result);
                    }
                    return new Constant(Type.LongString, IntForm.String, result);
                }
            }
            return new Constant(Type.Char, Character.valueOf(Constant.parseNakedString(string).charAt(0)));
        }

        public static Constant parseChar(String string) {
            int len = string.length();
            if (len <= 2 || string.charAt(0) != '\'' || string.charAt(len - 1) != '\'') {
                throw new IllegalArgumentException("Expecting char, got " + string);
            }
            string = string.substring(1, len - 1);
            return new Constant(Type.Char, Character.valueOf(Constant.parseNakedString(string).charAt(0)));
        }

        private static String parseNakedString(String string) {
            int len = string.length();
            StringBuffer b = new StringBuffer(len);
            int i = 0;
            block11: while (i < len) {
                char c;
                if ((c = string.charAt(i++)) == '\\') {
                    c = string.charAt(i++);
                    switch (c) {
                        case 't': {
                            b.append('\t');
                            continue block11;
                        }
                        case 'n': {
                            b.append('\n');
                            continue block11;
                        }
                        case 'r': {
                            b.append('\r');
                            continue block11;
                        }
                        case 'f': {
                            b.append('\f');
                            continue block11;
                        }
                        case 'b': {
                            b.append('\b');
                            continue block11;
                        }
                        case '\\': {
                            b.append('\\');
                            continue block11;
                        }
                        case '\"': {
                            b.append('\"');
                            continue block11;
                        }
                        case '\'': {
                            b.append('\'');
                            continue block11;
                        }
                        case 'u': {
                            if (i >= len - 3) continue block11;
                            b.append((char)Integer.parseInt(string.substring(i, i + 4), 16));
                            i += 4;
                            continue block11;
                        }
                    }
                    if (!Character.isDigit(c)) continue;
                    int start = i - 1;
                    int end2 = i;
                    while (Character.isDigit(string.charAt(end2))) {
                        ++end2;
                    }
                    b.append((char)Integer.parseInt(string.substring(start, end2), 8));
                    i = end2;
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }

        public static Constant parseStringInteger(String string) {
            int len = string.length();
            if (len <= 2 || string.charAt(0) != '\'' || string.charAt(len - 1) != '\'' || (len -= 2) != 4 && len != 8) {
                throw new IllegalArgumentException("Expecting 'xxxx' or 'xxxxxxxx', got " + string);
            }
            string = string.substring(1, len - 1);
            long result = 0L;
            int i = len;
            while (i-- != 0) {
                result = result << 8 | (long)string.charAt(i);
            }
            if (len == 4) {
                return new Constant(Type.Int, IntForm.String, (int)result);
            }
            return new Constant(Type.Long, IntForm.String, result);
        }

        public static Constant parseString(String string) {
            int len = string.length();
            if (len <= 2 || string.charAt(0) != '\"' || string.charAt(len - 1) != '\"') {
                throw new IllegalArgumentException("Expecting string, got " + string);
            }
            string = string.substring(1, len - 1);
            return new Constant(Type.String, Constant.parseNakedString(string));
        }

        public static Constant parseDecimal(String string) {
            return Constant.parseDecimal(string, 10, IntForm.Decimal, false);
        }

        public static Constant parseDecimal(String string, int radix, IntForm form, boolean negate) {
            long val;
            string = string.trim().toLowerCase();
            int len = string.length();
            boolean unsigned = false;
            if (string.endsWith("ll") || string.endsWith("li")) {
                return new Constant(Type.Long, Long.parseLong(string.substring(0, len - 2), radix));
            }
            if (string.endsWith("l")) {
                string = string.substring(0, len - 1);
            } else {
                if (string.endsWith("s")) {
                    return new Constant(Type.Short, Long.parseLong(string.substring(0, len - 1), radix));
                }
                if (string.endsWith("u")) {
                    string = string.substring(0, len - 1);
                    unsigned = true;
                }
            }
            if (string.equals("ffffffffffffffff")) {
                val = -1L;
            } else {
                if (string.startsWith("+")) {
                    string = string.substring(1);
                }
                try {
                    val = Long.parseLong(string, radix);
                }
                catch (NumberFormatException ex) {
                    unsigned = true;
                    val = Long.parseLong(string.substring(0, string.length() - 1), radix);
                    val = val * (long)radix + (long)Short.parseShort(string.substring(string.length() - 1));
                }
            }
            if (negate) {
                val = -val;
            }
            if (form == IntForm.Hex && len <= 8 || val > Integer.MIN_VALUE && val < Integer.MAX_VALUE) {
                return new Constant(unsigned ? Type.UInt : Type.Int, form, (int)val);
            }
            if (val >= 0L && val < 0xFFFFFFFEL) {
                return new Constant(Type.UInt, form, (int)val);
            }
            return new Constant(unsigned ? Type.ULong : Type.Long, form, val);
        }

        public static Constant parseHex(String string, boolean negate) {
            if (!(string = string.trim().toLowerCase()).startsWith("0x")) {
                throw new IllegalArgumentException("Expected hex literal, got " + string);
            }
            try {
                return Constant.parseDecimal(string.substring(2), 16, IntForm.Hex, negate);
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException("Parsing hex : \"" + string + "\"");
            }
        }

        public static Constant parseOctal(String string, boolean negate) {
            if (!(string = string.trim().toLowerCase()).startsWith("\\")) {
                throw new IllegalArgumentException("Expected octal literal, got " + string);
            }
            return Constant.parseDecimal(string.substring(2), 8, IntForm.Octal, negate);
        }

        public static Constant parseFloat(String string) {
            int lm1;
            char c;
            if ((string = string.trim().toLowerCase()).length() > 0 && Character.isLetter(c = string.charAt(lm1 = string.length() - 1))) {
                String beg = string.substring(0, lm1);
                if (c == 'f') {
                    return new Constant(Type.Float, Float.valueOf(Float.parseFloat(beg)));
                }
            }
            return new Constant(Type.Double, Double.parseDouble(string));
        }

        public Constant asJava() {
            Type type = this.getType();
            switch (type) {
                case ULong: 
                case LongString: {
                    type = Type.Long;
                    break;
                }
                case UInt: 
                case IntegerString: {
                    type = Type.Int;
                }
            }
            return new Constant(type, this.getValue());
        }

        public static enum IntForm {
            Hex,
            Octal,
            String,
            Decimal;

        }

        public static enum Type {
            Int,
            String,
            Char,
            IntegerString,
            Float,
            Short,
            Byte,
            Long,
            UInt,
            Double,
            LongString,
            ULong,
            Bool,
            Null;

        }
    }

    public static class UnaryOp
    extends Expression {
        UnaryOperator operator;
        Expression operand;

        public UnaryOp(Expression operand, UnaryOperator operator) {
            this.setOperand(operand);
            this.setOperator(operator);
        }

        public UnaryOp() {
        }

        public Expression getOperand() {
            return this.operand;
        }

        public void setOperator(UnaryOperator operator) {
            this.operator = operator;
        }

        public void setOperand(Expression operand) {
            this.operand = UnaryOp.changeValue((Element)this, this.operand, operand);
        }

        public UnaryOperator getOperator() {
            return this.operator;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitUnaryOp(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getOperand()) {
                this.setOperand((Expression)by);
                return true;
            }
            return false;
        }
    }

    public static class BinaryOp
    extends Expression {
        BinaryOperator operator;
        Expression firstOperand;
        Expression secondOperand;

        public BinaryOp(Expression firstOperand, BinaryOperator operator, Expression secondOperand) {
            if (operator == null) {
                throw new NullPointerException();
            }
            this.setOperator(operator);
            this.setFirstOperand(firstOperand);
            this.setSecondOperand(secondOperand);
        }

        public BinaryOp() {
        }

        public void setOperator(BinaryOperator operator) {
            this.operator = operator;
        }

        public Expression getSecondOperand() {
            return this.secondOperand;
        }

        public Expression getFirstOperand() {
            return this.firstOperand;
        }

        public void setSecondOperand(Expression secondOperand) {
            this.secondOperand = BinaryOp.changeValue((Element)this, this.secondOperand, secondOperand);
        }

        public void setFirstOperand(Expression firstOperand) {
            this.firstOperand = BinaryOp.changeValue((Element)this, this.firstOperand, firstOperand);
        }

        public BinaryOperator getOperator() {
            return this.operator;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitBinaryOp(this);
        }

        @Override
        public Element getNextChild(Element child) {
            if (child == this.getFirstOperand()) {
                return this.getSecondOperand();
            }
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            if (child == this.getSecondOperand()) {
                return this.getFirstOperand();
            }
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getFirstOperand()) {
                this.setFirstOperand((Expression)by);
                return true;
            }
            if (child == this.getSecondOperand()) {
                this.setSecondOperand((Expression)by);
                return true;
            }
            return false;
        }
    }

    public static class AssignmentOp
    extends Expression {
        Expression target;
        Expression value;
        AssignmentOperator operator;

        public AssignmentOp() {
        }

        public AssignmentOp(Expression target, AssignmentOperator operator, Expression value) {
            if (operator == null) {
                throw new NullPointerException();
            }
            this.setValue(value);
            this.setTarget(target);
            this.setOperator(operator);
        }

        public AssignmentOperator getOperator() {
            return this.operator;
        }

        public void setOperator(AssignmentOperator operator) {
            this.operator = operator;
        }

        public Expression getValue() {
            return this.value;
        }

        public Expression getTarget() {
            return this.target;
        }

        public void setValue(Expression value) {
            this.value = AssignmentOp.changeValue((Element)this, this.value, value);
        }

        public void setTarget(Expression target) {
            this.target = AssignmentOp.changeValue((Element)this, this.target, target);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitAssignmentOp(this);
        }

        @Override
        public Element getNextChild(Element child) {
            if (child == this.getTarget()) {
                return this.getValue();
            }
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            if (child == this.getValue()) {
                return this.getTarget();
            }
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
                return true;
            }
            if (child == this.getValue()) {
                this.setValue((Expression)by);
                return true;
            }
            return false;
        }
    }

    public static class Cast
    extends Expression {
        TypeRef type;
        Expression target;

        public Cast(TypeRef type, Expression target) {
            this.setTarget(target);
            this.setType(type);
        }

        public Cast() {
        }

        public void setTarget(Expression target) {
            this.target = Cast.changeValue((Element)this, this.target, target);
        }

        public void setType(TypeRef type) {
            this.type = Cast.changeValue((Element)this, this.type, type);
        }

        public Expression getTarget() {
            return this.target;
        }

        public TypeRef getType() {
            return this.type;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitCast(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
                return true;
            }
            if (child == this.getType()) {
                this.setType((TypeRef)by);
                return true;
            }
            return false;
        }
    }

    public static class ConditionalExpression
    extends Expression {
        Expression test;
        Expression thenValue;
        Expression elseValue;

        public Expression getTest() {
            return this.test;
        }

        public void setTest(Expression test) {
            this.test = ConditionalExpression.changeValue((Element)this, this.test, test);
        }

        public Expression getThenValue() {
            return this.thenValue;
        }

        public void setThenValue(Expression thenValue) {
            this.thenValue = ConditionalExpression.changeValue((Element)this, this.thenValue, thenValue);
        }

        public Expression getElseValue() {
            return this.elseValue;
        }

        public void setElseValue(Expression elseValue) {
            this.elseValue = ConditionalExpression.changeValue((Element)this, this.elseValue, elseValue);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitConditionalExpression(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTest()) {
                this.setTest((Expression)by);
                return true;
            }
            if (child == this.getThenValue()) {
                this.setThenValue((Expression)by);
                return true;
            }
            if (child == this.getElseValue()) {
                this.setElseValue((Expression)by);
                return true;
            }
            return false;
        }
    }

    public static class NullExpression
    extends Expression {
        @Override
        public void accept(Visitor visitor) {
            visitor.visitNullExpression(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            return false;
        }
    }

    public static enum UnaryOperator implements Operator
    {
        Not("!"),
        Parenthesis("()"),
        Complement("~"),
        PreIncr("++"),
        PreDecr("--"),
        PostIncr("++"),
        PostDecr("--");

        String s;

        private UnaryOperator(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }

    public static enum AssignmentOperator implements Operator
    {
        Equal("="),
        MultiplyEqual("*="),
        DivideEqual("/="),
        ModuloEqual("%="),
        PlusEqual("+="),
        MinusEqual("-="),
        LeftShiftEqual("<<="),
        RightShiftEqual(">>="),
        SignedRightShiftEqual(">>>="),
        BitAndEqual("&="),
        XOREqual("^="),
        ComplementEqual("~="),
        BitOrEqual("|=");

        String s;

        private AssignmentOperator(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }

    public static interface Operator {
    }

    public static enum BinaryOperator implements Operator
    {
        Assign("="),
        Arrow("->"),
        ArrowStar("->*"),
        SquareBrackets("[]"),
        Comma(","),
        Plus("+"),
        Minus("-"),
        Divide("/"),
        Multiply("*"),
        Modulo("%"),
        LeftShift("<<"),
        RightShift(">>"),
        SignedRightShift(">>>"),
        XOR("^"),
        LessEqual("<="),
        GreaterEqual(">="),
        Less("<"),
        Greater(">"),
        IsEqual("=="),
        IsDifferent("!="),
        BitOr("|"),
        Or("||"),
        BitAnd("&"),
        And("&&");

        String s;

        private BinaryOperator(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }

    public static class VariableRef
    extends Expression {
        Identifier name;

        public VariableRef(Identifier name) {
            this.setName(name);
        }

        public VariableRef() {
        }

        public Identifier getName() {
            return this.name;
        }

        public void setName(Identifier name) {
            this.name = VariableRef.changeValue((Element)this, this.name, name);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitVariableRef(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getName()) {
                this.setName((Identifier)by);
                return true;
            }
            return false;
        }
    }

    public static class ArrayAccess
    extends Expression {
        Expression target;
        Expression index;

        public ArrayAccess() {
        }

        public ArrayAccess(Expression target, Expression index) {
            this.setTarget(target);
            this.setIndex(index);
        }

        public Expression getTarget() {
            return this.target;
        }

        public void setTarget(Expression target) {
            this.target = ArrayAccess.changeValue((Element)this, this.target, target);
        }

        public void setIndex(Expression index) {
            this.index = ArrayAccess.changeValue((Element)this, this.index, index);
        }

        public Expression getIndex() {
            return this.index;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitArrayAccess(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
                return true;
            }
            if (child == this.getIndex()) {
                this.setIndex((Expression)by);
                return true;
            }
            return false;
        }
    }

    public static class FunctionCall
    extends MemberRef {
        Expression function;
        List<Pair<String, Expression>> arguments = new ArrayList<Pair<String, Expression>>();

        public List<Pair<String, Expression>> getArguments() {
            return this.unmodifiableList(this.arguments);
        }

        public void setArguments(List<Pair<String, Expression>> arguments) {
            for (Pair<String, Expression> p : this.arguments) {
                p.getSecond().setParentElement(null);
            }
            this.arguments.clear();
            for (Pair<String, Expression> p : arguments) {
                this.addArgument(p.getFirst(), p.getSecond());
            }
        }

        public FunctionCall(Expression function) {
            this.setFunction(function);
        }

        public FunctionCall(Expression function, Expression ... unnamedArgs) {
            this.setFunction(function);
            for (Expression x : unnamedArgs) {
                if (x == null) continue;
                this.addArgument(x);
            }
        }

        public FunctionCall(Expression target, Expression function, MemberRefStyle memberRefStyle, Expression ... unnamedArgs) {
            this.setTarget(target);
            this.setFunction(function);
            this.setMemberRefStyle(memberRefStyle);
            for (Expression x : unnamedArgs) {
                this.addArgument(x);
            }
        }

        public FunctionCall() {
        }

        public void addArgument(Expression ex) {
            this.addArgument(null, ex);
        }

        public void addArguments(List<Expression> ex) {
            for (Expression x : ex) {
                this.addArgument(null, x);
            }
        }

        public void addArgument(String argumentSelector, Expression ex) {
            if (ex == null) {
                return;
            }
            ex.setParentElement(this);
            this.arguments.add(new Pair<String, Expression>(argumentSelector, ex));
        }

        public Expression getFunction() {
            return this.function;
        }

        public void setFunction(Expression function) {
            this.function = FunctionCall.changeValue((Element)this, this.function, function);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitFunctionCall(this);
        }

        protected int indexOf(Element x, List<Pair<String, Expression>> list) {
            int i = 0;
            for (Pair<String, Expression> p : list) {
                if (p.getValue() == x) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public Element getNextChild(Element child) {
            int i = this.indexOf(child, this.arguments);
            if (i >= 0) {
                return i < this.arguments.size() - 1 ? this.arguments.get(i + 1).getValue() : null;
            }
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            int i = this.indexOf(child, this.arguments);
            if (i >= 0) {
                return i > 0 ? this.arguments.get(i - 1).getValue() : null;
            }
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
                return true;
            }
            if (child == this.getFunction()) {
                this.setFunction((Expression)by);
                return true;
            }
            int i = this.indexOf(child, this.arguments);
            if (i >= 0) {
                Expression old = by == null ? this.arguments.remove(i).getValue() : this.arguments.get(i).setValue((Expression)by);
                if (old != by) {
                    if (old != null) {
                        old.setParentElement(null);
                    }
                    if (by != null) {
                        by.setParentElement(this);
                    }
                }
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class New
    extends Expression {
        TypeRef type;
        FunctionCall construction;

        public New(TypeRef type) {
            this.setType(type);
        }

        public New(TypeRef type, FunctionCall construction) {
            this.setType(type);
            this.setConstruction(construction);
        }

        public New(TypeRef type, Expression ... arguments) {
            this.setType(type);
            this.setConstruction(new FunctionCall(null, arguments));
        }

        public New() {
        }

        public void setType(TypeRef type) {
            this.type = New.changeValue((Element)this, this.type, type);
        }

        public TypeRef getType() {
            return this.type;
        }

        public void setConstruction(FunctionCall construction) {
            this.construction = New.changeValue((Element)this, this.construction, construction);
        }

        public FunctionCall getConstruction() {
            return this.construction;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNew(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getType()) {
                this.setType((TypeRef)by);
                return true;
            }
            if (child == this.getConstruction()) {
                this.setConstruction((FunctionCall)by);
                return true;
            }
            return false;
        }
    }

    public static class NewArray
    extends Expression {
        TypeRef type;
        List<Expression> dimensions = new ArrayList<Expression>();

        public NewArray() {
        }

        public NewArray(TypeRef type, Expression ... dimensions) {
            this.setType(type);
            this.setDimensions(Arrays.asList(dimensions));
        }

        public List<Expression> getDimensions() {
            return this.unmodifiableList(this.dimensions);
        }

        public void setDimensions(List<Expression> dimensions) {
            NewArray.changeValue((Element)this, this.dimensions, dimensions);
        }

        public TypeRef getType() {
            return this.type;
        }

        public void setType(TypeRef type) {
            this.type = NewArray.changeValue((Element)this, this.type, type);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNewArray(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return NewArray.getNextSibling(this.dimensions, child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            return NewArray.getPreviousSibling(this.dimensions, child);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getType()) {
                this.setType((TypeRef)by);
                return true;
            }
            return NewArray.replaceChild(this.dimensions, Expression.class, this, child, by);
        }
    }

    public static class MemberRef
    extends Expression {
        MemberRefStyle memberRefStyle;
        Expression target;
        Identifier name;

        public MemberRef(Identifier.SimpleIdentifier name) {
            this.setName(name);
        }

        public MemberRef(Expression target, MemberRefStyle memberRefStyle, Identifier name) {
            this.setTarget(target);
            this.setName(name);
            this.setMemberRefStyle(memberRefStyle);
        }

        public MemberRef() {
        }

        public void setName(Identifier name) {
            this.name = MemberRef.changeValue((Element)this, this.name, name);
        }

        public Identifier getName() {
            return this.name;
        }

        public void setTarget(Expression target) {
            this.target = MemberRef.changeValue((Element)this, this.target, target);
        }

        public Expression getTarget() {
            return this.target;
        }

        public void setMemberRefStyle(MemberRefStyle memberRefStyle) {
            this.memberRefStyle = memberRefStyle;
        }

        public MemberRefStyle getMemberRefStyle() {
            return this.memberRefStyle;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
            }
            if (child == this.getName()) {
                this.setName((Identifier)by);
            }
            return false;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitMemberRef(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }
    }

    public static class EmptyArraySize
    extends Expression {
        @Override
        public void accept(Visitor visitor) {
            visitor.visitEmptyArraySize(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            return false;
        }
    }

    public static class TypeRefExpression
    extends Expression {
        TypeRef type;

        public TypeRefExpression(TypeRef type) {
            this.setType(type);
        }

        public TypeRefExpression() {
        }

        public TypeRef getType() {
            return this.type;
        }

        public void setType(TypeRef type) {
            this.type = TypeRefExpression.changeValue((Element)this, this.type, type);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTypeRefExpression(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getType()) {
                this.setType((TypeRef)by);
                return true;
            }
            return false;
        }
    }

    public static enum MemberRefStyle {
        Dot,
        SquareBrackets,
        Arrow,
        Colons;

    }

    public static class OpaqueExpression
    extends Expression {
        String opaqueString;

        public void setOpaqueString(String opaqueString) {
            this.opaqueString = opaqueString;
        }

        public String getOpaqueString() {
            return this.opaqueString;
        }

        public OpaqueExpression() {
        }

        public OpaqueExpression(String opaqueString) {
            this.setOpaqueString(opaqueString);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitOpaqueExpression(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            return false;
        }
    }

    public static class ExpressionSequence
    extends Expression {
        final List<Expression> sequence = new ArrayList<Expression>();

        public List<Expression> getSequence() {
            return this.sequence;
        }

        public ExpressionSequence() {
        }

        public ExpressionSequence(List<Expression> sequence) {
            this.setSequence(sequence);
        }

        public void setSequence(List<Expression> sequence) {
            ExpressionSequence.changeValue((Element)this, this.sequence, sequence);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitExpressionSequence(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return ExpressionSequence.getNextSibling(this.getSequence(), child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            return ExpressionSequence.getPreviousSibling(this.getSequence(), child);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            return ExpressionSequence.replaceChild(this.getSequence(), Expression.class, this, child, by);
        }
    }
}

