/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ElementsHelper {
    public static Expression memberRef(Expression x, String name) {
        return ElementsHelper.memberRef(x, Expression.MemberRefStyle.Dot, name);
    }

    public static Expression memberRef(Expression x, Expression.MemberRefStyle style, String name) {
        return new Expression.MemberRef(x, style, new Identifier.SimpleIdentifier(name, new Expression[0]));
    }

    public static Expression classLiteral(Class<?> c) {
        if (c == null) {
            return null;
        }
        if (c.isPrimitive()) {
            if (c == Integer.TYPE) {
                c = Integer.class;
            } else if (c == Long.TYPE) {
                c = Long.class;
            } else if (c == Short.TYPE) {
                c = Short.class;
            } else if (c == Byte.TYPE) {
                c = Byte.class;
            } else if (c == Character.TYPE) {
                c = Character.class;
            } else if (c == Boolean.TYPE) {
                c = Boolean.class;
            } else if (c == Float.TYPE) {
                c = Float.class;
            } else if (c == Double.TYPE) {
                c = Double.class;
            }
            return ElementsHelper.staticField(c, "TYPE");
        }
        return ElementsHelper.staticField(c, "class");
    }

    public static Expression staticField(Class<?> c, String name) {
        return ElementsHelper.memberRef(ElementsHelper.expr(ElementsHelper.typeRef(ElementsHelper.ident(c, new Expression[0]))), Expression.MemberRefStyle.Dot, name);
    }

    public static Expression thisField(String name) {
        return ElementsHelper.memberRef(ElementsHelper.thisRef(), Expression.MemberRefStyle.Dot, name);
    }

    public static Expression thisRef() {
        return ElementsHelper.varRef("this");
    }

    public static Expression memberRef(Expression x, Expression.MemberRefStyle style, Identifier name) {
        return new Expression.MemberRef(x, style, name);
    }

    public static Expression memberRef(Expression x, Identifier name) {
        return ElementsHelper.memberRef(x, Expression.MemberRefStyle.Dot, name);
    }

    public static Expression varRef(String name) {
        return new Expression.VariableRef(new Identifier.SimpleIdentifier(name, new Expression[0]));
    }

    public static Expression varRef(Identifier.SimpleIdentifier name) {
        return new Expression.VariableRef(name);
    }

    public static Expression varRef(Identifier name) {
        return ElementsHelper.memberRef(ElementsHelper.expr(ElementsHelper.typeRef(name.resolveAllButLastIdentifier())), Expression.MemberRefStyle.Dot, name.resolveLastSimpleIdentifier());
    }

    public static Identifier ident(String ... others) {
        if (others == null) {
            return null;
        }
        ArrayList<Identifier.SimpleIdentifier> list = new ArrayList<Identifier.SimpleIdentifier>();
        for (String o : others) {
            if (o == null || (o = o.trim()).length() <= 0) continue;
            for (String elt : o.split("\\.")) {
                list.add(new Identifier.SimpleIdentifier(elt, new Expression[0]));
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (Identifier)list.get(0);
        }
        Identifier.QualifiedIdentifier id = new Identifier.QualifiedIdentifier(Identifier.QualificationSeparator.Dot);
        id.setIdentifiers(list);
        return id;
    }

    public static List<Identifier.SimpleIdentifier> getClassSimpleIdentifiers(String className) {
        ArrayList<Identifier.SimpleIdentifier> elts = new ArrayList<Identifier.SimpleIdentifier>();
        for (String s : className.split("[.$]")) {
            if (s.length() <= 0) continue;
            elts.add(new Identifier.SimpleIdentifier(s, new Expression[0]));
        }
        return elts;
    }

    public static Identifier ident(Class<?> cl, Expression ... args) {
        if (cl == null) {
            return null;
        }
        if (cl == Void.TYPE || cl == Void.class) {
            return ElementsHelper.ident("void");
        }
        Identifier.QualifiedIdentifier id = new Identifier.QualifiedIdentifier(Identifier.QualificationSeparator.Dot);
        id.setIdentifiers(ElementsHelper.getClassSimpleIdentifiers(cl.getName()));
        id.resolveLastSimpleIdentifier().setTemplateArguments(Arrays.asList(args));
        return id;
    }

    public static Identifier ident(Identifier ident, String name) {
        return ElementsHelper.ident(ident, ElementsHelper.ident(name));
    }

    public static Identifier ident(Identifier ident, Identifier ... others) {
        if (ident == null) {
            if (others.length > 0) {
                return ElementsHelper.ident(others[0], Arrays.copyOfRange(others, 1, others.length));
            }
            return null;
        }
        return ident.derive(Identifier.QualificationSeparator.Dot, others);
    }

    public static Expression opaqueExpr(String s) {
        return new Expression.OpaqueExpression(s);
    }

    public static Expression cast(TypeRef t, Expression s) {
        return new Expression.Cast(t, s);
    }

    public static Expression nullExpr() {
        return new Expression.NullExpression();
    }

    public static Expression expr(TypeRef tr) {
        return new Expression.TypeRefExpression(tr);
    }

    public static Expression expr(boolean c) {
        return ElementsHelper.expr(Expression.Constant.Type.Bool, c);
    }

    public static Expression expr(double c) {
        return ElementsHelper.expr(Expression.Constant.Type.Double, c);
    }

    public static Expression expr(int c) {
        return ElementsHelper.expr(Expression.Constant.Type.Int, c);
    }

    public static Expression expr(String c) {
        return ElementsHelper.expr(Expression.Constant.Type.String, c);
    }

    public static Expression expr(Expression.Constant.Type type, Object value) {
        return new Expression.Constant(type, value);
    }

    public static Expression expr(Expression.UnaryOperator op, Expression b) {
        return new Expression.UnaryOp(b, op);
    }

    public static Expression expr(Expression a, Expression.BinaryOperator op, Expression b) {
        return new Expression.BinaryOp(a, op, b);
    }

    public static Expression expr(Expression a, Expression.AssignmentOperator op, Expression b) {
        return new Expression.AssignmentOp(a, op, b);
    }

    public static <T extends Element> List<T> clones(List<T> list) {
        ArrayList<Element> clone = new ArrayList<Element>(list.size());
        for (Element e : list) {
            clone.add(e.clone());
        }
        return clone;
    }

    public static Expression.FunctionCall methodCall(Expression x, Expression.MemberRefStyle style, String name, Expression ... exprs) {
        return new Expression.FunctionCall(ElementsHelper.memberRef(x, style, name), exprs);
    }

    public static Expression.FunctionCall methodCall(Expression x, String name, Expression ... exprs) {
        return ElementsHelper.methodCall(x, Expression.MemberRefStyle.Dot, name, exprs);
    }

    public static Expression.FunctionCall methodCall(String name, Expression ... exprs) {
        return new Expression.FunctionCall(ElementsHelper.memberRef(null, null, name), exprs);
    }

    public static TypeRef typeRef(Class<?> cl) {
        if (cl == null) {
            return null;
        }
        if (cl.isArray()) {
            return new TypeRef.ArrayRef(ElementsHelper.typeRef(cl.getComponentType()), new Expression[0]);
        }
        if (cl.isPrimitive() || cl == Void.class) {
            return new TypeRef.Primitive(cl.getSimpleName());
        }
        return ElementsHelper.typeRef(ElementsHelper.ident(cl, new Expression[0]));
    }

    public static TypeRef.SimpleTypeRef typeRef(String name) {
        return ElementsHelper.typeRef(ElementsHelper.ident(name));
    }

    public static TypeRef.SimpleTypeRef typeRef(Identifier name) {
        return name == null ? null : new TypeRef.SimpleTypeRef(name);
    }

    public static Statement stat(Declaration d) {
        return new Statement.DeclarationStatement(d);
    }

    public static Statement stat(Expression x) {
        return new Statement.ExpressionStatement(x);
    }

    public static Statement stat(TypeRef tr, String varName, Expression ass) {
        VariablesDeclaration vd = new VariablesDeclaration(tr, new Declarator.DirectDeclarator(varName, ass));
        return new Statement.DeclarationStatement(vd);
    }

    public static Statement.Block block(Statement ... x) {
        return new Statement.Block(x);
    }

    public static TaggedTypeRefDeclaration decl(TypeRef.TaggedTypeRef tr) {
        return tr == null ? null : new TaggedTypeRefDeclaration(tr);
    }
}

