/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class Declarator
extends ModifiableElement {
    protected Expression defaultValue;
    boolean parenthesized = false;
    int bits = -1;

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    @Override
    public Declarator addModifiers(Modifier ... mds) {
        return (Declarator)super.addModifiers(mds);
    }

    public abstract MutableByDeclarator mutateType(MutableByDeclarator var1);

    public void setDefaultValue(Expression defaultValue) {
        this.defaultValue = Declarator.changeValue((Element)this, this.defaultValue, defaultValue);
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean replaceChild(Element child, Element by) {
        if (child == this.getDefaultValue()) {
            this.setDefaultValue((Expression)by);
            return true;
        }
        return super.replaceChild(child, by);
    }

    public boolean isParenthesized() {
        return this.parenthesized;
    }

    public void setParenthesized(boolean parenthesized) {
        this.parenthesized = parenthesized;
    }

    public abstract String resolveName();

    public abstract void propagateName(String var1);

    public static class ArrayDeclarator
    extends TargettedDeclarator {
        protected final List<Expression> dimensions = new ArrayList<Expression>();

        public ArrayDeclarator() {
        }

        public ArrayDeclarator(Declarator target, List<Expression> dimensions) {
            super(target);
            this.setDimensions(dimensions);
        }

        public ArrayDeclarator(Declarator target, Expression ... dimensions) {
            this(target, Arrays.asList(dimensions));
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitArrayDeclarator(this);
        }

        public void setDimensions(List<Expression> dimensions) {
            ArrayDeclarator.changeValue((Element)this, this.dimensions, dimensions);
        }

        public List<Expression> getDimensions() {
            return this.unmodifiableList(this.dimensions);
        }

        public void addDimension(Expression ex) {
            if (ex == null) {
                return;
            }
            this.dimensions.add(ex);
            ex.setParentElement(this);
        }

        @Override
        public MutableByDeclarator mutateType(MutableByDeclarator type) {
            if (type == null) {
                return null;
            }
            if ((type = type.clone()) instanceof TypeRef) {
                type = new TypeRef.ArrayRef((TypeRef)type, ArrayDeclarator.deepClone(this.getDimensions()));
            } else if (type instanceof Function) {
                Function f = (Function)type;
                f.setValueType(new TypeRef.ArrayRef(f.getValueType(), ArrayDeclarator.deepClone(this.getDimensions())));
                type = f;
            }
            ((Element)((Object)type)).importDetails(this, false);
            return this.target.mutateType(type);
        }

        @Override
        public Element getNextChild(Element child) {
            Element e = ArrayDeclarator.getNextSibling(this.dimensions, child);
            if (e != null) {
                return null;
            }
            return super.getNextChild(child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            Element e = ArrayDeclarator.getPreviousSibling(this.dimensions, child);
            if (e != null) {
                return null;
            }
            return super.getPreviousChild(child);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (super.replaceChild(child, by)) {
                return true;
            }
            if (ArrayDeclarator.replaceChild(this.dimensions, Expression.class, this, child, by)) {
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class FunctionDeclarator
    extends TargettedDeclarator {
        final List<Arg> args = new ArrayList<Arg>();

        public FunctionDeclarator() {
        }

        public FunctionDeclarator(Declarator target, List<Arg> args) {
            this.setTarget(target);
            this.setArgs(args);
        }

        @Override
        public MutableByDeclarator mutateType(MutableByDeclarator type) {
            MutableByDeclarator mutableByDeclarator = type = type == null ? null : type.clone();
            if (type == null || type instanceof TypeRef) {
                Function f = new Function();
                f.importDetails(this, false);
                f.setValueType((TypeRef)type);
                f.setType(Function.Type.CFunction);
                f.setArgs(this.getArgs());
                return this.getTarget().mutateType(f);
            }
            if (type instanceof Function) {
                Function ff = (Function)type;
                Function f = new Function();
                f.importDetails(this, false);
                f.setValueType(new TypeRef.FunctionSignature(ff));
                f.setType(Function.Type.CFunction);
                f.setArgs(this.getArgs());
                return this.getTarget().mutateType(f);
            }
            throw new IllegalArgumentException("Function declarator can only mutate type references ! (mutating \"" + type + "\" by \"" + this + "\")");
        }

        public List<Arg> getArgs() {
            return this.unmodifiableList(this.args);
        }

        public void setArgs(List<Arg> args) {
            FunctionDeclarator.changeValue((Element)this, this.args, args);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitFunctionDeclarator(this);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (FunctionDeclarator.replaceChild(this.args, Arg.class, this, child, by)) {
                return true;
            }
            return super.replaceChild(child, by);
        }

        @Override
        public Element getNextChild(Element child) {
            Element e = FunctionDeclarator.getNextSibling(this.args, child);
            if (e != null) {
                return e;
            }
            return super.getNextChild(child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            Element e = FunctionDeclarator.getPreviousSibling(this.args, child);
            if (e != null) {
                return e;
            }
            return super.getNextChild(child);
        }
    }

    public static class PointerDeclarator
    extends TargettedDeclarator {
        PointerStyle pointerStyle;

        public PointerDeclarator() {
        }

        public PointerDeclarator(Declarator target, PointerStyle pointerStyle) {
            super(target);
            this.setPointerStyle(pointerStyle);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitPointerDeclarator(this);
        }

        @Override
        public MutableByDeclarator mutateType(MutableByDeclarator type) {
            if (type == null) {
                return null;
            }
            if ((type = type.clone()) instanceof Function) {
                type = new TypeRef.FunctionSignature((Function)type).importDetails((Element)type, true);
            } else if (type instanceof TypeRef) {
                type = new TypeRef.Pointer((TypeRef)type, this.getPointerStyle()).importDetails((Element)type, true);
            } else {
                throw new IllegalArgumentException(type.getClass().getName() + " cannot be mutated by pointer");
            }
            ((Element)type).importDetails(this, false);
            return this.getTarget() == null ? type : this.getTarget().mutateType((MutableByDeclarator)type);
        }

        public PointerStyle getPointerStyle() {
            return this.pointerStyle;
        }

        public void setPointerStyle(PointerStyle pointerStyle) {
            this.pointerStyle = pointerStyle;
        }
    }

    public static abstract class TargettedDeclarator
    extends Declarator {
        Declarator target;

        public TargettedDeclarator() {
        }

        public TargettedDeclarator(Declarator target) {
            this.setTarget(target);
        }

        public Declarator getTarget() {
            return this.target;
        }

        public void setTarget(Declarator target) {
            this.target = TargettedDeclarator.changeValue((Element)this, this.target, target);
        }

        @Override
        public String resolveName() {
            return this.getTarget() != null ? this.getTarget().resolveName() : null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Declarator)by);
                return true;
            }
            return super.replaceChild(child, by);
        }

        @Override
        public void propagateName(String name) {
            if (this.getTarget() != null) {
                this.getTarget().propagateName(name);
            } else {
                this.setTarget(new DirectDeclarator(name));
            }
        }
    }

    public static class DirectDeclarator
    extends Declarator {
        String name;

        public DirectDeclarator(String name, int bits) {
            this.setName(name);
            this.setBits(bits);
        }

        public DirectDeclarator(String name) {
            this.setName(name);
        }

        public DirectDeclarator(String name, Expression defaultValue) {
            this.setName(name);
            this.setDefaultValue(defaultValue);
        }

        public DirectDeclarator() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String resolveName() {
            return this.getName();
        }

        @Override
        public MutableByDeclarator mutateType(MutableByDeclarator type) {
            if (type == null) {
                return null;
            }
            if ((type = type.clone()) instanceof Function) {
                ((Function)type).setName(new Identifier.SimpleIdentifier(this.getName(), new Expression[0]));
            }
            ((Element)((Object)type)).importDetails(this, false);
            return type;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDirectDeclarator(this);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            return super.replaceChild(child, by);
        }

        @Override
        public void propagateName(String name) {
            this.setName(name);
        }
    }

    public static enum PointerStyle {
        Pointer{

            public String toString() {
                return "*";
            }
        }
        ,
        Reference{

            public String toString() {
                return "&";
            }
        }
        ,
        HatPointer{

            public String toString() {
                return "^";
            }
        };

        static Map<String, PointerStyle> styles;

        public static PointerStyle parsePointerStyle(String s) {
            return styles.get(s);
        }

        static {
            styles = new TreeMap<String, PointerStyle>();
            for (PointerStyle style : PointerStyle.values()) {
                styles.put(style.toString(), style);
            }
        }
    }

    public static interface MutableByDeclarator {
        public MutableByDeclarator clone();
    }
}

