/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.nativesupport;

import com.ochafik.lang.jnaerator.nativesupport.FatMachOExport;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class NativeExportUtils {
    public static byte[] GetFileBytes(RandomAccessFile raf, long offset, int size) throws IOException {
        raf.seek(offset);
        if (size < 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] b = new byte[1];
            while (raf.read(b) != 0 && b[0] != 0) {
                out.write(b);
            }
            return out.toByteArray();
        }
        byte[] bytes = new byte[size];
        raf.readFully(bytes);
        return bytes;
    }

    public static int fromBigEndian(int i) {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? NativeExportUtils.invertBytes(i) : i;
    }

    public static int fromLittleEndian(int i) {
        return ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN ? NativeExportUtils.invertBytes(i) : i;
    }

    private static long fromBigEndian(Long i) {
        return ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN ? (long)NativeExportUtils.invertBytes(i) : i;
    }

    public static int invertBytes(long i) {
        return NativeExportUtils.invertBytes((int)(i & 0xFFFFFFFFFFFFFFFFL)) << 32 | NativeExportUtils.invertBytes((int)(i >> 32));
    }

    public static int invertBytes(int i) {
        int j = (NativeExportUtils.invertBytes((short)(i & 0xFFFF)) & 0xFFFF) << 16 | NativeExportUtils.invertBytes((short)(i >> 16)) & 0xFFFF;
        return j;
    }

    public static short invertBytes(short i) {
        short j = (short)((i & 0xFF) << 8 | i >> 8 & 0xFF);
        return j;
    }

    public static <S extends Structure> S deserializeBigEndianStruct(S struct, RandomAccessFile raf, long offset) throws IOException {
        return NativeExportUtils.fromBigEndianFields(NativeExportUtils.deserializeStruct(struct, raf, offset));
    }

    static <T> T fromBigEndianFields(T o) {
        try {
            for (Field f : o.getClass().getFields()) {
                Structure u;
                if ((f.getModifiers() & 0x18) != 0 || (f.getModifiers() & 1) == 0) continue;
                if (f.getType() == Integer.TYPE) {
                    f.set(o, NativeExportUtils.fromBigEndian((Integer)f.get(o)));
                    continue;
                }
                if (f.getType() == Short.TYPE) {
                    f.set(o, (short)NativeExportUtils.fromBigEndian(((Short)f.get(o)).shortValue()));
                    continue;
                }
                if (f.getType() == Long.TYPE) {
                    f.set(o, NativeExportUtils.fromBigEndian((Long)f.get(o)));
                    continue;
                }
                if (Union.class.isAssignableFrom(f.getType())) {
                    u = (Union)f.get(o);
                    NativeExportUtils.fromBigEndianFields(u);
                    continue;
                }
                if (!Structure.class.isAssignableFrom(f.getType())) continue;
                u = (Structure)f.get(o);
                NativeExportUtils.fromBigEndianFields(u);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return o;
    }

    public static <S extends Structure> S deserializeStruct(S struct, RandomAccessFile raf, long offset) throws IOException {
        byte[] bytes = NativeExportUtils.GetFileBytes(raf, offset, struct.size());
        struct.getPointer().write(0L, bytes, 0, bytes.length);
        struct.read();
        return struct;
    }

    public static String createSourceFile(File sourceFile, List<ParsedExport> dllExports) {
        if (dllExports == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("#line \"" + sourceFile + "\"\n");
        for (ParsedExport ex : dllExports) {
            b.append("// @mangling " + ex.mangling + "\n");
            b.append(ex.demangled + ";\n");
            b.append("\n");
        }
        return b.toString();
    }

    public static void main(String[] args) {
        try {
            File f = new File("/System/Library/Frameworks/CoreFoundation.framework/CoreFoundation");
            System.out.println(FatMachOExport.parseDllExports(f));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int readLittleEndianInt(RandomAccessFile raf, long l) throws IOException {
        raf.seek(l);
        byte[] bytes = new byte[4];
        raf.read(bytes);
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get(0);
    }

    public static int readBigEndianInt(RandomAccessFile raf, long l) throws IOException {
        raf.seek(l);
        byte[] bytes = new byte[4];
        raf.read(bytes);
        return ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).asIntBuffer().get(0);
    }

    public static class ParsedExport {
        public String mangling;
        public String demangled;
        public String library;
    }
}

