/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.nativesupport;

import com.ochafik.lang.jnaerator.nativesupport.NativeExportUtils;
import com.ochafik.lang.jnaerator.nativesupport.machoexport.fat_arch;
import com.ochafik.lang.jnaerator.nativesupport.machoexport.fat_header;
import com.ochafik.lang.jnaerator.nativesupport.machoexport.load_command;
import com.ochafik.lang.jnaerator.nativesupport.machoexport.mach_header;
import com.ochafik.lang.jnaerator.nativesupport.machoexport.nlist;
import com.ochafik.lang.jnaerator.nativesupport.machoexport.symtab_command;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FatMachOExport {
    public static char[] parseDllExports(File f) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        byte[] b = NativeExportUtils.GetFileBytes(raf, 0L, 100);
        int i = NativeExportUtils.readBigEndianInt(raf, 0L);
        String h = Integer.toHexString(i);
        fat_header fat = NativeExportUtils.deserializeBigEndianStruct(new fat_header(), raf, 0L);
        if (fat.magic == -889275714) {
            long archsBase = fat.size();
            long archSize = new fat_arch().size();
            for (int iFatArch = 0; iFatArch < fat.nfat_arch; ++iFatArch) {
                long archBase = archsBase + archSize * (long)iFatArch;
                fat_arch arch = NativeExportUtils.deserializeBigEndianStruct(new fat_arch(), raf, archBase);
                if (arch.cputype == 0) continue;
                mach_header mach = NativeExportUtils.deserializeBigEndianStruct(new mach_header(), raf, arch.offset);
                if (mach.cputype != arch.cputype || mach.cpusubtype != arch.cpusubtype) {
                    throw new IOException("Failed to recognize Fat + MachO format !");
                }
                if (mach.magic != -17958194) continue;
                FatMachOExport.OutputSymbols(raf, mach, arch.offset);
            }
        }
        return null;
    }

    private static void OutputSymbols(RandomAccessFile raf, mach_header mach, int machOffset) throws IOException {
        int currentCommandOffset = machOffset + mach.size();
        boolean passedLastOk = false;
        for (int iLoadCmd = 0; iLoadCmd < mach.ncmds; ++iLoadCmd) {
            load_command lc = NativeExportUtils.deserializeBigEndianStruct(new load_command(), raf, currentCommandOffset);
            switch (lc.cmd) {
                case 2: {
                    symtab_command sc = NativeExportUtils.deserializeBigEndianStruct(new symtab_command(), raf, currentCommandOffset);
                    int symtabsize = new nlist().size();
                    int scsize = sc.size();
                    for (int iSymTab = 0; iSymTab < sc.nsyms; ++iSymTab) {
                        long nlOffset = machOffset + scsize + sc.symoff + iSymTab * symtabsize;
                        nlist nl = NativeExportUtils.deserializeBigEndianStruct(new nlist(), raf, nlOffset);
                        nl.n_un.setType(Integer.TYPE);
                        if (nl.n_un.n_strx == 0) continue;
                        short desc = nl.n_desc;
                        if (nl.n_desc != -1) continue;
                        int stab = nl.n_type & 0xE0;
                        if (stab != 0) {
                            String h = Integer.toHexString(stab);
                            h = h.toString();
                            continue;
                        }
                        try {
                            long stroff = sc.stroff + machOffset + nl.n_un.n_strx;
                            byte[] sbytes = NativeExportUtils.GetFileBytes(raf, stroff, -1);
                            String symbol = new String(sbytes);
                            byte sector = nl.n_sect;
                            if (symbol.equals("_kCFUserNotificationSoundPathKey")) {
                                passedLastOk = true;
                            }
                            System.out.println(symbol);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    byte[] sbytes = NativeExportUtils.GetFileBytes(raf, sc.stroff + machOffset, 100);
                    char[] chars = new char[sbytes.length];
                    for (int i = 0; i < sbytes.length; ++i) {
                        chars[i] = (char)(0xFF & sbytes[i]);
                    }
                    int nsyms = sc.nsyms;
                    break;
                }
            }
            currentCommandOffset += lc.cmdsize;
        }
    }
}

