/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.nativesupport;

import com.ochafik.lang.jnaerator.nativesupport.NativeExportUtils;
import com.ochafik.lang.jnaerator.nativesupport.dllexport.DbgHelpLibrary;
import com.ochafik.lang.jnaerator.nativesupport.dllexport.IMAGE_DOS_HEADER;
import com.ochafik.lang.jnaerator.nativesupport.dllexport.IMAGE_EXPORT_DIRECTORY;
import com.ochafik.lang.jnaerator.nativesupport.dllexport.IMAGE_NT_HEADERS;
import com.ochafik.lang.jnaerator.nativesupport.dllexport.IMAGE_SECTION_HEADER;
import com.ochafik.util.string.RegexUtils;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.PointerUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DllExport {
    private static final Pattern libraryFileNamePattern = Pattern.compile("^([^.]+)\\.dll");

    public static String createSourceFile(File sourceFile, List<NativeExportUtils.ParsedExport> dllExports) {
        if (dllExports == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("#line \"" + sourceFile + "\"\n");
        for (NativeExportUtils.ParsedExport ex : dllExports) {
            b.append("// @mangling " + ex.mangling + "\n");
            b.append(ex.demangled + ";\n");
            b.append("\n");
        }
        return b.toString();
    }

    public static List<NativeExportUtils.ParsedExport> parseDllExports(File f) throws IOException {
        ArrayList<NativeExportUtils.ParsedExport> ret = new ArrayList<NativeExportUtils.ParsedExport>();
        List<String> list = DllExport.OutputDllFunctions(f);
        if (list == null) {
            return null;
        }
        String library = RegexUtils.findFirst(f.getName(), libraryFileNamePattern, 1);
        int outSize = 8196;
        byte[] bytes = new byte[outSize];
        Memory m = new Memory(outSize);
        for (String symbol : list) {
            int len;
            DbgHelpLibrary.INSTANCE.UnDecorateSymbolName(symbol, m.getByteBuffer(0L, outSize), outSize, 0);
            m.read(0L, bytes, 0, outSize);
            for (len = 0; len < outSize && bytes[len] != 0; ++len) {
            }
            NativeExportUtils.ParsedExport ex = new NativeExportUtils.ParsedExport();
            ex.mangling = symbol;
            ex.demangled = new String(bytes, 0, len);
            ex.library = library;
            ret.add(ex);
        }
        return ret;
    }

    private static List<String> OutputDllFunctions(File f) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        IMAGE_DOS_HEADER dosHeader = NativeExportUtils.deserializeStruct(new IMAGE_DOS_HEADER(), raf, 0L);
        if (dosHeader.e_magic != 23117) {
            return null;
        }
        long ntHeaderBase = dosHeader.e_lfanew.longValue();
        IMAGE_NT_HEADERS ntHeader = NativeExportUtils.deserializeStruct(new IMAGE_NT_HEADERS(), raf, ntHeaderBase);
        if (ntHeader.Signature != 17744) {
            return null;
        }
        int exportsStartRVA = ntHeader.OptionalHeader.DataDirectory[0].VirtualAddress;
        IMAGE_SECTION_HEADER header = DllExport.GetExportsSectionHeader(raf, exportsStartRVA, ntHeaderBase, ntHeader);
        if (header == null) {
            return null;
        }
        int delta = header.VirtualAddress - header.PointerToRawData;
        IMAGE_EXPORT_DIRECTORY exportDir = NativeExportUtils.deserializeStruct(new IMAGE_EXPORT_DIRECTORY(), raf, exportsStartRVA - delta);
        ArrayList<String> ret = new ArrayList<String>(exportDir.NumberOfNames);
        for (int i = 0; i < exportDir.NumberOfNames; ++i) {
            int pstr = NativeExportUtils.readLittleEndianInt(raf, PointerUtils.getAddress(exportDir.AddressOfNames) - (long)delta + (long)(i * Pointer.SIZE));
            String name = new String(NativeExportUtils.GetFileBytes(raf, pstr - delta, -1));
            ret.add(name);
        }
        return ret;
    }

    private static IMAGE_SECTION_HEADER GetExportsSectionHeader(RandomAccessFile raf, int exportsStartRVA, long ntHeaderBase, IMAGE_NT_HEADERS ntHeader) throws IOException {
        IMAGE_SECTION_HEADER firstSection = new IMAGE_SECTION_HEADER();
        byte[] bytes = NativeExportUtils.GetFileBytes(raf, ntHeaderBase + PointerUtils.getAddress(ntHeader.OptionalHeader.getPointer()) - PointerUtils.getAddress(ntHeader.getPointer()) + (long)ntHeader.FileHeader.SizeOfOptionalHeader, firstSection.size() * ntHeader.FileHeader.NumberOfSections);
        IMAGE_SECTION_HEADER[] sections = (IMAGE_SECTION_HEADER[])firstSection.toArray(ntHeader.FileHeader.NumberOfSections);
        sections[0].getPointer().write(0L, bytes, 0, bytes.length);
        for (IMAGE_SECTION_HEADER section : sections) {
            section.read();
            if (exportsStartRVA < section.VirtualAddress || exportsStartRVA >= section.VirtualAddress + section.Misc.VirtualSize) continue;
            return section;
        }
        return null;
    }
}

