/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.cplusplus;

import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.cplusplus.CPlusPlusMangler;
import com.ochafik.lang.jnaerator.cplusplus.Primitive;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VC9Mangler
implements CPlusPlusMangler {
    static Map<Primitive, String> signatures = new HashMap<Primitive, String>();
    static Map<String, String> specialCodes;
    static final String CONSTRUCTOR = "?0";
    static final String DESTRUCTOR = "?1";
    static final String VFTABLE = "?_7";
    static final String VBTABLE = "?_8";
    static final String VCALL = "?_9";
    static final String TYPEOF = "?_A";

    public void mangleType(TypeRef tr, StringBuilder b, Result result, List<TypeRef> referenceList) {
        if (tr == null) {
            tr = new TypeRef.SimpleTypeRef("void");
        }
        referenceList.add(tr);
        if (tr instanceof TypeRef.TargettedTypeRef) {
            if (tr instanceof TypeRef.Pointer && ((TypeRef.Pointer)tr).getPointerStyle() == Declarator.PointerStyle.Reference) {
                b.append("A");
            } else if (tr instanceof TypeRef.ArrayRef) {
                b.append("Q");
            } else if (Modifier.__const.isContainedBy(tr.getModifiers())) {
                b.append("Q");
            } else {
                b.append("P");
            }
            this.mangleStorageMod(tr, b, result);
            this.mangleType(((TypeRef.TargettedTypeRef)tr).getTarget(), b, result, referenceList);
        } else if (tr instanceof TypeRef.SimpleTypeRef) {
            Primitive p;
            String s;
            TypeRef.SimpleTypeRef str = (TypeRef.SimpleTypeRef)tr;
            TypeRef resolved = result.typeConverter.resolveTypeDef(str, null, false);
            if (resolved != null && !resolved.toString().equals(str.toString())) {
                this.mangleType(resolved, b, result, referenceList);
                return;
            }
            if (str.getName() == null) {
                str.setName(new Identifier.SimpleIdentifier("int", new Expression[0]));
            }
            if ((s = signatures.get((Object)(p = Primitive.parsePrimitive(str)))) != null) {
                b.append(s);
            } else {
                VC9Mangler.lenghtedName(str.getName().toString(), b);
            }
        } else if (tr instanceof TypeRef.TaggedTypeRef) {
            this.mangleTaggedTypeRef((TypeRef.TaggedTypeRef)tr, b, result);
        } else if (tr instanceof TypeRef.FunctionSignature) {
            TypeRef.FunctionSignature fs = (TypeRef.FunctionSignature)tr;
            b.append("PF");
            this.mangleType(fs.getFunction().getValueType(), b, result, referenceList);
            this.mangleArgs(fs.getFunction().getArgs(), b, result, referenceList);
            b.append("E");
        } else {
            throw new UnsupportedOperationException("Cannot mangle type references of class " + tr.getClass().getName() + " : '" + tr + "'");
        }
    }

    private void mangleTaggedTypeRef(TypeRef.TaggedTypeRef tr, StringBuilder b, Result result) {
        if (tr instanceof Enum) {
            b.append("W4");
        } else if (tr instanceof Struct) {
            Struct s = (Struct)tr;
            switch (s.getType()) {
                case CPPClass: {
                    b.append("V");
                    break;
                }
                case CStruct: {
                    b.append("U");
                    break;
                }
                case CUnion: {
                    b.append("T");
                }
            }
        }
        this.qualify(b, tr.getOriginalTag(), tr.getNameSpace());
    }

    private void qualify(StringBuilder b, Identifier identifier, List<String> ns) {
        List<Identifier.SimpleIdentifier> sis = identifier.resolveSimpleIdentifiers();
        int i = sis.size();
        while (i-- != 0) {
            b.append(sis.get(i) + "@");
        }
        i = ns.size();
        while (i-- != 0) {
            b.append(ns.get(i) + "@");
        }
        b.append("@");
    }

    static void lenghtedName(String name, StringBuilder out) {
        out.append(name.length() + name);
    }

    @Override
    public String mangle(Function function, Result result) {
        ArrayList<String> ns;
        Identifier name = function.getName();
        if (name == null) {
            return null;
        }
        StringBuilder b = new StringBuilder("?");
        b.append(function.getName());
        b.append("@");
        Element parent = function.getParentElement();
        boolean isMethod = parent instanceof Struct;
        if (isMethod) {
            ns = new ArrayList<String>(parent.getNameSpace());
            ns.addAll(((Struct)parent).getTag().resolveSimpleIdentifiers());
        } else {
            ns = new ArrayList<String>(function.getNameSpace());
        }
        int i = ns.size();
        while (i-- != 0) {
            b.append(ns.get(i) + "@");
        }
        if (Modifier.Static.isContainedBy(function.getModifiers())) {
            b.append("@S");
        } else if (function.getParentElement() instanceof Struct) {
            b.append("@Q");
        } else {
            b.append("@Y");
        }
        this.mangleStorageMod(function, b, result);
        this.mangleType(function.getValueType(), b, result, new ArrayList<TypeRef>());
        this.mangleArgs(function.getArgs(), b, result, new ArrayList<TypeRef>());
        b.append("Z");
        return b.toString();
    }

    private void mangleStorageMod(ModifiableElement e, StringBuilder b, Result result) {
        List<Modifier> modifiers = e.getModifiers();
        if (e instanceof Function) {
            Function f = (Function)e;
            if (Modifier.__fastcall.isContainedBy(modifiers)) {
                b.append("I");
            } else if (Modifier.__stdcall.isContainedBy(modifiers)) {
                b.append("G");
            } else {
                b.append("A");
            }
            if (f.getParentElement() instanceof Struct && !Modifier.Static.isContainedBy(modifiers)) {
                b.append("E");
            }
        } else if (e instanceof TypeRef) {
            if (Modifier.__const.isContainedBy(modifiers)) {
                b.append("B");
            } else {
                b.append("A");
            }
        }
    }

    private void mangleArgs(List<Arg> args, StringBuilder b, Result result, List<TypeRef> referenceList) {
        if (args.isEmpty()) {
            b.append("X");
        } else {
            for (Arg arg : args) {
                TypeRef tr = arg.createMutatedType();
                this.mangleType(tr, b, result, referenceList);
            }
            b.append("@");
        }
    }

    static {
        signatures.put(Primitive.Void, "X");
        signatures.put(Primitive.SChar, "C");
        signatures.put(Primitive.Char, "D");
        signatures.put(Primitive.UChar, "E");
        signatures.put(Primitive.Short, "F");
        signatures.put(Primitive.UShort, "G");
        signatures.put(Primitive.Int, "H");
        signatures.put(Primitive.UInt, "I");
        signatures.put(Primitive.Long, "J");
        signatures.put(Primitive.ULong, "K");
        signatures.put(Primitive.Float, "M");
        signatures.put(Primitive.Double, "N");
        signatures.put(Primitive.LongDouble, "O");
        signatures.put(Primitive.LongLong, "_J");
        signatures.put(Primitive.ULongLong, "_K");
        signatures.put(Primitive.Bool, "_N");
        specialCodes = new HashMap<String, String>();
        specialCodes.put("new", "?2");
        specialCodes.put("delete", "?3");
        specialCodes.put("operator=", "?4");
        specialCodes.put("operator>>", "?5");
        specialCodes.put("operator/=", "?_0");
        specialCodes.put("operator%=", "?_1");
        specialCodes.put("operator>>=", "?_2");
        specialCodes.put("operator<<=", "?_3");
        specialCodes.put("operator&=", "?_4");
        specialCodes.put("operator|=", "?_5");
        specialCodes.put("operator^=", "?_6");
    }
}

