/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.cplusplus;

import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.cplusplus.CPlusPlusMangler;
import com.ochafik.lang.jnaerator.cplusplus.Primitive;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GCC4Mangler
implements CPlusPlusMangler {
    static Map<Primitive, String> signatures = new HashMap<Primitive, String>();

    protected void mangleType(TypeRef tr, StringBuilder b, Result result) {
        if (tr == null) {
            tr = new TypeRef.SimpleTypeRef("void");
        }
        if (Modifier.Const.isContainedBy(tr.getModifiers())) {
            b.append("K");
        }
        if (tr instanceof TypeRef.TargettedTypeRef) {
            if (tr instanceof TypeRef.Pointer && ((TypeRef.Pointer)tr).getPointerStyle() == Declarator.PointerStyle.Reference) {
                b.append("R");
            } else {
                b.append("P");
            }
            this.mangleType(((TypeRef.TargettedTypeRef)tr).getTarget(), b, result);
        } else if (tr instanceof TypeRef.SimpleTypeRef) {
            Primitive p;
            String s;
            TypeRef.SimpleTypeRef str = (TypeRef.SimpleTypeRef)tr;
            TypeRef resolved = result.typeConverter.resolveTypeDef(str, null, false);
            if (resolved != null && !resolved.toString().equals(str.toString())) {
                this.mangleType(resolved, b, result);
                return;
            }
            if (str.getName() == null) {
                str.setName(new Identifier.SimpleIdentifier("int", new Expression[0]));
            }
            if ((s = signatures.get((Object)(p = Primitive.parsePrimitive(str)))) != null) {
                b.append(s);
            } else {
                this.lenghtedName(str.getName().toString(), b);
            }
        } else if (tr instanceof TypeRef.TaggedTypeRef) {
            this.lenghtedName(((TypeRef.TaggedTypeRef)tr).getOriginalTag().toString(), b);
        } else if (tr instanceof TypeRef.FunctionSignature) {
            TypeRef.FunctionSignature fs = (TypeRef.FunctionSignature)tr;
            b.append("PF");
            this.mangleType(fs.getFunction().getValueType(), b, result);
            this.mangleArgs(fs.getFunction().getArgs(), b, result);
            b.append("E");
        } else {
            throw new UnsupportedOperationException("Cannot mangle type references of class " + tr.getClass().getName() + " : '" + tr + "'");
        }
    }

    protected void lenghtedName(String n, StringBuilder out) {
        out.append(n.length() + n);
    }

    @Override
    public String mangle(Function function, Result result) {
        ArrayList<String> ns;
        Identifier name = function.getName();
        if (name == null) {
            return null;
        }
        StringBuilder b = new StringBuilder("_Z");
        Element parent = function.getParentElement();
        boolean isMethod = parent instanceof Struct;
        if (isMethod) {
            ns = new ArrayList<String>(parent.getNameSpace());
            ns.addAll(((Struct)parent).getTag().resolveSimpleIdentifiers());
        } else {
            ns = new ArrayList<String>(function.getNameSpace());
        }
        if (ns.isEmpty()) {
            this.lenghtedName(name.toString(), b);
        } else {
            b.append("N");
            for (Object e : ns) {
                this.lenghtedName(e.toString(), b);
            }
            this.lenghtedName(name.toString(), b);
            if (isMethod) {
                b.append("E");
            }
        }
        this.mangleArgs(function.getArgs(), b, result);
        return b.toString();
    }

    private void mangleArgs(List<Arg> args, StringBuilder b, Result result) {
        if (args.isEmpty()) {
            b.append("v");
        } else {
            for (Arg arg : args) {
                TypeRef tr = arg.createMutatedType();
                this.mangleType(tr, b, result);
            }
        }
    }

    static {
        signatures.put(Primitive.Void, "v");
        signatures.put(Primitive.Char, "c");
        signatures.put(Primitive.SChar, "c");
        signatures.put(Primitive.UChar, "h");
        signatures.put(Primitive.Long, "l");
        signatures.put(Primitive.LongLong, "x");
        signatures.put(Primitive.ULongLong, "y");
        signatures.put(Primitive.ULong, "m");
        signatures.put(Primitive.Int, "i");
        signatures.put(Primitive.UInt, "j");
        signatures.put(Primitive.Short, "s");
        signatures.put(Primitive.UShort, "t");
        signatures.put(Primitive.Bool, "b");
        signatures.put(Primitive.Float, "f");
        signatures.put(Primitive.Double, "d");
        signatures.put(Primitive.LongDouble, "e");
    }
}

