/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.util.listenable.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UniversalReconciliator {
    static Map<Pair<String, String>, TypeRef> predefined32_64Reconciliations = new HashMap<Pair<String, String>, TypeRef>();

    DefSeq extractDefSeq(Element tr) {
        final DefSeq ret = new DefSeq();
        tr.accept(new Scanner(){

            @Override
            public void visitDeclarator(Declarator declarator) {
                super.visitDeclarator(declarator);
                ret.declarators.add(declarator);
            }

            @Override
            public void visitSimpleTypeRef(TypeRef.SimpleTypeRef simpleTypeRef) {
                super.visitSimpleTypeRef(simpleTypeRef);
                ret.simpleTypeRefs.add(simpleTypeRef);
            }
        });
        return ret;
    }

    public Element reconciliate32bitsAnd64bits(Element tr32, Element tr64) throws ReconciliationException {
        DefSeq s64;
        if (tr32 == null && tr64 == null) {
            return null;
        }
        if (tr32 == null != (tr64 == null)) {
            if (tr32 == null && tr64.toString().matches("id") || tr64 == null && tr32.toString().equals("id")) {
                return ElementsHelper.typeRef("id");
            }
            throw new ReconciliationException(tr32, tr64, null);
        }
        DefSeq s32 = this.extractDefSeq(tr32 = tr32.clone());
        if (!s32.matches(s64 = this.extractDefSeq(tr64))) {
            throw new ReconciliationException(tr32, tr64, null);
        }
        int n = s32.simpleTypeRefs.size();
        for (int i = 0; i < n; ++i) {
            TypeRef.SimpleTypeRef t32 = s32.simpleTypeRefs.get(i);
            TypeRef.SimpleTypeRef t64 = s64.simpleTypeRefs.get(i);
            if (t32.toString().equals(t64.toString())) continue;
            TypeRef tr = UniversalReconciliator.reconciliateSimple32bitsAnd64bits(t32, t64);
            if (tr == null) {
                throw new ReconciliationException(tr32, tr64, t32, t64);
            }
            if (t32 == tr32) {
                tr32 = tr;
                continue;
            }
            t32.replaceBy(tr);
        }
        return tr32;
    }

    static void defRecon(String s32, String s64, TypeRef sRecon) {
        predefined32_64Reconciliations.put(new Pair<String, String>(s32, s64), sRecon);
    }

    public static TypeRef reconciliateSimple32bitsAnd64bits(TypeRef t32, TypeRef t64) {
        TypeRef recon = predefined32_64Reconciliations.get(new Pair<String, String>(t32.toString(), t64.toString()));
        return recon == null ? null : recon.clone();
    }

    static {
        UniversalReconciliator.defRecon("float", "double", ElementsHelper.typeRef("CGFloat"));
        UniversalReconciliator.defRecon("long", "long long", ElementsHelper.typeRef("long"));
        UniversalReconciliator.defRecon("int", "long long", ElementsHelper.typeRef("NSInteger"));
        UniversalReconciliator.defRecon("int", "unsigned long long", ElementsHelper.typeRef("NSInteger"));
        UniversalReconciliator.defRecon("int", "signed long long", ElementsHelper.typeRef("NSInteger"));
        UniversalReconciliator.defRecon("long", "unsigned long long", ElementsHelper.typeRef("NSInteger"));
        UniversalReconciliator.defRecon("long", "signed long long", ElementsHelper.typeRef("NSInteger"));
        UniversalReconciliator.defRecon("unsigned long", "unsigned long long", (TypeRef)ElementsHelper.typeRef("long").addModifiers(new Modifier[]{Modifier.Unsigned}));
        UniversalReconciliator.defRecon("unsigned int", "unsigned long long", ElementsHelper.typeRef("NSUInteger"));
        UniversalReconciliator.defRecon("unsigned long", "unsigned int", (TypeRef)ElementsHelper.typeRef("int").addModifiers(new Modifier[]{Modifier.Unsigned}));
        UniversalReconciliator.defRecon("signed long", "signed int", (TypeRef)ElementsHelper.typeRef("int").addModifiers(new Modifier[]{Modifier.Signed}));
        UniversalReconciliator.defRecon("long", "int", ElementsHelper.typeRef("int"));
        UniversalReconciliator.defRecon("int", "unsigned int", ElementsHelper.typeRef("int"));
        UniversalReconciliator.defRecon("signed long", "signed long long", (TypeRef)ElementsHelper.typeRef("long").addModifiers(new Modifier[]{Modifier.Signed}));
        UniversalReconciliator.defRecon("signed int", "signed long long", ElementsHelper.typeRef("NSInteger"));
    }

    public static class ReconciliationException
    extends Exception {
        private static final long serialVersionUID = -8197343041734256268L;

        public ReconciliationException(Element t1, Element t2, Element reason1, Element reason2) {
            this(t1, t2, "\"" + reason1 + "\" and \"" + reason2 + "\" cannot be matched");
        }

        public ReconciliationException(Element t1, Element t2, String reason) {
            super("Types \"" + t1 + "\" and \"" + t2 + "\" could not be reconciliated" + (reason == null ? "" : ". Reason = " + reason));
        }
    }

    static class DefSeq {
        List<TypeRef.SimpleTypeRef> simpleTypeRefs = new ArrayList<TypeRef.SimpleTypeRef>();
        List<Declarator> declarators = new ArrayList<Declarator>();

        DefSeq() {
        }

        boolean matches(DefSeq o) {
            int n = this.declarators.size();
            if (n != this.declarators.size()) {
                return false;
            }
            if (this.simpleTypeRefs.size() != o.simpleTypeRefs.size()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                Declarator id = this.declarators.get(i);
                Declarator oid = this.declarators.get(i);
                if (id.toString().equals(oid.toString())) continue;
                return false;
            }
            return true;
        }
    }
}

