/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.SyntaxUtils;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ObjCppParser;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.runtime.CGFloatByReference;
import com.ochafik.lang.jnaerator.runtime.CharByReference;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.ochafik.lang.jnaerator.runtime.globals.Global;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalByte;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalCGFloat;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalChar;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalDouble;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalFloat;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalInt;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalLong;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalNativeLong;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalNativeSize;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalShort;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.StringUtils;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.bridj.SizeT;
import org.bridj.ValuedEnum;
import org.bridj.ann.CLong;
import org.bridj.ann.Ptr;
import org.bridj.util.DefaultParameterizedType;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Selector;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSObject;
import org.rococoa.cocoa.foundation.NSUInteger;

public class TypeConversion
implements ObjCppParser.ObjCParserHelper {
    Result result;
    public boolean allowUnknownPointers = true;
    public boolean allowFakePointers = false;
    public Map<JavaPrim, Class<? extends ByReference>> primToByReference = new HashMap<JavaPrim, Class<? extends ByReference>>();
    public Map<JavaPrim, Class<? extends Global>> primToGlobal = new HashMap<JavaPrim, Class<? extends Global>>();
    public Map<JavaPrim, Class<? extends Buffer>> primToBuffer = new HashMap<JavaPrim, Class<? extends Buffer>>();
    public final Set<String> byReferenceClassesNames = new HashSet<String>();
    Map<String, JavaPrim> javaPrims = new TreeMap<String, JavaPrim>();
    Map<String, TypeRef> manualTypeDefs = new HashMap<String, TypeRef>();
    static Map<String, Pair<Integer, Class<?>>> buffersAndArityByType = new HashMap();
    static Map<String, Pair<Integer, Class<?>>> arraysAndArityByType = new HashMap();
    static Map<String, String> pointerFieldGetterNameRadixByType = new HashMap<String, String>();
    Pattern wstringPat = Pattern.compile("(__)?const wchar_t\\*");
    Pattern stringPat = Pattern.compile("(__)?const char\\*");
    Pattern wstringPtrPtrPat = Pattern.compile("(__)?const wchar_t\\*\\*");
    Pattern stringPtrPtrPat = Pattern.compile("(__)?const char\\*\\*");
    static Map<String, Class<?>> predefObjCClasses;
    Set<String> unknownTypes = new HashSet<String>();
    public static Set<String> JAVA_KEYWORDS;

    public TypeConversion(Result result) {
        this.result = result;
        this.initTypes();
    }

    protected void prim(String from, JavaPrim to) {
        this.javaPrims.put(from, to);
    }

    @Override
    public boolean isObjCppPrimitive(String s) {
        return this.javaPrims.containsKey(s);
    }

    public Expression typeLiteral(TypeRef c) {
        Identifier id;
        Identifier.SimpleIdentifier sid;
        if (c instanceof TypeRef.SimpleTypeRef && this.result.config.runtime == JNAeratorConfig.Runtime.BridJ && !(sid = (id = ((TypeRef.SimpleTypeRef)c).getName()).resolveLastSimpleIdentifier()).getTemplateArguments().isEmpty()) {
            Identifier erased = id.eraseTemplateArguments();
            ArrayList<Expression> exprs = new ArrayList<Expression>();
            exprs.add(this.typeLiteral(ElementsHelper.typeRef(erased.clone())));
            for (Expression t : sid.getTemplateArguments()) {
                if (!(t instanceof Expression.TypeRefExpression)) continue;
                exprs.add(this.typeLiteral(((Expression.TypeRefExpression)t).getType().clone()));
            }
            return ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(DefaultParameterizedType.class)), "paramType", exprs.toArray(new Expression[exprs.size()]));
        }
        return ElementsHelper.memberRef(ElementsHelper.expr(c), Expression.MemberRefStyle.Dot, "class");
    }

    public void initTypes() {
        this.prim("void", JavaPrim.Void);
        this.prim("UTF32Char", JavaPrim.Char);
        this.prim("unichar", JavaPrim.Char);
        this.prim("int64_t", JavaPrim.Long);
        this.prim("uint64_t", JavaPrim.Long);
        this.prim("u_int64_t", JavaPrim.Long);
        this.prim("long long", JavaPrim.Long);
        this.prim("long long int", JavaPrim.Long);
        this.prim("long int", JavaPrim.Int);
        this.prim("LONGLONG", JavaPrim.Long);
        this.prim("ULONGLONG", JavaPrim.Long);
        this.prim("DWORD64", JavaPrim.Long);
        this.prim("LONG64", JavaPrim.Long);
        this.prim("UInt64", JavaPrim.Long);
        this.prim("SInt64", JavaPrim.Long);
        this.prim("__int64", JavaPrim.Long);
        this.prim("__int64_t", JavaPrim.Long);
        this.prim("int32_t", JavaPrim.Int);
        this.prim("uint32_t", JavaPrim.Int);
        this.prim("__int32_t", JavaPrim.Int);
        this.prim("__uint32_t", JavaPrim.Int);
        this.prim("u_int32_t", JavaPrim.Int);
        this.prim("uint32", JavaPrim.Int);
        this.prim("int32", JavaPrim.Int);
        this.prim("int", JavaPrim.Int);
        this.prim("SInt32", JavaPrim.Int);
        this.prim("UInt32", JavaPrim.Int);
        this.prim("GLint", JavaPrim.Int);
        this.prim("GLuint", JavaPrim.Int);
        this.prim("GLenum", JavaPrim.Int);
        this.prim("GLsizei", JavaPrim.Int);
        this.prim("__darwin_size_t", JavaPrim.Int);
        this.prim("DWORD", JavaPrim.Int);
        this.prim("__int32", JavaPrim.Int);
        this.prim("NSInteger", JavaPrim.NSInteger);
        this.prim("NSUInteger", JavaPrim.NSUInteger);
        this.prim("CGFloat", JavaPrim.CGFloat);
        JavaPrim longPrim = this.result.config.gccLong ? JavaPrim.NativeSize : JavaPrim.NativeLong;
        this.prim("long", longPrim);
        this.prim("LONG", longPrim);
        JavaPrim sizePrim = this.result.config.sizeAsLong ? longPrim : JavaPrim.NativeSize;
        this.prim("size_t", sizePrim);
        this.prim("ptrdiff_t", sizePrim);
        this.prim("int16_t", JavaPrim.Short);
        this.prim("uint16_t", JavaPrim.Short);
        this.prim("__int16_t", JavaPrim.Short);
        this.prim("__uint16_t", JavaPrim.Short);
        this.prim("u_int16_t", JavaPrim.Short);
        this.prim("uint16", JavaPrim.Short);
        this.prim("int16", JavaPrim.Short);
        this.prim("SInt16", JavaPrim.Short);
        this.prim("UInt16", JavaPrim.Short);
        this.prim("short", JavaPrim.Short);
        this.prim("WCHAR", JavaPrim.Short);
        this.prim("wchar_t", this.result.config.wcharAsShort ? JavaPrim.Short : JavaPrim.Char);
        this.prim("WORD", JavaPrim.Short);
        this.prim("__int16", JavaPrim.Short);
        this.prim("int8_t", JavaPrim.Byte);
        this.prim("uint8_t", JavaPrim.Byte);
        this.prim("u_int8_t", JavaPrim.Byte);
        this.prim("__uint8_t", JavaPrim.Byte);
        this.prim("__int8_t", JavaPrim.Byte);
        this.prim("SInt8", JavaPrim.Byte);
        this.prim("UInt8", JavaPrim.Byte);
        this.prim("char", JavaPrim.Byte);
        this.prim("unsigned char", JavaPrim.Byte);
        this.prim("__unsigned char", JavaPrim.Byte);
        this.prim("signed char", JavaPrim.Byte);
        this.prim("__signed char", JavaPrim.Byte);
        this.prim("SignedByte", JavaPrim.Byte);
        this.prim("BYTE", JavaPrim.Byte);
        this.prim("__int8", JavaPrim.Byte);
        this.prim("float", JavaPrim.Float);
        this.prim("NSFloat", JavaPrim.Float);
        this.prim("CGFloat", JavaPrim.Float);
        this.prim("double_t", JavaPrim.Double);
        this.prim("double", JavaPrim.Double);
        this.prim("NSDouble", JavaPrim.Double);
        this.prim("CGDouble", JavaPrim.Double);
        this.prim("BOOL", JavaPrim.Boolean);
        this.prim("bool", JavaPrim.Boolean);
        this.prim("Boolean", JavaPrim.Boolean);
        this.prim("boolean_t", JavaPrim.Boolean);
        this.primToByReference.put(JavaPrim.Int, IntByReference.class);
        this.primToByReference.put(JavaPrim.Char, CharByReference.class);
        this.primToByReference.put(JavaPrim.Short, ShortByReference.class);
        this.primToByReference.put(JavaPrim.Byte, ByteByReference.class);
        this.primToByReference.put(JavaPrim.Long, LongByReference.class);
        this.primToByReference.put(JavaPrim.Float, FloatByReference.class);
        this.primToByReference.put(JavaPrim.Double, DoubleByReference.class);
        this.primToByReference.put(JavaPrim.NativeLong, NativeLongByReference.class);
        this.primToByReference.put(JavaPrim.NativeSize, NativeSizeByReference.class);
        this.primToByReference.put(JavaPrim.NSInteger, NativeSizeByReference.class);
        this.primToByReference.put(JavaPrim.NSUInteger, NativeSizeByReference.class);
        this.primToByReference.put(JavaPrim.CGFloat, CGFloatByReference.class);
        for (Class<? extends ByReference> c : this.primToByReference.values()) {
            this.byReferenceClassesNames.add(c.getName());
        }
        this.primToGlobal.put(JavaPrim.Int, GlobalInt.class);
        this.primToGlobal.put(JavaPrim.Char, GlobalChar.class);
        this.primToGlobal.put(JavaPrim.Short, GlobalShort.class);
        this.primToGlobal.put(JavaPrim.Byte, GlobalByte.class);
        this.primToGlobal.put(JavaPrim.Long, GlobalLong.class);
        this.primToGlobal.put(JavaPrim.Float, GlobalFloat.class);
        this.primToGlobal.put(JavaPrim.Double, GlobalDouble.class);
        this.primToGlobal.put(JavaPrim.NativeLong, GlobalNativeLong.class);
        this.primToGlobal.put(JavaPrim.NativeSize, GlobalNativeSize.class);
        this.primToGlobal.put(JavaPrim.NSInteger, GlobalNativeSize.class);
        this.primToGlobal.put(JavaPrim.NSUInteger, GlobalNativeSize.class);
        this.primToGlobal.put(JavaPrim.CGFloat, GlobalCGFloat.class);
        this.primToBuffer.put(JavaPrim.Int, IntBuffer.class);
        this.primToBuffer.put(JavaPrim.Char, CharBuffer.class);
        this.primToBuffer.put(JavaPrim.Short, ShortBuffer.class);
        this.primToBuffer.put(JavaPrim.Byte, ByteBuffer.class);
        this.primToBuffer.put(JavaPrim.Long, LongBuffer.class);
        this.primToBuffer.put(JavaPrim.Float, FloatBuffer.class);
        this.primToBuffer.put(JavaPrim.Double, DoubleBuffer.class);
    }

    public Pair<StoredDeclarations.TypeDef, Declarator> getTypeDef(Identifier name) {
        String rname;
        if (name == null) {
            return null;
        }
        Pair<StoredDeclarations.TypeDef, Declarator> p = this.result.typeDefs.get(name);
        if (p == null) {
            return null;
        }
        Declarator value = p.getValue();
        String string = rname = value == null ? null : value.resolveName();
        if (rname != null) {
            if (name.equals("id")) {
                return null;
            }
            if (name.equals("SEL")) {
                return null;
            }
            if (name.equals("IMP")) {
                return null;
            }
            if (name.equals("Class")) {
                return null;
            }
            if (name.equals("BOOL") && rname.equals("byte")) {
                return null;
            }
        }
        return p;
    }

    public TypeRef resolveTypeDef(TypeRef valueType, final Identifier libraryClassName, final boolean convertToJavaRef) {
        TypeRef.TaggedTypeRef ttr;
        if (valueType == null) {
            return null;
        }
        if (valueType instanceof TypeRef.TaggedTypeRef & convertToJavaRef && (ttr = (TypeRef.TaggedTypeRef)valueType).getTag() != null) {
            TypeRef.SimpleTypeRef ref;
            TypeRef.SimpleTypeRef simpleTypeRef = ttr instanceof Struct ? ElementsHelper.typeRef(this.findStructRef(ttr.getTag(), libraryClassName)) : (ref = ttr instanceof Enum ? this.findEnum(ttr.getTag(), libraryClassName) : null);
            if (ref == null) {
                return ref;
            }
        }
        TypeRef valueTypeCl = valueType.clone();
        Arg holder = new Arg();
        holder.setValueType(valueTypeCl);
        valueTypeCl.accept(new Scanner(){
            Stack<String> names = new Stack();
            int depth = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void visitSimpleTypeRef(TypeRef.SimpleTypeRef simpleTypeRef) {
                ++this.depth;
                try {
                    Identifier name = simpleTypeRef.getName();
                    if (name == null) {
                        return;
                    }
                    String nameStr = name.toString();
                    if (nameStr == null) {
                        return;
                    }
                    if (JavaPrim.getJavaPrim(nameStr) != null) {
                        return;
                    }
                    if (this.names.contains(nameStr)) {
                        return;
                    }
                    this.names.push(nameStr);
                    try {
                        Define define;
                        TypeRef.SimpleTypeRef enumRef;
                        if (TypeConversion.this.resolvesToPrimitive(nameStr)) {
                            return;
                        }
                        super.visitSimpleTypeRef(simpleTypeRef);
                        if (simpleTypeRef.isMarkedAsResolved()) {
                            return;
                        }
                        Pair<StoredDeclarations.TypeDef, Declarator> p = TypeConversion.this.getTypeDef(name);
                        if (p != null) {
                            Identifier name2;
                            TypeRef tr = p.getFirst().getValueType();
                            if (tr instanceof TypeRef.TaggedTypeRef && (name2 = TypeConversion.this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)tr)) != null) {
                                name = name2;
                            }
                            if (convertToJavaRef) {
                                if (tr instanceof TypeRef.TaggedTypeRef) {
                                    TypeRef.TaggedTypeRef s = (TypeRef.TaggedTypeRef)tr;
                                    if (s.isForwardDeclaration()) {
                                        return;
                                    }
                                    Identifier ident = TypeConversion.this.result.getTaggedTypeIdentifierInJava(s);
                                    if (ident != null) {
                                        tr = ElementsHelper.typeRef(ident);
                                    }
                                } else if (tr instanceof TypeRef.FunctionSignature) {
                                    tr = TypeConversion.this.findCallbackRef((TypeRef.FunctionSignature)tr, libraryClassName);
                                }
                            }
                            String strs = simpleTypeRef.toString();
                            String trs = tr == null ? null : tr.toString();
                            if (trs == null) return;
                            if (strs.equals(trs)) return;
                            TypeRef clo = tr.clone();
                            simpleTypeRef.replaceBy(clo);
                            if (this.depth < 30) {
                                clo.accept(this);
                                return;
                            }
                            System.err.println("Infinite loop in type conversion ? " + tr);
                            return;
                        }
                        TypeRef manualTypeRef = TypeConversion.this.manualTypeDefs.get(name);
                        if (manualTypeRef != null) {
                            if (!convertToJavaRef) {
                                return;
                            }
                            simpleTypeRef.replaceBy(manualTypeRef);
                            return;
                        }
                        TypeRef.SimpleTypeRef structRef = ElementsHelper.typeRef(TypeConversion.this.result.typeConverter.findStructRef(name, libraryClassName));
                        if (structRef != null) {
                            if (!convertToJavaRef) {
                                return;
                            }
                            simpleTypeRef.replaceBy(structRef);
                        }
                        if ((enumRef = TypeConversion.this.result.typeConverter.findEnum(name, libraryClassName)) != null) {
                            if (!convertToJavaRef) {
                                return;
                            }
                            simpleTypeRef.replaceBy(enumRef);
                        }
                        Expression expression = (define = TypeConversion.this.result.defines.get(name)) == null ? null : define.getValue();
                        if (expression == null) return;
                        if (!convertToJavaRef) {
                            return;
                        }
                        Identifier fieldName = null;
                        if (expression instanceof Expression.VariableRef) {
                            fieldName = ((Expression.VariableRef)expression).getName();
                        } else if (expression instanceof Expression.MemberRef) {
                            fieldName = ((Expression.MemberRef)expression).getName();
                        }
                        if (fieldName == null) return;
                        if (fieldName.equals(name)) return;
                        simpleTypeRef.replaceBy(TypeConversion.this.resolveTypeDef(new TypeRef.SimpleTypeRef(fieldName), libraryClassName, true));
                        return;
                    }
                    finally {
                        this.names.pop();
                    }
                }
                finally {
                    --this.depth;
                }
            }
        });
        TypeRef tr = holder.getValueType();
        return tr;
    }

    public boolean resolvesToPrimitive(String name) {
        return this.javaPrims.containsKey(name);
    }

    public JavaPrim getPrimitive(TypeRef valueType, Identifier libraryClassName) {
        if ((valueType = this.resolveTypeDef(valueType, libraryClassName, true)) == null) {
            return null;
        }
        Identifier name = null;
        List<Modifier> mods = valueType.getModifiers();
        int longCount = Modifier.Long.countIn(mods);
        if (valueType instanceof JavaPrimitive) {
            return ((JavaPrimitive)valueType).getJavaPrim();
        }
        if (valueType instanceof TypeRef.Primitive) {
            name = ((TypeRef.Primitive)valueType).getName();
            if (name == null) {
                name = longCount == 1 ? ElementsHelper.ident("long") : (longCount > 1 ? ElementsHelper.ident("long long") : (Modifier.Short.isContainedBy(mods) ? ElementsHelper.ident("short") : ElementsHelper.ident("int")));
            }
        } else if (valueType instanceof TypeRef.SimpleTypeRef) {
            name = ((TypeRef.SimpleTypeRef)valueType).getName();
        }
        if (name == null) {
            return null;
        }
        JavaPrim p = JavaPrim.getJavaPrim(name.toString());
        if (p != null && !p.isPrimitive) {
            return p;
        }
        boolean isLong = false;
        isLong = valueType.getModifiers().contains("long");
        String str = isLong || valueType.getModifiers().contains("short") ? (isLong ? "long " : "short ") + name : name.toString();
        JavaPrim type = this.javaPrims.get(str);
        if (type == JavaPrim.Int && longCount > 1) {
            return JavaPrim.Long;
        }
        return type;
    }

    public Identifier findStructRef(Identifier name, Identifier libraryClassName) {
        return this.findStructRef(this.result.structsByName.get(name), name, libraryClassName);
    }

    public Identifier findStructRef(Struct s, Identifier name, Identifier libraryClassName) {
        if (s == null || s.isForwardDeclaration()) {
            Pair<StoredDeclarations.TypeDef, Declarator> pair = this.getTypeDef(name);
            if (pair == null) {
                return null;
            }
            if (pair.getFirst() == null || pair.getSecond() == null) {
                return null;
            }
            Declarator.MutableByDeclarator td = pair.getSecond().mutateType(pair.getFirst().getValueType());
            if (!(td instanceof Struct)) {
                return null;
            }
            s = (Struct)td;
            name = this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)pair.getFirst().getValueType());
            return this.findRef(name, s, libraryClassName, !this.result.config.putTopStructsInSeparateFiles);
        }
        return this.result.getTaggedTypeIdentifierInJava(s);
    }

    public Identifier findStructRef(Struct s, Identifier libraryClassName) {
        switch (s.getType()) {
            case ObjCClass: 
            case ObjCProtocol: {
                return this.result.objectiveCGenerator.getFullClassName(s);
            }
        }
        return this.findStructRef(s, this.result.declarationsConverter.getActualTaggedTypeName(s), libraryClassName);
    }

    public Identifier libMember(Identifier libClass, Identifier libraryClassName, Identifier member) {
        return ElementsHelper.ident(libClass, member);
    }

    public Identifier findRef(Identifier name, Element e, Identifier libraryClassName, boolean inLibClass) {
        Struct parentStruct;
        if (e == null || !name.isPlain()) {
            return null;
        }
        String library = this.result.getLibrary(e);
        if (library == null) {
            return null;
        }
        Struct struct = parentStruct = e instanceof Struct ? (Struct)e : e.findParentOfType(Struct.class);
        if (!inLibClass && parentStruct != null) {
            if (parentStruct == e) {
                return ElementsHelper.ident(this.result.getLibraryPackage(library), name);
            }
            return ElementsHelper.ident(this.result.getTaggedTypeIdentifierInJava(parentStruct), name);
        }
        return this.libMember(this.result.getLibraryClassFullName(library), libraryClassName, name);
    }

    public TypeRef.SimpleTypeRef findEnum(Identifier name, Identifier libraryClassName) {
        Enum s = this.result.enumsByName.get(name);
        if (s == null) {
            return null;
        }
        return this.findEnumRef(s, libraryClassName);
    }

    public TypeRef.SimpleTypeRef findEnumRef(Enum s, Identifier libraryClassName) {
        if (this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
            return ElementsHelper.typeRef(this.result.getTaggedTypeIdentifierInJava(s));
        }
        Identifier name = this.result.declarationsConverter.getActualTaggedTypeName(s);
        String library = this.result.getLibrary(s);
        if (library == null) {
            return null;
        }
        Identifier libClass = this.result.getLibraryClassFullName(library);
        TypeRef.SimpleTypeRef tr = new TypeRef.SimpleTypeRef("int");
        if (this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.EnumTypeLocationComments)) {
            tr.setCommentBefore("@see " + (SyntaxUtils.equal(libClass, libraryClassName) ? name : libClass + "#" + name));
        }
        return tr;
    }

    public static Expression javaStaticFieldRef(Identifier javaClass, Identifier fieldName) {
        return ElementsHelper.memberRef(ElementsHelper.expr(ElementsHelper.typeRef(javaClass)), Expression.MemberRefStyle.Dot, fieldName);
    }

    public Expression findDefine(Identifier name) {
        Define s = this.result.defines.get(name);
        String library = s == null ? null : this.result.getLibrary(s);
        return library == null ? null : TypeConversion.javaStaticFieldRef(this.result.getLibraryClassFullName(library), name);
    }

    public Identifier inferCallBackName(TypeRef.FunctionSignature functionSignature, boolean prependNamespaces, boolean qualify, Identifier libraryClassName) {
        String library;
        ArrayList<String> nameElements = new ArrayList<String>();
        Identifier name = functionSignature.getFunction().getName();
        if (name != null) {
            name = name.clone();
        }
        Identifier parentIdent = null;
        boolean firstParent = true;
        for (Element parent = functionSignature.getParentElement(); parent != null; parent = parent.getParentElement()) {
            if (parent instanceof Struct) {
                parentIdent = this.findStructRef((Struct)parent, null);
                break;
            }
            if (firstParent) {
                if (name == null && parent instanceof StoredDeclarations.TypeDef) {
                    Declarator simpleSto = null;
                    for (Declarator sto : ((StoredDeclarations.TypeDef)parent).getDeclarators()) {
                        String stoName = sto.resolveName();
                        if (stoName == null) continue;
                        if (!(sto instanceof Declarator.ArrayDeclarator)) {
                            boolean weirdName;
                            boolean bl = weirdName = stoName.startsWith("_") || stoName.endsWith("_");
                            if (simpleSto == null || (simpleSto.resolveName().startsWith("_") || simpleSto.resolveName().endsWith("_")) && !weirdName) {
                                simpleSto = sto;
                            }
                            if (!weirdName) break;
                        }
                        if (stoName == null) continue;
                        name = new Identifier.SimpleIdentifier(stoName, new Expression[0]);
                    }
                } else if (name == null && parent instanceof Arg) {
                    Arg arg = (Arg)parent;
                    Function f = SyntaxUtils.as(arg.getParentElement(), Function.class);
                    if (f != null) {
                        name = new Identifier.SimpleIdentifier(f.getName() + "_" + arg.getName(), new Expression[0]);
                        break;
                    }
                } else if (firstParent) {
                    // empty if block
                }
            }
            firstParent = false;
        }
        if (qualify && parentIdent == null && (library = this.result.getLibrary(functionSignature)) != null) {
            parentIdent = this.result.getLibraryClassFullName(library);
        }
        if (prependNamespaces) {
            if (name == null) {
                name = new Identifier.SimpleIdentifier("callback", new Expression[0]);
            }
            nameElements.add(name.toString());
            return ElementsHelper.ident(qualify ? parentIdent : null, StringUtils.implode(nameElements, (Object)"_"));
        }
        return ElementsHelper.ident(qualify ? parentIdent : null, name);
    }

    public TypeRef findCallbackRef(Identifier name, Identifier libraryClassName) {
        TypeRef.FunctionSignature s = this.result.callbacksByName.get(name);
        if (s == null) {
            return null;
        }
        return this.findCallbackRef(s, libraryClassName);
    }

    public TypeRef findCallbackRef(TypeRef.FunctionSignature s, Identifier callerLibraryClass) {
        String library = this.result.getLibrary(s);
        if (library == null) {
            return null;
        }
        return ElementsHelper.typeRef(this.inferCallBackName(s, true, true, callerLibraryClass));
    }

    static TypeRef primRef(JavaPrim p) {
        if (p == null) {
            return null;
        }
        return new JavaPrimitive(p);
    }

    boolean isResolved(TypeRef.SimpleTypeRef tr) {
        return tr != null && (tr.isMarkedAsResolved() || this.isResolved(tr.getName()));
    }

    boolean isResolved(Identifier i) {
        if (i == null || i.isPlain()) {
            return false;
        }
        return i instanceof Identifier.QualifiedIdentifier && Identifier.QualificationSeparator.Dot.equals((Object)((Identifier.QualifiedIdentifier)i).getSeparator());
    }

    public NL4JConversion convertTypeToNL4J(TypeRef valueType, Identifier libraryClassName, Expression structIOExpr, Expression valueExpr, int fieldIndex, int bits) throws UnsupportedConversionException {
        TypeRef original;
        block30: {
            Identifier valueName;
            original = valueType;
            valueType = this.resolveTypeDef(valueType, libraryClassName, true);
            NL4JConversion conv = new NL4JConversion();
            if (valueType == null) {
                conv.type = ConvType.Void;
                conv.typeRef = TypeConversion.primRef(JavaPrim.Void);
                return conv;
            }
            if (valueType instanceof TypeRef.TargettedTypeRef) {
                TypeRef targetRef = ((TypeRef.TargettedTypeRef)valueType).getTarget();
                if (valueType instanceof TypeRef.ArrayRef) {
                    TypeRef.ArrayRef arrayRef = (TypeRef.ArrayRef)valueType;
                    ArrayList<Expression> sizes = new ArrayList<Expression>();
                    for (Expression dim : arrayRef.flattenDimensions()) {
                        if (dim == null || dim instanceof Expression.EmptyArraySize) continue;
                        Expression m = this.result.typeConverter.convertExpressionToJava(dim, libraryClassName, false).getFirst();
                        m.setParenthesis(false);
                        sizes.add(m);
                    }
                    if (!sizes.isEmpty()) {
                        conv.arrayLengths = sizes;
                    }
                }
                try {
                    NL4JConversion targetConv = this.convertTypeToNL4J(targetRef, libraryClassName, null, null, -1, -1);
                    TypeRef pointedTypeRef = targetConv.getIndirectTypeRef();
                    if (targetConv.type != ConvType.Void) {
                        if (targetConv.type == ConvType.NativeSize) {
                            pointedTypeRef = ElementsHelper.typeRef(SizeT.class);
                        } else if (targetConv.type == ConvType.NativeLong) {
                            pointedTypeRef = ElementsHelper.typeRef(CLong.class);
                        }
                    }
                    if (pointedTypeRef != null) {
                        conv.typeRef = ElementsHelper.typeRef(ElementsHelper.ident(this.result.config.runtime.pointerClass, ElementsHelper.expr(pointedTypeRef.clone())));
                        if (structIOExpr != null) {
                            if (conv.arrayLengths == null) {
                                conv.setExpr = ElementsHelper.methodCall(structIOExpr.clone(), "setPointerField", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex), valueExpr);
                            }
                            conv.getExpr = ElementsHelper.methodCall(structIOExpr.clone(), "getPointerField", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex));
                        }
                        return conv;
                    }
                    break block30;
                }
                catch (UnsupportedConversionException ex) {
                    if (valueType instanceof TypeRef.Pointer && targetRef instanceof TypeRef.SimpleTypeRef && this.allowFakePointers) {
                        conv.typeRef = ElementsHelper.typeRef(this.result.getFakePointer(libraryClassName, ((TypeRef.SimpleTypeRef)targetRef).getName().clone()));
                        if (structIOExpr != null) {
                            if (conv.arrayLengths == null) {
                                conv.setExpr = ElementsHelper.methodCall(structIOExpr.clone(), "setPointerField", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex), valueExpr);
                            }
                            conv.getExpr = ElementsHelper.methodCall(structIOExpr.clone(), "getTypedPointerField", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex));
                        }
                        return conv;
                    }
                    break block30;
                }
            }
            JavaPrim prim = this.getPrimitive(valueType, libraryClassName);
            if (prim != null) {
                String radix;
                switch (prim) {
                    case NativeLong: {
                        conv.type = ConvType.NativeLong;
                        conv.typeRef = ElementsHelper.typeRef(Long.TYPE);
                        conv.indirectType = ElementsHelper.typeRef(org.bridj.CLong.class);
                        radix = "CLong";
                        break;
                    }
                    case NativeSize: {
                        conv.type = ConvType.NativeSize;
                        conv.typeRef = ElementsHelper.typeRef(Long.TYPE);
                        conv.indirectType = ElementsHelper.typeRef(SizeT.class);
                        radix = "SizeT";
                        break;
                    }
                    case Void: {
                        conv.type = ConvType.Void;
                        conv.typeRef = TypeConversion.primRef(prim);
                        radix = null;
                        break;
                    }
                    default: {
                        conv.type = ConvType.Primitive;
                        conv.typeRef = TypeConversion.primRef(prim);
                        conv.indirectType = ElementsHelper.typeRef(prim.wrapperType);
                        radix = StringUtils.capitalize(prim.type.getName());
                    }
                }
                if (structIOExpr != null && radix != null) {
                    conv.setExpr = ElementsHelper.methodCall(structIOExpr.clone(), "set" + radix + "Field", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex), valueExpr);
                    conv.getExpr = ElementsHelper.methodCall(structIOExpr.clone(), "get" + radix + "Field", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex));
                }
                return conv;
            }
            Identifier identifier = valueName = valueType instanceof TypeRef.SimpleTypeRef ? ((TypeRef.SimpleTypeRef)valueType).getName() : null;
            if ((this.result.structsFullNames.contains(valueName) ? valueType : (conv.typeRef = ElementsHelper.typeRef(valueType instanceof Struct ? this.findStructRef((Struct)valueType, libraryClassName) : this.findStructRef(valueName, libraryClassName)))) != null) {
                if (structIOExpr != null) {
                    conv.getExpr = ElementsHelper.methodCall(structIOExpr, "getNativeObjectField", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex));
                }
                conv.type = ConvType.Struct;
                return conv;
            }
            if ((this.result.enumsFullNames.contains(valueName) ? valueType : (conv.typeRef = valueType instanceof Enum ? this.findEnumRef((Enum)valueType, libraryClassName) : this.findEnum(valueName, libraryClassName))) != null) {
                if (structIOExpr != null) {
                    conv.setExpr = ElementsHelper.methodCall(structIOExpr, "setEnumField", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex), valueExpr);
                    conv.getExpr = ElementsHelper.methodCall(structIOExpr, "getEnumField", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex));
                }
                conv.type = ConvType.Enum;
                conv.typeRef = ElementsHelper.typeRef(ElementsHelper.ident(ValuedEnum.class, ElementsHelper.expr(conv.typeRef)));
                return conv;
            }
            if ((this.result.callbacksFullNames.contains(valueName) ? valueType : (conv.typeRef = valueType instanceof TypeRef.FunctionSignature ? this.findCallbackRef((TypeRef.FunctionSignature)valueType, libraryClassName) : this.findCallbackRef(valueName, libraryClassName))) != null) {
                if (structIOExpr != null) {
                    conv.setExpr = ElementsHelper.methodCall(structIOExpr.clone(), "setPointerField", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex), valueExpr);
                    conv.getExpr = ElementsHelper.methodCall(structIOExpr.clone(), "getPointerField", ElementsHelper.thisRef(), ElementsHelper.expr(fieldIndex));
                }
                conv.type = ConvType.Pointer;
                conv.typeRef = ElementsHelper.typeRef(ElementsHelper.ident(this.result.config.runtime.pointerClass, ElementsHelper.expr(conv.typeRef)));
                return conv;
            }
        }
        throw new UnsupportedConversionException(original, "Unsupported type");
    }

    Pair<TypeRef, List<Annotation>> toRawNL4JType(TypeRef nl4jType) throws UnsupportedConversionException {
        if (!(nl4jType instanceof TypeRef.SimpleTypeRef)) {
            throw new UnsupportedConversionException(nl4jType, "Not a known type : " + nl4jType);
        }
        Pair<TypeRef, List<Annotation>> ret = new Pair<TypeRef, List<Annotation>>(nl4jType.clone(), Collections.EMPTY_LIST);
        if (nl4jType instanceof TypeRef.Primitive) {
            return ret;
        }
        TypeRef.SimpleTypeRef str = (TypeRef.SimpleTypeRef)nl4jType;
        Identifier strn = str.getName();
        if (strn.equals(this.result.config.runtime.pointerClass.getName())) {
            ret.setSecond(Arrays.asList(new Annotation(Ptr.class, new Expression[0])));
            ret.setFirst(ElementsHelper.typeRef(JavaPrim.Long.type));
        } else if (strn.equals(ValuedEnum.class.getName())) {
            ret.setFirst(ElementsHelper.typeRef(JavaPrim.Int.type));
        } else {
            throw new UnsupportedConversionException(nl4jType, "No raw conversion available yet for type " + nl4jType);
        }
        return ret;
    }

    public Expression getFlatArraySizeExpression(TypeRef.ArrayRef arrayRef, Identifier callerLibraryName) throws UnsupportedConversionException {
        Expression mul = null;
        List<Expression> dims = arrayRef.flattenDimensions();
        int i = dims.size();
        while (i-- != 0) {
            Expression x = dims.get(i);
            if (x == null || x instanceof Expression.EmptyArraySize) {
                return null;
            }
            Pair<Expression, TypeRef> c = this.result.typeConverter.convertExpressionToJava(x, callerLibraryName, false);
            c.getFirst().setParenthesis(dims.size() > 1);
            if (mul == null) {
                mul = c.getFirst();
                continue;
            }
            mul = ElementsHelper.expr(c.getFirst(), Expression.BinaryOperator.Multiply, mul);
        }
        return mul;
    }

    protected boolean isString(String typeRefAsString, boolean wide) {
        if (wide) {
            return this.wstringPat.matcher(typeRefAsString).matches() || this.result.config.charPtrAsString && typeRefAsString.equals("wchar_t*");
        }
        return this.stringPat.matcher(typeRefAsString).matches() || this.result.config.charPtrAsString && typeRefAsString.equals("char*");
    }

    protected boolean isStringPtrPtr(String typeRefAsString, boolean wide) {
        if (wide) {
            return this.wstringPtrPtrPat.matcher(typeRefAsString).matches() || this.result.config.charPtrAsString && typeRefAsString.equals("wchar_t**");
        }
        return this.stringPtrPtrPat.matcher(typeRefAsString).matches() || this.result.config.charPtrAsString && typeRefAsString.equals("char**");
    }

    public TypeRef convertTypeToJNA(TypeRef valueType, TypeConversionMode conversionMode, Identifier libraryClassName) throws UnsupportedConversionException {
        Identifier name;
        JavaPrim prim;
        block83: {
            JavaPrim prim2;
            TypeRef convArgType;
            boolean staticallySized;
            TypeRef target;
            block85: {
                block86: {
                    Identifier name2;
                    block87: {
                        Identifier structRef;
                        TypeRef original;
                        block84: {
                            original = valueType;
                            String valueTypeString = String.valueOf(valueType = this.resolveTypeDef(valueType, libraryClassName, true));
                            if (valueTypeString.matches("void\\s*\\*") || valueTypeString.matches("const\\s*void\\s*\\*")) {
                                TypeRef.Pointer p;
                                if (original instanceof TypeRef.Pointer && this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.TypedPointersForForwardDeclarations) && this.allowFakePointers && (p = (TypeRef.Pointer)original).getTarget() instanceof TypeRef.SimpleTypeRef) {
                                    if (this.isResolved((TypeRef.SimpleTypeRef)p.getTarget())) {
                                        return p.getTarget();
                                    }
                                    Identifier name3 = ((TypeRef.SimpleTypeRef)p.getTarget()).getName();
                                    if (!"void".equals(name3.toString()) && name3.isPlain()) {
                                        return ElementsHelper.typeRef(this.result.getFakePointer(libraryClassName, name3));
                                    }
                                }
                            } else if (conversionMode == TypeConversionMode.ReturnType && this.result.config.stringifyConstCStringReturnValues) {
                                if (this.isString(valueTypeString, false)) {
                                    return ElementsHelper.typeRef(String.class);
                                }
                                if (this.isString(valueTypeString, true)) {
                                    return ElementsHelper.typeRef(WString.class);
                                }
                            } else if (conversionMode == TypeConversionMode.PrimitiveOrBufferParameter) {
                                if (this.isString(valueTypeString, false)) {
                                    return ElementsHelper.typeRef(String.class);
                                }
                                if (this.isString(valueTypeString, true)) {
                                    return ElementsHelper.typeRef(WString.class);
                                }
                                if (this.isStringPtrPtr(valueTypeString, false)) {
                                    return this.arrayRef(ElementsHelper.typeRef(String.class));
                                }
                                if (this.isStringPtrPtr(valueTypeString, true)) {
                                    return this.arrayRef(ElementsHelper.typeRef(WString.class));
                                }
                            }
                            if (valueType instanceof TypeRef.Primitive && (prim = this.getPrimitive(valueType, libraryClassName)) != null) {
                                return TypeConversion.primRef(prim);
                            }
                            if (valueType instanceof TypeRef.TaggedTypeRef && (name = this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)valueType)) != null) {
                                Element tr;
                                if (valueType instanceof Enum) {
                                    tr = this.findEnum(name, libraryClassName);
                                    if (tr != null) {
                                        TypeRef intRef = TypeConversion.primRef(JavaPrim.Int);
                                        intRef.setCommentBefore(tr.getCommentBefore());
                                        return intRef;
                                    }
                                } else if (valueType instanceof Struct && (tr = this.findStructRef(name, libraryClassName)) != null) {
                                    switch (conversionMode) {
                                        case PointedValue: 
                                        case NativeParameterWithStructsPtrPtrs: 
                                        case NativeParameter: 
                                        case PrimitiveOrBufferParameter: 
                                        case ReturnType: 
                                        case PrimitiveReturnType: 
                                        case FieldType: {
                                            return ElementsHelper.typeRef((Identifier)tr);
                                        }
                                    }
                                    return ElementsHelper.typeRef(ElementsHelper.ident((Identifier)tr, ElementsHelper.ident("ByValue")));
                                }
                            }
                            if (valueType instanceof TypeRef.FunctionSignature) {
                                TypeRef tr = this.findCallbackRef((TypeRef.FunctionSignature)valueType, libraryClassName);
                                if (tr != null) {
                                    return tr;
                                }
                                return ElementsHelper.typeRef(((TypeRef.FunctionSignature)valueType).getFunction().getName().clone());
                            }
                            if (!(valueType instanceof TypeRef.TargettedTypeRef)) break block83;
                            target = ((TypeRef.TargettedTypeRef)valueType).getTarget();
                            staticallySized = valueType instanceof TypeRef.ArrayRef && ((TypeRef.ArrayRef)valueType).hasStaticStorageSize();
                            convArgType = null;
                            prim2 = this.getPrimitive(target, libraryClassName);
                            if (prim2 == null) break block84;
                            if (prim2 == JavaPrim.Void) {
                                return ElementsHelper.typeRef(this.result.config.runtime.pointerClass);
                            }
                            convArgType = TypeConversion.primRef(prim2);
                            break block85;
                        }
                        name2 = null;
                        if (target instanceof TypeRef.SimpleTypeRef) {
                            name2 = ((TypeRef.SimpleTypeRef)target).getName();
                        } else if (target instanceof Struct) {
                            Struct struct = (Struct)target;
                            if (struct == null) {
                                valueType = this.resolveTypeDef(original, libraryClassName, true);
                                struct = null;
                            } else {
                                name2 = this.result.declarationsConverter.getActualTaggedTypeName(struct);
                            }
                        } else if (target instanceof TypeRef.FunctionSignature) {
                            TypeRef tr = this.findCallbackRef((TypeRef.FunctionSignature)target, libraryClassName);
                            if (tr != null) {
                                if (valueType instanceof TypeRef.ArrayRef) {
                                    return new TypeRef.ArrayRef(tr, new Expression[0]);
                                }
                                return tr;
                            }
                        } else if (target instanceof TypeRef.Pointer) {
                            if (conversionMode == TypeConversionMode.NativeParameter) {
                                return ElementsHelper.typeRef(PointerByReference.class);
                            }
                            TypeRef.Pointer pt = (TypeRef.Pointer)target;
                            TypeRef ptarget = pt.getTarget();
                            if (ptarget instanceof TypeRef.SimpleTypeRef) {
                                TypeRef.SimpleTypeRef ptargett = (TypeRef.SimpleTypeRef)ptarget;
                                Identifier tname = ptargett.getName();
                                if (this.result.structsFullNames.contains(tname)) {
                                    if (conversionMode == TypeConversionMode.FieldType) {
                                        return ElementsHelper.typeRef(PointerByReference.class);
                                    }
                                    return new TypeRef.ArrayRef((TypeRef)ElementsHelper.typeRef(ElementsHelper.ident(ptargett.getName(), "ByReference")), new Expression[0]);
                                }
                                if ((tname = this.result.findFakePointer(tname)) != null) {
                                    return new TypeRef.ArrayRef((TypeRef)ElementsHelper.typeRef(tname.clone()), new Expression[0]);
                                }
                            }
                        }
                        if (name2 == null) break block86;
                        convArgType = this.findObjCClass(name2);
                        boolean isQualStruct = this.result.structsFullNames.contains(name2);
                        if (convArgType != null && !isQualStruct) break block85;
                        Identifier identifier = structRef = isQualStruct ? name2 : this.findStructRef(name2, libraryClassName);
                        if (structRef == null) break block87;
                        switch (conversionMode) {
                            case FieldType: 
                            case ExpressionType: {
                                TypeRef typeRef = convArgType = valueType instanceof TypeRef.ArrayRef ? ElementsHelper.typeRef(structRef) : ElementsHelper.typeRef(ElementsHelper.ident(structRef, ElementsHelper.ident("ByReference")));
                                if (valueType instanceof TypeRef.Pointer) {
                                    return convArgType;
                                }
                                break block85;
                            }
                            default: {
                                if (isQualStruct && valueType instanceof TypeRef.ArrayRef && (conversionMode == TypeConversionMode.NativeParameterWithStructsPtrPtrs || conversionMode == TypeConversionMode.PrimitiveOrBufferParameter)) {
                                    return this.arrayRef(ElementsHelper.typeRef(structRef));
                                }
                                convArgType = ElementsHelper.typeRef(structRef);
                                if (valueType instanceof TypeRef.Pointer) {
                                    return convArgType;
                                }
                                break block85;
                            }
                        }
                    }
                    try {
                        convArgType = this.convertTypeToJNA(target, conversionMode, libraryClassName);
                        if (convArgType != null && this.result.callbacksFullNames.contains(ElementsHelper.ident(convArgType.toString())) && !(valueType instanceof TypeRef.ArrayRef)) {
                            TypeRef tr = ElementsHelper.typeRef(this.result.config.runtime.pointerClass);
                            if (!this.result.config.noComments) {
                                tr.setCommentBefore("@see " + convArgType);
                            }
                            return tr;
                        }
                        prim2 = this.getPrimitive(convArgType, libraryClassName);
                    }
                    catch (UnsupportedConversionException ex) {
                        if (valueType instanceof TypeRef.Pointer && target instanceof TypeRef.SimpleTypeRef && this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.TypedPointersForForwardDeclarations) && this.allowFakePointers) {
                            if (this.isResolved((TypeRef.SimpleTypeRef)target)) {
                                return target;
                            }
                            return ElementsHelper.typeRef(this.result.getFakePointer(libraryClassName, name2));
                        }
                        return ElementsHelper.typeRef(this.result.config.runtime.pointerClass);
                    }
                }
                try {
                    convArgType = this.convertTypeToJNA(target, conversionMode, libraryClassName);
                    prim2 = this.getPrimitive(convArgType, libraryClassName);
                }
                catch (UnsupportedConversionException ex) {
                    return ElementsHelper.typeRef(this.result.config.runtime.pointerClass);
                }
            }
            switch (conversionMode) {
                case StaticallySizedArrayField: {
                    return new TypeRef.ArrayRef(convArgType, new Expression[0]);
                }
                case PrimitiveOrBufferParameter: {
                    if (!this.result.config.noPrimitiveArrays && (target.getModifiers().contains((Object)Modifier.Const) || valueType.getModifiers().contains((Object)Modifier.Const))) {
                        return new TypeRef.ArrayRef(convArgType, new Expression[0]);
                    }
                    Class<? extends Buffer> bc = this.primToBuffer.get((Object)prim2);
                    if (bc != null) {
                        return ElementsHelper.typeRef(bc);
                    }
                }
                case ReturnType: 
                case FieldType: {
                    if (!staticallySized) break;
                    return this.arrayRef(convArgType);
                }
            }
            if (prim2 != null) {
                if (prim2 == JavaPrim.Byte) {
                    return ElementsHelper.typeRef(this.result.config.runtime.pointerClass).importDetails(convArgType, false);
                }
                Class<? extends ByReference> byRefClass = this.primToByReference.get((Object)prim2);
                if (byRefClass != null) {
                    return ElementsHelper.typeRef(byRefClass).importDetails(convArgType, false);
                }
            }
            if (convArgType != null && !convArgType.toString().equals(this.result.config.runtime.pointerClass.getName()) && valueType instanceof TypeRef.Pointer && target instanceof TypeRef.SimpleTypeRef) {
                return convArgType;
            }
            if (target instanceof TypeRef.Pointer) {
                return ElementsHelper.typeRef(PointerByReference.class);
            }
            if (this.allowUnknownPointers) {
                return ElementsHelper.typeRef(this.result.config.runtime.pointerClass);
            }
        }
        if (valueType instanceof TypeRef.SimpleTypeRef) {
            Identifier structRef;
            name = ((TypeRef.SimpleTypeRef)valueType).getName();
            if (name == null) {
                throw new UnsupportedConversionException(valueType, null);
            }
            boolean isQualStruct = this.result.structsFullNames.contains(name);
            if (!isQualStruct && this.isResolved((TypeRef.SimpleTypeRef)valueType)) {
                return valueType;
            }
            if (name instanceof Identifier.SimpleIdentifier) {
                TypeRef tr = this.findObjCClass(name);
                if (tr == null) {
                    tr = this.findObjCClass(new Identifier.SimpleIdentifier(((Identifier.SimpleIdentifier)name).getName(), new Expression[0]));
                }
                if (tr != null) {
                    return tr;
                }
            }
            Identifier identifier = structRef = isQualStruct ? name : this.findStructRef(name, libraryClassName);
            if (structRef != null) {
                switch (conversionMode) {
                    case PointedValue: 
                    case FieldType: {
                        return ElementsHelper.typeRef(structRef);
                    }
                }
                return ElementsHelper.typeRef(ElementsHelper.ident(structRef, "ByValue"));
            }
            TypeRef callbackRef = this.findCallbackRef(name, libraryClassName);
            if (callbackRef != null) {
                return callbackRef;
            }
            TypeRef.SimpleTypeRef enumTypeRef = this.findEnum(name, libraryClassName);
            if (enumTypeRef != null) {
                return enumTypeRef;
            }
            TypeRef objCClassRef = this.findObjCClass(name);
            if (objCClassRef != null) {
                return objCClassRef;
            }
        }
        if ((prim = this.getPrimitive(valueType, libraryClassName)) != null) {
            return TypeConversion.primRef(prim);
        }
        this.unknownTypes.add(String.valueOf(valueType));
        throw new UnsupportedConversionException(valueType, null);
    }

    public Identifier findObjCClassIdent(Identifier name) {
        Class<?> class1;
        Identifier.SimpleIdentifier sname;
        String n;
        if (name instanceof Identifier.SimpleIdentifier && (n = (sname = (Identifier.SimpleIdentifier)name).getName()).equals("id") && sname.getTemplateArguments().size() == 1) {
            TypeRef.SimpleTypeRef str;
            Expression x = sname.getTemplateArguments().get(0);
            Expression.TypeRefExpression trx = x instanceof Expression.TypeRefExpression ? (Expression.TypeRefExpression)x : null;
            TypeRef.SimpleTypeRef simpleTypeRef = str = trx.getType() instanceof TypeRef.SimpleTypeRef ? (TypeRef.SimpleTypeRef)trx.getType() : null;
            if (str != null) {
                name = str.getName();
            }
        }
        if ((class1 = predefObjCClasses.get(name.toString())) != null) {
            return ElementsHelper.ident(class1, new Expression[0]);
        }
        Struct s = this.result.getObjcCClassOrProtocol(name);
        if (s != null) {
            return this.result.objectiveCGenerator.getFullClassName(s);
        }
        return null;
    }

    public TypeRef findObjCClass(Identifier name) {
        return ElementsHelper.typeRef(this.findObjCClassIdent(name));
    }

    private TypeRef arrayRef(TypeRef tr) {
        TypeRef.ArrayRef arrayRef;
        if (tr instanceof TypeRef.ArrayRef) {
            arrayRef = (TypeRef.ArrayRef)tr;
            arrayRef.addDimension(new Expression.EmptyArraySize());
        } else {
            arrayRef = new TypeRef.ArrayRef(tr, new Expression[0]);
        }
        return arrayRef;
    }

    public static <A, B> Pair<A, B> pair(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    public static Pair<Expression, TypeRef> typed(Expression a, TypeRef b) {
        return new Pair<Expression, TypeRef>(a, b);
    }

    public Pair<Expression, TypeRef> convertExpressionToJava(Expression x, Identifier libraryClassName, boolean promoteNativeLongToLong) throws UnsupportedConversionException {
        Expression.TypeRefExpression typeEx;
        Expression.FunctionCall fc;
        Pair<Expression, TypeRef> res = null;
        if (x instanceof Expression.AssignmentOp) {
            Pair<Expression, TypeRef> convTarget = this.convertExpressionToJava(((Expression.AssignmentOp)x).getTarget(), libraryClassName, promoteNativeLongToLong);
            Pair<Expression, TypeRef> convValue = this.convertExpressionToJava(((Expression.AssignmentOp)x).getValue(), libraryClassName, promoteNativeLongToLong);
            res = TypeConversion.typed(ElementsHelper.expr(convTarget.getFirst(), Expression.AssignmentOperator.Equal, convValue.getFirst()), convTarget.getSecond());
        } else if (x instanceof Expression.BinaryOp) {
            Expression.BinaryOp bop = (Expression.BinaryOp)x;
            Pair<Expression, TypeRef> conv1 = this.convertExpressionToJava(bop.getFirstOperand(), libraryClassName, promoteNativeLongToLong);
            Pair<Expression, TypeRef> conv2 = this.convertExpressionToJava(bop.getSecondOperand(), libraryClassName, promoteNativeLongToLong);
            if (conv1 != null && conv2 != null) {
                TypeRef t1 = conv1.getSecond();
                TypeRef t2 = conv2.getSecond();
                Expression x1 = conv1.getFirst();
                Expression x2 = conv2.getFirst();
                String s1 = String.valueOf(t1);
                String s2 = String.valueOf(t2);
                TypeRef tr = null;
                if (s1.equals(s2)) {
                    tr = t1;
                } else {
                    JavaPrim p1 = this.getPrimitive(t1, null);
                    JavaPrim p2 = this.getPrimitive(t2, null);
                    if (p1 != null && p2 != null) {
                        block0 : switch (bop.getOperator()) {
                            case LeftShift: 
                            case RightShift: 
                            case SignedRightShift: {
                                tr = t1;
                                break;
                            }
                            default: {
                                for (JavaPrim p : new JavaPrim[]{JavaPrim.Double, JavaPrim.Float, JavaPrim.Long, JavaPrim.NativeSize, JavaPrim.NativeLong, JavaPrim.Int, JavaPrim.Short, JavaPrim.Byte}) {
                                    if (p1 != p && p2 != p) continue;
                                    if (promoteNativeLongToLong && (p == JavaPrim.NativeLong || p == JavaPrim.NativeSize)) {
                                        p = JavaPrim.Long;
                                    }
                                    tr = TypeConversion.primRef(p);
                                    break block0;
                                }
                            }
                        }
                    }
                }
                res = TypeConversion.typed(ElementsHelper.expr(x1, ((Expression.BinaryOp)x).getOperator(), x2), tr);
            }
        } else if (x instanceof Expression.UnaryOp) {
            Expression.UnaryOperator op = ((Expression.UnaryOp)x).getOperator();
            if (op == Expression.UnaryOperator.Not) {
                throw new UnsupportedConversionException(x, null);
            }
            Pair<Expression, TypeRef> conv = this.convertExpressionToJava(((Expression.UnaryOp)x).getOperand(), libraryClassName, promoteNativeLongToLong);
            res = TypeConversion.typed(ElementsHelper.expr(op, conv.getFirst()), conv.getSecond());
        } else if (x instanceof Expression.Cast) {
            TypeRef tr = this.convertTypeToJNA(((Expression.Cast)x).getType(), TypeConversionMode.ExpressionType, libraryClassName);
            JavaPrim prim = this.getPrimitive(tr, libraryClassName);
            if (promoteNativeLongToLong && (prim == JavaPrim.NativeLong || prim == JavaPrim.NativeSize)) {
                prim = JavaPrim.Long;
                tr = ElementsHelper.typeRef(Long.TYPE);
            }
            Pair<Expression, TypeRef> casted = this.convertExpressionToJava(((Expression.Cast)x).getTarget(), libraryClassName, promoteNativeLongToLong);
            res = TypeConversion.typed(casted.getFirst(), tr);
            if (prim == JavaPrim.NativeLong) {
                res.setFirst(new Expression.New(ElementsHelper.typeRef(NativeLong.class), casted.getFirst()));
            } else if (prim == JavaPrim.NativeSize) {
                res.setFirst(new Expression.New(ElementsHelper.typeRef(NativeSize.class), casted.getFirst()));
            }
        } else if (x instanceof Expression.Constant) {
            Class<Object> c = null;
            Expression.Constant jc = ((Expression.Constant)x).asJava();
            switch (jc.getType()) {
                case Byte: {
                    c = Byte.TYPE;
                    break;
                }
                case Char: {
                    c = Character.TYPE;
                    break;
                }
                case Double: {
                    c = Double.TYPE;
                    break;
                }
                case Float: {
                    c = Float.TYPE;
                    break;
                }
                case Int: 
                case UInt: 
                case IntegerString: {
                    c = Integer.TYPE;
                    break;
                }
                case ULong: 
                case Long: 
                case LongString: {
                    c = Long.TYPE;
                    break;
                }
                case Short: {
                    c = Short.TYPE;
                    break;
                }
                case String: {
                    c = String.class;
                }
            }
            if (c != null) {
                res = TypeConversion.typed(((Expression.Constant)x).asJava(), ElementsHelper.typeRef(c));
            }
        } else if (x instanceof Expression.VariableRef) {
            Expression.VariableRef fr = (Expression.VariableRef)x;
            Identifier name = fr.getName();
            if (name != null) {
                Define define = this.result.defines.get(name);
                if (define != null && define.getValue() != null) {
                    if (x.toString().equals(define.getValue().toString())) {
                        res = null;
                    } else {
                        Expression defineValue = define.getValue();
                        if (defineValue instanceof Expression.Constant) {
                            Expression.Constant constant = (Expression.Constant)defineValue;
                            res = TypeConversion.typed(this.findDefine(name), this.convertToJavaType(constant.getType()));
                        }
                        if (res == null) {
                            res = this.convertExpressionToJava(defineValue, libraryClassName, promoteNativeLongToLong);
                        }
                    }
                } else {
                    VariablesDeclaration constant;
                    Enum.EnumItem enumItem;
                    String sname = name.toString();
                    res = sname.equals("True") || sname.equals("true") ? TypeConversion.typed(ElementsHelper.expr(Expression.Constant.Type.Bool, true), TypeConversion.primRef(JavaPrim.Boolean)) : (sname.equals("False") || sname.equals("false") ? TypeConversion.typed(ElementsHelper.expr(Expression.Constant.Type.Bool, false), TypeConversion.primRef(JavaPrim.Boolean)) : ((enumItem = this.result.enumItems.get(name)) != null ? TypeConversion.typed(this.findEnumItem(enumItem), ElementsHelper.typeRef(Integer.TYPE)) : ((constant = this.result.globalVariablesByName.get(name)) != null ? TypeConversion.typed(ElementsHelper.varRef(this.findRef(name, constant, libraryClassName, true)), null) : TypeConversion.typed(new Expression.VariableRef(name), null))));
                }
            }
        } else if (x instanceof Expression.FunctionCall && "sizeof".equals(String.valueOf((fc = (Expression.FunctionCall)x).getFunction())) && fc.getArguments().size() == 1 && (typeEx = SyntaxUtils.as(fc.getArguments().get(0).getValue(), Expression.TypeRefExpression.class)) != null) {
            res = TypeConversion.typed(this.sizeofToJava(typeEx.getType(), libraryClassName), ElementsHelper.typeRef(Integer.TYPE));
        }
        if (x instanceof Expression.TypeRefExpression) {
            TypeRef.SimpleTypeRef str;
            Identifier ident;
            Expression.TypeRefExpression tre = (Expression.TypeRefExpression)x;
            TypeRef tr = tre.getType();
            if (tr instanceof TypeRef.SimpleTypeRef && (ident = (str = (TypeRef.SimpleTypeRef)tr).getName()) != null && this.result.enumItemsFullName.contains(ident)) {
                res = TypeConversion.typed(tre, ElementsHelper.typeRef(Integer.TYPE));
            }
            if (res == null) {
                if (tr.isMarkedAsResolved()) {
                    res = TypeConversion.typed(tre, tr);
                } else {
                    TypeRef conv = this.convertTypeToJNA(tr, TypeConversionMode.ExpressionType, libraryClassName);
                    res = TypeConversion.typed(new Expression.TypeRefExpression(conv), conv);
                }
            }
        }
        if (res == null) {
            throw new UnsupportedConversionException(x, null);
        }
        if (res.getFirst() == null) {
            return null;
        }
        ((Expression)res.getFirst()).setParenthesis(x.getParenthesis());
        return res;
    }

    public TypeRef convertToJavaType(Expression.Constant.Type type) {
        switch (type) {
            case Bool: {
                return ElementsHelper.typeRef(Boolean.TYPE);
            }
            case Int: 
            case UInt: 
            case IntegerString: {
                return ElementsHelper.typeRef(Integer.TYPE);
            }
            case ULong: 
            case Long: 
            case LongString: {
                return ElementsHelper.typeRef(Long.TYPE);
            }
            case Short: {
                return ElementsHelper.typeRef(Short.TYPE);
            }
            case Byte: {
                return ElementsHelper.typeRef(Byte.TYPE);
            }
            case Float: {
                return ElementsHelper.typeRef(Float.TYPE);
            }
            case Double: {
                return ElementsHelper.typeRef(Double.TYPE);
            }
            case String: {
                return ElementsHelper.typeRef(String.class);
            }
        }
        return null;
    }

    private Expression sizeofToJava(TypeRef type, Identifier libraryClassName) throws UnsupportedConversionException {
        Expression res;
        block12: {
            Struct s;
            block14: {
                block13: {
                    block11: {
                        type = this.resolveTypeDef(type, libraryClassName, true);
                        res = null;
                        if (!(type instanceof TypeRef.Pointer)) break block11;
                        res = ElementsHelper.memberRef(ElementsHelper.expr(ElementsHelper.typeRef(this.result.config.runtime.pointerClass)), Expression.MemberRefStyle.Dot, "SIZE");
                        break block12;
                    }
                    if (!(type instanceof TypeRef.ArrayRef)) break block13;
                    res = this.sizeofToJava(((TypeRef.ArrayRef)type).getTarget(), libraryClassName);
                    if (res == null) {
                        return null;
                    }
                    TypeRef.ArrayRef ar = (TypeRef.ArrayRef)type;
                    for (Expression x : ar.getDimensions()) {
                        Expression c = this.convertExpressionToJava(x, libraryClassName, false).getFirst();
                        res = ElementsHelper.expr(res, Expression.BinaryOperator.Multiply, c);
                    }
                    break block12;
                }
                if (!(type instanceof TypeRef.SimpleTypeRef) && !(type instanceof TypeRef.Primitive)) break block14;
                JavaPrim prim = this.getPrimitive(type, libraryClassName);
                if (prim != null) {
                    res = this.sizeof(prim);
                } else {
                    Identifier structRef = this.findStructRef(((TypeRef.SimpleTypeRef)type).getName(), libraryClassName);
                    if (structRef == null) {
                        structRef = this.findStructRef(((TypeRef.SimpleTypeRef)type).getName().resolveLastSimpleIdentifier(), libraryClassName);
                    }
                    if (structRef != null) {
                        return ElementsHelper.methodCall((Expression)new Expression.New(ElementsHelper.typeRef(structRef)), Expression.MemberRefStyle.Dot, "size", new Expression[0]);
                    }
                }
                break block12;
            }
            if (!(type instanceof Struct) || (s = (Struct)type) == null) break block12;
            Identifier structName = this.result.declarationsConverter.getActualTaggedTypeName(s);
            Identifier structRef = this.findStructRef(structName, libraryClassName);
            if (structRef != null) {
                return ElementsHelper.methodCall((Expression)new Expression.New(ElementsHelper.typeRef(structRef)), Expression.MemberRefStyle.Dot, "size", new Expression[0]);
            }
            for (Declaration d : s.getDeclarations()) {
                if (!(d instanceof VariablesDeclaration)) continue;
                TypeRef varsType = d.getValueType();
                for (Declarator sto : ((VariablesDeclaration)d).getDeclarators()) {
                    Expression so = this.sizeofToJava(SyntaxUtils.as(sto.mutateType(varsType), TypeRef.class), libraryClassName);
                    if (so == null) {
                        return null;
                    }
                    if (res == null) {
                        res = so;
                        continue;
                    }
                    res = ElementsHelper.expr(res, Expression.BinaryOperator.Plus, so);
                }
            }
        }
        return res;
    }

    private Expression sizeof(JavaPrim prim) {
        return prim.size.sizeof(prim);
    }

    private Expression findEnumItem(Enum.EnumItem enumItem) {
        String library = this.result.getLibrary(enumItem);
        if (library == null) {
            return null;
        }
        Element parent = enumItem.getParentElement();
        if (parent == null || !(parent instanceof Enum)) {
            return null;
        }
        Enum e = (Enum)parent;
        Identifier ident = ElementsHelper.ident(this.result.getLibraryClassFullName(library), this.result.declarationsConverter.getActualTaggedTypeName(e), ElementsHelper.ident(enumItem.getName()));
        return ElementsHelper.expr(ElementsHelper.typeRef(ident).setMarkedAsResolved(true));
    }

    public Identifier getValidJavaArgumentName(Identifier name) {
        return this.getValidJavaIdentifier(name);
    }

    public Identifier getValidJavaMethodName(Identifier name) {
        String nameStr = name.toString();
        String newName = null;
        if (nameStr.matches("operator[^\\w]+")) {
            String op = nameStr.substring("operator".length());
            String suffix = null;
            java.lang.Enum<?> e = Expression.getAnyOperator(op);
            if (e == null) {
                if (op.equals("()")) {
                    suffix = "parenthesis";
                } else if (op.equals("[]")) {
                    suffix = "brackets";
                } else if (op.equals("->")) {
                    suffix = "arrow";
                }
            } else {
                suffix = e.name();
            }
            if (suffix != null) {
                newName = "operator" + StringUtils.capitalize(suffix);
            }
        }
        if (newName == null) {
            newName = this.getValidJavaIdentifierString(name);
        } else if (this.result.config.beautifyNames) {
            newName = this.beautify(newName);
        }
        return ElementsHelper.ident(newName);
    }

    String beautify(String name) {
        String newName = StringUtils.uncapitalize(StringUtils.underscoredToCamel(name));
        if (name.endsWith("_")) {
            newName = newName + "$";
        }
        return newName;
    }

    public boolean isJavaKeyword(String name) {
        return JAVA_KEYWORDS.contains(name);
    }

    public Identifier getValidJavaIdentifier(Identifier name) {
        return ElementsHelper.ident(this.getValidJavaIdentifierString(name));
    }

    public String getValidJavaIdentifierString(Identifier name) {
        if (name == null) {
            return null;
        }
        if (this.isJavaKeyword(name.toString())) {
            return name + "$";
        }
        String newName = name.toString().replace('-', '_').replaceAll("[^\\w]", "\\$");
        if (this.result.config.beautifyNames) {
            newName = this.beautify(newName);
        }
        return newName;
    }

    public static String toPrimString(JavaPrim prim) {
        return prim.name;
    }

    public Expression getJavaClassLitteralExpression(TypeRef tr) {
        JavaPrim prim = this.result.typeConverter.getPrimitive(tr, null);
        return prim != null ? ElementsHelper.classLiteral(prim.type) : this.typeLiteral(tr.clone());
    }

    public Expression getJavaClassLitteralExpression() {
        throw new UnsupportedOperationException(this.getClass().getName() + "." + this.toString() + " not handled !");
    }

    static {
        Object[] data = new Object[]{"char", Byte.TYPE, byte[].class, ByteBuffer.class, "Char", "long", Long.TYPE, long[].class, LongBuffer.class, "Long", "int", Integer.TYPE, int[].class, IntBuffer.class, "Int", "short", Short.TYPE, short[].class, ShortBuffer.class, "Short", "wchar_t", Character.TYPE, char[].class, CharBuffer.class, "WChar", "double", Double.TYPE, double[].class, DoubleBuffer.class, "Double", "float", Float.TYPE, float[].class, FloatBuffer.class, "Float", "bool", Boolean.TYPE, boolean[].class, null, "Bool"};
        for (int arity : new int[]{1, 2, 4, 8, 16}) {
            String suffix = arity == 1 ? "" : arity + "";
            for (int i = 0; i < data.length; i += 5) {
                String rawType = (String)data[i];
                Class scalClass = (Class)data[i + 1];
                Class arrClass = (Class)data[i + 2];
                Class buffClass = (Class)data[i + 3];
                String radix = (String)data[i + 4];
                Pair<Integer, Class> buffPair = new Pair<Integer, Class>(arity, arity == 1 ? scalClass : buffClass);
                Pair<Integer, Class> arrPair = new Pair<Integer, Class>(arity, arity == 1 ? scalClass : arrClass);
                for (String type : new String[]{rawType + suffix, "u" + rawType + suffix}) {
                    buffersAndArityByType.put(type, buffPair);
                    arraysAndArityByType.put(type, arrPair);
                    pointerFieldGetterNameRadixByType.put(type, radix);
                }
            }
        }
        predefObjCClasses = new HashMap();
        predefObjCClasses.put("id", ObjCObject.class);
        predefObjCClasses.put("SEL", Selector.class);
        predefObjCClasses.put("IMP", Pointer.class);
        predefObjCClasses.put("Class", ObjCClass.class);
        predefObjCClasses.put("Protocol", ObjCClass.class);
        predefObjCClasses.put("NSObject", NSObject.class);
        JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("null", "true", "false", "abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "wait"));
    }

    public class NL4JConversion {
        public ConvType type;
        public TypeRef typeRef;
        public TypeRef indirectType;
        public List<Expression> arrayLengths;
        public Expression bits;
        public Expression getExpr;
        public Expression setExpr;
        public boolean wideString;
        public boolean readOnly;
        public boolean isPtr;
        public boolean byValue;
        public boolean nativeSize;
        public boolean cLong;
        public Charset charset;
        public final List<Annotation> annotations = new ArrayList<Annotation>();
        public String pointerFieldGetterNameRadix;

        public Expression arrayLength() {
            Expression length = null;
            for (Expression m : this.arrayLengths) {
                m.setParenthesis(true);
                if (length == null) {
                    length = m.clone();
                    continue;
                }
                length = ElementsHelper.expr(length, Expression.BinaryOperator.Multiply, m.clone());
            }
            return length.setParenthesis(this.arrayLengths.size() > 1);
        }

        public TypeRef getIndirectTypeRef() {
            if (this.type == ConvType.Void) {
                return ElementsHelper.typeRef(ElementsHelper.ident("?"));
            }
            if (TypeConversion.this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
                if (this.type == ConvType.NativeSize) {
                    return ElementsHelper.typeRef(SizeT.class);
                }
                if (this.type == ConvType.NativeLong) {
                    return ElementsHelper.typeRef(org.bridj.CLong.class);
                }
            }
            TypeRef t = this.indirectType == null ? this.typeRef : this.indirectType;
            return t == null ? null : t.clone();
        }

        public <M extends ModifiableElement> M annotateRawType(M element) throws UnsupportedConversionException {
            element.addAnnotations(this.annotations);
            if (this.type != null) {
                switch (this.type) {
                    case Enum: 
                    case Primitive: 
                    case Void: {
                        break;
                    }
                    case NativeLong: {
                        element.addAnnotation(new Annotation(CLong.class, new Expression[0]));
                        break;
                    }
                    case NativeSize: {
                        element.addAnnotation(new Annotation(Ptr.class, new Expression[0]));
                        break;
                    }
                    case Pointer: {
                        element.addAnnotation(new Annotation(Ptr.class, new Expression[0]));
                        break;
                    }
                    case Struct: {
                        break;
                    }
                    default: {
                        throw new UnsupportedConversionException(this.typeRef, "Not supported");
                    }
                }
            }
            return element;
        }

        public <M extends ModifiableElement> M annotateTypedType(M element) throws UnsupportedConversionException {
            element.addAnnotations(this.annotations);
            if (this.type != ConvType.Pointer) {
                this.annotateRawType(element);
            }
            return element;
        }
    }

    public static enum ConvType {
        Enum,
        Pointer,
        Primitive,
        Struct,
        NativeLong,
        NativeSize,
        Void,
        Callback;

    }

    public static class JavaPrimitive
    extends TypeRef.Primitive {
        JavaPrim javaPrim;

        public JavaPrimitive() {
        }

        public JavaPrimitive(JavaPrim javaPrim) {
            this.setName(ElementsHelper.ident(javaPrim == JavaPrim.Void ? Void.TYPE : javaPrim.type, new Expression[0]));
            this.javaPrim = javaPrim;
        }

        public JavaPrim getJavaPrim() {
            return this.javaPrim;
        }

        public void setJavaPrim(JavaPrim javaPrim) {
            this.javaPrim = javaPrim;
        }
    }

    public static enum JavaPrim {
        Void(null, null, ESize.Zero),
        Char(Character.TYPE, Character.class, ESize.CharSize),
        Long(java.lang.Long.TYPE, Long.class, ESize.Eight),
        Int(Integer.TYPE, Integer.class, ESize.Four),
        Short(java.lang.Short.TYPE, Short.class, ESize.Two),
        Byte(java.lang.Byte.TYPE, Byte.class, ESize.One),
        Boolean(java.lang.Boolean.TYPE, Boolean.class, ESize.One),
        Float(java.lang.Float.TYPE, Float.class, ESize.Four),
        Double(java.lang.Double.TYPE, Double.class, ESize.Eight),
        NativeLong(NativeLong.class, NativeLong.class, ESize.StaticSizeField),
        NativeSize(NativeSize.class, NativeSize.class, ESize.StaticSizeField),
        NSInteger(NSInteger.class, NSInteger.class, ESize.StaticSizeField),
        NSUInteger(NSUInteger.class, NSUInteger.class, ESize.StaticSizeField),
        CGFloat(CGFloat.class, CGFloat.class, ESize.StaticSizeField);

        public final Class<?> type;
        public final Class<?> wrapperType;
        public final String simpleName;
        public final String name;
        public final boolean isPrimitive;
        public final ESize size;
        private static Map<String, JavaPrim> nameToPrim;

        public static JavaPrim getJavaPrim(String name) {
            if (nameToPrim == null) {
                nameToPrim = new HashMap<String, JavaPrim>();
                for (JavaPrim p : JavaPrim.values()) {
                    nameToPrim.put(p.simpleName, p);
                }
            }
            return nameToPrim.get(name);
        }

        private JavaPrim(Class<?> type, Class<?> wrapperType, ESize size) {
            this.type = type;
            this.wrapperType = wrapperType;
            this.size = size;
            this.name = type == null ? "void" : type.getName();
            this.isPrimitive = type == null || type.isPrimitive();
            this.simpleName = type == null ? "void" : type.getSimpleName();
        }

        public static enum ESize {
            One(ElementsHelper.expr(1)),
            Two(ElementsHelper.expr(2)),
            Four(ElementsHelper.expr(4)),
            Eight(ElementsHelper.expr(8)),
            StaticSizeField(null){

                @Override
                public Expression sizeof(JavaPrim p) {
                    return ElementsHelper.staticField(p.type, "SIZE");
                }
            }
            ,
            CharSize(null){

                @Override
                public Expression sizeof(JavaPrim p) {
                    return ElementsHelper.staticField(Native.class, "WCHAR_SIZE");
                }
            }
            ,
            Zero(ElementsHelper.expr(0));

            private final Expression sizeOfExpression;

            private ESize(Expression sizeOfExpression) {
                this.sizeOfExpression = sizeOfExpression;
            }

            public Expression sizeof(JavaPrim p) {
                return this.sizeOfExpression.clone();
            }
        }
    }

    public static enum TypeConversionMode {
        PrimitiveOrBufferParameter,
        NativeParameter,
        NativeParameterWithStructsPtrPtrs,
        FieldType,
        ReturnType,
        ExpressionType,
        StaticallySizedArrayField,
        PrimitiveReturnType,
        PointedValue;

    }
}

