/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.JNAerator;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.studio.JNAeratorStudio;
import com.ochafik.lang.reflect.DebugUtils;
import com.ochafik.swing.candy.JLinkLabel;
import com.ochafik.util.SystemUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SimpleGUI
implements JNAerator.Feedback {
    JFrame frame;
    JLabel status;
    JButton cancelButton;
    final JNAeratorConfig config;
    final Thread threadToCancel;
    private String title;
    private String ftitle;
    Object toOpenWhenFinished;
    boolean finished;

    public SimpleGUI(JNAeratorConfig config) {
        this.config = config;
        this.frame = new JFrame("JNAerator");
        this.threadToCancel = Thread.currentThread();
        this.title = config.entryName;
        if (this.title == null) {
            this.title = "<unnamed configuration>";
        }
        this.ftitle = "JNAerator : " + this.title;
        this.frame.getContentPane().add("North", new JLinkLabel(this.title, new Runnable(){

            @Override
            public void run() {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PrintStream pout = new PrintStream(bout);
                DebugUtils.println((Object)SimpleGUI.this.config, pout);
                JTextArea ta = new JTextArea();
                ta.setWrapStyleWord(true);
                ta.setLineWrap(true);
                ta.setText(new String(bout.toByteArray()));
                JScrollPane sp = new JScrollPane(ta);
                Dimension s = new Dimension(500, 400);
                ta.setMaximumSize(new Dimension(s.width, Integer.MAX_VALUE));
                sp.setMaximumSize(s);
                sp.setMinimumSize(s);
                sp.setPreferredSize(s);
                JOptionPane.showMessageDialog(SimpleGUI.this.frame, sp, SimpleGUI.this.ftitle, 1);
            }
        }));
        this.status = new JLabel("Initializing...");
        this.frame.getContentPane().add("Center", this.status);
        this.frame.setMinimumSize(new Dimension(400, 0));
        this.cancelButton = new JButton("Cancel");
        this.frame.getContentPane().add("South", this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block9: {
                    if (SimpleGUI.this.finished) {
                        if (SimpleGUI.this.toOpenWhenFinished instanceof File) {
                            try {
                                File f = (File)SimpleGUI.this.toOpenWhenFinished;
                                f = f.getAbsoluteFile();
                                if (f.isDirectory()) {
                                    SystemUtils.runSystemOpenDirectory(f);
                                    break block9;
                                }
                                SystemUtils.runSystemOpenFileParent(f);
                            }
                            catch (NoSuchMethodException e1) {
                                e1.printStackTrace();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        } else if (SimpleGUI.this.toOpenWhenFinished instanceof Throwable) {
                            JNAeratorStudio.error(SimpleGUI.this.frame, null, null, (Throwable)SimpleGUI.this.toOpenWhenFinished);
                        }
                    } else {
                        SimpleGUI.this.tryCancel();
                    }
                }
            }
        });
        this.cancelButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SimpleGUI.this.tryQuit();
                }
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SimpleGUI.this.tryQuit();
            }
        });
    }

    void tryQuit() {
        if (this.finished) {
            System.exit(0);
        }
        this.tryCancel();
    }

    private void tryCancel() {
        if (JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to cancel ?", this.ftitle, 2) == 0) {
            this.threadToCancel.interrupt();
            System.exit(0);
        }
    }

    void show() {
        this.frame.pack();
        this.frame.setVisible(true);
    }

    void hide() {
        this.frame.setVisible(false);
    }

    @Override
    public void setStatus(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleGUI.this.status.setText(string);
            }
        });
    }

    @Override
    public void setFinished(final File fileToOpen) {
        this.toOpenWhenFinished = fileToOpen;
        this.finished = true;
        this.setStatus("JNAeration completed (hit Escape to quit)");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String name = fileToOpen.getName();
                SimpleGUI.this.cancelButton.setText(fileToOpen.isDirectory() ? "Open output directory" : "Show file '" + name + "'");
                SimpleGUI.this.cancelButton.setToolTipText(fileToOpen.getAbsolutePath());
            }
        });
    }

    @Override
    public void setFinished(final Throwable e) {
        this.finished = true;
        this.toOpenWhenFinished = e;
        this.setStatus("JNAeration failed !");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleGUI.this.cancelButton.setText("Show error details");
                SimpleGUI.this.cancelButton.setToolTipText(e.toString());
            }
        });
    }

    @Override
    public void sourcesParsed(SourceFiles sourceFiles) {
    }

    @Override
    public void wrappersGenerated(Result result) {
    }
}

