/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.util.string.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RococoaUtils {
    static TypeRef ROCOCOA_ID_TYPEREF = new TypeRef.SimpleTypeRef("id");
    static Pattern shortNamesPattern = Pattern.compile("([A-Z]+?[a-z]*)(?:[A-Z][a-z]|$)");

    public static List<String> getShortNames(Struct type) {
        String name = type.getTag().toString();
        ArrayList<String> shortNames = new ArrayList<String>();
        String base = name.startsWith("NS") ? name.substring(2) : name;
        Matcher matcher = shortNamesPattern.matcher(base);
        int i = 0;
        while (matcher.find(i)) {
            String n = matcher.group(1);
            shortNames.add(base.substring(matcher.start()));
            i = matcher.start() + n.length();
        }
        return shortNames;
    }

    public static String getMethodName(Function function) {
        StringBuilder nb = new StringBuilder();
        nb.append(function.getName());
        boolean firstArg = true;
        for (Arg arg : function.getArgs()) {
            if (arg.isVarArg()) continue;
            if (firstArg) {
                firstArg = false;
                continue;
            }
            nb.append("_");
            nb.append(arg.getSelector());
        }
        return nb.toString();
    }

    public static boolean methodNameMatchesObjcStaticConstructor(Struct type, Identifier identifier) {
        String name = identifier.toString();
        for (String shortName : RococoaUtils.getShortNames(type)) {
            if (name.matches(StringUtils.uncapitalize(shortName) + "(With.*)?")) {
                return true;
            }
            if (!name.matches("[a-z]+" + StringUtils.capitalize(shortName) + "(With.*)?")) continue;
            return true;
        }
        return false;
    }

    public static TypeRef fixReturnType(Function function) {
        TypeRef returnType = function.getValueType();
        if (returnType == null) {
            returnType = ROCOCOA_ID_TYPEREF;
        }
        Struct declaringClass = function.findParentOfType(Struct.class);
        if (returnType.toString().equals("id")) {
            String pointedClassName = function.getName().toString().matches("^(alloc|(init|copy|mutableCopy)([A-Z].*)?)$") || RococoaUtils.methodNameMatchesObjcStaticConstructor(declaringClass, function.getName()) ? declaringClass.getTag().toString() : "NSObject";
            returnType = new TypeRef.Pointer(new TypeRef.SimpleTypeRef(pointedClassName), Declarator.PointerStyle.Pointer);
        }
        return returnType;
    }
}

