/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.ClassOutputter;
import com.ochafik.lang.jnaerator.DeclarationsConverter;
import com.ochafik.lang.jnaerator.GlobalsGenerator;
import com.ochafik.lang.jnaerator.JNAerator;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.ObjectiveCGenerator;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UniversalReconciliator;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Printer;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.util.SystemUtils;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.StringUtils;
import com.sun.jna.Platform;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rococoa.cocoa.foundation.NSObject;

public class Result
extends Scanner {
    public final JNAeratorConfig config;
    public final JNAerator.Feedback feedback;
    public final ClassOutputter classOutputter;
    public TypeConversion typeConverter;
    public DeclarationsConverter declarationsConverter;
    public GlobalsGenerator globalsGenerator;
    public ObjectiveCGenerator objectiveCGenerator;
    public UniversalReconciliator universalReconciliator;
    public final Set<Identifier> structsFullNames = new HashSet<Identifier>();
    public final Set<Identifier> enumsFullNames = new HashSet<Identifier>();
    public final Set<Identifier> unionsFullNames = new HashSet<Identifier>();
    public final Set<Identifier> callbacksFullNames = new HashSet<Identifier>();
    Set<Identifier> javaPackages = new TreeSet<Identifier>();
    Map<Struct.Type, Map<Identifier, Struct>> classes = new TreeMap<Struct.Type, Map<Identifier, Struct>>();
    Map<Identifier, Map<String, Struct>> objCCategoriesByTargetType = new HashMap<Identifier, Map<String, Struct>>();
    Map<String, Struct> objCCategoriesByName = new HashMap<String, Struct>();
    Map<String, Map<String, String>> stringConstants = new HashMap<String, Map<String, String>>();
    Map<String, Map<String, Boolean>> retainedRetValFunctions = new HashMap<String, Map<String, Boolean>>();
    public Map<String, List<String>> missingPointersByUsingLibrary = new HashMap<String, List<String>>();
    public Map<String, List<Struct>> structsByLibrary = new HashMap<String, List<Struct>>();
    public Map<String, List<TypeRef.FunctionSignature>> callbacksByLibrary = new HashMap<String, List<TypeRef.FunctionSignature>>();
    public Map<String, List<VariablesDeclaration>> globalsByLibrary = new HashMap<String, List<VariablesDeclaration>>();
    public Map<Identifier, VariablesDeclaration> globalVariablesByName = new HashMap<Identifier, VariablesDeclaration>();
    public Map<Identifier, Struct> structsByName = new HashMap<Identifier, Struct>();
    public Map<Identifier, TypeRef.FunctionSignature> callbacksByName = new HashMap<Identifier, TypeRef.FunctionSignature>();
    public Map<String, List<Enum>> enumsByLibrary = new HashMap<String, List<Enum>>();
    public Map<Identifier, Enum> enumsByName = new HashMap<Identifier, Enum>();
    public Map<String, Enum.EnumItem> enumItems = new HashMap<String, Enum.EnumItem>();
    public Map<String, Define> defines = new LinkedHashMap<String, Define>();
    public Map<String, List<Define>> definesByLibrary = new HashMap<String, List<Define>>();
    public Map<String, Set<String>> fakePointersByLibrary = new HashMap<String, Set<String>>();
    public Map<String, List<Function>> functionsByLibrary = new HashMap<String, List<Function>>();
    public Map<Identifier, Signatures> signaturesByOutputClass = new HashMap<Identifier, Signatures>();
    public Map<String, Pair<StoredDeclarations.TypeDef, Declarator>> typeDefs = new HashMap<String, Pair<StoredDeclarations.TypeDef, Declarator>>();
    Map<Identifier, List<Pair<Identifier, Function>>> functionsReifiableInFakePointers = new HashMap<Identifier, List<Pair<Identifier, Function>>>();
    Set<Identifier> resolvedFakePointers = new HashSet<Identifier>();
    Set<String> libraries = new HashSet<String>();
    Map<String, Identifier> javaPackageByLibrary = new HashMap<String, Identifier>();
    public Set<Identifier> enumItemsFullName = new HashSet<Identifier>();
    Class<?>[] overwrittenClassesThatNeedToKeepAllTheirMethods = new Class[]{NSObject.class};
    public List<ClassWritingNotifiable> classWritingNotifiables = new ArrayList<ClassWritingNotifiable>();
    public final Map<String, TypeRef> weakTypeDefs = new HashMap<String, TypeRef>();

    public Result(JNAeratorConfig config, ClassOutputter classOutputter, JNAerator.Feedback feedback) {
        if (config == null) {
            throw new IllegalArgumentException("No config in result !");
        }
        this.config = config;
        this.classOutputter = classOutputter;
        this.feedback = feedback;
        this.init();
    }

    public void init() {
        this.typeConverter = new TypeConversion(this);
        this.declarationsConverter = new DeclarationsConverter(this);
        this.globalsGenerator = new GlobalsGenerator(this);
        this.objectiveCGenerator = new ObjectiveCGenerator(this);
        this.universalReconciliator = new UniversalReconciliator();
    }

    static <T> List<T> getList(Map<String, List<T>> m, String key) {
        List<T> list = m.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            m.put(key, list);
        }
        return list;
    }

    static <T, U, V> Map<U, V> getMap(Map<T, Map<U, V>> m, T key) {
        Map<U, V> map = m.get(key);
        if (map == null) {
            map = new LinkedHashMap<U, V>();
            m.put(key, map);
        }
        return map;
    }

    public Identifier findFakePointer(Identifier name) {
        if ((name = this.getFakePointerName(name)) == null) {
            return null;
        }
        String s = name.toString();
        for (Map.Entry<String, Set<String>> e : this.fakePointersByLibrary.entrySet()) {
            if (!e.getValue().contains(s)) continue;
            return ElementsHelper.ident(ElementsHelper.ident(e.getKey()), name);
        }
        return null;
    }

    public boolean isFakePointer(Identifier id) {
        return this.resolvedFakePointers.contains(id);
    }

    public Identifier getFakePointer(Identifier libraryToUseIfNotDefinedYet, Identifier name) {
        Identifier lib = this.findFakePointer(name);
        if (lib != null) {
            return lib;
        }
        name = this.getFakePointerName(name);
        Set<String> set = this.fakePointersByLibrary.get(libraryToUseIfNotDefinedYet);
        if (set == null) {
            set = new HashSet<String>();
            this.fakePointersByLibrary.put(libraryToUseIfNotDefinedYet.toString(), set);
        }
        set.add(name.toString());
        Identifier id = ElementsHelper.ident(libraryToUseIfNotDefinedYet, name);
        this.resolvedFakePointers.add(id);
        return id;
    }

    private Identifier getFakePointerName(Identifier name) {
        String target;
        String nicerName;
        Pair<StoredDeclarations.TypeDef, Declarator> pair;
        String nameStr = name == null ? null : name.toString();
        String trimmed = StringUtils.trimUnderscores(nameStr);
        if (trimmed != null && !nameStr.equals(trimmed) && (pair = this.typeDefs.get(nicerName = trimmed)) != null && ((target = pair.getFirst().getValueType().toString()).equals(nameStr) || target.equals(nameStr + "*"))) {
            nameStr = nicerName;
            name = ElementsHelper.ident(nameStr);
        }
        return name;
    }

    public Signatures getSignaturesForOutputClass(Identifier name) {
        Signatures s = this.signaturesByOutputClass.get(name);
        if (s == null) {
            s = new Signatures();
            this.signaturesByOutputClass.put(name, s);
        }
        return s;
    }

    @Override
    public void visitDefine(Define define) {
        super.visitDefine(define);
        this.defines.put(define.getName(), define);
        Result.getList(this.definesByLibrary, this.getLibrary(define)).add(define);
    }

    @Override
    public void visitEnum(Enum e) {
        String simpleTypeStr;
        StoredDeclarations.TypeDef typeDef;
        TypeRef type;
        Element nextDeclaration;
        super.visitEnum(e);
        if (e.getTag() == null && (nextDeclaration = e.getNextSibling()) != null && nextDeclaration instanceof StoredDeclarations.TypeDef && (type = (typeDef = (StoredDeclarations.TypeDef)nextDeclaration).getValueType()) instanceof TypeRef.SimpleTypeRef && ((simpleTypeStr = ((TypeRef.SimpleTypeRef)type).getName().toString()).equals("NSUInteger") || simpleTypeStr.equals("NSInteger") || simpleTypeStr.equals("CFIndex"))) {
            Declarator bestPlainStorage = null;
            for (Declarator st : typeDef.getDeclarators()) {
                if (!(st instanceof Declarator.DirectDeclarator)) continue;
                String name = st.resolveName();
                boolean niceName = StringUtils.trimUnderscores(name).equals(name);
                if (bestPlainStorage != null && !niceName) continue;
                bestPlainStorage = st;
                if (!niceName) continue;
                break;
            }
            if (bestPlainStorage != null) {
                String name = bestPlainStorage.resolveName();
                System.err.println("Automatic struct name matching : " + name);
                e.setTag(ElementsHelper.ident(name));
            }
        }
        if (e.getTag() != null) {
            this.enumsByName.put(e.getTag(), e);
        }
        Result.getList(this.enumsByLibrary, this.getLibrary(e)).add(e);
        Identifier identifier = this.getTaggedTypeIdentifierInJava(e);
        if (identifier != null) {
            this.enumsFullNames.add(identifier);
        }
    }

    @Override
    public void visitEnumItem(Enum.EnumItem enumItem) {
        super.visitEnumItem(enumItem);
        this.enumItems.put(enumItem.getName(), enumItem);
        String library = this.getLibrary(enumItem);
        if (library == null) {
            return;
        }
        Element parent = enumItem.getParentElement();
        if (parent == null || !(parent instanceof Enum)) {
            return;
        }
        Enum e = (Enum)parent;
        Identifier ident = ElementsHelper.ident(this.getLibraryClassFullName(library), this.declarationsConverter.getActualTaggedTypeName(e), ElementsHelper.ident(enumItem.getName()));
        this.enumItemsFullName.add(ident);
    }

    @Override
    public void visitVariablesDeclaration(VariablesDeclaration v) {
        super.visitVariablesDeclaration(v);
        if (v.findParentOfTypes(Struct.class, Function.class, Enum.class) != null) {
            return;
        }
        for (Declarator d : v.getDeclarators()) {
            this.globalVariablesByName.put(ElementsHelper.ident(d.resolveName()), v);
        }
        Result.getList(this.globalsByLibrary, this.getLibrary(v)).add(v);
    }

    @Override
    public void visitTypeDef(StoredDeclarations.TypeDef typeDef) {
        super.visitTypeDef(typeDef);
        for (Declarator vs : typeDef.getDeclarators()) {
            this.typeDefs.put(vs.resolveName(), new Pair<StoredDeclarations.TypeDef, Declarator>(typeDef, vs));
        }
    }

    String getLibrary(Element decl) {
        String library = null;
        SourceFile f = decl.findParentOfType(SourceFile.class);
        if (f != null && (library = f.guessFramework()) == null) {
            library = f.getLibrary();
        }
        if (library == null) {
            Element e = decl;
            String file = this.resolveFile(e);
            if (decl instanceof Define) {
                e = decl;
            }
            library = this.config.getLibrary(file);
        }
        return library;
    }

    public String resolveFile(Element e) {
        String file = null;
        while (e != null && (file = e.getElementFile()) == null) {
            e = e.getParentElement();
        }
        return file;
    }

    @Override
    public void visitFunction(Function function) {
        super.visitFunction(function);
        Element parent = function.getParentElement();
        if (parent != null) {
            if (parent instanceof TypeRef.FunctionSignature) {
                return;
            }
            if (parent instanceof Struct) {
                Struct parentStruct = (Struct)parent;
                switch (parentStruct.getType()) {
                    case CPPClass: 
                    case JavaClass: 
                    case JavaInterface: 
                    case ObjCClass: 
                    case ObjCProtocol: 
                    case CStruct: {
                        return;
                    }
                }
            }
        }
        Result.getList(this.functionsByLibrary, this.getLibrary(function)).add(function);
    }

    public Expression getLibraryInstanceReferenceExpression(String libraryName) {
        String fieldName;
        Identifier classIdent;
        Identifier hub = this.getHubFullClassName();
        if (hub != null) {
            classIdent = hub;
            fieldName = libraryName;
        } else {
            classIdent = this.getLibraryClassFullName(libraryName);
            fieldName = "INSTANCE";
        }
        return ElementsHelper.memberRef(ElementsHelper.expr(ElementsHelper.typeRef(classIdent)), Expression.MemberRefStyle.Dot, fieldName);
    }

    public Identifier getHubFullClassName() {
        return this.config.entryName == null ? null : ElementsHelper.ident(this.config.entryName.toLowerCase(), this.config.entryName);
    }

    public Identifier getTaggedTypeIdentifierInJava(TypeRef.TaggedTypeRef s) {
        Identifier name = this.declarationsConverter.getActualTaggedTypeName(s);
        if (name == null) {
            return null;
        }
        String library = this.getLibrary(s);
        if (library == null) {
            return null;
        }
        name = name.clone();
        Struct parentStruct = s.findParentOfType(Struct.class);
        if (parentStruct != null && parentStruct != s) {
            return ElementsHelper.ident(this.getTaggedTypeIdentifierInJava(parentStruct), name);
        }
        if (s instanceof Struct && this.config.putTopStructsInSeparateFiles) {
            return ElementsHelper.ident(this.getLibraryPackage(library), name);
        }
        return this.typeConverter.libMember(this.getLibraryClassFullName(library), null, name);
    }

    @Override
    public void visitStruct(Struct struct) {
        super.visitStruct(struct);
        Identifier name = struct.getTag();
        if (name != null) {
            switch (struct.getType()) {
                case CPPClass: {
                    if (!this.config.runtime.equals((Object)JNAeratorConfig.Runtime.BridJ) && !this.config.genCPlusPlus) break;
                }
                case CStruct: 
                case CUnion: {
                    String lib;
                    if (struct.isForwardDeclaration() || this.config.skipIncludedFrameworks && (lib = this.getLibrary(struct)) != null && !this.config.frameworks.contains(lib)) break;
                    Struct oldStruct = this.structsByName.get(name);
                    if (oldStruct == null || oldStruct.isForwardDeclaration() || !(oldStruct.getParentElement() instanceof StoredDeclarations.TypeDef) && struct.getParentElement() instanceof StoredDeclarations.TypeDef) {
                        this.structsByName.put(name, struct);
                    }
                    Result.getList(this.structsByLibrary, this.getLibrary(struct)).add(struct);
                    Identifier identifier = this.getTaggedTypeIdentifierInJava(struct);
                    if (identifier == null) break;
                    if (struct.getType() == Struct.Type.CUnion) {
                        this.unionsFullNames.add(identifier);
                    }
                    this.structsFullNames.add(identifier);
                    break;
                }
                case ObjCClass: 
                case ObjCProtocol: {
                    if (struct.isForwardDeclaration()) break;
                    if (struct.getCategoryName() != null) {
                        Result.getMap(this.objCCategoriesByTargetType, struct.getTag()).put(struct.getCategoryName(), struct);
                        this.objCCategoriesByName.put(struct.getCategoryName(), struct);
                        break;
                    }
                    Result.getMap(this.classes, struct.getType()).put(struct.getTag(), struct);
                    break;
                }
                default: {
                    struct = null;
                }
            }
        }
    }

    @Override
    public void visitFunctionSignature(TypeRef.FunctionSignature functionSignature) {
        super.visitFunctionSignature(functionSignature);
        Function function = functionSignature.getFunction();
        if (function != null) {
            Result.getList(this.callbacksByLibrary, this.getLibrary(functionSignature)).add(functionSignature);
            Identifier name = this.typeConverter.inferCallBackName(functionSignature, false, false, null);
            if (name != null) {
                this.callbacksByName.put(name, functionSignature);
                Identifier identifier = this.typeConverter.inferCallBackName(functionSignature, true, true, null);
                if (identifier != null) {
                    this.callbacksFullNames.add(identifier);
                }
            }
        }
    }

    public Identifier getLibraryClassSimpleName(String library) {
        return ElementsHelper.ident(StringUtils.capitalize(library) + "Library");
    }

    public Identifier getLibraryClassFullName(String library) {
        return ElementsHelper.ident(this.getLibraryPackage(library), this.getLibraryClassSimpleName(library));
    }

    public String getLibraryFileExpression(String library) {
        Class platformClass;
        Class clazz = platformClass = this.config.runtime.hasJNA ? Platform.class : SystemUtils.class;
        if (library.equals("c")) {
            return "(" + platformClass.getName() + ".isWindows() ? \"msvcrt\" : \"c\")";
        }
        return "\"" + library + "\"";
    }

    public Identifier getLibraryPackage(String library) {
        if (library == null) {
            return null;
        }
        return this.config.packageName == null ? ElementsHelper.ident(ElementsHelper.ident(this.config.rootPackageName), library.toLowerCase()) : ElementsHelper.ident(this.config.packageName);
    }

    public void chooseLibraryClasses(String packageName, String rootPackageName) {
        this.libraries.clear();
        this.javaPackages.clear();
        this.javaPackageByLibrary.clear();
        this.libraries.addAll(this.structsByLibrary.keySet());
        this.libraries.addAll(this.callbacksByLibrary.keySet());
        this.libraries.addAll(this.functionsByLibrary.keySet());
        this.libraries.addAll(this.enumsByLibrary.keySet());
        this.libraries.addAll(this.globalsByLibrary.keySet());
        this.libraries.addAll(this.definesByLibrary.keySet());
        this.libraries.addAll(this.stringConstants.keySet());
        for (String library : this.libraries) {
            Identifier javaPackage = this.getLibraryPackage(library);
            if (javaPackage == null) continue;
            this.javaPackageByLibrary.put(library, javaPackage);
        }
        this.javaPackages.addAll(this.javaPackageByLibrary.values());
    }

    public Struct getObjcCClassOrProtocol(Identifier name) {
        Struct s = Result.getMap(this.classes, Struct.Type.ObjCClass).get(name);
        if (s == null) {
            s = Result.getMap(this.classes, Struct.Type.ObjCProtocol).get(name);
        }
        if (s == null) {
            s = this.objCCategoriesByName.get(name.toString());
        }
        return s;
    }

    public void addFunctionReifiableInFakePointer(Identifier resolvedFakePointer, Identifier libraryClassName, Function f) {
        List<Pair<Identifier, Function>> list = this.functionsReifiableInFakePointers.get(resolvedFakePointer);
        if (list == null) {
            list = new ArrayList<Pair<Identifier, Function>>();
            this.functionsReifiableInFakePointers.put(resolvedFakePointer, list);
        }
        list.add(new Pair<Identifier, Function>(libraryClassName, f));
    }

    public List<Pair<Identifier, Function>> getFunctionsReifiableInFakePointer(Identifier resolvedFakePointer) {
        return this.functionsReifiableInFakePointers.get(resolvedFakePointer);
    }

    public Struct notifyBeforeWritingClass(Identifier fullClassName, Struct interf, Signatures signatures, String currentLibrary) {
        for (Class<?> c : this.overwrittenClassesThatNeedToKeepAllTheirMethods) {
            if (!fullClassName.equals(c.getName())) continue;
            this.declarationsConverter.addMissingMethods(c, signatures, interf);
            break;
        }
        if (fullClassName.resolveLastSimpleIdentifier().equals("char")) {
            return null;
        }
        String runtimeSpecificHelp = this.config.runtime == JNAeratorConfig.Runtime.BridJ ? "or <a href=\"http://bridj.googlecode.com/\">BridJ</a> " : ", <a href=\"http://rococoa.dev.java.net/\">Rococoa</a>, or <a href=\"http://jna.dev.java.net/\">JNA</a>";
        interf.addToCommentBefore("This file was autogenerated by <a href=\"http://jnaerator.googlecode.com/\">JNAerator</a>, ", "a tool written by <a href=\"http://ochafik.free.fr/\">Olivier Chafik</a> that <a href=\"http://code.google.com/p/jnaerator/wiki/CreditsAndLicense\">uses a few opensource projects.</a>.", "For help, please visit <a href=\"http://nativelibs4java.googlecode.com/\">NativeLibs4Java</a> " + runtimeSpecificHelp + ".");
        for (ClassWritingNotifiable n : this.classWritingNotifiables) {
            interf = n.writingClass(fullClassName, interf, signatures, currentLibrary);
            if (interf != null) continue;
            return null;
        }
        return interf;
    }

    public void printJavaClass(Identifier javaPackage, Struct javaClass, PrintWriter out) {
        if (javaPackage != null) {
            out.println("package " + javaPackage + ";");
        }
        if (this.config.noAutoImports) {
            out.println(javaClass);
        } else {
            Printer.printJava(javaPackage, ElementsHelper.ident(javaPackage.clone(), javaClass.getTag().clone()), javaClass, out);
        }
    }

    public boolean hasObjectiveC() {
        if (!this.objCCategoriesByName.isEmpty()) {
            return true;
        }
        Map<Identifier, Struct> m = this.classes.get((Object)Struct.Type.ObjCClass);
        if (m != null && !m.isEmpty()) {
            return true;
        }
        m = this.classes.get((Object)Struct.Type.ObjCProtocol);
        return m != null && !m.isEmpty();
    }

    public void addWeakTypeDef(TypeRef clone, String sn) {
        this.weakTypeDefs.put(sn, clone);
    }

    public void rehabilitateWeakTypeDefs() {
        for (Map.Entry<String, TypeRef> e : this.weakTypeDefs.entrySet()) {
            if (this.typeDefs.get(e.getKey()) != null) continue;
            Declarator.DirectDeclarator dd = new Declarator.DirectDeclarator(e.getKey());
            StoredDeclarations.TypeDef td = new StoredDeclarations.TypeDef(e.getValue(), dd);
            this.typeDefs.put(e.getKey(), new Pair<StoredDeclarations.TypeDef, Declarator.DirectDeclarator>(td, dd));
        }
    }

    public static interface ClassWritingNotifiable {
        public Struct writingClass(Identifier var1, Struct var2, Signatures var3, String var4);
    }
}

