/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.util.string.StringUtils;

public class ObjectiveCToJavaPreScanner
extends Scanner {
    Result result;

    public ObjectiveCToJavaPreScanner(Result result) {
        this.result = result;
    }

    @Override
    public void visitEnum(Enum e) {
        String comment;
        Element base;
        Element next;
        Element parent = e.getParentElement();
        if (!(e.getTag() != null && parent instanceof StoredDeclarations.TypeDef || this.handleAppleEnumTypeDef(next = (base = parent instanceof Declaration ? e.getParentElement() : e).getNextSibling(), e))) {
            Element beforePrevious;
            Element previous = base.getPreviousSibling();
            Element element = beforePrevious = previous == null ? null : previous.getPreviousSibling();
            if (!(previous == null || beforePrevious instanceof TaggedTypeRefDeclaration && ((TaggedTypeRefDeclaration)beforePrevious).getTaggedTypeRef() instanceof Enum)) {
                this.handleAppleEnumTypeDef(previous, e);
            }
        }
        if ((comment = e.getCommentBefore()) != null) {
            // empty if block
        }
        super.visitEnum(e);
    }

    @Override
    public void visitVariablesDeclaration(VariablesDeclaration v) {
        if (v.getDeclarators().isEmpty() && v.getValueType() instanceof TypeRef.TaggedTypeRef) {
            TaggedTypeRefDeclaration d = new TaggedTypeRefDeclaration((TypeRef.TaggedTypeRef)v.getValueType());
            d.importDetails(v, false);
            v.replaceBy(d);
            d.accept(this);
        } else {
            super.visitVariablesDeclaration(v);
        }
    }

    private boolean handleAppleEnumTypeDef(Element nextDeclaration, Enum e) {
        if (!(nextDeclaration instanceof StoredDeclarations.TypeDef)) {
            return false;
        }
        StoredDeclarations.TypeDef typeDef = (StoredDeclarations.TypeDef)nextDeclaration;
        if (typeDef.getDeclarators().size() != 1) {
            return false;
        }
        Declarator decl = typeDef.getDeclarators().get(0);
        if (!(decl instanceof Declarator.DirectDeclarator)) {
            return false;
        }
        TypeRef type = typeDef.getValueType();
        if (!(type instanceof TypeRef.SimpleTypeRef)) {
            return false;
        }
        Identifier simpleType = ((TypeRef.SimpleTypeRef)type).getName();
        if (!(simpleType != null && (simpleType.equals("NSUInteger") || simpleType.equals("NSInteger") || simpleType.equals("int32_t") || simpleType.equals("uint32_t") || simpleType.equals("CFIndex")))) {
            return false;
        }
        String name = decl.resolveName();
        if (e.getTag() != null && !StringUtils.trimUnderscores(e.getTag().toString()).equals(name)) {
            return false;
        }
        Element ep = e.getParentElement();
        ep.addToCommentBefore(typeDef.getCommentBefore());
        ep.addToCommentBefore(typeDef.getCommentAfter());
        typeDef.importDetails(ep, true);
        ep.replaceBy(null);
        typeDef.setValueType(e);
        if (this.result.config.verbose) {
            System.err.println("Inferred enum name : " + name);
        }
        return false;
    }
}

