/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.io.ReadText;
import com.ochafik.lang.jnaerator.DeclarationsConverter;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSClass;
import org.rococoa.cocoa.foundation.NSObject;

public class ObjectiveCGenerator {
    String classClassName = "_class_";
    String classInterfaceNameInCategoriesAndProtocols = "_static_";
    String classInstanceName = "_NSCLASS_";
    String classInstanceGetterName = "getNSClass";
    boolean AUTO_RELEASE_IN_FACTORIES = false;
    static Map<String, Set<String>> protocolsForcedInheritance;
    static Map<String, Set<String>> methodsExcludedFromStaticForwarding;
    final Result result;
    static Identifier NSObjectIdent;
    static Identifier ObjCObjectIdent;
    static Identifier ObjCClassIdent;

    public static Set<String> getForcedProtocolParents(String protocolName) {
        Set<String> ret;
        if (protocolsForcedInheritance == null) {
            protocolsForcedInheritance = new HashMap<String, Set<String>>();
            try {
                InputStream in = ObjectiveCGenerator.class.getClassLoader().getResourceAsStream("com/ochafik/lang/jnaerator/ObjectiveCProtocolsForcedInheritanceList.data");
                List<String> lines = ReadText.readLines(in);
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("//") || line.startsWith("#") || line.length() == 0) continue;
                    String[] tks = line.split(":");
                    protocolsForcedInheritance.put(tks[0], new TreeSet<String>(Arrays.asList(tks[1].split(","))));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return (ret = protocolsForcedInheritance.get(protocolName)) == null ? Collections.EMPTY_SET : ret;
    }

    public static boolean isMethodExcludedFromStaticForwarding(Function m) {
        if (methodsExcludedFromStaticForwarding == null) {
            methodsExcludedFromStaticForwarding = new HashMap<String, Set<String>>();
            try {
                InputStream in = ObjectiveCGenerator.class.getClassLoader().getResourceAsStream("com/ochafik/lang/jnaerator/ObjectiveCStaticForwardsExcludeList.data");
                List<String> lines = ReadText.readLines(in);
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("//") || line.startsWith("#") || line.length() == 0) continue;
                    String[] tks = line.split("\\|");
                    String className = tks[0].trim();
                    String methodSignature = tks[1].trim();
                    Set<String> set = methodsExcludedFromStaticForwarding.get(className);
                    if (set == null) {
                        set = new HashSet<String>();
                        methodsExcludedFromStaticForwarding.put(className, set);
                    }
                    set.add(methodSignature);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!(m.getParentElement() instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)m.getParentElement();
        Identifier n = s.getTag();
        if (n != null && n.equals("NSObject")) {
            return true;
        }
        String sig = m.computeSignature(false);
        if (DeclarationsConverter.getMethodsAndTheirSignatures(NSObject.class).getSecond().contains(sig)) {
            return true;
        }
        String cn = s.getTag() == null ? "" : s.getTag().toString();
        Set<String> set = methodsExcludedFromStaticForwarding.get(cn);
        if (set != null && set.contains(sig)) {
            return true;
        }
        set = methodsExcludedFromStaticForwarding.get("");
        return set != null && set.contains(sig);
    }

    public ObjectiveCGenerator(Result result) {
        this.result = result;
    }

    public Struct getStruct(Identifier className, Struct.Type type) {
        return Result.getMap(this.result.classes, type).get(className);
    }

    public Identifier getPackageName(Struct struct) {
        if (struct == null) {
            return null;
        }
        String library = this.result.getLibrary(struct);
        Identifier javaPackage = this.result.getLibraryPackage(library);
        if (struct.getType() == Struct.Type.ObjCProtocol) {
            javaPackage = ElementsHelper.ident(javaPackage, "protocols");
        } else if (struct.getCategoryName() != null) {
            javaPackage = ElementsHelper.ident(javaPackage, "categories");
        }
        return javaPackage;
    }

    public Identifier getFullClassName(Struct struct) {
        if (struct == null) {
            return null;
        }
        Identifier javaPackage = this.getPackageName(struct);
        Identifier tag = struct.getTag();
        String categ = struct.getCategoryName();
        return ElementsHelper.ident(javaPackage, categ == null ? tag.clone() : ElementsHelper.ident(categ));
    }

    public void generateObjectiveCClasses() throws IOException {
        for (Struct in : Result.getMap(this.result.classes, Struct.Type.ObjCClass).values()) {
            this.outputObjectiveCClass(in);
        }
        for (Struct protocol : Result.getMap(this.result.classes, Struct.Type.ObjCProtocol).values()) {
            for (String parent : ObjectiveCGenerator.getForcedProtocolParents(String.valueOf(protocol.getTag()))) {
                protocol.addParent(ElementsHelper.ident(parent));
            }
            this.outputObjectiveCClass(protocol);
        }
    }

    public void outputObjectiveCClass(Struct in) throws IOException {
        Identifier fullClassName = this.getFullClassName(in);
        Signatures signatures = new Signatures();
        Struct s = this.generateObjectiveCClass(in, signatures);
        this.result.notifyBeforeWritingClass(fullClassName, s, signatures, this.result.getLibrary(in));
        PrintWriter out = this.result.classOutputter.getClassSourceWriter(fullClassName.toString());
        this.result.printJavaClass(this.getPackageName(in), s, out);
        out.close();
    }

    public Struct generateObjectiveCClass(Struct in, Signatures signatures) throws IOException {
        Struct structThatReceivesStaticMethods;
        Function classGetter;
        boolean isInterface;
        boolean isProtocol = in.getType() == Struct.Type.ObjCProtocol;
        boolean isCategory = in.getCategoryName() != null;
        Struct instanceStruct = new Struct().addModifiers(Modifier.Public);
        instanceStruct.setCommentBefore(in.getCommentBefore());
        instanceStruct.addToCommentBefore(in.getCommentAfter());
        instanceStruct.setTag(isCategory ? ElementsHelper.ident(in.getCategoryName()) : in.getTag().clone());
        if (isProtocol || isCategory) {
            instanceStruct.setType(Struct.Type.JavaInterface);
        } else {
            instanceStruct.addModifiers(Modifier.Abstract).setType(Struct.Type.JavaClass);
        }
        Struct classStruct = new Struct();
        classStruct.setTag(ElementsHelper.ident(this.classClassName));
        classStruct.setType(Struct.Type.JavaClass);
        classStruct.addModifiers(Modifier.Public, Modifier.Static, Modifier.Abstract);
        ArrayList<TypeRef.SimpleTypeRef> interfacesForInstance = new ArrayList<TypeRef.SimpleTypeRef>();
        ArrayList<TypeRef.SimpleTypeRef> parentsForInstance = new ArrayList<TypeRef.SimpleTypeRef>(in.getParents());
        boolean isNSObject = in.getTag().equals(NSObject.class.getSimpleName());
        if (!isCategory && !isProtocol) {
            for (Struct catIn : Result.getMap(this.result.objCCategoriesByTargetType, in.getTag()).values()) {
                Identifier identifier = this.getFullClassName(catIn);
                Identifier.SimpleIdentifier sim = identifier.resolveLastSimpleIdentifier();
                String categName = catIn.getTag() + "_" + sim;
                if (this.add(instanceStruct, this.createCastMethod(ElementsHelper.ident(categName), identifier, false), signatures, new Set[0])) {
                    classStruct.addDeclaration(this.createCastMethod(ElementsHelper.ident(categName), ElementsHelper.ident(identifier, this.classInterfaceNameInCategoriesAndProtocols), true));
                }
                this.outputObjectiveCClass(catIn);
            }
        }
        for (TypeRef.SimpleTypeRef sp : parentsForInstance) {
            Identifier id;
            Identifier identifier = sp.getName();
            String ps = identifier.toString();
            boolean basic = ps.toString().equals(ObjCObject.class.getName()) || ps.equals(NSObject.class.getName());
            Identifier identifier2 = id = basic ? identifier : this.result.typeConverter.findObjCClassIdent(identifier);
            if (id == null && (identifier.isPlain() || (id = identifier) == null)) continue;
            if (ps.toString().equals("NSObject")) {
                instanceStruct.addProtocol(ElementsHelper.ident(ObjCObject.class, new Expression[0]));
            } else {
                instanceStruct.addParent(id.clone());
            }
            if (basic) continue;
            classStruct.addParent(ElementsHelper.ident(id, this.classClassName));
        }
        boolean bl = isInterface = isProtocol || isCategory;
        if (instanceStruct.getParents().isEmpty()) {
            if (isInterface) {
                instanceStruct.addParent(ElementsHelper.ident(ObjCObject.class, new Expression[0]));
            } else if (isNSObject) {
                instanceStruct.addProtocol(ElementsHelper.ident(ObjCObject.class, new Expression[0]));
            } else {
                instanceStruct.addParent(ElementsHelper.ident(NSObject.class, new Expression[0]));
            }
        }
        if (classStruct.getParents().isEmpty()) {
            if (isNSObject) {
                classStruct.addParent(ElementsHelper.ident(NSClass.class, new Expression[0]));
            } else {
                classStruct.addParent(ElementsHelper.ident(ElementsHelper.ident(NSObject.class, new Expression[0]), this.classClassName));
            }
        }
        for (TypeRef.SimpleTypeRef simpleTypeRef : in.getProtocols()) {
            Identifier id = this.getFullClassName(this.getStruct(simpleTypeRef.getName(), Struct.Type.ObjCProtocol));
            if (id == null) continue;
            interfacesForInstance.add(ElementsHelper.typeRef(id));
        }
        for (TypeRef.SimpleTypeRef simpleTypeRef : interfacesForInstance) {
            if (isProtocol || isCategory) {
                instanceStruct.addParent(simpleTypeRef);
                continue;
            }
            instanceStruct.addProtocol(simpleTypeRef);
        }
        VariablesDeclaration classHolder = new VariablesDeclaration();
        if (!isProtocol && !isCategory) {
            ((ModifiableElement)classHolder).addModifiers(Modifier.Private, Modifier.Static);
        }
        classHolder.setValueType(ElementsHelper.typeRef(this.classClassName));
        Expression.FunctionCall functionCall = ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(Rococoa.class)), Expression.MemberRefStyle.Dot, "createClass", new Expression[0]);
        functionCall.addArgument(ElementsHelper.expr(in.getTag().toString()));
        functionCall.addArgument(ElementsHelper.memberRef(ElementsHelper.expr(ElementsHelper.typeRef(this.classClassName)), Expression.MemberRefStyle.Dot, "class"));
        if (isProtocol || isCategory) {
            classGetter = null;
            classHolder.addDeclarator(new Declarator.DirectDeclarator(this.classInstanceName, functionCall));
        } else {
            classHolder.addDeclarator(new Declarator.DirectDeclarator(this.classInstanceName));
            classGetter = new Function(Function.Type.JavaMethod, ElementsHelper.ident(this.classInstanceGetterName), ElementsHelper.typeRef(this.classClassName));
            classGetter.addModifiers(Modifier.Public, Modifier.Static);
            classGetter.setBody(new Statement.Block(new Statement.If(ElementsHelper.expr(ElementsHelper.varRef(this.classInstanceName), Expression.BinaryOperator.IsEqual, (Expression)new Expression.Constant(Expression.Constant.Type.Null, null)), new Statement.ExpressionStatement(new Expression.AssignmentOp(ElementsHelper.varRef(this.classInstanceName), Expression.AssignmentOperator.Equal, functionCall)), null), new Statement.Return(ElementsHelper.varRef(this.classInstanceName))));
        }
        Struct classInterfaceStruct = null;
        if (isProtocol || isCategory) {
            structThatReceivesStaticMethods = classInterfaceStruct = new Struct();
            classInterfaceStruct.setType(Struct.Type.JavaInterface);
            classInterfaceStruct.setTag(ElementsHelper.ident(this.classInterfaceNameInCategoriesAndProtocols));
            classInterfaceStruct.addParent(ElementsHelper.ident(ObjCClass.class, new Expression[0]));
            classStruct.addProtocol(ElementsHelper.ident(this.classInterfaceNameInCategoriesAndProtocols));
        } else {
            structThatReceivesStaticMethods = classStruct;
        }
        if (!isProtocol && !isCategory) {
            this.addAllocIfMissing(in, "alloc");
            this.addAllocIfMissing(in, "new_");
        }
        this.outputMembers(signatures, in, instanceStruct, structThatReceivesStaticMethods, in.getDeclarations(), isProtocol || isCategory);
        Identifier fullClassName = this.getFullClassName(in);
        instanceStruct.addDeclaration(ElementsHelper.decl(classInterfaceStruct));
        if (!isCategory) {
            instanceStruct.addDeclaration(new TaggedTypeRefDeclaration(classStruct));
            instanceStruct.addDeclaration(classGetter);
            instanceStruct.addDeclaration(classHolder);
        }
        return instanceStruct;
    }

    Function createCastMethod(Identifier name, Identifier classId, boolean isStatic) {
        Function m = new Function();
        m.setType(Function.Type.JavaMethod);
        m.addModifiers(Modifier.Public);
        m.setName(ElementsHelper.ident("as" + (isStatic ? "Static_" : "_") + name));
        m.setValueType(ElementsHelper.typeRef(classId.clone()));
        m.setBody(ElementsHelper.block(new Statement.Return(ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(Rococoa.class)), Expression.MemberRefStyle.Dot, "cast", ElementsHelper.varRef("this"), this.result.typeConverter.typeLiteral(ElementsHelper.typeRef(classId.clone()))))));
        return m;
    }

    private void addAllocIfMissing(Struct in, String allocName) {
        Identifier n = in.getTag();
        if (n.equals("NSObject") || n.equals("NSClass")) {
            return;
        }
        boolean hasAlloc = false;
        for (Declaration d : in.getDeclarations()) {
            Function f;
            if (!(d instanceof Function) || !(f = (Function)d).getArgs().isEmpty() || !allocName.equals(f.getName())) continue;
            hasAlloc = true;
            break;
        }
        if (!hasAlloc) {
            in.addDeclaration(new Function(Function.Type.ObjCMethod, ElementsHelper.ident(allocName), ElementsHelper.typeRef(in.getTag())).addModifiers(Modifier.Static));
        }
    }

    private void outputMembers(Signatures signatures, Struct in, Struct instanceStruct, Struct classStruct, List<Declaration> declarations, boolean isProtocol) throws IOException {
        Identifier fullClassName = this.getFullClassName(in);
        Set<String> objSigs = DeclarationsConverter.getMethodsAndTheirSignatures(NSObject.class).getSecond();
        HashSet clasSigs = new HashSet();
        int[] iChild = new int[1];
        for (Declaration d : declarations) {
            if (d instanceof Function) {
                Function f = (Function)d;
                ArrayList<Declaration> decls = new ArrayList<Declaration>();
                this.result.declarationsConverter.convertFunction(f, null, false, new DeclarationsHolder.ListWrapper(decls), fullClassName);
                if (Modifier.Static.isContainedBy(f.getModifiers())) {
                    for (Declaration decl : decls) {
                        if (!this.add(classStruct, decl, signatures, objSigs, clasSigs)) continue;
                        if (!isProtocol && decl instanceof Function) {
                            instanceStruct.addDeclaration(this.createProxyCopy(f, (Function)decl));
                            signatures.methodsSignatures.add(((Function)decl).computeSignature(false));
                        }
                        if (classStruct.getType() != Struct.Type.JavaClass) continue;
                        decl.addModifiers(Modifier.Public, Modifier.Abstract);
                        decl.reorganizeModifiers();
                    }
                } else {
                    for (Declaration decl : decls) {
                        if (!this.add(instanceStruct, decl, signatures, objSigs) || isProtocol || !(decl instanceof Function)) continue;
                        Function addedF = this.createCreateCopyFromInit((Function)decl, instanceStruct);
                        signatures.methodsSignatures.add(((Function)decl).computeSignature(false));
                        instanceStruct.addDeclaration(addedF);
                        if (instanceStruct.getType() != Struct.Type.JavaClass) continue;
                        decl.addModifiers(Modifier.Public, Modifier.Abstract);
                        decl.reorganizeModifiers();
                    }
                }
            } else if (d instanceof TaggedTypeRefDeclaration) {
                TypeRef.TaggedTypeRef tr = ((TaggedTypeRefDeclaration)d).getTaggedTypeRef();
                if (tr instanceof Struct) {
                    this.result.declarationsConverter.outputConvertedStruct((Struct)tr, signatures, instanceStruct, fullClassName, false);
                } else if (tr instanceof Enum) {
                    this.result.declarationsConverter.convertEnum((Enum)tr, signatures, instanceStruct, fullClassName);
                }
            } else if (d instanceof StoredDeclarations.TypeDef) {
                StoredDeclarations.TypeDef td = (StoredDeclarations.TypeDef)d;
                TypeRef tr = td.getValueType();
                if (tr instanceof Struct) {
                    this.result.declarationsConverter.outputConvertedStruct((Struct)tr, signatures, instanceStruct, fullClassName, false);
                } else if (tr instanceof TypeRef.FunctionSignature) {
                    this.result.declarationsConverter.convertCallback((TypeRef.FunctionSignature)tr, signatures, instanceStruct, fullClassName);
                }
            }
            iChild[0] = iChild[0] + 1;
        }
    }

    private boolean add(Struct classStruct, Declaration decl, Signatures signatures, Set<?> ... additionalMethodSignatures) {
        if (decl instanceof Function) {
            String sig = ((Function)decl).computeSignature(false);
            for (Set<?> sigs : additionalMethodSignatures) {
                if (!sigs.contains(sig)) continue;
                return false;
            }
            if (signatures.methodsSignatures.add(sig)) {
                classStruct.addDeclaration(decl);
                return true;
            }
            return false;
        }
        classStruct.addDeclaration(decl);
        return true;
    }

    private Function createCreateCopyFromInit(Function meth, TypeRef.TaggedTypeRef instanceStruct) {
        String name = meth.getName().toString();
        if (!name.matches("^init([A-Z].*|)$")) {
            return null;
        }
        Function createCopy = meth.clone();
        createCopy.setCommentBefore("Factory method");
        createCopy.addToCommentBefore("@see #" + meth.computeSignature(false));
        createCopy.setName(ElementsHelper.ident("create" + name.substring("init".length())));
        createCopy.addModifiers(Modifier.Public, Modifier.Static);
        createCopy.reorganizeModifiers();
        Expression[] args = new Expression[meth.getArgs().size()];
        int i = 0;
        for (Arg arg : meth.getArgs()) {
            args[i++] = ElementsHelper.varRef(arg.getName());
        }
        Expression.FunctionCall val = ElementsHelper.methodCall((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.methodCall(null, null, this.classInstanceGetterName, new Expression[0]), Expression.MemberRefStyle.Dot, "alloc", new Expression[0]), Expression.MemberRefStyle.Dot, meth.getName().toString(), args);
        if (this.AUTO_RELEASE_IN_FACTORIES) {
            val = ElementsHelper.methodCall((Expression)val, Expression.MemberRefStyle.Dot, "autorelease", new Expression[0]);
            val = ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(Rococoa.class)), Expression.MemberRefStyle.Dot, "cast", val, ElementsHelper.memberRef(ElementsHelper.expr(ElementsHelper.typeRef(instanceStruct.getTag())), Expression.MemberRefStyle.Dot, "class"));
        }
        createCopy.setBody(new Statement.Block(new Statement.Return(val)));
        return createCopy;
    }

    private Function createProxyCopy(Function originalMethod, Function meth) {
        if (ObjectiveCGenerator.isMethodExcludedFromStaticForwarding(originalMethod)) {
            return null;
        }
        Function proxyCopy = meth.clone();
        proxyCopy.addModifiers(Modifier.Public, Modifier.Static);
        proxyCopy.reorganizeModifiers();
        Expression[] args = new Expression[meth.getArgs().size()];
        int i = 0;
        for (Arg arg : meth.getArgs()) {
            args[i++] = ElementsHelper.varRef(arg.getName());
        }
        Expression.FunctionCall val = ElementsHelper.methodCall((Expression)ElementsHelper.methodCall(null, null, this.classInstanceGetterName, new Expression[0]), Expression.MemberRefStyle.Dot, meth.getName().toString(), args);
        proxyCopy.setBody(new Statement.Block(meth.getValueType() == null || "void".equals(meth.getValueType().toString()) ? ElementsHelper.stat(val) : new Statement.Return(val)));
        return proxyCopy;
    }

    static {
        NSObjectIdent = ElementsHelper.ident(NSObject.class, new Expression[0]);
        ObjCObjectIdent = ElementsHelper.ident(ObjCObject.class, new Expression[0]);
        ObjCClassIdent = ElementsHelper.ident(ObjCClass.class, new Expression[0]);
    }
}

