/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.SyntaxUtils;
import com.ochafik.lang.jnaerator.JNAeratorUtils;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierKind;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class MissingNamesChooser
extends Scanner {
    NameGenerationStyle nameGenerationStyle = NameGenerationStyle.PreserveCaseAndSeparateByUnderscores;
    Result result;
    Map<String, Integer> nextUnnamedId = new HashMap<String, Integer>();
    int nextAnonymous = 1;

    public MissingNamesChooser(Result result) {
        this.result = result;
    }

    public void setNameGenerationStyle(NameGenerationStyle nameGenerationStyle) {
        this.nameGenerationStyle = nameGenerationStyle;
    }

    public String chooseArgNameFromType(TypeRef tr) throws UnsupportedConversionException {
        if (tr instanceof TypeRef.SimpleTypeRef) {
            String out;
            Identifier name = ((TypeRef.SimpleTypeRef)tr).getName();
            out = MissingNamesChooser.isNull(name) ? ((out = StringUtils.implode(tr.getModifiers(), (Object)"")).length() > 0 ? out.substring(0, 1) : out) : name.toString();
            return out;
        }
        if (tr instanceof TypeRef.Pointer) {
            return this.chooseArgNameFromType(((TypeRef.Pointer)tr).getTarget()) + "Ptr";
        }
        if (tr instanceof TypeRef.ArrayRef) {
            return this.chooseArgNameFromType(((TypeRef.ArrayRef)tr).getTarget()) + "Arr";
        }
        throw new UnsupportedConversionException(tr, String.valueOf(tr));
    }

    @Override
    public void visitFunction(Function function) {
        switch (function.getType()) {
            case CFunction: 
            case CppMethod: {
                TreeSet<String> names = new TreeSet<String>();
                ArrayList<Pair<Arg, Integer>> missing = new ArrayList<Pair<Arg, Integer>>();
                int i = 0;
                for (Arg arg : function.getArgs()) {
                    if (arg.getName() == null) {
                        missing.add(new Pair<Arg, Integer>(arg, i));
                    } else {
                        names.add(arg.getName());
                    }
                    ++i;
                }
                for (Pair pair : missing) {
                    String name;
                    String base;
                    i = 1;
                    try {
                        base = this.chooseArgNameFromType(((Arg)pair.getFirst()).getValueType());
                    }
                    catch (UnsupportedConversionException ex) {
                        base = "arg";
                    }
                    while (names.contains(name = base + i)) {
                        ++i;
                    }
                    names.add(name);
                    ((Arg)pair.getFirst()).setName(name);
                }
                break;
            }
        }
        super.visitFunction(function);
    }

    static boolean isNull(Identifier i) {
        return i == null || i.resolveLastSimpleIdentifier() == null || i.resolveLastSimpleIdentifier().getName() == null;
    }

    @Override
    public void visitFunctionSignature(TypeRef.FunctionSignature functionSignature) {
        Identifier origName;
        Identifier identifier = origName = functionSignature.getFunction() == null ? null : functionSignature.getFunction().getName();
        if (!this.chooseNameIfMissing(functionSignature)) {
            super.visitFunctionSignature(functionSignature);
        }
        DeclarationsHolder holder = functionSignature.findParentOfType(DeclarationsHolder.class);
        Function f = functionSignature.getFunction();
        if (holder != null && f != null && !MissingNamesChooser.isNull(f.getName())) {
            Identifier fnameClone = f.getName().clone();
            StoredDeclarations d = SyntaxUtils.as(functionSignature.getParentElement(), StoredDeclarations.class);
            if (d instanceof StoredDeclarations.TypeDef) {
                return;
            }
            if (d != null && d.getDeclarators().isEmpty()) {
                if (d instanceof VariablesDeclaration) {
                    VariablesDeclaration pvd = (VariablesDeclaration)d;
                    pvd.addDeclarator(new Declarator.DirectDeclarator((origName == null ? fnameClone : origName).toString()));
                    functionSignature.replaceBy(new TypeRef.SimpleTypeRef(fnameClone));
                } else {
                    d.replaceBy(null);
                }
            } else {
                functionSignature.replaceBy(new TypeRef.SimpleTypeRef(fnameClone.clone()));
            }
            StoredDeclarations.TypeDef td = new StoredDeclarations.TypeDef();
            td.importDetails(functionSignature, true);
            td.setValueType(functionSignature);
            td.addDeclarator(new Declarator.DirectDeclarator(fnameClone.toString()));
            holder.addDeclaration(td);
            td.accept(this);
        }
    }

    static boolean isUnnamed(TaggedTypeRefDeclaration d) {
        return d != null && d.getTaggedTypeRef() != null && MissingNamesChooser.isNull(d.getTaggedTypeRef().getTag());
    }

    @Override
    public void visitTaggedTypeRef(TypeRef.TaggedTypeRef taggedTypeRef) {
        DeclarationsHolder holder;
        super.visitTaggedTypeRef(taggedTypeRef);
        this.chooseNameIfMissing(taggedTypeRef);
        Element parent = taggedTypeRef.getParentElement();
        if (!(parent instanceof TaggedTypeRefDeclaration || parent instanceof StoredDeclarations.TypeDef || (holder = taggedTypeRef.findParentOfType(DeclarationsHolder.class)) == null || holder == taggedTypeRef.getParentElement() || parent instanceof DeclarationsHolder)) {
            TaggedTypeRefDeclaration td = new TaggedTypeRefDeclaration();
            if (parent instanceof VariablesDeclaration && ((VariablesDeclaration)parent).getDeclarators().isEmpty()) {
                taggedTypeRef.importDetails(parent, false);
                parent.replaceBy(null);
            } else {
                TypeRef.SimpleTypeRef tr = new TypeRef.SimpleTypeRef(taggedTypeRef.getTag().clone());
                for (Modifier mod : taggedTypeRef.getModifiers()) {
                    if (!mod.isA(ModifierKind.StorageClassSpecifier)) continue;
                    ((TypeRef)tr).addModifiers(mod);
                }
                taggedTypeRef.replaceBy(tr);
                if (taggedTypeRef instanceof Struct) {
                    tr.setMarkedAsResolved(true);
                }
            }
            td.setTaggedTypeRef(taggedTypeRef);
            holder.addDeclaration(td);
            td.accept(this);
        }
    }

    private boolean chooseNameIfMissing(TypeRef.FunctionSignature functionSignature) {
        Function function = functionSignature.getFunction();
        if (function != null && (MissingNamesChooser.isNull(function.getName()) || functionSignature.getParentElement() instanceof VariablesDeclaration)) {
            String name = null;
            String exact = JNAeratorUtils.getExactTypeDefName(functionSignature);
            if (exact != null) {
                name = exact;
            } else {
                List<String> ownerNames = JNAeratorUtils.guessOwnerName(function);
                if (function.getName() != null) {
                    ownerNames.add(function.getName().toString());
                }
                name = this.chooseName(functionSignature, ownerNames);
            }
            if (name != null) {
                function.setName(ElementsHelper.ident(name));
                function.accept(this);
                return true;
            }
        }
        return false;
    }

    private boolean chooseNameIfMissing(TypeRef.TaggedTypeRef taggedTypeRef) {
        if (MissingNamesChooser.isNull(taggedTypeRef.getTag()) && !(taggedTypeRef.getParentElement() instanceof TaggedTypeRefDeclaration)) {
            Identifier tag = this.result.declarationsConverter.getActualTaggedTypeName(taggedTypeRef);
            if (MissingNamesChooser.isNull(tag)) {
                List<String> ownerNames = JNAeratorUtils.guessOwnerName(taggedTypeRef);
                tag = ElementsHelper.ident(this.chooseName(taggedTypeRef, ownerNames));
            }
            if (!MissingNamesChooser.isNull(tag)) {
                taggedTypeRef.setTag(tag.clone());
                return true;
            }
        }
        return false;
    }

    private int getNextUnnamedId(String type) {
        Integer i = this.nextUnnamedId.get(type);
        int unnamedId = i == null ? 1 : i;
        this.nextUnnamedId.put(type, unnamedId + 1);
        return unnamedId;
    }

    public String chooseName(Element e, List<String> ownerNames) {
        String s = this.chooseNameSuffix(e);
        if (s == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (ownerNames != null) {
            names.addAll(ownerNames);
        }
        if (ownerNames.isEmpty()) {
            return s + this.nextAnonymous++;
        }
        names.add(s);
        switch (this.nameGenerationStyle) {
            case Java: {
                return StringUtils.capitalize(ownerNames, "");
            }
            case PreserveCaseAndSeparateByUnderscores: {
                return StringUtils.implode(names, (Object)"_");
            }
        }
        throw new UnsupportedOperationException("Unknown name generation style " + (Object)((Object)this.nameGenerationStyle));
    }

    public String chooseNameSuffix(Element e) {
        if (e instanceof Struct) {
            Struct struct = (Struct)e;
            if (struct.getType() == Struct.Type.CStruct) {
                return "struct";
            }
            if (struct.getType() == Struct.Type.CUnion) {
                return "union";
            }
        } else {
            if (e instanceof Enum) {
                return "enum";
            }
            if (e instanceof TypeRef.FunctionSignature) {
                return "callback";
            }
        }
        return null;
    }

    static <T extends Element> T importDetails(T t, Element e, boolean move) {
        t.importDetails(e, move);
        return t;
    }

    public static enum NameGenerationStyle {
        Java,
        PreserveCaseAndSeparateByUnderscores;

    }
}

