/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.io.WriteText;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.PreprocessorUtils;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.parser.ObjCppLexer;
import com.ochafik.lang.jnaerator.parser.ObjCppParser;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.reflect.DebugUtils;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.RegexUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.anarres.cpp.LexerException;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;

public class JNAeratorParser {
    private static final boolean EASILY_DEBUGGABLE_BUT_FRAGILE_PARSING_MODE = false;

    private static List<Slice> cutSourceContentInSlices(String sourceContent, PrintStream originalOut) {
        StringBuffer currentEmptyLines = new StringBuffer();
        StringBuffer currentBuffer = new StringBuffer();
        boolean sliceGotContent = false;
        String[] lines = sourceContent.split("\n");
        int iLine = 0;
        int nLines = lines.length;
        int lastStart = 0;
        String lastFile = null;
        Pattern fileInLinePattern = Pattern.compile("\"([^\"]+)\"");
        ArrayList<Slice> slices = new ArrayList<Slice>(nLines / 10);
        for (String line : lines) {
            if (line.startsWith("#line")) {
                lastStart = iLine;
                lastFile = RegexUtils.findFirst(line, fileInLinePattern, 1);
                if (sliceGotContent) {
                    String content = currentBuffer.toString();
                    slices.add(new Slice(lastFile, lastStart, content));
                }
                currentBuffer.setLength(0);
                sliceGotContent = false;
            }
            if (!sliceGotContent) {
                sliceGotContent = line.trim().length() > 0;
            }
            currentBuffer.append(line);
            currentBuffer.append('\n');
            currentEmptyLines.append('\n');
            ++iLine;
        }
        if (sliceGotContent) {
            String content = currentBuffer.toString();
            slices.add(new Slice(lastFile, lastStart, content));
        }
        return slices;
    }

    private static void parseSlices(final JNAeratorConfig config, final TypeConversion typeConverter, SourceFiles sourceFilesOut, List<Slice> slices, PrintStream originalOut, PrintStream originalErr, boolean multithreaded) throws InterruptedException {
        class ResultCountHolder {
            volatile int nSlicesParsed = 0;

            ResultCountHolder() {
            }
        }
        final ResultCountHolder resultCountHolder = new ResultCountHolder();
        ArrayList<Pair<Slice, Future<SourceFile>>> sourceFileFutures = new ArrayList<Pair<Slice, Future<SourceFile>>>(slices.size());
        final Set topLevelTypeDefs = Collections.synchronizedSet(new HashSet());
        ExecutorService executorService = Executors.newFixedThreadPool(multithreaded ? Runtime.getRuntime().availableProcessors() * 2 : 1);
        for (final Slice slice : slices) {
            sourceFileFutures.add(new Pair<Slice, Future<SourceFile>>(slice, executorService.submit(new Callable<SourceFile>(){
                {
                }

                @Override
                public SourceFile call() throws Exception {
                    try {
                        SourceFile sourceFile;
                        ObjCppParser parser = JNAeratorParser.newObjCppParser(typeConverter, slice.text, config.verbose);
                        parser.topLevelTypeIdentifiers = topLevelTypeDefs;
                        SourceFile sourceFile2 = sourceFile = parser.sourceFile();
                        return sourceFile2;
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        throw new Exception(ex);
                    }
                    finally {
                        ++resultCountHolder.nSlicesParsed;
                    }
                }
            })));
        }
        if (slices.isEmpty()) {
            originalOut.println("Slices are empty with the following config : \n" + DebugUtils.toString(config));
        } else {
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            for (Pair pair : sourceFileFutures) {
                try {
                    sourceFilesOut.add((SourceFile)((Future)pair.getSecond()).get(1000L, TimeUnit.MILLISECONDS));
                }
                catch (ExecutionException e) {
                    originalErr.println("Exception for " + ((Slice)pair.getFirst()).file + " at line " + ((Slice)pair.getFirst()).line + ":" + e);
                    e.printStackTrace(originalErr);
                }
                catch (TimeoutException e) {
                    originalErr.println("TIMEOUT for " + ((Slice)pair.getFirst()).file + " at line " + ((Slice)pair.getFirst()).line + ".");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SourceFiles parse(JNAeratorConfig config, TypeConversion typeConverter, PreprocessorUtils.MacroUseCallback macrosDependenciesOut) throws IOException, LexerException {
        SourceFiles sourceFiles = new SourceFiles();
        String sourceContent = PreprocessorUtils.preprocessSources(config, sourceFiles.defines, config.verbose, typeConverter, macrosDependenciesOut);
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        System.setOut(pout);
        System.setErr(pout);
        try {
            List<Slice> slices = JNAeratorParser.cutSourceContentInSlices(sourceContent, originalOut);
            if (config.verbose) {
                originalOut.println("Now parsing " + slices.size() + " text blocks");
            }
            JNAeratorParser.parseSlices(config, typeConverter, sourceFiles, slices, originalOut, originalErr, false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            pout.flush();
            System.setOut(originalOut);
            System.setErr(originalErr);
            String errs = new String(bout.toByteArray()).trim();
            if (errs.length() > 0 && config.verbose) {
                WriteText.writeText(errs, new File("out.errors.txt"));
            }
        }
        return sourceFiles;
    }

    static ObjCppParser newObjCppParser(TypeConversion typeConverter, String s, final boolean verbose) throws IOException {
        ObjCppParser parser = new ObjCppParser((TokenStream)new CommonTokenStream(new ObjCppLexer(new ANTLRReaderStream(new StringReader(s))))){

            @Override
            public void reportError(RecognitionException arg0) {
                if (verbose) {
                    super.reportError(arg0);
                }
            }
        };
        parser.setupSymbolsStack();
        parser.objCParserHelper = typeConverter;
        return parser;
    }

    static class Slice {
        public String file;
        public int line;
        public String text;

        public Slice(String file, int line, String text) {
            this.file = file;
            this.line = line;
            this.text = text;
        }
    }
}

