/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.JNAeratorConfigUtils;
import com.ochafik.lang.jnaerator.cplusplus.CPlusPlusMangler;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.runtime.Bits;
import com.ochafik.lang.jnaerator.runtime.Structure;
import com.ochafik.lang.jnaerator.runtime.Union;
import com.ochafik.util.CompoundCollection;
import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.listenable.Filter;
import com.ochafik.util.listenable.Pair;
import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bridj.Pointer;
import org.bridj.ann.Array;

public class JNAeratorConfig {
    public static final String DEFAULT_HEADER_EXTENSIONS = "h:hpp:hxx";
    public static final String DEFAULT_IMPLEMS_EXTENSIONS = "cpp:c:cxx:m:mm";
    public final EnumSet<GenFeatures> features = EnumSet.allOf(GenFeatures.class);
    public final List<CPlusPlusMangler> cPlusPlusManglers = new ArrayList<CPlusPlusMangler>();
    public Runtime runtime = Runtime.DEFAULT;
    public final PreprocessorConfig preprocessorConfig = new PreprocessorConfig();
    public boolean followIncludes = false;
    public File preprocessingOutFile;
    public File macrosOutFile;
    public File choicesOutFile;
    public File choicesInputFile;
    public boolean useJNADirectCalls = false;
    public boolean limitComments = false;
    public boolean noComments = false;
    public boolean putTopStructsInSeparateFiles = true;
    public boolean bundleRuntime = true;
    public boolean beautifyNames = false;
    public String[] libraryNamingPrefixes;
    public boolean extractLibSymbols = false;
    public List<Pair<MessageFormat, MessageFormat>> onlineDocumentationURLFormats = new ArrayList<Pair<MessageFormat, MessageFormat>>();
    public String entryName;
    public int maxConstructedFields = 10;
    public boolean beanStructs;
    public boolean reification = false;
    public Map<String, String> extraJavaSourceFilesContents = new LinkedHashMap<String, String>();
    public Set<String> frameworks = new LinkedHashSet<String>();
    boolean skipIncludedFrameworks = false;
    public FileFilter fileFilter = new JNAeratorConfigUtils.FileExtensionFilter("h:hpp:hxx".split("[:;]"));
    public Map<String, List<File>> libraryFilesByArch = new LinkedHashMap<String, List<File>>();
    public List<File> libraryFiles = new ArrayList<File>();
    public Map<File, String> libraryByFile = new LinkedHashMap<File, String>();
    public boolean verbose = false;
    public File outputDir;
    public List<String> rootDirectoriesPrefixesForSourceComments = new ArrayList<String>();
    public Adapter<Function, Boolean> functionsAccepter;
    public String packageName = null;
    public String rootPackageName = null;
    public String defaultLibrary;
    public Map<String, File> libraryProjectSources = new LinkedHashMap<String, File>();
    public Adapter<File, String> fileToLibrary = new Adapter<File, String>(){

        @Override
        public String adapt(File value) {
            String libraryFile = null;
            try {
                libraryFile = JNAeratorConfig.this.libraryByFile.get(value.getCanonicalFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return libraryFile == null ? JNAeratorConfig.this.defaultLibrary : libraryFile;
        }
    };
    public Filter<Element> symbolsAccepter = new Filter<Element>(){

        @Override
        public boolean accept(Element value) {
            String s = Element.getFileOfAscendency(value);
            if (s == null) {
                return false;
            }
            File f = new File(s);
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return JNAeratorConfig.this.libraryByFile.containsKey(f);
        }
    };
    public String libraryForElementsInNullFile;
    public String cPlusPlusNameSpaceSeparator = "_";
    public boolean preferJavac = false;
    public Set<File> bridgeSupportFiles = new LinkedHashSet<File>();
    public File outputJar;
    public File cacheDir;
    public boolean autoConf = true;
    public Set<String> undefines = new HashSet<String>();
    public boolean gccLong = false;
    public boolean sizeAsLong = false;
    public boolean compile = true;
    public boolean noAutoImports = false;
    public boolean bundleSources = true;
    public boolean noCPlusPlus;
    Set<File> sourceFiles = new LinkedHashSet<File>();
    public boolean bundleLibraries = true;
    public boolean wcharAsShort = false;
    public boolean charPtrAsString = false;
    public boolean genCPlusPlus = false;
    public File extractedSymbolsOut;
    public boolean stringifyConstCStringReturnValues = true;
    public File bridgesupportOutFile;
    public boolean noMangling;
    public boolean scalaStructSetters;
    public boolean noPrimitiveArrays;
    public boolean synchronizedMethods;
    public File scalaOut;
    public boolean skipPrivateMembers = true;
    public File rawParsedSourcesOutFile;
    public File normalizedParsedSourcesOutFile;
    public boolean skipLibraryInstanceDeclarations;
    public String callbackInvokeMethodName = "apply";

    public void addLibraryFile(File file, String arch) {
        String fn;
        int i;
        List<File> others = this.libraryFilesByArch.get(arch);
        if (others == null) {
            others = new ArrayList<File>();
            this.libraryFilesByArch.put(arch, others);
        }
        if ((i = (fn = file.getName()).lastIndexOf(46)) > 0) {
            fn = fn.substring(0, i);
        }
        others.add(file);
        this.libraryByFile.put(file, fn);
        this.libraryFiles.add(file);
    }

    public void addSourceFile(File file, String library, boolean applyFilters, boolean retainAsTarget) throws IOException {
        block4: {
            block3: {
                if (!file.isFile()) break block3;
                if (this.fileFilter != null && applyFilters && !this.fileFilter.accept(file)) break block4;
                file = file.getCanonicalFile();
                if (library == null && this.fileToLibrary != null) {
                    library = this.fileToLibrary.adapt(file);
                }
                this.sourceFiles.add(file);
                if (!retainAsTarget) break block4;
                this.libraryByFile.put(file, library);
                break block4;
            }
            File[] fs = file.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    this.addSourceFile(f, library, true, retainAsTarget);
                }
            }
        }
    }

    public void addRootDir(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        String str = dir.getCanonicalPath();
        if (!str.endsWith(File.separator)) {
            str = str + File.separator;
        }
        if (!this.rootDirectoriesPrefixesForSourceComments.contains(str)) {
            this.rootDirectoriesPrefixesForSourceComments.add(str);
        }
    }

    public Set<String> getLibraries() {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<File, String> e : this.libraryByFile.entrySet()) {
            if (e.getValue() == null) continue;
            ret.add(e.getValue());
        }
        return ret;
    }

    public String getLibrary(String elementFile) {
        if (elementFile == null) {
            return this.libraryForElementsInNullFile;
        }
        return this.fileToLibrary == null ? this.defaultLibrary : this.fileToLibrary.adapt(new File(elementFile));
    }

    public Collection<File> getFiles() {
        return this.sourceFiles;
    }

    public String relativizeFileForSourceComments(String path) {
        if (path == null) {
            return null;
        }
        for (String pref : this.rootDirectoriesPrefixesForSourceComments) {
            if (!path.startsWith(pref)) continue;
            path = path.substring(pref.length());
            break;
        }
        return path;
    }

    public Collection<File> getInputFiles() {
        return new CompoundCollection<File>(this.sourceFiles, this.bridgeSupportFiles, this.libraryFiles);
    }

    public static class PreprocessorConfig {
        public boolean WORKAROUND_PP_BUGS = true;
        public final List<String> includes = new ArrayList<String>();
        public final Map<String, String> macros = new LinkedHashMap<String, String>();
        public final List<String> frameworksPath = new ArrayList<String>();
        public List<String> includeStrings = new ArrayList<String>();
        public boolean preprocess = true;
    }

    public static enum GenFeatures {
        Compile,
        FileComments,
        UsageComments,
        EnumTypeLocationComments,
        LibrariesAutoExtraction,
        CPlusPlusMangling,
        StructConstructors,
        TypedPointersForForwardDeclarations,
        OriginalFunctionSignatures,
        FunctionArgsJavaDoc;

    }

    public static enum Runtime {
        JNA(false, true, false, Callback.class, com.sun.jna.Pointer.class, Memory.class, com.sun.jna.Structure.class, com.sun.jna.Union.class, null, null, Library.class, null, "jna-runtime.jar.files"),
        JNAerator(false, true, true, (Class)Callback.class, (Class)com.sun.jna.Pointer.class, (Class)Memory.class, (Class)Structure.class, (Class)Union.class, null, null, (Class)Library.class, Bits.class, "jnaerator-runtime.jar.files"){

            public String toString() {
                return "JNAerator (based on JNA)";
            }
        }
        ,
        BridJ(true, false, true, (Class)org.bridj.Callback.class, (Class)Pointer.class, null, null, null, null, (Class)Pointer.class, null, org.bridj.ann.Bits.class, "bridj.jar.files"){

            public String toString() {
                return "BridJ (experimental dyncall-based runtime)";
            }
        };

        public static final Runtime DEFAULT;
        public final String runtimeFilesListFileName;
        private String annotationPackage;
        public final Class callbackClass;
        public final Class pointerClass;
        public final Class memoryClass;
        public final Class structClass;
        public final Class unionClass;
        public final Class structIOClass;
        public final Class arrayClass;
        public final Class libraryClass;
        public final boolean hasFastStructs;
        public final boolean hasJNA;
        public final boolean hasBitFields;

        private Runtime(boolean hasFastStructs, boolean hasJNA, boolean hasBitFields, Class<?> callbackClass, Class<?> pointerClass, Class<?> memoryClass, Class<?> structClass, Class<?> unionClass, Class<?> structIOClass, Class<?> arrayClass, Class<?> libraryClass, Class<? extends Annotation> someAnnotationClass, String runtimeFilesListFileName) {
            this.hasFastStructs = hasFastStructs;
            this.hasBitFields = hasBitFields;
            this.hasJNA = hasJNA;
            this.callbackClass = callbackClass;
            this.pointerClass = pointerClass;
            this.memoryClass = memoryClass;
            this.structClass = structClass;
            this.libraryClass = libraryClass;
            this.unionClass = unionClass;
            this.structIOClass = structIOClass;
            this.arrayClass = arrayClass;
            this.runtimeFilesListFileName = runtimeFilesListFileName;
            this.annotationPackage = someAnnotationClass == null ? null : someAnnotationClass.getPackage().getName();
        }

        public TypeRef.SimpleTypeRef typeRef(Ann ann) {
            if (this.annotationPackage == null) {
                return null;
            }
            String n = ann.toString();
            if (this == BridJ && ann == Ann.Length) {
                n = Array.class.getSimpleName();
            }
            ArrayList<String> elts = new ArrayList<String>();
            elts.addAll(Arrays.asList(this.annotationPackage.split("\\.")));
            elts.add(n);
            return this.annotationPackage == null ? null : ElementsHelper.typeRef(ElementsHelper.ident(elts.toArray(new String[elts.size()])));
        }

        static {
            DEFAULT = JNAerator;
        }

        public static enum Ann {
            Bits,
            FastCall,
            Mangling,
            ObjCBlock,
            This,
            ThisCall,
            Length,
            ByValue,
            Field,
            Virtual,
            Symbol,
            Name;

        }
    }

    public static enum Platform {
        Windows,
        Linux,
        MacOSX;

    }

    public static enum Architecture {
        x86_64,
        i386,
        PowerPC;

    }

    public static enum Compiler {
        GCC4,
        MSVC9;

    }
}

