/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.io.FileListUtils;
import com.ochafik.io.ReadText;
import com.ochafik.io.WriteText;
import com.ochafik.lang.compiler.CompilerUtils;
import com.ochafik.lang.compiler.MemoryFileManager;
import com.ochafik.lang.compiler.MemoryJavaFile;
import com.ochafik.lang.compiler.URLFileObject;
import com.ochafik.lang.jnaerator.BridgeSupportParser;
import com.ochafik.lang.jnaerator.CToJavaPreScanner;
import com.ochafik.lang.jnaerator.ClassOutputter;
import com.ochafik.lang.jnaerator.JNAeratorCommandLineArgs;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.JNAeratorConfigUtils;
import com.ochafik.lang.jnaerator.JNAeratorParser;
import com.ochafik.lang.jnaerator.JavaDocCreator;
import com.ochafik.lang.jnaerator.MissingNamesChooser;
import com.ochafik.lang.jnaerator.ObjectiveCToJavaPreScanner;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.ScalaGenerator;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.SimpleGUI;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.nativesupport.DllExport;
import com.ochafik.lang.jnaerator.nativesupport.NativeExportUtils;
import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierKind;
import com.ochafik.lang.jnaerator.parser.ObjCppLexer;
import com.ochafik.lang.jnaerator.parser.ObjCppParser;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.runtime.LibraryExtractor;
import com.ochafik.lang.jnaerator.runtime.MangledFunctionMapper;
import com.ochafik.lang.jnaerator.runtime.Mangling;
import com.ochafik.lang.jnaerator.studio.JNAeratorStudio;
import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.RegexUtils;
import com.ochafik.util.string.StringUtils;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.win32.StdCallLibrary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import org.anarres.cpp.LexerException;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.bridj.BridJ;
import org.bridj.TypedPointer;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;
import org.bridj.ann.Runtime;
import org.bridj.cpp.CPPRuntime;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSClass;

public class JNAerator {
    private static Pattern argTokenPattern = Pattern.compile("(?m)\"[^\"]*\"|[^\\s]+");
    private static Pattern argVariablePattern = Pattern.compile("\\$\\(([^)]+)\\)");
    protected final JNAeratorConfig config;
    static final Pattern definePattern = Pattern.compile("#\\s*define\\s+(\\w+)\\s+(.*)");
    static final boolean fullFilePathInComments = true;
    private static final String DEFAULT_CONFIG_FILE = "config.jnaerator";
    protected static final Pattern fileRadixPattern = Pattern.compile("(?:[/\\\\]|^)(.*?)(?:Full\\.bridgesupport|\\.[^.]+)$");
    private static final Pattern classAndMethodNamePattern = Pattern.compile("(.+?)::([^:]+)");
    Pattern rxObj1 = Pattern.compile("(\\w+)_([\\w_]+)_.*");

    private void privatize(Declaration d) {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>(d.getModifiers());
        modifiers.remove((Object)Modifier.Public);
        modifiers.remove((Object)Modifier.Protected);
        modifiers.add(0, Modifier.Private);
        d.setModifiers(modifiers);
    }

    public JNAerator(JNAeratorConfig config) {
        this.config = config;
    }

    public static String[] getJNAeratorArgsFromPref() {
        String argsPref = System.getProperty("jnaerator.args");
        if (argsPref == null) {
            return null;
        }
        return argsPref.split(",");
    }

    public static void main(String[] argsArray) {
        JNAerator.main(new JNAerator(new JNAeratorConfig()), argsArray);
    }

    public static void main(final JNAerator jnaerator, String[] argsArray) {
        try {
            String[] jnAeratorArgsFromPref = JNAerator.getJNAeratorArgsFromPref();
            if (jnAeratorArgsFromPref != null) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(jnAeratorArgsFromPref));
                list.addAll(Arrays.asList(argsArray));
                argsArray = list.toArray(new String[list.size()]);
            }
            if (argsArray.length == 0) {
                argsArray = new File(DEFAULT_CONFIG_FILE).exists() ? new String[]{"@", DEFAULT_CONFIG_FILE} : new String[]{"-studio"};
            }
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(argsArray));
            final JNAeratorConfig config = jnaerator.config;
            config.preprocessorConfig.frameworksPath.addAll(JNAeratorConfigUtils.DEFAULT_FRAMEWORKS_PATH);
            new JNAeratorCommandLineArgs.ArgsParser(){
                Feedback feedback = null;
                boolean simpleGUI = false;
                String arch = LibraryExtractor.getCurrentOSAndArchString();
                String currentLibrary = null;

                @Override
                List<String> parsed(JNAeratorCommandLineArgs.ArgsParser.ParsedArg a) throws Exception {
                    switch (a.def) {
                        case AddIncludePath: {
                            File includedFile = a.getFileParam(0);
                            if (includedFile.isFile()) {
                                this.parsedActualFile(includedFile, false);
                                break;
                            }
                            config.preprocessorConfig.includes.add(includedFile.toString());
                            break;
                        }
                        case CallbackInvokeName: {
                            config.callbackInvokeMethodName = a.getStringParam(0);
                            break;
                        }
                        case AddFrameworksPath: {
                            config.preprocessorConfig.frameworksPath.add(a.getFileParam(0).toString());
                            break;
                        }
                        case NoPreprocessing: {
                            config.preprocessorConfig.preprocess = false;
                            break;
                        }
                        case MaxConstructedFields: {
                            config.maxConstructedFields = a.getIntParam(0);
                            break;
                        }
                        case BeanStructs: {
                            config.beanStructs = true;
                            break;
                        }
                        case NoPrimitiveArrays: {
                            config.noPrimitiveArrays = true;
                            break;
                        }
                        case IfRegexMatch: {
                            String javaProperty = a.getStringParam(0);
                            String regex = a.getStringParam(1);
                            String thenCmd = a.getStringParam(2);
                            String elseCmd = a.getStringParam(3);
                            String propValue = System.getProperty(javaProperty);
                            if (propValue == null) {
                                propValue = "";
                            }
                            return Arrays.asList(propValue.matches(regex) ? thenCmd : elseCmd);
                        }
                        case AddRootDir: {
                            config.addRootDir(a.getFileParam("dir"));
                            break;
                        }
                        case NoAutoImports: {
                            config.noAutoImports = true;
                            break;
                        }
                        case NoCompile: {
                            config.compile = false;
                            break;
                        }
                        case SkipLibInstance: {
                            config.skipLibraryInstanceDeclarations = true;
                            break;
                        }
                        case NoStringReturns: {
                            config.stringifyConstCStringReturnValues = false;
                            break;
                        }
                        case SkipIncludedFrameworks: {
                            config.skipIncludedFrameworks = true;
                            break;
                        }
                        case GenPrivateMembers: {
                            config.skipPrivateMembers = false;
                            break;
                        }
                        case CPlusPlusGen: {
                            config.genCPlusPlus = true;
                            break;
                        }
                        case CurrentLibrary: {
                            this.currentLibrary = a.getStringParam(0);
                            break;
                        }
                        case CurrentPackage: {
                            config.packageName = a.getStringParam(0);
                            break;
                        }
                        case OnlineDocURLFormat: {
                            config.onlineDocumentationURLFormats.add(new Pair<MessageFormat, MessageFormat>(a.getMessageFormatParam(0), a.getMessageFormatParam(1)));
                            break;
                        }
                        case BeautifyNames: {
                            config.beautifyNames = true;
                            break;
                        }
                        case NoLibBundle: {
                            config.bundleLibraries = false;
                            break;
                        }
                        case DefaultLibrary: {
                            config.defaultLibrary = a.getStringParam(0);
                            break;
                        }
                        case RecursedExtensions: {
                            config.fileFilter = "*".equals(a.getStringParam(0)) ? null : new JNAeratorConfigUtils.FileExtensionFilter(a.getStringParam(0).split("[:;"));
                            break;
                        }
                        case DefineMacro: {
                            config.preprocessorConfig.macros.put(a.getStringParam(0), a.getStringParam(1));
                            break;
                        }
                        case Direct: {
                            config.useJNADirectCalls = true;
                            break;
                        }
                        case EntryName: {
                            config.entryName = a.getStringParam(0);
                            break;
                        }
                        case ExtractSymbols: {
                            config.extractLibSymbols = true;
                            break;
                        }
                        case Runtime: {
                            config.runtime = a.getEnumParam(0, JNAeratorConfig.Runtime.class);
                            break;
                        }
                        case LibFile: {
                            config.addLibraryFile(a.getFileParam(0), this.arch);
                            break;
                        }
                        case File: {
                            return this.parsedFile(a);
                        }
                        case FrameworksPath: {
                            config.preprocessorConfig.frameworksPath.clear();
                            config.preprocessorConfig.frameworksPath.addAll(Arrays.asList(a.getStringParam(0).split(":")));
                            break;
                        }
                        case GUI: {
                            this.simpleGUI = true;
                            break;
                        }
                        case Help: 
                        case WikiDoc: {
                            JNAeratorCommandLineArgs.displayHelp(a.def == JNAeratorCommandLineArgs.OptionDef.WikiDoc);
                            throw new ExitException(0);
                        }
                        case WCharAsShort: {
                            config.wcharAsShort = true;
                            break;
                        }
                        case Synchronized: {
                            config.synchronizedMethods = true;
                            break;
                        }
                        case JarOut: {
                            config.outputJar = a.getFileParam(0);
                            break;
                        }
                        case NoMangling: {
                            config.noMangling = true;
                            break;
                        }
                        case ScalaStructSetters: {
                            config.scalaStructSetters = true;
                            break;
                        }
                        case NoComments: {
                            config.noComments = true;
                            break;
                        }
                        case LimitComments: {
                            config.limitComments = true;
                            break;
                        }
                        case MacrosOut: {
                            config.macrosOutFile = a.getFileParam(0);
                            break;
                        }
                        case GCCLong: {
                            config.gccLong = true;
                            break;
                        }
                        case SizeAsLong: {
                            config.sizeAsLong = true;
                            break;
                        }
                        case Undefine: {
                            config.undefines.add(a.getStringParam(0));
                            break;
                        }
                        case NoAuto: {
                            config.autoConf = false;
                            break;
                        }
                        case Reification: {
                            config.reification = true;
                            break;
                        }
                        case NoCPP: {
                            config.noCPlusPlus = true;
                            break;
                        }
                        case ScalaOut: {
                            config.scalaOut = a.getFileParam(0);
                            break;
                        }
                        case NoRuntime: {
                            config.bundleRuntime = false;
                            break;
                        }
                        case OutputDir: {
                            config.outputDir = a.getFileParam(0);
                            break;
                        }
                        case LibraryNamingPrefixes: {
                            config.libraryNamingPrefixes = a.getStringParam(0).split(",");
                            break;
                        }
                        case PreferJavac: {
                            config.preferJavac = true;
                            break;
                        }
                        case BridgeSupportOutFile: {
                            config.bridgesupportOutFile = a.getFileParam(0);
                            break;
                        }
                        case ChoicesOut: {
                            config.choicesOutFile = a.getFileParam(0);
                            break;
                        }
                        case ChoicesIn: {
                            config.choicesInputFile = a.getFileParam(0);
                            break;
                        }
                        case PreprocessingOut: {
                            config.preprocessingOutFile = a.getFileParam(0);
                            break;
                        }
                        case ExtractionOut: {
                            config.extractedSymbolsOut = a.getFileParam(0);
                            break;
                        }
                        case Project: {
                            JNAeratorConfigUtils.readProjectConfig(a.getFileParam(0), a.getStringParam(1), config);
                            break;
                        }
                        case RootPackage: {
                            config.rootPackageName = a.getStringParam(0);
                            break;
                        }
                        case StructsInLibrary: {
                            config.putTopStructsInSeparateFiles = false;
                            break;
                        }
                        case Studio: {
                            try {
                                JNAeratorStudio.main(new String[0]);
                                return null;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                throw new ExitException(1);
                            }
                        }
                        case Verbose: {
                            config.verbose = true;
                            break;
                        }
                        case Framework: {
                            config.frameworks.add(a.getStringParam(0));
                            break;
                        }
                        case IncludeArgs: {
                            return this.parsedArgsInclude(a);
                        }
                        case Arch: {
                            this.arch = a.getStringParam(0).trim();
                            if (this.arch.length() != 0) break;
                            this.arch = null;
                        }
                    }
                    return Collections.emptyList();
                }

                private void parsedActualFile(File file, boolean retainAsTarget) throws Exception {
                    String lib = this.currentLibrary;
                    String fn = file.getName();
                    if (lib == null) {
                        String name = fn;
                        int i = name.indexOf(46);
                        if (i >= 0) {
                            name = name.substring(0, i).trim();
                        }
                        if (name.length() > 0) {
                            lib = name;
                        }
                        System.out.println("Warning: no -library option for file '" + fn + "', using \"" + lib + "\".");
                    }
                    config.addSourceFile(file, lib, !file.isFile(), retainAsTarget);
                }

                private List<String> parsedFile(JNAeratorCommandLineArgs.ArgsParser.ParsedArg a) throws Exception {
                    File file = a.getFileParam(0);
                    if (file != null) {
                        String fn = file.getName();
                        if (fn.startsWith("-") && !file.exists()) {
                            JNAeratorCommandLineArgs.displayHelp(false);
                            System.exit(1);
                        }
                        if (file.isDirectory() && fn.matches(".*\\.framework")) {
                            config.frameworks.add(file.toString());
                        } else {
                            if (file.isFile() && fn.matches(".*\\.jnaerator")) {
                                return this.parsedArgsInclude(a);
                            }
                            if (fn.matches(".*\\.bridgesupport")) {
                                config.bridgeSupportFiles.add(file);
                            } else if (file.isFile() && JNAerator.isLibraryFile(file)) {
                                if (config.verbose) {
                                    System.out.println("Adding file '" + file + "' for arch '" + this.arch + "'.");
                                }
                                config.addLibraryFile(file, this.arch);
                            } else {
                                String lib = this.currentLibrary;
                                if (file.isDirectory() && fn.endsWith(".xcode") || file.isFile() && fn.toLowerCase().endsWith(".sln")) {
                                    JNAeratorConfigUtils.readProjectConfig(file, null, config);
                                } else {
                                    this.parsedActualFile(file, true);
                                }
                            }
                        }
                    }
                    return Collections.emptyList();
                }

                private List<String> parsedArgsInclude(JNAeratorCommandLineArgs.ArgsParser.ParsedArg a) throws IOException {
                    final File argsFile = a.getFileParam(0);
                    String argsFileContent = ReadText.readText(argsFile);
                    Adapter<String[], String> argVariableReplacer = new Adapter<String[], String>(){

                        @Override
                        public String adapt(String[] value) {
                            String n = value[1];
                            String v = System.getProperty(n);
                            if (v == null) {
                                v = System.getenv(n);
                            }
                            if (v == null && n.equals("DIR")) {
                                v = argsFile.getAbsoluteFile().getParent();
                            }
                            return v;
                        }
                    };
                    argsFileContent = argsFileContent.replaceAll("http://", "http:\\\\");
                    argsFileContent = argsFileContent.replaceAll("(?m)//[^\n]*(\n|$)", "\n");
                    argsFileContent = argsFileContent.replaceAll("http:\\\\", "http://");
                    argsFileContent = argsFileContent.replaceAll("(?m)/\\*([^*]|\\*[^/])*\\*/", "");
                    argsFileContent = RegexUtils.regexReplace(argVariablePattern, argsFileContent, argVariableReplacer);
                    ArrayList<String> ret = new ArrayList<String>();
                    List<String[]> tokens = RegexUtils.find(argsFileContent, argTokenPattern);
                    for (String[] tokenMatch : tokens) {
                        String token = tokenMatch[0];
                        if ((token = token.trim()).startsWith("\"") && token.endsWith("\"")) {
                            token = token.substring(1, token.length() - 1);
                        }
                        if (token.length() == 0 || token.matches("^(//|#).*")) continue;
                        boolean allowMissing = token.endsWith("?");
                        if (token.contains("*")) {
                            Collection<String> rs = FileListUtils.resolveShellLikeFileList(allowMissing ? token.substring(0, token.length() - 1) : token);
                            for (String r : rs) {
                                ret.add(allowMissing ? r + "?" : r);
                            }
                            if (!rs.isEmpty()) continue;
                        }
                        ret.add(token);
                    }
                    return ret;
                }

                @Override
                void finished() throws IOException {
                    String entry;
                    Collection<File> inputFiles;
                    for (String framework : config.frameworks) {
                        JNAeratorConfigUtils.addFramework(config, framework);
                    }
                    config.addRootDir(new File("."));
                    for (String i : config.preprocessorConfig.includes) {
                        try {
                            config.addRootDir(new File(i));
                        }
                        catch (Exception ex) {}
                    }
                    if (config.sourceFiles.isEmpty() && config.bridgeSupportFiles.isEmpty() && !config.libraryFiles.isEmpty()) {
                        config.extractLibSymbols = true;
                    }
                    File firstFile = (inputFiles = config.getInputFiles()).isEmpty() ? null : inputFiles.iterator().next().getAbsoluteFile();
                    String firstFileName = firstFile == null ? null : firstFile.getName();
                    Set<String> libraries = config.getLibraries();
                    String string = config.entryName != null ? config.entryName : (entry = libraries.size() == 1 ? libraries.iterator().next() : null);
                    if (config.outputDir == null) {
                        File file = config.outputDir = firstFile == null ? new File(".") : firstFile.getAbsoluteFile().getParentFile();
                    }
                    if (config.outputJar == null && config.compile) {
                        config.outputJar = new File(config.outputDir, (entry == null ? "out" : entry) + ".jar");
                    }
                    if (config.verbose) {
                        if (config.rawParsedSourcesOutFile == null) {
                            config.rawParsedSourcesOutFile = new File("_jnaerator.rawParsed.cpp");
                        }
                        if (config.normalizedParsedSourcesOutFile == null) {
                            config.normalizedParsedSourcesOutFile = new File("_jnaerator.normalizedParsed.cpp");
                        }
                        if (config.macrosOutFile == null) {
                            config.macrosOutFile = new File("_jnaerator.macros.cpp");
                        }
                        if (config.choicesOutFile == null) {
                            config.choicesOutFile = new File("_jnaerator.choices");
                        }
                        if (config.preprocessingOutFile == null) {
                            config.preprocessingOutFile = new File("_jnaerator.preprocessed.c");
                        }
                        if (config.extractedSymbolsOut == null) {
                            config.extractedSymbolsOut = new File("_jnaerator.extractedSymbols.h");
                        }
                        if (config.bridgesupportOutFile == null) {
                            config.bridgesupportOutFile = new File("_jnaerator.bridgesupport.h");
                        }
                    }
                    config.cacheDir = JNAerator.getDir("cache");
                    if (this.simpleGUI) {
                        SimpleGUI gui = new SimpleGUI(config);
                        this.feedback = gui;
                        gui.show();
                    } else {
                        this.feedback = new Feedback(){

                            @Override
                            public void setStatus(String string) {
                                if (config.verbose) {
                                    System.out.println(string);
                                }
                            }

                            @Override
                            public void setFinished(Throwable e) {
                                System.out.println("JNAeration failed !");
                                e.printStackTrace();
                                throw new ExitException(1);
                            }

                            @Override
                            public void setFinished(File toOpen) {
                                System.out.println("JNAeration completed !");
                                System.out.println(toOpen.getAbsolutePath());
                                throw new ExitException(0);
                            }

                            @Override
                            public void sourcesParsed(SourceFiles sourceFiles) {
                            }

                            @Override
                            public void wrappersGenerated(Result result) {
                            }
                        };
                    }
                    jnaerator.jnaerate(this.feedback);
                    if (!this.simpleGUI) {
                        throw new ExitException(0);
                    }
                }
            }.parse(args);
        }
        catch (ExitException e) {
            if (e.errorCode != 0) {
                System.err.println("Finished with errors.");
            }
        }
        catch (Exception e) {
            System.err.println("Finished with errors.");
            e.printStackTrace();
        }
    }

    public PrintWriter getClassSourceWriter(ClassOutputter outputter, String className) throws IOException {
        return outputter.getClassSourceWriter(className);
    }

    private static boolean isLibraryFile(File file) {
        String arg = file.getName().toLowerCase();
        return arg.endsWith(".dll") || arg.endsWith(".pdb") || arg.endsWith(".dylib") || arg.endsWith(".so") || arg.endsWith(".jnilib");
    }

    protected void autoConfigure() {
        JNAeratorConfigUtils.autoConfigure(this.config);
    }

    public void jnaerate(final Feedback feedback) {
        try {
            if (this.config.autoConf) {
                feedback.setStatus("Auto-configuring parser...");
                this.autoConfigure();
            }
            this.config.preprocessorConfig.macros.keySet().removeAll(this.config.undefines);
            if (this.config.verbose) {
                JNAeratorConfigUtils.logger.log(Level.INFO, "Include path : \n\t" + StringUtils.implode(this.config.preprocessorConfig.includes, (Object)"\n\t"));
            }
            DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
            JavaCompiler c = CompilerUtils.getJavaCompiler(this.config.preferJavac);
            final MemoryFileManager mfm = new MemoryFileManager(c.getStandardFileManager(diagnostics, null, null));
            final ClassOutputter[] classOutputter = new ClassOutputter[]{this.config.compile ? new ClassOutputter(){

                @Override
                public PrintWriter getClassSourceWriter(String className) throws FileNotFoundException {
                    String path = "file:///" + className.replace('.', '/') + ".java";
                    MemoryJavaFile c = new MemoryJavaFile(path, null, JavaFileObject.Kind.SOURCE);
                    mfm.inputs.put(c.getPath().toString(), c);
                    return new PrintWriter(c.openWriter());
                }
            } : new ClassOutputter(){

                @Override
                public PrintWriter getClassSourceWriter(String className) throws FileNotFoundException {
                    File file = new File(JNAerator.this.config.outputDir, className.replace('.', File.separatorChar) + ".java");
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    feedback.setStatus("Generating " + file.getName());
                    return new PrintWriter(file){

                        @Override
                        public void print(String s) {
                            super.print(s.replace("\r", "").replace("\n", StringUtils.LINE_SEPARATOR));
                        }
                    };
                }
            }};
            Result result = this.createResult(new ClassOutputter(){

                @Override
                public PrintWriter getClassSourceWriter(String className) throws IOException {
                    PrintWriter w = JNAerator.this.getClassSourceWriter(classOutputter[0], className);
                    return new PrintWriter(w){
                        StringBuilder bout;
                        {
                            this.bout = new StringBuilder();
                        }

                        @Override
                        public void print(String s) {
                            JNAerator.escapeUnicode(s, this.bout);
                            super.print(this.bout.toString());
                        }
                    };
                }
            }, feedback);
            SourceFiles sourceFiles = this.parseSources(feedback, result.typeConverter);
            if (this.config.extractLibSymbols) {
                this.parseLibSymbols(sourceFiles, result);
            }
            feedback.sourcesParsed(sourceFiles);
            ScalaGenerator sgen = null;
            if (this.config.scalaOut != null) {
                sgen = new ScalaGenerator(result);
            }
            this.jnaerationCore(sourceFiles, result);
            if (sgen != null) {
                sgen.jnaerationCompleted();
            }
            feedback.wrappersGenerated(result);
            if (this.config.compile) {
                for (Map.Entry<String, String> cnAndSrc : this.config.extraJavaSourceFilesContents.entrySet()) {
                    mfm.addSourceInput(cnAndSrc.getKey(), cnAndSrc.getValue());
                }
                feedback.setStatus("Compiling JNAerated files...");
                CompilerUtils.compile(c, mfm, diagnostics, "1.5", this.config.cacheDir, this.config.runtime.libraryClass, JNAerator.class, NSClass.class, Rococoa.class, Mangling.class, BridJ.class);
                CompilerUtils.CompilationError.throwErrors(diagnostics.getDiagnostics(), mfm.inputs, c.getClass().getName());
                if (this.config.outputJar != null && result.config.bundleRuntime) {
                    feedback.setStatus("Copying runtime classes...");
                    this.addRuntimeClasses(result, mfm);
                }
            }
            if (this.config.outputJar != null) {
                feedback.setStatus("Generating " + this.config.outputJar.getName());
                mfm.writeJar(this.config.outputJar, this.config.bundleSources, this.getAdditionalFiles());
            }
            feedback.setFinished(this.config.outputJar != null ? this.config.outputJar : this.config.outputDir);
        }
        catch (ExitException ex) {
            throw ex;
        }
        catch (Throwable th) {
            feedback.setFinished(th);
        }
    }

    public void parseLibSymbols(SourceFiles sourceFiles, Result result) throws FileNotFoundException {
        PrintWriter fileOut = null;
        if (this.config.extractedSymbolsOut != null) {
            if (this.config.verbose) {
                System.out.println("Writing symbols extracted from libraries to '" + this.config.extractedSymbolsOut + "'");
            }
            fileOut = new PrintWriter(this.config.extractedSymbolsOut);
        }
        for (File libFile : this.config.libraryFiles) {
            if (!libFile.getName().toLowerCase().endsWith(".dll")) continue;
            try {
                result.feedback.setStatus("Extracting symbols from " + libFile.getName() + "...");
                SourceFile sf = new SourceFile();
                sf.setElementFile(libFile.toString());
                List<NativeExportUtils.ParsedExport> dllExports = DllExport.parseDllExports(libFile);
                HashMap<String, Struct> cppClasses = new HashMap<String, Struct>();
                Pattern pubPat = Pattern.compile("(public|private|protected):(.*)");
                for (NativeExportUtils.ParsedExport dllExport : dllExports) {
                    String dem = dllExport.demangled;
                    Matcher m = pubPat.matcher(dem);
                    String pub = null;
                    if (m.matches()) {
                        dem = m.group(2);
                        pub = m.group(1);
                    }
                    String text = "// @mangling " + dllExport.mangling + "\n" + dem + ";";
                    ObjCppParser parser = JNAeratorParser.newObjCppParser(result.typeConverter, text, false);
                    parser.setupSymbolsStack();
                    List<Declaration> decls = parser.declarationEOF();
                    if (decls == null) continue;
                    for (Declaration decl : decls) {
                        if (decl instanceof VariablesDeclaration && decl.getValueType() != null) {
                            decl.getValueType().addModifiers(Modifier.Extern);
                        }
                        decl.addModifiers(Modifier.parseModifier(pub, new ModifierKind[0]));
                        if (decl instanceof Function) {
                            Struct s;
                            Identifier ci;
                            Function f = (Function)decl;
                            ArrayList<Identifier.SimpleIdentifier> si = new ArrayList<Identifier.SimpleIdentifier>(f.getName().resolveSimpleIdentifiers());
                            if (si.size() == 1) {
                                String[] cm;
                                String name = si.get(0) == null ? null : ((Identifier.SimpleIdentifier)si.get(0)).toString();
                                String[] stringArray = cm = name == null ? null : RegexUtils.match(name, classAndMethodNamePattern);
                                if (cm == null) {
                                    sf.addDeclaration(decl);
                                    continue;
                                }
                                ci = ElementsHelper.ident(cm[0]);
                                f.setName(ElementsHelper.ident(cm[1]));
                            } else {
                                si.remove(si.size() - 1);
                                ci = new Identifier.QualifiedIdentifier(Identifier.QualificationSeparator.Colons, si);
                            }
                            if (dem.contains("__thiscall")) {
                                f.addModifiers(Modifier.__thiscall);
                            }
                            if (dem.contains("__fastcall")) {
                                f.addModifiers(Modifier.__fastcall);
                            }
                            if ((s = (Struct)cppClasses.get(ci.toString())) == null) {
                                s = new Struct();
                                cppClasses.put(ci.toString(), s);
                                s.setType(Struct.Type.CPPClass);
                                s.setTag(ci.clone());
                                sf.addDeclaration(ElementsHelper.decl(s));
                            }
                            Identifier.SimpleIdentifier n = f.getName().resolveLastSimpleIdentifier();
                            f.setName(n);
                            s.addDeclaration(f);
                            continue;
                        }
                        sf.addDeclaration(decl);
                    }
                }
                if (sf.getDeclarations().isEmpty()) continue;
                sourceFiles.add(sf);
                if (fileOut == null) continue;
                fileOut.println(sf);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (fileOut != null) {
            fileOut.close();
        }
    }

    private Map<String, File> getAdditionalFiles() {
        HashMap<String, File> additionalFiles = new HashMap<String, File>();
        if (this.config.bundleLibraries) {
            for (Map.Entry<String, List<File>> e : this.config.libraryFilesByArch.entrySet()) {
                String arch = e.getKey();
                for (File libraryFile : e.getValue()) {
                    additionalFiles.put("libraries/" + (arch == null || arch.length() == 0 ? "" : arch + "/") + libraryFile.getName(), libraryFile);
                }
            }
            for (String library : new HashSet<String>(this.config.libraryByFile.values())) {
                String key;
                String libraryFileName = System.mapLibraryName(library);
                File libraryFile = new File(libraryFileName);
                if (!libraryFile.exists() && libraryFileName.endsWith(".jnilib")) {
                    libraryFileName = libraryFileName.substring(0, libraryFileName.length() - ".jnilib".length()) + ".dylib";
                    libraryFile = new File(libraryFileName);
                }
                if (additionalFiles.containsKey(key = "libraries/" + LibraryExtractor.getCurrentOSAndArchString() + "/" + libraryFile.getName()) || !libraryFile.exists()) continue;
                System.out.println("Bundling " + libraryFile);
                additionalFiles.put(key, libraryFile);
            }
        }
        return additionalFiles;
    }

    /*
     * WARNING - void declaration
     */
    protected void addRuntimeClasses(Result result, MemoryFileManager mfm) throws IOException {
        void var8_12;
        ClassLoader classLoader = JNAerator.class.getClassLoader();
        String listingFile = result.config.runtime.runtimeFilesListFileName;
        if (listingFile == null) {
            return;
        }
        List<Object> files = new ArrayList<String>();
        String[] arr$ = listingFile.split(",");
        int len$ = arr$.length;
        boolean bl = false;
        while (var8_12 < len$) {
            String s = arr$[var8_12];
            files.addAll(ReadText.readLines(classLoader.getResourceAsStream(s.trim())));
            ++var8_12;
        }
        try {
            if (files == null) {
                files = ReadText.readLines("/Users/ochafik/Prog/Java/bin/jnaerator-runtime.jar.files");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (files == null) {
            throw new FileNotFoundException("Warning: Could not find JNAerator listing file '" + listingFile + "' : JNAerated files will need JNAerator in the path to execute.");
        }
        boolean needsObjCRuntime = result.hasObjectiveC();
        for (String string : files) {
            if (string.startsWith("Archive: ") || string.startsWith("META-INF/") || !needsObjCRuntime && string.contains("rococoa")) continue;
            URL url = classLoader.getResource(string);
            if (url == null) {
                if (string.matches("com/sun/jna/[^/]+/(lib\\w+\\.(jnilib|so)|\\w+\\.dll)")) {
                    System.out.println("JNA library missing : " + string);
                    continue;
                }
                if (string.matches("com/ochafik/lang/jnaerator/runtime/scala/.*\\.part")) {
                    System.out.println("Scala code missing : " + string);
                    continue;
                }
                throw new FileNotFoundException(string);
            }
            String string2 = "file:///" + string;
            if (mfm.outputs.containsKey(string2)) continue;
            mfm.outputs.put(string2, new URLFileObject(url));
        }
    }

    public static File getDir(String name) {
        File dir = new File(JNAerator.getDir(), name);
        dir.mkdirs();
        return dir;
    }

    public static File getDir() {
        File dir = new File(System.getProperty("user.home"));
        dir = new File(dir, ".jnaerator");
        dir = new File(dir, "temp");
        dir.mkdirs();
        return dir;
    }

    static boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || Character.isDigit(c);
    }

    static void escapeUnicode(String s, StringBuilder bout) {
        if (s == null) {
            return;
        }
        bout.setLength(0);
        for (char c : s.toCharArray()) {
            char v = c;
            if (v > '\u007f') {
                bout.append("\\u");
                String h = Integer.toHexString(v);
                int i = 4 - h.length();
                while (i-- != 0) {
                    bout.append('0');
                }
                bout.append(h);
                continue;
            }
            bout.append(c);
        }
    }

    public SourceFiles parseSources(Feedback feedback, TypeConversion typeConverter) throws IOException, LexerException {
        feedback.setStatus("Parsing native headers...");
        return JNAeratorParser.parse(this.config, typeConverter, null);
    }

    public void addFile(File file, List<File> out) throws IOException {
        if (file.isFile()) {
            out.add(file);
        } else {
            File[] fs = file.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    this.addFile(f, out);
                }
            }
        }
    }

    protected void generateLibraryFiles(SourceFiles sourceFiles, Result result) throws IOException {
        switch (result.config.runtime) {
            case JNA: 
            case JNAerator: {
                this.generateJNALibraryFiles(sourceFiles, result);
                break;
            }
            case BridJ: {
                this.generateNL4JLibraryFiles(sourceFiles, result);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected runtime : " + (Object)((Object)result.config.runtime));
            }
        }
    }

    protected void generateNL4JLibraryFiles(SourceFiles sourceFiles, Result result) throws IOException {
        for (String library : result.libraries) {
            if (library == null) continue;
            Identifier javaPackage = result.javaPackageByLibrary.get(library);
            Identifier simpleLibraryClassName = result.getLibraryClassSimpleName(library);
            Identifier fullLibraryClassName = result.getLibraryClassFullName(library);
            Struct interf = new Struct();
            interf.setType(Struct.Type.JavaClass);
            interf.addToCommentBefore("Wrapper for library <b>" + library + "</b>", result.declarationsConverter.getFileCommentContent(result.config.libraryProjectSources.get(library), null));
            interf.addModifiers(Modifier.Public);
            interf.setTag(simpleLibraryClassName);
            interf.addParent(ElementsHelper.ident(this.config.runtime.libraryClass, ElementsHelper.expr(ElementsHelper.typeRef(simpleLibraryClassName))));
            interf.addDeclaration(new Function(Function.Type.StaticInit, null, null).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(BridJ.class)), Expression.MemberRefStyle.Dot, "register", new Expression[0])))).addModifiers(Modifier.Static));
            this.fillLibraryMapping(result, sourceFiles, interf, library, javaPackage, fullLibraryClassName, ElementsHelper.varRef("this"));
        }
    }

    protected void generateJNALibraryFiles(SourceFiles sourceFiles, Result result) throws IOException {
        Struct librariesHub = null;
        PrintWriter hubOut = null;
        if (result.config.entryName != null) {
            librariesHub = new Struct();
            librariesHub.addToCommentBefore("JNA Wrappers instances");
            librariesHub.setType(Struct.Type.JavaClass);
            librariesHub.addModifiers(Modifier.Public, Modifier.Abstract);
            Identifier hubName = result.getHubFullClassName();
            librariesHub.setTag(hubName.resolveLastSimpleIdentifier());
            hubOut = result.classOutputter.getClassSourceWriter(hubName.toString());
            hubOut.println("package " + hubName.resolveAllButLastIdentifier() + ";");
            for (Identifier pn : result.javaPackages) {
                if (pn.equals("")) continue;
                hubOut.println("import " + pn + ".*;");
            }
        }
        for (String library : result.libraries) {
            if (library == null) continue;
            Identifier javaPackage = result.javaPackageByLibrary.get(library);
            Identifier simpleLibraryClassName = result.getLibraryClassSimpleName(library);
            Identifier fullLibraryClassName = result.getLibraryClassFullName(library);
            Struct interf = new Struct();
            interf.addToCommentBefore("JNA Wrapper for library <b>" + library + "</b>", result.declarationsConverter.getFileCommentContent(result.config.libraryProjectSources.get(library), null));
            if (hubOut != null) {
                interf.addToCommentBefore("@see " + result.config.entryName + "." + library);
            }
            interf.addModifiers(Modifier.Public);
            interf.setTag(simpleLibraryClassName);
            Expression nativeLibFieldExpr = null;
            if (!result.config.skipLibraryInstanceDeclarations) {
                Expression libNameExpr = ElementsHelper.opaqueExpr(result.getLibraryFileExpression(library));
                TypeRef.SimpleTypeRef libTypeRef = ElementsHelper.typeRef(fullLibraryClassName);
                Expression libClassLiteral = result.typeConverter.typeLiteral(libTypeRef);
                Expression.FunctionCall libraryPathGetterExpr = ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(LibraryExtractor.class)), Expression.MemberRefStyle.Dot, "getLibraryPath", libNameExpr, ElementsHelper.expr(true), libClassLiteral);
                String libNameStringFieldName = "JNA_LIBRARY_NAME";
                String nativeLibFieldName = "JNA_NATIVE_LIB";
                interf.addDeclaration(new VariablesDeclaration(ElementsHelper.typeRef(String.class), new Declarator.DirectDeclarator(libNameStringFieldName, libraryPathGetterExpr)).addModifiers(Modifier.Public, Modifier.Static, Modifier.Final));
                Expression libraryNameFieldExpr = ElementsHelper.memberRef(ElementsHelper.expr(((TypeRef)libTypeRef).clone()), Expression.MemberRefStyle.Dot, ElementsHelper.ident(libNameStringFieldName));
                Expression optionsMapExpr = ElementsHelper.memberRef(ElementsHelper.expr(ElementsHelper.typeRef(MangledFunctionMapper.class)), Expression.MemberRefStyle.Dot, "DEFAULT_OPTIONS");
                interf.addDeclaration(new VariablesDeclaration(ElementsHelper.typeRef(NativeLibrary.class), new Declarator.DirectDeclarator(nativeLibFieldName, ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(NativeLibrary.class)), Expression.MemberRefStyle.Dot, "getInstance", libraryNameFieldExpr.clone(), optionsMapExpr.clone()))).addModifiers(Modifier.Public, Modifier.Static, Modifier.Final));
                nativeLibFieldExpr = ElementsHelper.memberRef(ElementsHelper.expr(((TypeRef)libTypeRef).clone()), Expression.MemberRefStyle.Dot, ElementsHelper.ident(nativeLibFieldName));
                if (result.config.useJNADirectCalls) {
                    interf.addDeclaration(new Function(Function.Type.StaticInit, null, null).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(Native.class)), Expression.MemberRefStyle.Dot, "register", libraryNameFieldExpr.clone())))).addModifiers(Modifier.Static));
                } else {
                    VariablesDeclaration instanceDecl = new VariablesDeclaration((TypeRef)libTypeRef, new Declarator.DirectDeclarator(librariesHub == null ? "INSTANCE" : library, ElementsHelper.cast(libTypeRef, ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(Native.class)), Expression.MemberRefStyle.Dot, "loadLibrary", libraryNameFieldExpr.clone(), libClassLiteral, optionsMapExpr.clone())))).addModifiers(Modifier.Public, Modifier.Static, Modifier.Final);
                    if (librariesHub != null) {
                        librariesHub.addDeclaration(instanceDecl);
                        librariesHub.addProtocol(fullLibraryClassName.clone());
                    } else {
                        interf.addDeclaration(instanceDecl);
                    }
                }
            }
            boolean stdcall = false;
            List<Function> functions = result.functionsByLibrary.get(library);
            if (functions != null) {
                for (Function function : functions) {
                    if (!Modifier.__stdcall.isContainedBy(function.getModifiers())) continue;
                    stdcall = true;
                    break;
                }
            }
            Identifier libSuperInter = ElementsHelper.ident(stdcall ? StdCallLibrary.class : this.config.runtime.libraryClass, new Expression[0]);
            if (result.config.useJNADirectCalls) {
                interf.addProtocol(libSuperInter);
                interf.setType(Struct.Type.JavaClass);
            } else {
                interf.addParent(libSuperInter);
                interf.setType(Struct.Type.JavaInterface);
            }
            this.fillLibraryMapping(result, sourceFiles, interf, library, javaPackage, fullLibraryClassName, nativeLibFieldExpr);
        }
        if (hubOut != null) {
            hubOut.println(librariesHub.toString());
            hubOut.close();
        }
    }

    protected void fillLibraryMapping(Result result, SourceFiles sourceFiles, Struct interf, String library, Identifier javaPackage, Identifier fullLibraryClassName, Expression nativeLibFieldExpr) throws IOException {
        Signatures signatures = result.getSignaturesForOutputClass(fullLibraryClassName);
        result.typeConverter.allowFakePointers = true;
        result.declarationsConverter.convertEnums(result.enumsByLibrary.get(library), signatures, interf, fullLibraryClassName);
        result.declarationsConverter.convertConstants(library, result.definesByLibrary.get(library), sourceFiles, signatures, interf, fullLibraryClassName);
        result.declarationsConverter.convertStructs(result.structsByLibrary.get(library), signatures, interf, fullLibraryClassName);
        result.declarationsConverter.convertCallbacks(result.callbacksByLibrary.get(library), signatures, interf, fullLibraryClassName);
        result.declarationsConverter.convertFunctions(result.functionsByLibrary.get(library), signatures, interf, fullLibraryClassName);
        if (result.globalsGenerator != null) {
            result.globalsGenerator.convertGlobals(result.globalsByLibrary.get(library), signatures, (DeclarationsHolder)interf, nativeLibFieldExpr, fullLibraryClassName, library);
        }
        result.typeConverter.allowFakePointers = false;
        Set<String> fakePointers = result.fakePointersByLibrary.get(fullLibraryClassName);
        if (fakePointers != null) {
            for (String fakePointerName : fakePointers) {
                Struct ptClass;
                Identifier fakePointer;
                if (fakePointerName.contains("::") || !signatures.classSignatures.add(fakePointer = ElementsHelper.ident(fakePointerName))) continue;
                if (result.config.runtime.hasJNA) {
                    ptClass = result.declarationsConverter.publicStaticClass(fakePointer, ElementsHelper.ident(PointerType.class, new Expression[0]), Struct.Type.JavaClass, null, new Identifier[0]);
                    String pointerVarName = "address";
                    ptClass.addDeclaration(new Function(Function.Type.JavaMethod, fakePointer, null, new Arg(pointerVarName, ElementsHelper.typeRef(Pointer.class))).addModifiers(Modifier.Public).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall("super", ElementsHelper.varRef(pointerVarName))))));
                    ptClass.addDeclaration(new Function(Function.Type.JavaMethod, fakePointer, null).addModifiers(Modifier.Public).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall("super", new Expression[0])))));
                    interf.addDeclaration(ElementsHelper.decl(ptClass));
                } else {
                    ptClass = result.declarationsConverter.publicStaticClass(fakePointer, ElementsHelper.ident(TypedPointer.class, new Expression[0]), Struct.Type.JavaClass, null, new Identifier[0]);
                    String addressVarName = "address";
                    ptClass.addDeclaration(new Function(Function.Type.JavaMethod, fakePointer, null, new Arg(addressVarName, ElementsHelper.typeRef(Long.TYPE))).addModifiers(Modifier.Public).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall("super", ElementsHelper.varRef(addressVarName))))));
                    ptClass.addDeclaration(new Function(Function.Type.JavaMethod, fakePointer, null, new Arg(addressVarName, ElementsHelper.typeRef(org.bridj.Pointer.class))).addModifiers(Modifier.Public).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall("super", ElementsHelper.varRef(addressVarName))))));
                    interf.addDeclaration(ElementsHelper.decl(ptClass));
                }
                ptClass.addToCommentBefore("Pointer to unknown (opaque) type");
                if (!result.config.reification) continue;
                Identifier resolvedFakePointer = result.getFakePointer(fullLibraryClassName, ElementsHelper.ident(fakePointerName));
                List<Pair<Identifier, Function>> functionsReifiableInFakePointers = result.getFunctionsReifiableInFakePointer(resolvedFakePointer);
                String thisFakePtrRefStr = ElementsHelper.typeRef(resolvedFakePointer).toString();
                if (functionsReifiableInFakePointers == null) continue;
                for (Pair<Identifier, Function> p : functionsReifiableInFakePointers) {
                    Function original = p.getSecond();
                    Function fDirect = original.clone();
                    int thisLocation = -1;
                    ArrayList<Integer> fakePointersLocations = new ArrayList<Integer>();
                    int iArg = 0;
                    for (Arg arg : fDirect.getArgs()) {
                        if (this.isFakePointerRef(result, arg.getValueType())) {
                            if (iArg == 0 && arg.getValueType().toString().equals(thisFakePtrRefStr)) {
                                thisLocation = iArg;
                            }
                            fakePointersLocations.add(iArg);
                            this.toDirectFakePointer(result, arg);
                        }
                        ++iArg;
                    }
                    String indirectRetVarName = "$";
                    boolean returnsFakePointer = this.isFakePointerRef(result, fDirect.getValueType());
                    boolean needsDirect = !fakePointersLocations.isEmpty() || returnsFakePointer;
                    Expression.New finalCall = null;
                    String directFunctionName = null;
                    if (needsDirect) {
                        if (returnsFakePointer) {
                            finalCall = new Expression.New(fDirect.getValueType(), ElementsHelper.varRef(indirectRetVarName));
                            this.toDirectFakePointer(result, fDirect);
                        }
                        this.privatize(fDirect);
                        if (signatures.methodsSignatures.add(fDirect.computeSignature(false))) {
                            ((DeclarationsHolder)((Object)original.getParentElement())).addDeclaration(fDirect);
                        }
                        if (original.computeSignature(false).equals(fDirect.computeSignature(false))) {
                            fDirect.setName(ElementsHelper.ident(original.getName() + "$direct"));
                        }
                        directFunctionName = fDirect.getName().toString();
                    }
                    Function f = original.clone();
                    ArrayList<Arg> args = new ArrayList<Arg>(f.getArgs());
                    f.setModifiers(Collections.EMPTY_LIST);
                    f.addModifiers(Modifier.Public);
                    if (thisLocation < 0) {
                        f.addModifiers(Modifier.Static);
                    }
                    String functionName = f.getName().toString();
                    f.setName(ElementsHelper.ident(this.reifyFunctionName(result, fakePointerName, functionName)));
                    Identifier id = p.getFirst();
                    ArrayList<Expression> followedArgs = new ArrayList<Expression>();
                    iArg = 0;
                    for (Arg arg : args) {
                        if (iArg == thisLocation) {
                            followedArgs.add(ElementsHelper.methodCall(ElementsHelper.thisRef(), "getPeer", new Expression[0]));
                        } else if (fakePointersLocations.contains(iArg)) {
                            followedArgs.add(ElementsHelper.methodCall(ElementsHelper.varRef(arg.getName()), "getPeer", new Expression[0]));
                        } else {
                            followedArgs.add(ElementsHelper.varRef(arg.getName()));
                        }
                        ++iArg;
                    }
                    if (thisLocation >= 0) {
                        args.remove(thisLocation);
                    }
                    f.setArgs(args);
                    Expression nlib = ElementsHelper.expr(ElementsHelper.typeRef(p.getFirst().clone()));
                    Expression.FunctionCall x = ElementsHelper.methodCall(nlib, needsDirect ? directFunctionName : functionName, followedArgs.toArray(new Expression[followedArgs.size()]));
                    boolean retVoid = "void".equals(String.valueOf(f.getValueType()));
                    if (retVoid) {
                        f.setBody(ElementsHelper.block(ElementsHelper.stat(x)));
                    } else if (needsDirect && finalCall != null) {
                        VariablesDeclaration vd = new VariablesDeclaration(ElementsHelper.typeRef(Long.TYPE), new Declarator.DirectDeclarator(indirectRetVarName, x));
                        Expression.ConditionalExpression ce = new Expression.ConditionalExpression();
                        ce.setTest(ElementsHelper.expr(ElementsHelper.varRef(indirectRetVarName), Expression.BinaryOperator.IsEqual, ElementsHelper.expr(0)));
                        ce.setThenValue(ElementsHelper.nullExpr());
                        ce.setElseValue(finalCall);
                        f.setBody(ElementsHelper.block(ElementsHelper.stat(vd), new Statement.Return(ce)));
                    } else {
                        f.setBody(ElementsHelper.block(new Statement.Return(x)));
                    }
                    ptClass.addDeclaration(f);
                }
            }
        }
        if (result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
            interf.addAnnotation(new Annotation(Library.class, ElementsHelper.expr(library)));
            interf.addAnnotation(new Annotation(Runtime.class, ElementsHelper.classLiteral(CPPRuntime.class)));
        }
        if ((interf = result.notifyBeforeWritingClass(fullLibraryClassName, interf, signatures, library)) != null) {
            PrintWriter out = result.classOutputter.getClassSourceWriter(fullLibraryClassName.toString());
            result.printJavaClass(javaPackage, interf, out);
            out.close();
        }
    }

    boolean isFakePointerRef(Result result, TypeRef tr) {
        Identifier id;
        return tr instanceof TypeRef.SimpleTypeRef && result.isFakePointer(id = ((TypeRef.SimpleTypeRef)tr).getName());
    }

    void toDirectFakePointer(Result result, Declaration decl) {
        decl.setValueType(ElementsHelper.typeRef(Long.TYPE));
        decl.addAnnotation(new Annotation(ElementsHelper.typeRef(Ptr.class), new Expression[0]));
    }

    static String trimAny(String s, String[] prefixes, String[] suffixes) {
        String l = s.toLowerCase();
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!l.startsWith(prefix.toLowerCase())) continue;
                s = s.substring(prefix.length());
                break;
            }
        }
        if (suffixes != null) {
            for (String suffix : suffixes) {
                if (!l.endsWith(suffix.toLowerCase())) continue;
                s = s.substring(0, s.length() - suffix.length());
                break;
            }
        }
        return s;
    }

    public String reifyFunctionName(Result result, String fakePointerName, String functionName) {
        String simplifiedPointerName = StringUtils.trimUnderscores(JNAerator.trimAny(fakePointerName, result.config.libraryNamingPrefixes, null));
        ArrayList<String> prefs = new ArrayList<String>();
        if (result.config.libraryNamingPrefixes != null) {
            prefs.addAll(Arrays.asList(result.config.libraryNamingPrefixes));
        }
        prefs.add(fakePointerName);
        prefs.add(simplifiedPointerName);
        String s = StringUtils.uncapitalize(StringUtils.trimUnderscores(JNAerator.trimAny(functionName, prefs.toArray(new String[prefs.size()]), new String[]{simplifiedPointerName, simplifiedPointerName.replaceAll("_", "")})));
        if (s.length() == 0 || result.typeConverter.isJavaKeyword(s)) {
            return functionName;
        }
        return s;
    }

    public Result createResult(ClassOutputter outputter, Feedback feedback) {
        return new Result(this.config, outputter, feedback);
    }

    public static ObjCppParser newParser(String s) throws IOException {
        Result result = new Result(new JNAeratorConfig(), null, null);
        ObjCppParser parser = new ObjCppParser(new CommonTokenStream(new ObjCppLexer(new ANTLRReaderStream(new StringReader(s)))));
        parser.objCParserHelper = result.typeConverter;
        return parser;
    }

    protected void readChoices(Result result) throws IOException, RecognitionException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(result.config.choicesInputFile));
        ArrayList<Function> functions = null;
        int iLine = 0;
        while ((line = in.readLine()) != null) {
            ++iLine;
            if ((line = line.trim()).startsWith("//")) continue;
            if (line.length() == 0) {
                functions = null;
            }
            Function function = null;
            function = functions == null ? JNAerator.newParser(line).javaMethodDeclaration() : JNAerator.newParser((String)line).functionDeclaration().function;
            if (function == null) {
                System.err.println("Error: failed to parse function at line " + iLine + ": '" + line + "'");
                continue;
            }
            if (functions == null) {
                functions = new ArrayList<Function>();
                result.declarationsConverter.functionAlternativesByNativeSignature.put(function.computeSignature(false), new Pair(function, functions));
                continue;
            }
            functions.add(function);
        }
        System.err.println("Read " + result.declarationsConverter.functionAlternativesByNativeSignature.size() + " custom declarations from " + result.config.choicesInputFile);
    }

    public void jnaerationCore(SourceFiles sourceFiles, Result result) throws IOException, LexerException, RecognitionException {
        List<Define> list;
        result.feedback.setStatus("Normalizing parsed code...");
        if (result.config.choicesInputFile != null) {
            this.readChoices(result);
        }
        if (this.config.rawParsedSourcesOutFile != null) {
            if (this.config.verbose) {
                System.out.println("Writing raw parsed sources to '" + this.config.rawParsedSourcesOutFile + "'");
            }
            WriteText.writeText(sourceFiles.toString(), this.config.rawParsedSourcesOutFile);
        }
        sourceFiles.accept(new ObjectiveCToJavaPreScanner(result));
        sourceFiles.accept(new CToJavaPreScanner());
        sourceFiles.accept(new MissingNamesChooser(result));
        sourceFiles.accept(new Scanner(){

            @Override
            protected void visitTypeRef(TypeRef tr) {
                List<Modifier> stoMods;
                super.visitTypeRef(tr);
                Element parent = tr.getParentElement();
                if (parent instanceof TypeRef && (stoMods = this.getStoMods(tr.getModifiers())) != null) {
                    ArrayList<Modifier> newMods = new ArrayList<Modifier>(tr.getModifiers());
                    newMods.removeAll(stoMods);
                    tr.setModifiers(newMods);
                    ((ModifiableElement)parent).addModifiers(stoMods);
                }
            }

            public List<Modifier> getStoMods(List<Modifier> mods) {
                ArrayList<Modifier> ret = null;
                for (Modifier mod : mods) {
                    if (!mod.isA(ModifierKind.StorageClassSpecifier)) continue;
                    if (ret == null) {
                        ret = new ArrayList<Modifier>();
                    }
                    ret.add(mod);
                }
                return ret;
            }
        });
        sourceFiles.accept(new JavaDocCreator(result));
        assert (this.checkNoCycles(sourceFiles));
        if (this.config.normalizedParsedSourcesOutFile != null) {
            if (this.config.verbose) {
                System.out.println("Writing normalized parsed sources to '" + this.config.normalizedParsedSourcesOutFile + "'");
            }
            WriteText.writeText(sourceFiles.toString(), this.config.normalizedParsedSourcesOutFile);
        }
        if (!result.config.bridgeSupportFiles.isEmpty()) {
            if (result.feedback != null) {
                result.feedback.setStatus("Parsing BridgeSupport files...");
            }
            new BridgeSupportParser(result, sourceFiles).parseBridgeSupportFiles();
        }
        sourceFiles.accept(result);
        result.rehabilitateWeakTypeDefs();
        result.chooseLibraryClasses(this.config.packageName, this.config.rootPackageName);
        if (!result.classes.isEmpty() && result.objectiveCGenerator != null) {
            result.feedback.setStatus("Generating Objective-C classes...");
            result.objectiveCGenerator.generateObjectiveCClasses();
        }
        result.feedback.setStatus("Generating libraries...");
        if (result.libraries.size() == 1 && (list = result.definesByLibrary.get(null)) != null) {
            String lib = result.libraries.iterator().next();
            Result.getList(result.definesByLibrary, lib).addAll(list);
        }
        this.generateLibraryFiles(sourceFiles, result);
        if (this.config.verbose) {
            for (String unknownType : result.typeConverter.unknownTypes) {
                System.out.println("Unknown Type: " + unknownType);
            }
        }
        if (result.config.choicesOutFile != null) {
            PrintWriter out = new PrintWriter(result.config.choicesOutFile);
            for (Map.Entry<String, Pair<Function, List<Function>>> e : result.declarationsConverter.functionAlternativesByNativeSignature.entrySet()) {
                Function f = e.getValue().getKey();
                String ff = f.getElementFile();
                if (ff != null) {
                    out.println("// " + ff + (f.getElementLine() > 0 ? ":" + f.getElementLine() : ""));
                }
                out.println(f);
                for (Function alt : e.getValue().getValue()) {
                    out.println(alt);
                }
                out.println();
            }
            out.close();
        }
    }

    private boolean checkNoCycles(SourceFiles sourceFiles) {
        final HashSet ids = new HashSet(new Arg().getId());
        sourceFiles.accept(new Scanner(){

            @Override
            protected void visitElement(Element d) {
                if (d != null && !ids.add(d.getId())) {
                    throw new RuntimeException("Cycle : " + d);
                }
                super.visitElement(d);
            }
        });
        return true;
    }

    class JNALibraryMapping
    extends LibraryMapping {
        JNALibraryMapping() {
        }
    }

    class LibraryMapping {
        public Struct interf;

        LibraryMapping() {
        }
    }

    private static class ExitException
    extends RuntimeException {
        int errorCode;

        public ExitException(int errorCode) {
            this.errorCode = errorCode;
        }
    }

    public static interface Feedback {
        public void setStatus(String var1);

        public void setFinished(File var1);

        public void setFinished(Throwable var1);

        public void sourcesParsed(SourceFiles var1);

        public void wrappersGenerated(Result var1);
    }
}

