/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.runtime.globals.Global;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalCallback;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalPointer;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalPointerType;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalStruct;
import com.sun.jna.ptr.ByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GlobalsGenerator {
    final Result result;

    public GlobalsGenerator(Result result) {
        this.result = result;
    }

    public void convertGlobals(VariablesDeclaration globals, Signatures signatures, DeclarationsHolder out, Expression nativeLibFieldExpr, Identifier callerLibraryName, String callerLibrary) throws UnsupportedConversionException {
        for (Declarator d : globals.getDeclarators()) {
            try {
                boolean hasOffset;
                TypeRef instType;
                Identifier name = this.result.typeConverter.getValidJavaArgumentName(ElementsHelper.ident(d.resolveName()));
                TypeRef type = (TypeRef)d.mutateType(globals.getValueType());
                if (type == null) continue;
                boolean isCallback = this.result.callbacksByName.containsKey(ElementsHelper.ident(type.toString()));
                ArrayList<Modifier> modifiers = new ArrayList<Modifier>(type.getModifiers());
                modifiers.addAll(globals.getModifiers());
                type.setModifiers(Collections.EMPTY_LIST);
                if (!isCallback && !Modifier.Extern.isContainedBy(modifiers) && !Modifier.Dllexport.isContainedBy(modifiers) && !Modifier.Dllimport.isContainedBy(modifiers) || !signatures.variablesSignatures.add(name.toString())) continue;
                boolean isPointer = type instanceof TypeRef.Pointer;
                TypeConversion.JavaPrim prim = this.result.typeConverter.getPrimitive(isPointer ? ((TypeRef.Pointer)type).getTarget() : type, callerLibraryName);
                type.setMarkedAsResolved(false);
                TypeRef convertedType = this.result.typeConverter.convertTypeToJNA(type, TypeConversion.TypeConversionMode.NativeParameter, callerLibraryName);
                String convTypStr = convertedType.toString();
                if (convTypStr.endsWith(".ByValue")) {
                    convTypStr = convTypStr.substring(0, convTypStr.length() - ".ByValue".length());
                }
                boolean isStruct = this.result.structsFullNames.contains(ElementsHelper.ident(convTypStr));
                boolean isUnion = this.result.unionsFullNames.contains(ElementsHelper.ident(convTypStr));
                if (prim != null || isCallback || isStruct || isUnion) {
                    TypeRef globalType = null;
                    Expression extraArg = null;
                    if (isUnion || isStruct) {
                        globalType = ElementsHelper.typeRef(ElementsHelper.ident(GlobalStruct.class, ElementsHelper.expr(convertedType.clone())));
                        extraArg = ElementsHelper.memberRef(ElementsHelper.expr(convertedType.clone()), Expression.MemberRefStyle.Dot, "class");
                    } else if (isCallback) {
                        globalType = ElementsHelper.typeRef(ElementsHelper.ident(GlobalCallback.class, ElementsHelper.expr(type.clone())));
                        extraArg = ElementsHelper.memberRef(ElementsHelper.expr(type.clone()), Expression.MemberRefStyle.Dot, "class");
                    } else if (isPointer) {
                        Class<? extends ByReference> brt = this.result.typeConverter.primToByReference.get((Object)prim);
                        if (brt != null) {
                            globalType = ElementsHelper.typeRef(ElementsHelper.ident(GlobalPointerType.class, ElementsHelper.expr(ElementsHelper.typeRef(ElementsHelper.ident(brt, new Expression[0])))));
                            extraArg = ElementsHelper.classLiteral(brt);
                        } else if (prim == TypeConversion.JavaPrim.Void) {
                            globalType = ElementsHelper.typeRef(GlobalPointer.class);
                        }
                    } else {
                        Class<? extends Global> globalClass = this.result.typeConverter.primToGlobal.get((Object)prim);
                        if (globalClass != null) {
                            globalType = ElementsHelper.typeRef(globalClass);
                        }
                    }
                    if (globalType != null) {
                        ArrayList<Expression> constructorArgs = new ArrayList<Expression>();
                        constructorArgs.add(nativeLibFieldExpr.clone());
                        if (extraArg != null) {
                            constructorArgs.add(extraArg);
                        }
                        constructorArgs.add(ElementsHelper.expr(name.toString()));
                        VariablesDeclaration vd = new VariablesDeclaration(globalType, new Declarator.DirectDeclarator(name.toString(), new Expression.New(globalType.clone(), constructorArgs.toArray(new Expression[constructorArgs.size()]))));
                        vd.addModifiers(Modifier.Public, Modifier.Static, Modifier.Final);
                        vd.importDetails(globals, false);
                        vd.moveAllCommentsBefore();
                        out.addDeclaration(vd);
                        continue;
                    }
                }
                if (!signatures.classSignatures.add(name)) continue;
                Struct struct = this.result.declarationsConverter.publicStaticClass(name, null, Struct.Type.JavaClass, null, new Identifier[0]);
                struct.addModifiers(Modifier.Final);
                struct.importDetails(globals, false);
                struct.moveAllCommentsBefore();
                TypeRef.Pointer pointerType = new TypeRef.Pointer(type, Declarator.PointerStyle.Pointer);
                TypeRef convPointerType = this.result.typeConverter.convertTypeToJNA(pointerType, TypeConversion.TypeConversionMode.FieldType, callerLibraryName);
                boolean isPtr = false;
                boolean isByRef = false;
                String convPointerTypeStr = convPointerType.toString();
                if (convPointerTypeStr.equals(this.result.config.runtime.pointerClass.getName())) {
                    isPtr = true;
                    instType = convPointerType;
                    hasOffset = false;
                } else if (this.result.typeConverter.byReferenceClassesNames.contains(convPointerTypeStr)) {
                    isByRef = true;
                    instType = convPointerType;
                    hasOffset = false;
                } else if (convPointerTypeStr.endsWith(".ByReference") && this.result.structsByName.get(convPointerTypeStr.substring(0, convPointerTypeStr.length() - ".ByReference".length())) != null) {
                    instType = this.result.typeConverter.convertTypeToJNA(type, TypeConversion.TypeConversionMode.PointedValue, callerLibraryName);
                    hasOffset = true;
                } else {
                    Identifier instTypeName = ElementsHelper.ident(name + "_holder");
                    Struct holderStruct = this.result.declarationsConverter.publicStaticClass(instTypeName, ElementsHelper.ident(this.result.config.runtime.structClass, new Expression[0]), Struct.Type.JavaClass, null, new Identifier[0]);
                    holderStruct.addModifiers(Modifier.Final);
                    VariablesDeclaration vd = this.result.declarationsConverter.convertVariablesDeclarationToJNA("value", type, new int[1], callerLibraryName, new Element[0]);
                    if (vd.getValueType().toString().equals(this.result.config.runtime.pointerClass.getName())) {
                        isByRef = true;
                        instType = convPointerType;
                        hasOffset = false;
                    } else {
                        holderStruct.addDeclaration(vd);
                        Function pointerConstructor = new Function(Function.Type.JavaMethod, instTypeName, null, new Arg("pointer", new TypeRef.SimpleTypeRef(this.result.config.runtime.pointerClass.getName())));
                        hasOffset = false;
                        pointerConstructor.setBody(new Statement.Block(new Statement.ExpressionStatement(ElementsHelper.methodCall("super", new Expression[0])), new Statement.ExpressionStatement(ElementsHelper.methodCall("useMemory", ElementsHelper.varRef("pointer"), ElementsHelper.expr(0))), new Statement.ExpressionStatement(ElementsHelper.methodCall("read", new Expression[0]))));
                        holderStruct.addDeclaration(pointerConstructor);
                        instType = new TypeRef.SimpleTypeRef(instTypeName);
                        struct.addDeclaration(ElementsHelper.decl(holderStruct));
                    }
                }
                Identifier instName = name;
                struct.addDeclaration(new VariablesDeclaration(instType, new Declarator.DirectDeclarator(instName.toString())).addModifiers(Modifier.Private, Modifier.Static));
                Expression.VariableRef instRef = new Expression.VariableRef(instName);
                Expression.FunctionCall ptrExpr = ElementsHelper.methodCall(nativeLibFieldExpr.clone(), Expression.MemberRefStyle.Dot, "getGlobalVariableAddress", ElementsHelper.expr(name.toString()));
                ArrayList<Statement> initStats = new ArrayList<Statement>();
                initStats.add(new Statement.ExpressionStatement(ElementsHelper.expr((Expression)instRef.clone(), Expression.AssignmentOperator.Equal, isPtr ? ptrExpr : (isByRef ? new Expression.New(instType) : new Expression.New(instType, new Expression.FunctionCall(null, ptrExpr, hasOffset ? ElementsHelper.expr(0) : null))))));
                if (isByRef) {
                    initStats.add(new Statement.ExpressionStatement(ElementsHelper.methodCall((Expression)instRef, Expression.MemberRefStyle.Dot, "setPointer", ptrExpr)));
                }
                struct.addDeclaration(new Function(Function.Type.JavaMethod, ElementsHelper.ident("get"), instType).setBody(new Statement.Block(new Statement.If(ElementsHelper.expr((Expression)instRef, Expression.BinaryOperator.IsEqual, ElementsHelper.nullExpr()), initStats.size() == 1 ? (Statement)initStats.get(0) : new Statement.Block(initStats), null), new Statement.Return((Expression)instRef.clone()))).addModifiers(Modifier.Public, Modifier.Static, Modifier.Synchronized));
                out.addDeclaration(ElementsHelper.decl(struct));
            }
            catch (Throwable t) {
                out.addDeclaration(this.result.declarationsConverter.skipDeclaration(d, t.toString()));
            }
        }
    }

    public void convertGlobals(List<VariablesDeclaration> list, Signatures signatures, DeclarationsHolder out, Expression nativeLibFieldExpr, Identifier libraryNameExpression, String library) {
        if (list == null) {
            return;
        }
        if (this.result.config.skipLibraryInstanceDeclarations) {
            return;
        }
        for (VariablesDeclaration v : list) {
            try {
                this.convertGlobals(v, signatures, out, nativeLibFieldExpr, libraryNameExpression, library);
            }
            catch (UnsupportedConversionException ex) {
                out.addDeclaration(this.result.declarationsConverter.skipDeclaration(v, ex.toString()));
            }
        }
    }
}

