/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.SyntaxUtils;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.JNAeratorUtils;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.RococoaUtils;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.cplusplus.CPlusPlusMangler;
import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.EmptyDeclaration;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.ExternDeclarations;
import com.ochafik.lang.jnaerator.parser.FriendDeclaration;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.Printer;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.runtime.VirtualTablePointer;
import com.ochafik.util.CompoundCollection;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.RegexUtils;
import com.ochafik.util.string.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.StructObject;
import org.bridj.ValuedEnum;
import org.bridj.ann.Library;
import org.bridj.cpp.CPPObject;
import org.rococoa.AlreadyRetained;
import org.rococoa.cocoa.foundation.NSObject;

public class DeclarationsConverter {
    private static final String DEFAULT_VPTR_NAME = "_vptr";
    private static final Pattern manglingCommentPattern = Pattern.compile("@mangling (.*)$", 8);
    protected final Result result;
    static Map<Class<?>, Pair<List<Pair<Function, String>>, Set<String>>> cachedForcedMethodsAndTheirSignatures;
    Map<String, Pair<Function, List<Function>>> functionAlternativesByNativeSignature = new LinkedHashMap<String, Pair<Function, List<Function>>>();
    Map<Identifier, Boolean> structsVirtuality = new HashMap<Identifier, Boolean>();
    protected String ioVarName = "io";
    protected String ioStaticVarName = "IO";
    int nextAnonymousFieldId;

    public DeclarationsConverter(Result result) {
        this.result = result;
    }

    public void convertCallback(TypeRef.FunctionSignature functionSignature, Signatures signatures, DeclarationsHolder out, Identifier callerLibraryName) {
        Identifier name = this.result.typeConverter.inferCallBackName(functionSignature, true, false, callerLibraryName);
        if (name == null) {
            return;
        }
        name = this.result.typeConverter.getValidJavaArgumentName(name);
        Function function = functionSignature.getFunction();
        int i = 1;
        Identifier chosenName = name;
        while (!signatures.classSignatures.add(chosenName)) {
            chosenName = ElementsHelper.ident(name.toString() + ++i);
        }
        Element parent = functionSignature.getParentElement();
        TypeRef.FunctionSignature comel = parent != null && parent instanceof StoredDeclarations.TypeDef ? parent : functionSignature;
        Struct callbackStruct = new Struct();
        if (this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
            callbackStruct.setType(Struct.Type.JavaClass);
            callbackStruct.addModifiers(Modifier.Public, Modifier.Static, Modifier.Abstract);
        } else {
            callbackStruct.setType(Struct.Type.JavaInterface);
            callbackStruct.addModifiers(Modifier.Public);
        }
        callbackStruct.setParents(Arrays.asList(TypeRef.FunctionSignature.Type.ObjCBlock.equals((Object)functionSignature.getType()) ? this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.ObjCBlock) : (this.result.config.runtime == JNAeratorConfig.Runtime.BridJ ? ElementsHelper.typeRef(ElementsHelper.ident(this.result.config.runtime.callbackClass, ElementsHelper.expr(ElementsHelper.typeRef(chosenName.clone())))) : (TypeRef.SimpleTypeRef)ElementsHelper.typeRef(this.result.config.runtime.callbackClass))));
        callbackStruct.setTag(ElementsHelper.ident(chosenName, new Identifier[0]));
        if (!this.result.config.noComments) {
            callbackStruct.addToCommentBefore(comel.getCommentBefore(), comel.getCommentAfter(), this.getFileCommentContent(comel));
        }
        this.convertFunction(function, new Signatures(), true, callbackStruct, callerLibraryName);
        for (Declaration d : callbackStruct.getDeclarations()) {
            if (!(d instanceof Function)) continue;
            callbackStruct.addAnnotations(callbackStruct.getAnnotations());
            callbackStruct.setAnnotations(null);
            break;
        }
        out.addDeclaration(new TaggedTypeRefDeclaration(callbackStruct));
    }

    public void convertCallbacks(List<TypeRef.FunctionSignature> functionSignatures, Signatures signatures, DeclarationsHolder out, Identifier libraryClassName) {
        if (functionSignatures != null) {
            for (TypeRef.FunctionSignature functionSignature : functionSignatures) {
                Arg a;
                if (functionSignature.findParentOfType(Struct.class) != null || (a = functionSignature.findParentOfType(Arg.class)) != null && a.getParentElement() == null) continue;
                this.convertCallback(functionSignature, signatures, out, libraryClassName);
            }
        }
    }

    private List<EnumItemResult> getEnumValuesAndCommentsByName(Enum e, Signatures signatures, Identifier libraryClassName) {
        ArrayList<EnumItemResult> ret = new ArrayList<EnumItemResult>();
        Integer lastAdditiveValue = null;
        Expression lastRefValue = null;
        boolean failedOnceForThisEnum = false;
        for (Enum.EnumItem item : e.getItems()) {
            EnumItemResult res = new EnumItemResult();
            res.originalItem = item;
            try {
                if (item.getArguments().isEmpty()) {
                    Integer n;
                    Integer n2;
                    if (lastRefValue == null) {
                        if (lastAdditiveValue != null) {
                            n2 = lastAdditiveValue;
                            n = lastAdditiveValue = Integer.valueOf(lastAdditiveValue + 1);
                            res.value = ElementsHelper.expr(lastAdditiveValue);
                        } else if (item == e.getItems().get(0)) {
                            lastAdditiveValue = 0;
                            res.value = ElementsHelper.expr(lastAdditiveValue);
                        } else {
                            res.value = null;
                        }
                    } else {
                        if (lastAdditiveValue != null) {
                            n2 = lastAdditiveValue;
                            n = lastAdditiveValue = Integer.valueOf(lastAdditiveValue + 1);
                        } else {
                            lastAdditiveValue = 1;
                        }
                        res.value = ElementsHelper.expr(lastRefValue.clone(), Expression.BinaryOperator.Plus, ElementsHelper.expr(lastAdditiveValue));
                    }
                } else {
                    failedOnceForThisEnum = false;
                    lastAdditiveValue = null;
                    res.value = lastRefValue = item.getArguments().get(0);
                    if (lastRefValue instanceof Expression.Constant) {
                        try {
                            lastAdditiveValue = ((Expression.Constant)lastRefValue).asInteger();
                            lastRefValue = null;
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            catch (Exception ex) {
                failedOnceForThisEnum = true;
                res.exceptionMessage = ex.toString();
            }
            boolean bl = failedOnceForThisEnum = failedOnceForThisEnum || res.errorElement != null;
            if (failedOnceForThisEnum) {
                res.errorElement = this.skipDeclaration(item, new String[0]);
            }
            ret.add(res);
        }
        return ret;
    }

    public void convertConstants(String library, List<Define> defines, Element sourcesRoot, final Signatures signatures, final DeclarationsHolder out, final Identifier libraryClassName) {
        final Map<String, String> constants = Result.getMap(this.result.stringConstants, library);
        sourcesRoot.accept(new Scanner(){

            @Override
            public void visitVariablesDeclaration(VariablesDeclaration v) {
                super.visitVariablesDeclaration(v);
                if (v.findParentOfType(Struct.class) != null) {
                    return;
                }
                if (v.getValueType() instanceof TypeRef.FunctionSignature) {
                    return;
                }
                for (Declarator decl : v.getDeclarators()) {
                    TypeRef mutatedType;
                    if (!(decl instanceof Declarator.DirectDeclarator) || (mutatedType = (TypeRef)decl.mutateType(v.getValueType())) == null || !mutatedType.getModifiers().contains((Object)Modifier.Const) || mutatedType.getModifiers().contains((Object)Modifier.Extern) || decl.getDefaultValue() == null) continue;
                    String name = decl.resolveName();
                    TypeConversion.JavaPrim prim = DeclarationsConverter.this.result.typeConverter.getPrimitive(mutatedType, libraryClassName);
                    if (prim == null) {
                        String value;
                        if (!mutatedType.toString().contains("NSString") || (value = (String)constants.get(name)) == null) continue;
                        DeclarationsConverter.this.outputNSString(name, value, out, signatures, new Element[]{v, decl});
                        continue;
                    }
                    try {
                        Pair<Expression, TypeRef> val = DeclarationsConverter.this.result.typeConverter.convertExpressionToJava(decl.getDefaultValue(), libraryClassName, true);
                        if (!signatures.variablesSignatures.add(name)) continue;
                        TypeRef.SimpleTypeRef tr = prim == TypeConversion.JavaPrim.NativeLong || prim == TypeConversion.JavaPrim.NativeSize ? ElementsHelper.typeRef("long") : DeclarationsConverter.this.result.typeConverter.convertTypeToJNA(mutatedType, TypeConversion.TypeConversionMode.FieldType, libraryClassName);
                        VariablesDeclaration vd = new VariablesDeclaration((TypeRef)tr, new Declarator.DirectDeclarator(name, val.getFirst()));
                        if (!DeclarationsConverter.this.result.config.noComments) {
                            vd.setCommentBefore(v.getCommentBefore());
                            vd.addToCommentBefore(decl.getCommentBefore());
                            vd.addToCommentBefore(decl.getCommentAfter());
                            vd.addToCommentBefore(v.getCommentAfter());
                        }
                        if (DeclarationsConverter.this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
                            vd.addModifiers(Modifier.Public, Modifier.Static, Modifier.Final);
                        }
                        out.addDeclaration(vd);
                    }
                    catch (UnsupportedConversionException e) {
                        out.addDeclaration(DeclarationsConverter.this.skipDeclaration(v, e.toString()));
                    }
                }
            }
        });
        if (defines != null) {
            for (Define define : this.reorderDefines(defines)) {
                if (define.getValue() == null) continue;
                try {
                    out.addDeclaration(this.outputConstant(define.getName(), define.getValue(), signatures, define.getValue(), "define", libraryClassName, true, false, false));
                }
                catch (UnsupportedConversionException ex) {
                    out.addDeclaration(this.skipDeclaration(define, ex.toString()));
                }
            }
        }
        for (Map.Entry entry : constants.entrySet()) {
            this.outputNSString((String)entry.getKey(), (String)entry.getValue(), out, signatures, new Element[0]);
        }
    }

    private void outputNSString(String name, String value, DeclarationsHolder out, Signatures signatures, Element ... elementsToTakeCommentsFrom) {
        if (!signatures.variablesSignatures.add(name)) {
            return;
        }
        TypeRef tr = ElementsHelper.typeRef(String.class);
        VariablesDeclaration vd = new VariablesDeclaration(tr, new Declarator.DirectDeclarator(name, ElementsHelper.expr(value)));
        if (!this.result.config.noComments) {
            for (Element e : elementsToTakeCommentsFrom) {
                vd.addToCommentBefore(e.getCommentBefore());
                vd.addToCommentBefore(e.getCommentAfter());
            }
        }
        vd.addModifiers(Modifier.Public);
        out.addDeclaration(vd);
    }

    public static synchronized Pair<List<Pair<Function, String>>, Set<String>> getMethodsAndTheirSignatures(Class<?> originalLib) {
        Pair<List<Pair<Function, String>>, Set<String>> pair;
        if (cachedForcedMethodsAndTheirSignatures == null) {
            cachedForcedMethodsAndTheirSignatures = new HashMap();
        }
        if ((pair = cachedForcedMethodsAndTheirSignatures.get(originalLib)) == null) {
            pair = new Pair(new ArrayList(), new HashSet());
            for (Method m : originalLib.getDeclaredMethods()) {
                Function f = Function.fromMethod(m);
                String sig = f.computeSignature(false);
                pair.getFirst().add(new Pair<Function, String>(f, sig));
                pair.getSecond().add(sig);
            }
        }
        return pair;
    }

    public void addMissingMethods(Class<?> originalLib, Signatures existingSignatures, Struct outputLib) {
        for (Pair<Function, String> f : DeclarationsConverter.getMethodsAndTheirSignatures(originalLib).getFirst()) {
            if (!existingSignatures.methodsSignatures.add(f.getSecond())) continue;
            outputLib.addDeclaration(f.getFirst().clone());
        }
    }

    public EmptyDeclaration skipDeclaration(Element e, String ... preMessages) {
        if (this.result.config.limitComments) {
            return null;
        }
        ArrayList<String> mess = new ArrayList<String>();
        if (preMessages != null) {
            mess.addAll(Arrays.asList(preMessages));
        }
        mess.addAll(Arrays.asList("SKIPPED:", new Printer(null).formatComments(e, true, true, false, new String[0]).toString(), this.getFileCommentContent(e), e.toString().replace("*/", "* /")));
        return new EmptyDeclaration(mess.toArray(new String[0]));
    }

    public void convertEnum(Enum e, Signatures signatures, DeclarationsHolder out, Identifier libraryClassName) {
        if (e.isForwardDeclaration()) {
            return;
        }
        Identifier enumName = this.getActualTaggedTypeName(e);
        List<EnumItemResult> results = this.getEnumValuesAndCommentsByName(e, signatures, libraryClassName);
        switch (this.result.config.runtime) {
            case JNA: 
            case JNAerator: {
                boolean hasEnumClass = false;
                if (enumName != null && enumName.resolveLastSimpleIdentifier().getName() != null) {
                    if (!signatures.classSignatures.add(enumName)) {
                        return;
                    }
                    hasEnumClass = true;
                    Struct struct = this.publicStaticClass(enumName, null, Struct.Type.JavaInterface, e, new Identifier[0]);
                    out.addDeclaration(new TaggedTypeRefDeclaration(struct));
                    if (!this.result.config.noComments) {
                        struct.addToCommentBefore("enum values");
                    }
                    out = struct;
                    signatures = new Signatures();
                }
                this.outputEnumItemsAsConstants(results, out, signatures, libraryClassName, hasEnumClass);
                break;
            }
            case BridJ: {
                boolean hasEnumClass = false;
                if (enumName != null && enumName.resolveLastSimpleIdentifier().getName() != null) {
                    if (!signatures.classSignatures.add(enumName)) {
                        return;
                    }
                    signatures = new Signatures();
                    Enum en = new Enum();
                    en.setType(Enum.Type.Java);
                    en.setTag(enumName.clone());
                    en.addModifiers(new Modifier[]{Modifier.Public});
                    out.addDeclaration(new TaggedTypeRefDeclaration(en));
                    Struct body = new Struct();
                    en.setBody(body);
                    for (EnumItemResult er : results) {
                        if (er.errorElement != null) {
                            out.addDeclaration(er.errorElement);
                            continue;
                        }
                        Enum.EnumItem item = new Enum.EnumItem(er.originalItem.getName(), er.value);
                        en.addItem(item);
                        if (this.result.config.noComments || item == null || !hasEnumClass) continue;
                        String c = item.getCommentBefore();
                        item.setCommentBefore(er.originalItem.getCommentBefore());
                        item.addToCommentBefore(c);
                    }
                    en.addInterface(ElementsHelper.ident(IntValuedEnum.class, ElementsHelper.expr(ElementsHelper.typeRef(enumName.clone()))));
                    String valueArgName = "value";
                    body.addDeclaration(new Function(Function.Type.JavaMethod, enumName.clone(), null, new Arg(valueArgName, ElementsHelper.typeRef(Long.TYPE))).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.expr(ElementsHelper.memberRef(ElementsHelper.thisRef(), Expression.MemberRefStyle.Dot, valueArgName), Expression.AssignmentOperator.Equal, ElementsHelper.varRef(valueArgName))))));
                    body.addDeclaration(new VariablesDeclaration(ElementsHelper.typeRef(Long.TYPE), new Declarator.DirectDeclarator(valueArgName)).addModifiers(Modifier.Public, Modifier.Final));
                    body.addDeclaration(new Function(Function.Type.JavaMethod, ElementsHelper.ident(valueArgName), ElementsHelper.typeRef(Long.TYPE)).setBody(ElementsHelper.block(new Statement.Return(ElementsHelper.memberRef(ElementsHelper.thisRef(), Expression.MemberRefStyle.Dot, valueArgName)))).addModifiers(Modifier.Public));
                    body.addDeclaration(new Function(Function.Type.JavaMethod, ElementsHelper.ident("iterator"), ElementsHelper.typeRef(ElementsHelper.ident(Iterator.class, ElementsHelper.expr(ElementsHelper.typeRef(enumName.clone()))))).setBody(ElementsHelper.block(new Statement.Return(ElementsHelper.methodCall((Expression)ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(Collections.class)), Expression.MemberRefStyle.Dot, "singleton", ElementsHelper.thisRef()), Expression.MemberRefStyle.Dot, "iterator", new Expression[0])))).addModifiers(Modifier.Public));
                    body.addDeclaration(new Function(Function.Type.JavaMethod, ElementsHelper.ident("fromValue"), (TypeRef)ElementsHelper.typeRef(ElementsHelper.ident(ValuedEnum.class, ElementsHelper.expr(ElementsHelper.typeRef(enumName.clone())))), new Arg(valueArgName, ElementsHelper.typeRef(Long.TYPE))).setBody(ElementsHelper.block(new Statement.Return(ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(FlagSet.class)), Expression.MemberRefStyle.Dot, "fromValue", ElementsHelper.varRef(valueArgName), ElementsHelper.methodCall("values", new Expression[0]))))).addModifiers(Modifier.Public, Modifier.Static));
                    break;
                }
                this.outputEnumItemsAsConstants(results, out, signatures, libraryClassName, hasEnumClass);
            }
        }
    }

    private void outputEnumItemsAsConstants(List<EnumItemResult> results, DeclarationsHolder out, Signatures signatures, Identifier libraryClassName, boolean hasEnumClass) {
        for (EnumItemResult er : results) {
            try {
                if (er.errorElement != null) {
                    out.addDeclaration(er.errorElement);
                    continue;
                }
                Declaration ct = this.outputConstant(er.originalItem.getName(), this.result.typeConverter.convertExpressionToJava(er.value, libraryClassName, true), signatures, er.originalItem, "enum item", libraryClassName, hasEnumClass, true, true, true);
                if (!this.result.config.noComments && ct != null && hasEnumClass) {
                    String c = ct.getCommentBefore();
                    ct.setCommentBefore(er.originalItem.getCommentBefore());
                    ct.addToCommentBefore(c);
                }
                out.addDeclaration(ct);
            }
            catch (Exception ex) {
                out.addDeclaration(this.skipDeclaration(er.originalItem, ex.toString()));
            }
        }
    }

    private Declaration outputConstant(String name, Expression x, Signatures signatures, Element element, String elementTypeDescription, Identifier libraryClassName, boolean addFileComment, boolean signalErrors, boolean forceInteger) throws UnsupportedConversionException {
        return this.outputConstant(name, TypeConversion.pair(x, null), signatures, element, elementTypeDescription, libraryClassName, addFileComment, signalErrors, forceInteger, false);
    }

    private Declaration outputConstant(String name, Pair<Expression, TypeRef> x, Signatures signatures, Element element, String elementTypeDescription, Identifier libraryClassName, boolean addFileComment, boolean signalErrors, boolean forceInteger, boolean alreadyConverted) throws UnsupportedConversionException {
        try {
            if (this.result.typeConverter.isJavaKeyword(name)) {
                throw new UnsupportedConversionException(element, "The name '" + name + "' is invalid for a Java field.");
            }
            Pair<Expression, TypeRef> converted = alreadyConverted ? x : this.result.typeConverter.convertExpressionToJava(x.getFirst(), libraryClassName, true);
            TypeConversion.JavaPrim prim = this.result.typeConverter.getPrimitive(converted.getValue(), libraryClassName);
            if (forceInteger && prim == TypeConversion.JavaPrim.Boolean) {
                prim = TypeConversion.JavaPrim.Int;
                converted = TypeConversion.pair(ElementsHelper.expr("true".equals(String.valueOf(converted.toString())) ? 1 : 0), ElementsHelper.typeRef(Integer.TYPE));
            }
            if ((prim == null || converted.getValue() == null) && signalErrors) {
                if (this.result.config.limitComments) {
                    return null;
                }
                return new EmptyDeclaration("Failed to infer type of " + converted);
            }
            if (prim != TypeConversion.JavaPrim.Void && converted.getValue() != null && signatures.variablesSignatures.add(name)) {
                String t = converted.toString();
                if (t.contains("sizeof")) {
                    converted = alreadyConverted ? x : this.result.typeConverter.convertExpressionToJava(x.getFirst(), libraryClassName, false);
                }
                VariablesDeclaration declaration = new VariablesDeclaration(converted.getValue(), new Declarator.DirectDeclarator(name, converted.getFirst()));
                ((ModifiableElement)declaration).addModifiers(Modifier.Public, Modifier.Static, Modifier.Final);
                declaration.importDetails(element, false);
                declaration.moveAllCommentsBefore();
                if (!this.result.config.noComments && addFileComment) {
                    declaration.addToCommentBefore(this.getFileCommentContent(element));
                }
                return declaration;
            }
            return this.skipDeclaration(element, elementTypeDescription);
        }
        catch (UnsupportedConversionException e) {
            return this.skipDeclaration(element, elementTypeDescription, e.toString());
        }
    }

    public void convertEnums(List<Enum> enums, Signatures signatures, DeclarationsHolder out, Identifier libraryClassName) {
        if (enums != null) {
            for (Enum e : enums) {
                if (e.findParentOfType(Struct.class) != null) continue;
                this.convertEnum(e, signatures, out, libraryClassName);
            }
        }
    }

    static <E extends Element> E cleanClone(E e) {
        Element c = e.clone();
        c.setCommentBefore(null);
        c.setCommentAfter(null);
        if (c instanceof Declaration) {
            Declaration d = (Declaration)c;
            d.setAnnotations(null);
        }
        return (E)c;
    }

    void throwBadRuntime() {
        throw new RuntimeException("Unhandled runtime : " + this.result.config.runtime.name());
    }

    public void convertFunction(Function function, Signatures signatures, boolean isCallback, final DeclarationsHolder out, final Identifier libraryClassName) {
        block13: {
            if (this.result.config.functionsAccepter != null && !this.result.config.functionsAccepter.adapt(function).booleanValue()) {
                return;
            }
            String library = this.result.getLibrary(function);
            Identifier functionName = function.getName();
            boolean isMethod = function.getParentElement() instanceof Struct;
            if (functionName == null || isCallback) {
                if (function.getParentElement() instanceof TypeRef.FunctionSignature) {
                    functionName = ElementsHelper.ident(this.result.config.callbackInvokeMethodName);
                } else {
                    return;
                }
            }
            if (function.getParentElement() instanceof FriendDeclaration) {
                return;
            }
            String n = functionName.toString();
            if (n.contains("<") || n.startsWith("~")) {
                return;
            }
            if ((functionName = this.result.typeConverter.getValidJavaMethodName(functionName)) == null) {
                return;
            }
            String sig = function.computeSignature(false);
            DeclarationsHolder objOut = this.result.config.reification && !isCallback && !isMethod ? new DeclarationsHolder(){

                @Override
                public void addDeclaration(Declaration d) {
                    out.addDeclaration(d);
                    if (d instanceof Function) {
                        Function f = (Function)d;
                        List<Arg> args = f.getArgs();
                        ArrayList<TypeRef> trs = new ArrayList<TypeRef>(2);
                        trs.add(f.getValueType());
                        if (!args.isEmpty()) {
                            trs.add(args.get(0).getValueType());
                        }
                        for (TypeRef tr : trs) {
                            Identifier id;
                            if (!(tr instanceof TypeRef.SimpleTypeRef) || !DeclarationsConverter.this.result.isFakePointer(id = ((TypeRef.SimpleTypeRef)tr).getName())) continue;
                            DeclarationsConverter.this.result.addFunctionReifiableInFakePointer(id, libraryClassName, f);
                        }
                    }
                }

                @Override
                public List<Declaration> getDeclarations() {
                    return out.getDeclarations();
                }
            } : out;
            try {
                switch (this.result.config.runtime) {
                    case JNA: 
                    case JNAerator: {
                        this.convertJNAFunction(function, signatures, isCallback, objOut, libraryClassName, sig, functionName, library);
                        break;
                    }
                    case BridJ: {
                        this.convertNL4JFunction(function, signatures, isCallback, objOut, libraryClassName, sig, functionName, library);
                        break;
                    }
                    default: {
                        this.throwBadRuntime();
                        break;
                    }
                }
            }
            catch (UnsupportedConversionException ex) {
                EmptyDeclaration d = this.skipDeclaration(function, new String[0]);
                if (d == null) break block13;
                d.addToCommentBefore(ex.toString());
                out.addDeclaration(d);
            }
        }
    }

    private void convertJNAFunction(Function function, Signatures signatures, boolean isCallback, DeclarationsHolder out, Identifier libraryClassName, String sig, Identifier functionName, String library) {
        block48: {
            Boolean alreadyRetained;
            Pair<Function, List<Function>> alternativesPair = this.functionAlternativesByNativeSignature.get(sig);
            if (alternativesPair != null) {
                if (this.result.config.choicesInputFile != null) {
                    for (Function alt : alternativesPair.getValue()) {
                        out.addDeclaration(alt.clone());
                    }
                    return;
                }
            } else {
                alternativesPair = new Pair(DeclarationsConverter.cleanClone(function), new ArrayList());
                this.functionAlternativesByNativeSignature.put(sig, alternativesPair);
            }
            List<Function> alternatives = alternativesPair.getValue();
            Function natFunc = new Function();
            Element parent = function.getParentElement();
            ArrayList<String> ns = new ArrayList<String>(function.getNameSpace());
            boolean isMethod = parent instanceof Struct;
            if (isMethod) {
                ns.clear();
                ns.addAll(parent.getNameSpace());
                switch (((Struct)parent).getType()) {
                    case ObjCClass: 
                    case ObjCProtocol: {
                        break;
                    }
                    case CPPClass: {
                        if (!this.result.config.genCPlusPlus && !Modifier.Static.isContainedBy(function.getModifiers())) {
                            return;
                        }
                        ns.add(((Struct)parent).getTag().toString());
                    }
                }
            }
            if (!isMethod && library != null && (alreadyRetained = Result.getMap(this.result.retainedRetValFunctions, library).get(functionName.toString())) != null && alreadyRetained.booleanValue()) {
                natFunc.addAnnotation(new Annotation(AlreadyRetained.class, ElementsHelper.expr(alreadyRetained)));
            }
            boolean isObjectiveC = function.getType() == Function.Type.ObjCMethod;
            natFunc.setType(Function.Type.JavaMethod);
            if (this.result.config.synchronizedMethods && !isCallback && (this.result.config.useJNADirectCalls || this.result.config.runtime == JNAeratorConfig.Runtime.BridJ)) {
                natFunc.addModifiers(Modifier.Synchronized);
            }
            if (this.result.config.useJNADirectCalls && !isCallback && !isObjectiveC) {
                natFunc.addModifiers(Modifier.Public, Modifier.Static, Modifier.Native);
            }
            try {
                String bufSign;
                TypeRef.SimpleTypeRef mgc;
                TypeRef returnType = null;
                if (!isObjectiveC) {
                    returnType = function.getValueType();
                    if (returnType == null) {
                        returnType = new TypeRef.Primitive("int");
                    }
                    if (returnType != null) {
                        returnType.addModifiers(function.getModifiers());
                    }
                } else {
                    returnType = RococoaUtils.fixReturnType(function);
                    functionName = ElementsHelper.ident(RococoaUtils.getMethodName(function));
                }
                Identifier modifiedMethodName = isCallback ? ElementsHelper.ident(this.result.config.callbackInvokeMethodName) : this.result.typeConverter.getValidJavaMethodName(ElementsHelper.ident(StringUtils.implode(ns, (Object)this.result.config.cPlusPlusNameSpaceSeparator) + (ns.isEmpty() ? "" : this.result.config.cPlusPlusNameSpaceSeparator) + functionName));
                LinkedHashSet<String> names = new LinkedHashSet<String>();
                if (!this.result.config.noMangling && !isCallback && !isObjectiveC && this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.CPlusPlusMangling)) {
                    this.addCPlusPlusMangledNames(function, names);
                }
                if (function.getName() != null && !modifiedMethodName.equals(function.getName().toString()) && ns.isEmpty()) {
                    names.add(function.getName().toString());
                }
                if (function.getAsmName() != null) {
                    names.add(function.getAsmName());
                }
                if (!isCallback && !names.isEmpty() && (mgc = this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Mangling)) != null) {
                    natFunc.addAnnotation(new Annotation((TypeRef)mgc, "({\"" + StringUtils.implode(names, (Object)"\", \"") + "\"})"));
                }
                boolean needsThis = false;
                boolean needsThisAnnotation = false;
                if (Modifier.__fastcall.isContainedBy(function.getModifiers())) {
                    natFunc.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.FastCall), new Expression[0]));
                    needsThis = true;
                }
                if (Modifier.__thiscall.isContainedBy(function.getModifiers())) {
                    natFunc.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.ThisCall), new Expression[0]));
                    needsThis = true;
                }
                if (function.getType() == Function.Type.CppMethod && !function.getModifiers().contains((Object)Modifier.Static)) {
                    needsThisAnnotation = true;
                    needsThis = true;
                }
                if (needsThis && !this.result.config.genCPlusPlus) {
                    return;
                }
                natFunc.setName(modifiedMethodName);
                natFunc.setValueType(this.result.typeConverter.convertTypeToJNA(returnType, TypeConversion.TypeConversionMode.ReturnType, libraryClassName));
                if (!this.result.config.noComments) {
                    natFunc.importDetails(function, false);
                    natFunc.moveAllCommentsBefore();
                    if (!isCallback) {
                        natFunc.addToCommentBefore(this.getFileCommentContent(function));
                    }
                }
                if (function.getName() != null) {
                    Object[] name = new Object[]{function.getName().toString()};
                    for (Pair<MessageFormat, MessageFormat> mf : this.result.config.onlineDocumentationURLFormats) {
                        try {
                            MessageFormat urlFormat = mf.getSecond();
                            URL url = new URL(urlFormat.format(name));
                            URLConnection con = url.openConnection();
                            con.getInputStream().close();
                            MessageFormat displayFormat = mf.getFirst();
                            natFunc.addToCommentBefore("@see <a href=\"" + url + "\">" + displayFormat.format(name) + "</a>");
                            break;
                        }
                        catch (Exception ex) {
                        }
                    }
                }
                boolean alternativeOutputs = !isCallback;
                Function primOrBufFunc = alternativeOutputs ? natFunc.clone() : null;
                Function natStructFunc = alternativeOutputs ? natFunc.clone() : null;
                TreeSet<String> argNames = new TreeSet<String>();
                int iArg = 1;
                for (Arg arg : function.getArgs()) {
                    if (arg.isVarArg() && arg.getValueType() == null) {
                        Identifier vaType = ElementsHelper.ident(isObjectiveC ? NSObject.class : Object.class, new Expression[0]);
                        String argName = this.chooseJavaArgName("varargs", iArg, argNames);
                        natFunc.addArg(new Arg(argName, ElementsHelper.typeRef(vaType.clone()))).setVarArg(true);
                        if (alternativeOutputs) {
                            primOrBufFunc.addArg(new Arg(argName, ElementsHelper.typeRef(vaType.clone()))).setVarArg(true);
                            natStructFunc.addArg(new Arg(argName, ElementsHelper.typeRef(vaType.clone()))).setVarArg(true);
                        }
                    } else {
                        String argName = this.chooseJavaArgName(arg.getName(), iArg, argNames);
                        TypeRef mutType = arg.createMutatedType();
                        if (mutType == null) {
                            throw new UnsupportedConversionException(function, "Argument " + arg.getName() + " cannot be converted");
                        }
                        if (mutType.toString().contains("NSOpenGLContextParameter")) {
                            argName = argName.toString();
                        }
                        natFunc.addArg(new Arg(argName, this.result.typeConverter.convertTypeToJNA(mutType, TypeConversion.TypeConversionMode.NativeParameter, libraryClassName)));
                        if (alternativeOutputs) {
                            primOrBufFunc.addArg(new Arg(argName, this.result.typeConverter.convertTypeToJNA(mutType, TypeConversion.TypeConversionMode.PrimitiveOrBufferParameter, libraryClassName)));
                            natStructFunc.addArg(new Arg(argName, this.result.typeConverter.convertTypeToJNA(mutType, TypeConversion.TypeConversionMode.NativeParameterWithStructsPtrPtrs, libraryClassName)));
                        }
                    }
                    ++iArg;
                }
                String natSign = natFunc.computeSignature(false);
                String primOrBufSign = alternativeOutputs ? primOrBufFunc.computeSignature(false) : null;
                String string = bufSign = alternativeOutputs ? natStructFunc.computeSignature(false) : null;
                if (signatures == null || signatures.methodsSignatures.add(natSign)) {
                    if (alternativeOutputs && !primOrBufSign.equals(natSign)) {
                        if (!this.result.config.noComments) {
                            if (primOrBufSign.equals(bufSign)) {
                                natFunc.addToCommentBefore(Arrays.asList("@deprecated use the safer method {@link #" + primOrBufSign + "} instead"));
                            } else {
                                natFunc.addToCommentBefore(Arrays.asList("@deprecated use the safer methods {@link #" + primOrBufSign + "} and {@link #" + bufSign + "} instead"));
                            }
                        }
                        natFunc.addAnnotation(new Annotation(Deprecated.class, new Expression[0]));
                    }
                    this.collectParamComments(natFunc);
                    out.addDeclaration(natFunc);
                    alternatives.add(DeclarationsConverter.cleanClone(natFunc));
                }
                if (alternativeOutputs) {
                    if (signatures == null || signatures.methodsSignatures.add(primOrBufSign)) {
                        this.collectParamComments(primOrBufFunc);
                        out.addDeclaration(primOrBufFunc);
                        alternatives.add(DeclarationsConverter.cleanClone(primOrBufFunc));
                    }
                    if (signatures == null || signatures.methodsSignatures.add(bufSign)) {
                        this.collectParamComments(natStructFunc);
                        out.addDeclaration(natStructFunc);
                        alternatives.add(DeclarationsConverter.cleanClone(natStructFunc));
                    }
                }
            }
            catch (UnsupportedConversionException ex) {
                if (this.result.config.limitComments) break block48;
                out.addDeclaration(new EmptyDeclaration(this.getFileCommentContent(function), ex.toString()));
            }
        }
    }

    private void convertNL4JFunction(Function function, Signatures signatures, boolean isCallback, DeclarationsHolder out, Identifier libraryClassName, String sig, Identifier functionName, String library) throws UnsupportedConversionException {
        TypeRef.SimpleTypeRef mgc;
        Element parent = function.getParentElement();
        List<Modifier> modifiers = function.getModifiers();
        Struct.MemberVisibility visibility = function.getVisibility();
        boolean isPublic = visibility == Struct.MemberVisibility.Public || Modifier.Public.isContainedBy(modifiers);
        boolean isPrivate = visibility == Struct.MemberVisibility.Private || Modifier.Private.isContainedBy(modifiers);
        boolean isProtected = visibility == Struct.MemberVisibility.Protected || Modifier.Protected.isContainedBy(modifiers);
        boolean isInStruct = parent instanceof Struct;
        if (isInStruct && this.result.config.skipPrivateMembers && (isPrivate || !isPublic && !isProtected)) {
            return;
        }
        boolean isStatic = Modifier.Static.isContainedBy(modifiers);
        Function nativeMethod = new Function(Function.Type.JavaMethod, ElementsHelper.ident(functionName, new Identifier[0]), null);
        nativeMethod.addModifiers(isProtected ? Modifier.Protected : Modifier.Public, isCallback ? Modifier.Abstract : Modifier.Native, isStatic || !isCallback && !isInStruct ? Modifier.Static : null);
        if (this.result.config.synchronizedMethods && !isCallback) {
            nativeMethod.addModifiers(Modifier.Synchronized);
        }
        if (function.getName() != null && !functionName.toString().equals(function.getName().toString()) && !isCallback && (mgc = this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Name)) != null) {
            nativeMethod.addAnnotation(new Annotation((TypeRef)mgc, "(\"" + function.getName() + "\")"));
        }
        TypeConversion.NL4JConversion retType = this.result.typeConverter.convertTypeToNL4J(function.getValueType(), libraryClassName, null, null, -1, -1);
        retType.annotateTypedType(nativeMethod);
        nativeMethod.setValueType(retType.typeRef);
        LinkedHashMap<String, TypeConversion.NL4JConversion> argTypes = new LinkedHashMap<String, TypeConversion.NL4JConversion>();
        for (Arg arg : function.getArgs()) {
            String argName = arg.getName();
            TypeConversion.NL4JConversion argType = this.result.typeConverter.convertTypeToNL4J(arg.getValueType(), libraryClassName, null, null, -1, -1);
            argTypes.put(argName, argType);
            nativeMethod.addArg(argType.annotateTypedType(new Arg(argName, argType.typeRef)));
        }
        String natSig = nativeMethod.computeSignature(false);
        if (!signatures.methodsSignatures.add(natSig)) {
            return;
        }
        out.addDeclaration(nativeMethod);
    }

    protected boolean isCPlusPlusFileName(String file) {
        if (file == null) {
            return true;
        }
        return !(file = file.toLowerCase()).endsWith(".c") && !file.endsWith(".m");
    }

    private void addCPlusPlusMangledNames(Function function, Set<String> names) {
        List<String[]> mats;
        if (function.getType() == Function.Type.ObjCMethod) {
            return;
        }
        String elementFile = this.result.resolveFile(function);
        if (elementFile != null && (elementFile.contains(".framework/") || elementFile.endsWith(".bridgesupport"))) {
            return;
        }
        ExternDeclarations externDeclarations = function.findParentOfType(ExternDeclarations.class);
        if (externDeclarations != null && !"C++".equals(externDeclarations.getLanguage())) {
            return;
        }
        if (!this.isCPlusPlusFileName(Element.getFileOfAscendency(function))) {
            return;
        }
        List<String[]> list = mats = function.getCommentBefore() == null ? null : RegexUtils.find(function.getCommentBefore(), manglingCommentPattern);
        if (mats != null && !mats.isEmpty()) {
            for (String[] mat : mats) {
                names.add(mat[1]);
            }
        } else {
            for (CPlusPlusMangler mangler : this.result.config.cPlusPlusManglers) {
                try {
                    names.add(mangler.mangle(function, this.result));
                }
                catch (Exception ex) {
                    System.err.println("Error in mangling of '" + function.computeSignature(true) + "' : " + ex);
                    ex.printStackTrace();
                }
            }
        }
    }

    private void collectParamComments(Function f) {
        for (Arg arg : f.getArgs()) {
            arg.moveAllCommentsBefore();
            TypeRef argType = arg.getValueType();
            if (argType != null) {
                if (!this.result.config.noComments) {
                    argType.moveAllCommentsBefore();
                    arg.addToCommentBefore(argType.getCommentBefore());
                }
                argType.stripDetails();
            }
            if (arg.getCommentBefore() == null) continue;
            if (!this.result.config.noComments) {
                f.addToCommentBefore("@param " + arg.getName() + " " + Element.cleanComment(arg.getCommentBefore()));
            }
            arg.stripDetails();
        }
    }

    public void convertFunctions(List<Function> functions, Signatures signatures, DeclarationsHolder out, Identifier libraryClassName) {
        if (functions != null) {
            for (Function function : functions) {
                this.convertFunction(function, signatures, false, out, libraryClassName);
            }
        }
    }

    public Identifier getActualTaggedTypeName(TypeRef.TaggedTypeRef struct) {
        Element structName = null;
        Identifier tag = struct.getTag();
        if (tag == null || tag.isPlain() && tag.toString().startsWith("_")) {
            String better;
            Pair<StoredDeclarations.TypeDef, Declarator> pair;
            StoredDeclarations.TypeDef parentDef = SyntaxUtils.as(struct.getParentElement(), StoredDeclarations.TypeDef.class);
            if (parentDef != null) {
                structName = new Identifier.SimpleIdentifier(JNAeratorUtils.findBestPlainStorageName(parentDef), new Expression[0]);
            } else if (tag != null && (pair = this.result.typeDefs.get(better = tag.toString().substring(1))) != null && pair.getFirst().getValueType() != null && pair.getSecond() instanceof Declarator.DirectDeclarator) {
                TypeRef tr = pair.getFirst().getValueType();
                Declarator.DirectDeclarator dd = (Declarator.DirectDeclarator)pair.getSecond();
                if (tr instanceof TypeRef.SimpleTypeRef) {
                    if (tag.equals(((TypeRef.SimpleTypeRef)tr).getName())) {
                        structName = ElementsHelper.ident(dd.resolveName());
                    }
                } else if (tr instanceof TypeRef.TaggedTypeRef && tag.equals(((TypeRef.TaggedTypeRef)tr).getTag())) {
                    structName = ElementsHelper.ident(dd.resolveName());
                }
            }
        }
        if (structName == null || structName.toString().equals("")) {
            structName = tag;
        }
        return structName == null ? null : ((Identifier)structName).clone();
    }

    public Struct convertStruct(Struct struct, Signatures signatures, Identifier callerLibraryClass, boolean onlyFields) throws IOException {
        if (this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
            return this.convertStructToBridJ(struct, signatures, callerLibraryClass, onlyFields);
        }
        return this.convertStructToJNA(struct, signatures, callerLibraryClass, onlyFields);
    }

    public Struct convertStructToJNA(Struct struct, Signatures signatures, Identifier callerLibraryClass, boolean onlyFields) throws IOException {
        Identifier structName = this.getActualTaggedTypeName(struct);
        if (structName == null) {
            return null;
        }
        if (struct.isForwardDeclaration()) {
            return null;
        }
        if (!signatures.classSignatures.add(structName)) {
            return null;
        }
        boolean isUnion = struct.getType() == Struct.Type.CUnion;
        boolean inheritsFromStruct = false;
        Identifier baseClass = null;
        if (!onlyFields) {
            if (!struct.getParents().isEmpty()) {
                for (TypeRef.SimpleTypeRef parentName : struct.getParents()) {
                    Struct parent = this.result.structsByName.get(parentName.getName());
                    if (parent == null || (baseClass = this.result.getTaggedTypeIdentifierInJava(parent)) == null) continue;
                    inheritsFromStruct = true;
                    break;
                }
            }
            if (baseClass == null) {
                Class c = isUnion ? this.result.config.runtime.unionClass : this.result.config.runtime.structClass;
                baseClass = this.result.config.runtime != JNAeratorConfig.Runtime.JNA ? ElementsHelper.ident(c, ElementsHelper.expr(ElementsHelper.typeRef(structName.clone())), ElementsHelper.expr(ElementsHelper.typeRef(ElementsHelper.ident(structName.clone(), "ByValue"))), ElementsHelper.expr(ElementsHelper.typeRef(ElementsHelper.ident(structName.clone(), "ByReference")))) : ElementsHelper.ident(c, new Expression[0]);
            }
        }
        Struct structJavaClass = this.publicStaticClass(structName, baseClass, Struct.Type.JavaClass, struct, new Identifier[0]);
        int[] iChild = new int[]{0};
        Signatures childSignatures = new Signatures();
        for (Declaration d : struct.getDeclarations()) {
            if (d instanceof VariablesDeclaration) {
                this.convertVariablesDeclaration((VariablesDeclaration)d, structJavaClass, iChild, structName, callerLibraryClass);
                continue;
            }
            if (onlyFields) continue;
            if (d instanceof TaggedTypeRefDeclaration) {
                TypeRef.TaggedTypeRef tr = ((TaggedTypeRefDeclaration)d).getTaggedTypeRef();
                if (tr instanceof Struct) {
                    this.outputConvertedStruct((Struct)tr, childSignatures, structJavaClass, callerLibraryClass, false);
                    continue;
                }
                if (!(tr instanceof Enum)) continue;
                this.convertEnum((Enum)tr, childSignatures, structJavaClass, callerLibraryClass);
                continue;
            }
            if (d instanceof StoredDeclarations.TypeDef) {
                StoredDeclarations.TypeDef td = (StoredDeclarations.TypeDef)d;
                TypeRef tr = td.getValueType();
                if (tr instanceof Struct) {
                    this.outputConvertedStruct((Struct)tr, childSignatures, structJavaClass, callerLibraryClass, false);
                    continue;
                }
                if (!(tr instanceof TypeRef.FunctionSignature)) continue;
                this.convertCallback((TypeRef.FunctionSignature)tr, childSignatures, structJavaClass, callerLibraryClass);
                continue;
            }
            if (!this.result.config.genCPlusPlus || !(d instanceof Function)) continue;
            Function f = (Function)d;
            String library = this.result.getLibrary(struct);
            if (library == null) continue;
            ArrayList<Declaration> decls = new ArrayList<Declaration>();
            this.convertFunction(f, childSignatures, false, new DeclarationsHolder.ListWrapper(decls), callerLibraryClass);
            for (Declaration md : decls) {
                if (!(md instanceof Function)) continue;
                Function method = (Function)md;
                Identifier methodImplName = method.getName().clone();
                Identifier methodName = this.result.typeConverter.getValidJavaMethodName(f.getName());
                method.setName(methodName);
                ArrayList<Expression> args = new ArrayList<Expression>();
                boolean isStatic = Modifier.Static.isContainedBy(f.getModifiers());
                int iArg = 0;
                for (Arg arg : new ArrayList<Arg>(method.getArgs())) {
                    if (iArg == 0 && !isStatic) {
                        arg.replaceBy(null);
                        args.add(ElementsHelper.thisRef());
                    } else {
                        args.add(ElementsHelper.varRef(arg.getName()));
                    }
                    ++iArg;
                }
                Expression.FunctionCall implCall = ElementsHelper.methodCall(this.result.getLibraryInstanceReferenceExpression(library), Expression.MemberRefStyle.Dot, methodImplName.toString(), args.toArray(new Expression[args.size()]));
                method.setBody(ElementsHelper.block("void".equals(String.valueOf(method.getValueType())) ? ElementsHelper.stat(implCall) : new Statement.Return(implCall)));
                method.addModifiers(Modifier.Public, isStatic ? Modifier.Static : null);
                structJavaClass.addDeclaration(method);
            }
        }
        if (!onlyFields) {
            if (this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.StructConstructors)) {
                this.addStructConstructors(structName, structJavaClass, struct);
            }
            Struct byRef = this.publicStaticClass(ElementsHelper.ident("ByReference"), structName, Struct.Type.JavaClass, null, ElementsHelper.ident(ElementsHelper.ident(this.result.config.runtime.structClass, new Expression[0]), "ByReference"));
            Struct byVal = this.publicStaticClass(ElementsHelper.ident("ByValue"), structName, Struct.Type.JavaClass, null, ElementsHelper.ident(ElementsHelper.ident(this.result.config.runtime.structClass, new Expression[0]), "ByValue"));
            if (this.result.config.runtime != JNAeratorConfig.Runtime.JNA) {
                if (!inheritsFromStruct) {
                    structJavaClass.addDeclaration(this.createNewStructMethod("newByReference", byRef));
                    structJavaClass.addDeclaration(this.createNewStructMethod("newByValue", byVal));
                }
                structJavaClass.addDeclaration(this.createNewStructMethod("newInstance", structJavaClass));
                structJavaClass.addDeclaration(this.createNewStructArrayMethod(structJavaClass, isUnion));
            }
            structJavaClass.addDeclaration(ElementsHelper.decl(byRef));
            structJavaClass.addDeclaration(ElementsHelper.decl(byVal));
        }
        return structJavaClass;
    }

    public int countFieldsInStruct(Struct s) throws UnsupportedConversionException {
        int count = 0;
        for (Declaration declaration : s.getDeclarations()) {
            if (!(declaration instanceof VariablesDeclaration)) continue;
            count += ((VariablesDeclaration)declaration).getDeclarators().size();
        }
        for (TypeRef.SimpleTypeRef parentName : s.getParents()) {
            Struct parent = this.result.structsByName.get(parentName.getName());
            if (parent == null) {
                throw new UnsupportedConversionException(s, "Cannot find parent " + parentName + " of struct " + s);
            }
            count += this.countFieldsInStruct(parent);
        }
        return count;
    }

    public Struct convertStructToBridJ(Struct struct, Signatures signatures, Identifier callerLibraryClass, boolean onlyFields) throws IOException {
        Identifier structName = this.getActualTaggedTypeName(struct);
        if (structName == null) {
            return null;
        }
        if (struct.isForwardDeclaration()) {
            return null;
        }
        if (!signatures.classSignatures.add(structName)) {
            return null;
        }
        boolean isUnion = struct.getType() == Struct.Type.CUnion;
        boolean inheritsFromStruct = false;
        Identifier baseClass = null;
        int parentFieldsCount = 0;
        ArrayList<String> preComments = new ArrayList<String>();
        for (TypeRef.SimpleTypeRef parentName : struct.getParents()) {
            Struct parent = this.result.structsByName.get(parentName.getName());
            if (parent == null) continue;
            try {
                parentFieldsCount += this.countFieldsInStruct(struct);
            }
            catch (UnsupportedConversionException ex) {
                preComments.add("Error: " + ex);
            }
            if ((baseClass = this.result.getTaggedTypeIdentifierInJava(parent)) == null) continue;
            inheritsFromStruct = true;
            break;
        }
        boolean hasMemberFunctions = false;
        for (Declaration d : struct.getDeclarations()) {
            if (!(d instanceof Function)) continue;
            hasMemberFunctions = true;
            break;
        }
        if (baseClass == null) {
            switch (struct.getType()) {
                case CStruct: 
                case CUnion: {
                    if (!hasMemberFunctions) {
                        baseClass = ElementsHelper.ident(StructObject.class, new Expression[0]);
                        break;
                    }
                }
                case CPPClass: {
                    baseClass = ElementsHelper.ident(CPPObject.class, new Expression[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        Struct structJavaClass = this.publicStaticClass(structName, baseClass, Struct.Type.JavaClass, struct, new Identifier[0]);
        structJavaClass.addToCommentBefore(preComments);
        int[] iChild = new int[]{parentFieldsCount};
        Signatures childSignatures = new Signatures();
        structJavaClass.addDeclaration(new Function(Function.Type.JavaMethod, ElementsHelper.ident(structName, new Identifier[0]), null).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall("super", new Expression[0])))).addModifiers(Modifier.Public));
        String ptrName = "pointer";
        structJavaClass.addDeclaration(new Function(Function.Type.JavaMethod, ElementsHelper.ident(structName, new Identifier[0]), null, new Arg(ptrName, ElementsHelper.typeRef(this.result.config.runtime.pointerClass))).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall("super", ElementsHelper.varRef(ptrName))))).addModifiers(Modifier.Public));
        int iVirtual = 0;
        for (Declaration d : struct.getDeclarations()) {
            if (isUnion) {
                iChild[0] = 0;
            }
            if (d instanceof VariablesDeclaration) {
                this.convertVariablesDeclaration((VariablesDeclaration)d, structJavaClass, iChild, structName, callerLibraryClass);
                continue;
            }
            if (onlyFields) continue;
            if (d instanceof TaggedTypeRefDeclaration) {
                TypeRef.TaggedTypeRef tr = ((TaggedTypeRefDeclaration)d).getTaggedTypeRef();
                if (tr instanceof Struct) {
                    this.outputConvertedStruct((Struct)tr, childSignatures, structJavaClass, callerLibraryClass, false);
                    continue;
                }
                if (!(tr instanceof Enum)) continue;
                this.convertEnum((Enum)tr, childSignatures, structJavaClass, callerLibraryClass);
                continue;
            }
            if (d instanceof StoredDeclarations.TypeDef) {
                StoredDeclarations.TypeDef td = (StoredDeclarations.TypeDef)d;
                TypeRef tr = td.getValueType();
                if (tr instanceof Struct) {
                    this.outputConvertedStruct((Struct)tr, childSignatures, structJavaClass, callerLibraryClass, false);
                    continue;
                }
                if (!(tr instanceof TypeRef.FunctionSignature)) continue;
                this.convertCallback((TypeRef.FunctionSignature)tr, childSignatures, structJavaClass, callerLibraryClass);
                continue;
            }
            if (this.result.config.runtime != JNAeratorConfig.Runtime.BridJ && !this.result.config.genCPlusPlus || !(d instanceof Function)) continue;
            Function f = (Function)d;
            List<Modifier> modifiers = f.getModifiers();
            boolean isVirtual = Modifier.Virtual.isContainedBy(modifiers);
            String library = this.result.getLibrary(struct);
            if (library == null) continue;
            ArrayList<Declaration> decls = new ArrayList<Declaration>();
            this.convertFunction(f, childSignatures, false, new DeclarationsHolder.ListWrapper(decls), callerLibraryClass);
            for (Declaration md : decls) {
                if (!(md instanceof Function)) continue;
                Function method = (Function)md;
                if (isVirtual) {
                    method.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Virtual), ElementsHelper.expr(iVirtual)));
                }
                structJavaClass.addDeclaration(method);
            }
            if (!isVirtual) continue;
            ++iVirtual;
        }
        return structJavaClass;
    }

    void outputConvertedStruct(Struct struct, Signatures signatures, DeclarationsHolder out, Identifier callerLibraryClass, boolean onlyFields) throws IOException {
        Struct structJavaClass = this.convertStruct(struct, signatures, callerLibraryClass, onlyFields);
        if (structJavaClass == null) {
            return;
        }
        if (this.result.config.putTopStructsInSeparateFiles && struct.findParentOfType(Struct.class) == null) {
            String library = this.result.getLibrary(struct);
            Identifier javaPackage = this.result.getLibraryPackage(library);
            Identifier fullClassName = ElementsHelper.ident(javaPackage, structJavaClass.getTag().clone());
            if (this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
                structJavaClass.addAnnotation(new Annotation(Library.class, ElementsHelper.expr(library)));
            }
            structJavaClass.removeModifiers(Modifier.Static);
            structJavaClass = this.result.notifyBeforeWritingClass(fullClassName, structJavaClass, signatures, library);
            if (structJavaClass != null) {
                PrintWriter pout = this.result.classOutputter.getClassSourceWriter(fullClassName.toString());
                this.result.printJavaClass(javaPackage, structJavaClass, pout);
                pout.close();
            }
        } else {
            out.addDeclaration(ElementsHelper.decl(structJavaClass));
        }
    }

    public boolean isVirtual(Struct struct) {
        Identifier name = this.getActualTaggedTypeName(struct);
        Boolean bVirtual = this.structsVirtuality.get(name);
        if (bVirtual == null) {
            boolean hasVirtualParent = false;
            boolean hasVirtualMembers = false;
            for (TypeRef.SimpleTypeRef parentName : struct.getParents()) {
                Struct parentStruct = this.result.structsByName.get(parentName.getName());
                if (parentStruct == null) {
                    if (!this.result.config.verbose) continue;
                    System.out.println("Failed to resolve parent '" + parentName + "' for struct '" + name + "'");
                    continue;
                }
                if (!this.isVirtual(parentStruct)) continue;
                hasVirtualParent = true;
                break;
            }
            for (Declaration mb : struct.getDeclarations()) {
                if (!Modifier.Virtual.isContainedBy(mb.getModifiers())) continue;
                hasVirtualMembers = true;
                break;
            }
            bVirtual = hasVirtualMembers && !hasVirtualParent;
            this.structsVirtuality.put(name, bVirtual);
        }
        return bVirtual;
    }

    private Function createNewStructMethod(String name, Struct byRef) {
        TypeRef.SimpleTypeRef tr = ElementsHelper.typeRef(byRef.getTag().clone());
        Function f = new Function(Function.Type.JavaMethod, ElementsHelper.ident(name), tr);
        String varName = "s";
        f.addModifiers(Modifier.Protected);
        if (this.result.config.runtime != JNAeratorConfig.Runtime.JNA) {
            f.setBody(ElementsHelper.block(new Statement.Return(new Expression.New(((TypeRef)tr).clone(), ElementsHelper.methodCall(null, new Expression[0])))).setCompact(true));
        } else {
            f.setBody(ElementsHelper.block(ElementsHelper.stat(((TypeRef)tr).clone(), varName, new Expression.New(((TypeRef)tr).clone(), ElementsHelper.methodCall(null, new Expression[0]))), ElementsHelper.stat(ElementsHelper.methodCall(ElementsHelper.varRef(varName), Expression.MemberRefStyle.Dot, "useMemory", ElementsHelper.methodCall("getPointer", new Expression[0]))), ElementsHelper.stat(ElementsHelper.methodCall("write", new Expression[0])), ElementsHelper.stat(ElementsHelper.methodCall(ElementsHelper.varRef(varName), Expression.MemberRefStyle.Dot, "read", new Expression[0])), new Statement.Return(ElementsHelper.varRef(varName))));
        }
        return f;
    }

    private Function createNewStructArrayMethod(Struct struct, boolean isUnion) {
        if (this.result.config.runtime == JNAeratorConfig.Runtime.JNA) {
            return null;
        }
        TypeRef.SimpleTypeRef tr = ElementsHelper.typeRef(struct.getTag().clone());
        TypeRef.ArrayRef ar = new TypeRef.ArrayRef((TypeRef)tr, new Expression[0]);
        String varName = "arrayLength";
        Function f = new Function(Function.Type.JavaMethod, ElementsHelper.ident("newArray"), (TypeRef)ar, new Arg(varName, ElementsHelper.typeRef(Integer.TYPE)));
        f.addModifiers(Modifier.Public, Modifier.Static);
        f.setBody(ElementsHelper.block(new Statement.Return(ElementsHelper.methodCall(ElementsHelper.expr(ElementsHelper.typeRef(isUnion ? this.result.config.runtime.unionClass : this.result.config.runtime.structClass)), Expression.MemberRefStyle.Dot, "newArray", this.result.typeConverter.typeLiteral(tr), ElementsHelper.varRef(varName)))));
        return f;
    }

    public void convertStructs(List<Struct> structs, Signatures signatures, DeclarationsHolder out, Identifier libraryClassName) throws IOException {
        if (structs != null) {
            for (Struct struct : structs) {
                if (struct.findParentOfType(Struct.class) != null) continue;
                this.outputConvertedStruct(struct, signatures, out, libraryClassName, false);
            }
        }
    }

    public VariablesDeclaration convertVariablesDeclarationToJNA(String name, TypeRef mutatedType, int[] iChild, Identifier callerLibraryName, Element ... toImportDetailsFrom) throws UnsupportedConversionException {
        name = this.result.typeConverter.getValidJavaArgumentName(ElementsHelper.ident(name)).toString();
        Expression.NewArray initVal = null;
        TypeRef javaType = this.result.typeConverter.convertTypeToJNA(mutatedType, TypeConversion.TypeConversionMode.FieldType, callerLibraryName);
        mutatedType = this.result.typeConverter.resolveTypeDef(mutatedType, callerLibraryName, true);
        VariablesDeclaration convDecl = new VariablesDeclaration();
        convDecl.addModifiers(Modifier.Public);
        if (javaType instanceof TypeRef.ArrayRef && mutatedType instanceof TypeRef.ArrayRef) {
            TypeRef.ArrayRef mr = (TypeRef.ArrayRef)mutatedType;
            TypeRef.ArrayRef jr = (TypeRef.ArrayRef)javaType;
            Expression mul = null;
            List<Expression> dims = mr.flattenDimensions();
            int i = dims.size();
            while (i-- != 0) {
                Expression x = dims.get(i);
                if (x == null || x instanceof Expression.EmptyArraySize) {
                    jr = new TypeRef.ArrayRef(ElementsHelper.typeRef(TypeRef.Pointer.class), new Expression[0]);
                    javaType = jr;
                    break;
                }
                Pair<Expression, TypeRef> c = this.result.typeConverter.convertExpressionToJava(x, callerLibraryName, false);
                c.getFirst().setParenthesis(dims.size() == 1);
                if (mul == null) {
                    mul = c.getFirst();
                    continue;
                }
                mul = ElementsHelper.expr(c.getFirst(), Expression.BinaryOperator.Multiply, mul);
            }
            initVal = new Expression.NewArray(jr.getTarget(), mul);
        }
        if (javaType == null) {
            throw new UnsupportedConversionException(mutatedType, "failed to convert type to Java");
        }
        if (javaType.toString().equals("void")) {
            throw new UnsupportedConversionException(mutatedType, "void type !");
        }
        for (Element e : toImportDetailsFrom) {
            convDecl.importDetails(e, false);
        }
        convDecl.importDetails(mutatedType, true);
        convDecl.importDetails(javaType, true);
        convDecl.moveAllCommentsBefore();
        convDecl.setValueType(javaType);
        convDecl.addDeclarator(new Declarator.DirectDeclarator(name, initVal));
        return convDecl;
    }

    public List<Declaration> convertVariablesDeclarationToBridJ(String name, TypeRef mutatedType, int[] iChild, int bits, Identifier holderName, Identifier callerLibraryName, Element ... toImportDetailsFrom) throws UnsupportedConversionException {
        name = this.result.typeConverter.getValidJavaArgumentName(ElementsHelper.ident(name)).toString();
        int fieldIndex = iChild[0];
        TypeConversion.NL4JConversion conv = this.result.typeConverter.convertTypeToNL4J(mutatedType, callerLibraryName, ElementsHelper.thisField("io"), ElementsHelper.varRef(name), fieldIndex, bits);
        if (conv == null) {
            throw new UnsupportedConversionException(mutatedType, "failed to convert type to Java");
        }
        if ("void".equals(String.valueOf(conv.typeRef))) {
            throw new UnsupportedConversionException(mutatedType, "void type !");
        }
        Function convDecl = new Function();
        conv.annotateTypedType(convDecl);
        convDecl.setType(Function.Type.JavaMethod);
        convDecl.addModifiers(Modifier.Public);
        if (conv.arrayLengths != null) {
            convDecl.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Length), "({" + StringUtils.implode(conv.arrayLengths, (Object)", ") + "})"));
        }
        if (conv.bits != null) {
            convDecl.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Bits), conv.bits));
        }
        if (conv.byValue) {
            convDecl.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.ByValue), new Expression[0]));
        }
        for (Element e : toImportDetailsFrom) {
            convDecl.importDetails(e, false);
        }
        convDecl.importDetails(mutatedType, true);
        convDecl.moveAllCommentsBefore();
        convDecl.setName(ElementsHelper.ident(name));
        convDecl.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Field), ElementsHelper.expr(fieldIndex)));
        convDecl.setValueType(conv.typeRef);
        TypeRef javaType = convDecl.getValueType();
        String pointerGetSetMethodSuffix = StringUtils.capitalize(javaType.toString());
        ArrayList<Declaration> out = new ArrayList<Declaration>();
        if (conv.getExpr != null) {
            Function getter = convDecl.clone();
            getter.setBody(ElementsHelper.block(new Statement.Return(conv.getExpr)));
            out.add(getter);
        }
        if (!conv.readOnly && conv.setExpr != null) {
            Function setter = convDecl.clone();
            setter.setValueType(ElementsHelper.typeRef(holderName.clone()));
            setter.addArg(new Arg(name, javaType));
            setter.setBody(ElementsHelper.block(ElementsHelper.stat(conv.setExpr), new Statement.Return(ElementsHelper.thisRef())));
            out.add(setter);
            if (this.result.config.scalaStructSetters) {
                setter = new Function();
                setter.setType(Function.Type.JavaMethod);
                setter.setName(ElementsHelper.ident(name + "_$eq"));
                setter.setValueType(javaType.clone());
                setter.addArg(new Arg(name, javaType.clone()));
                setter.addModifiers(Modifier.Public, Modifier.Final);
                setter.setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall(name, ElementsHelper.varRef(name))), new Statement.Return(ElementsHelper.varRef(name))));
                out.add(setter);
            }
        }
        return out;
    }

    public void convertVariablesDeclaration(VariablesDeclaration v, DeclarationsHolder out, int[] iChild, Identifier holderName, Identifier callerLibraryClass) {
        if (this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
            this.convertVariablesDeclarationToBridJ(v, out, iChild, holderName, callerLibraryClass);
        } else {
            this.convertVariablesDeclarationToJNA(v, out, iChild, callerLibraryClass);
        }
    }

    public void convertVariablesDeclarationToBridJ(VariablesDeclaration v, DeclarationsHolder out, int[] iChild, Identifier holderName, Identifier callerLibraryClass) {
        block9: {
            try {
                TypeRef valueType = v.getValueType();
                for (Declarator vs : v.getDeclarators()) {
                    String name = vs.resolveName();
                    if (name == null || name.length() == 0) {
                        name = "anonymous" + this.nextAnonymousFieldId++;
                    }
                    TypeRef mutatedType = valueType;
                    if (!(vs instanceof Declarator.DirectDeclarator)) {
                        mutatedType = (TypeRef)vs.mutateType(valueType);
                        vs = new Declarator.DirectDeclarator(vs.resolveName());
                    }
                    Declarator d = v.getDeclarators().get(0);
                    List<Declaration> vds = this.convertVariablesDeclarationToBridJ(name, mutatedType, iChild, d.getBits(), holderName, callerLibraryClass, v, vs);
                    if (d.getBits() > 0) {
                        for (Declaration vd : vds) {
                            vd.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Bits), ElementsHelper.expr(d.getBits())));
                        }
                    }
                    for (Declaration vd : vds) {
                        vd.importDetails(mutatedType, true);
                        vd.moveAllCommentsBefore();
                        if (!(mutatedType instanceof TypeRef.Primitive) && !this.result.config.noComments) {
                            vd.addToCommentBefore("C type : " + mutatedType);
                        }
                        out.addDeclaration(vd);
                    }
                    iChild[0] = iChild[0] + 1;
                }
            }
            catch (UnsupportedConversionException e) {
                if (this.result.config.limitComments) break block9;
                out.addDeclaration(new EmptyDeclaration(e.toString()));
            }
        }
    }

    public void convertVariablesDeclarationToJNA(VariablesDeclaration v, DeclarationsHolder out, int[] iChild, Identifier callerLibraryClass) {
        block12: {
            try {
                TypeRef valueType = v.getValueType();
                for (Declarator vs : v.getDeclarators()) {
                    VariablesDeclaration vd;
                    String name = vs.resolveName();
                    if (name == null || name.length() == 0) {
                        name = "anonymous" + this.nextAnonymousFieldId++;
                    }
                    TypeRef mutatedType = valueType;
                    if (!(vs instanceof Declarator.DirectDeclarator)) {
                        mutatedType = (TypeRef)vs.mutateType(valueType);
                        vs = new Declarator.DirectDeclarator(vs.resolveName());
                    }
                    if ((vd = this.convertVariablesDeclarationToJNA(name, mutatedType, iChild, callerLibraryClass, v, vs)) != null) {
                        Declarator d = v.getDeclarators().get(0);
                        if (d.getBits() > 0) {
                            String st;
                            int bits = d.getBits();
                            if (!this.result.config.runtime.hasBitFields) {
                                throw new UnsupportedConversionException(d, "This runtime does not support bit fields : " + (Object)((Object)this.result.config.runtime));
                            }
                            vd.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Bits), ElementsHelper.expr(bits)));
                            String mst = st = vd.getValueType().toString();
                            if (st.equals("int") || st.equals("long") || st.equals("short") || st.equals("long")) {
                                mst = bits <= 8 ? "byte" : (bits <= 16 ? "short" : (bits <= 32 ? "int" : "long"));
                            }
                            if (!st.equals(mst)) {
                                vd.setValueType(new TypeRef.Primitive(mst));
                            }
                        }
                        if (!(mutatedType instanceof TypeRef.Primitive) && !this.result.config.noComments) {
                            vd.addToCommentBefore("C type : " + mutatedType);
                        }
                        out.addDeclaration(vd);
                    }
                    if (this.result.config.beanStructs) {
                        out.addDeclaration(new Function(Function.Type.JavaMethod, ElementsHelper.ident("get" + StringUtils.capitalize(name)), vd.getValueType().clone()).setBody(ElementsHelper.block(new Statement.Return(ElementsHelper.varRef(name)))).addModifiers(Modifier.Public));
                        out.addDeclaration(new Function(Function.Type.JavaMethod, ElementsHelper.ident("set" + StringUtils.capitalize(name)), ElementsHelper.typeRef(Void.TYPE), new Arg(name, vd.getValueType().clone())).setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.expr(ElementsHelper.memberRef(ElementsHelper.thisRef(), Expression.MemberRefStyle.Dot, ElementsHelper.ident(name)), Expression.AssignmentOperator.Equal, ElementsHelper.varRef(name))))).addModifiers(Modifier.Public));
                    }
                    iChild[0] = iChild[0] + 1;
                }
            }
            catch (UnsupportedConversionException e) {
                if (this.result.config.limitComments) break block12;
                out.addDeclaration(new EmptyDeclaration(e.toString()));
            }
        }
    }

    TaggedTypeRefDeclaration publicStaticClassDecl(Identifier name, Identifier parentName, Struct.Type type, Element toCloneCommentsFrom, Identifier ... interfaces) {
        return ElementsHelper.decl(this.publicStaticClass(name, parentName, type, toCloneCommentsFrom, interfaces));
    }

    Struct publicStaticClass(Identifier name, Identifier parentName, Struct.Type type, Element toCloneCommentsFrom, Identifier ... interfaces) {
        Struct cl = new Struct();
        cl.setType(type);
        cl.setTag(name);
        if (parentName != null) {
            cl.setParents(ElementsHelper.typeRef(parentName));
        }
        if (type == Struct.Type.JavaInterface) {
            for (Identifier inter : interfaces) {
                cl.addParent(ElementsHelper.typeRef(inter));
            }
        } else {
            for (Identifier inter : interfaces) {
                cl.addProtocol(ElementsHelper.typeRef(inter));
            }
        }
        if (!this.result.config.noComments && toCloneCommentsFrom != null) {
            cl.importDetails(toCloneCommentsFrom, false);
            cl.moveAllCommentsBefore();
            cl.addToCommentBefore(this.getFileCommentContent(toCloneCommentsFrom));
        }
        cl.addModifiers(Modifier.Public, Modifier.Static);
        return cl;
    }

    public Pair<List<VariablesDeclaration>, List<VariablesDeclaration>> getParentAndOwnDeclarations(Struct structJavaClass, Struct nativeStruct) throws IOException {
        Pair<List<VariablesDeclaration>, List<VariablesDeclaration>> ret = new Pair<List<VariablesDeclaration>, List<VariablesDeclaration>>(new ArrayList(), new ArrayList());
        if (!nativeStruct.getParents().isEmpty()) {
            for (TypeRef.SimpleTypeRef parentName : nativeStruct.getParents()) {
                Struct parent = this.result.structsByName.get(parentName.getName());
                if (parent == null) continue;
                Struct parentJavaClass = this.convertStruct(parent, new Signatures(), null, true);
                Pair<List<VariablesDeclaration>, List<VariablesDeclaration>> parentDecls = this.getParentAndOwnDeclarations(parentJavaClass, parent);
                ret.getFirst().addAll((Collection<VariablesDeclaration>)parentDecls.getFirst());
                ret.getFirst().addAll((Collection<VariablesDeclaration>)parentDecls.getSecond());
            }
        }
        for (Declaration d : structJavaClass.getDeclarations()) {
            VariablesDeclaration vd;
            if (!(d instanceof VariablesDeclaration) || (vd = (VariablesDeclaration)d).getDeclarators().size() != 1 || !this.isField(vd)) continue;
            ret.getSecond().add(vd);
        }
        return ret;
    }

    private void addStructConstructors(Identifier structName, Struct structJavaClass, Struct nativeStruct) throws IOException {
        boolean isUnion;
        ArrayList<Declaration> initialMembers = new ArrayList<Declaration>(structJavaClass.getDeclarations());
        TreeSet<String> signatures = new TreeSet<String>();
        Function emptyConstructor = new Function(Function.Type.JavaMethod, structName.clone(), null).addModifiers(Modifier.Public);
        emptyConstructor.setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall("super", new Expression[0]))));
        this.addConstructor(structJavaClass, emptyConstructor);
        boolean bl = isUnion = nativeStruct.getType() == Struct.Type.CUnion;
        if (isUnion) {
            HashMap fieldsAndCommentsByTypeStr = new HashMap();
            for (Declaration d : initialMembers) {
                VariablesDeclaration vd;
                if (!(d instanceof VariablesDeclaration) || (vd = (VariablesDeclaration)d).getDeclarators().size() != 1) continue;
                String name = vd.getDeclarators().get(0).resolveName();
                TypeRef tr = vd.getValueType();
                if (!this.isField(vd)) continue;
                String trStr = tr.toString();
                Pair pair = (Pair)fieldsAndCommentsByTypeStr.get(trStr);
                if (pair == null) {
                    pair = new Pair(tr, new ArrayList());
                    fieldsAndCommentsByTypeStr.put(trStr, pair);
                }
                ((List)pair.getSecond()).add(new Pair<String, String>(vd.getCommentBefore(), name));
            }
            for (Pair pair : fieldsAndCommentsByTypeStr.values()) {
                ArrayList commentBits = new ArrayList();
                ArrayList nameBits = new ArrayList();
                for (Pair p : (List)pair.getValue()) {
                    if (p.getFirst() != null) {
                        commentBits.add(p.getFirst());
                    }
                    nameBits.add(p.getValue());
                }
                String name = StringUtils.implode(nameBits, (Object)"_or_");
                TypeRef tr = (TypeRef)pair.getFirst();
                Function unionValConstr = new Function(Function.Type.JavaMethod, structName.clone(), null, new Arg(name, tr.clone()));
                if (!this.result.config.noComments && !commentBits.isEmpty()) {
                    unionValConstr.addToCommentBefore("@param " + name + " " + StringUtils.implode(commentBits, (Object)", or "));
                }
                unionValConstr.addModifiers(Modifier.Public);
                Expression assignmentExpr = ElementsHelper.varRef(name);
                for (Pair p : (List)pair.getValue()) {
                    assignmentExpr = new Expression.AssignmentOp(ElementsHelper.memberRef(ElementsHelper.thisRef(), Expression.MemberRefStyle.Dot, ElementsHelper.ident((String)p.getValue())), Expression.AssignmentOperator.Equal, assignmentExpr);
                }
                unionValConstr.setBody(ElementsHelper.block(ElementsHelper.stat(ElementsHelper.methodCall("super", new Expression[0])), tr instanceof TypeRef.ArrayRef ? this.throwIfArraySizeDifferent(name) : null, ElementsHelper.stat(assignmentExpr), ElementsHelper.stat(ElementsHelper.methodCall("setType", this.result.typeConverter.getJavaClassLitteralExpression(tr)))));
                if (!signatures.add(unionValConstr.computeSignature(false))) continue;
                structJavaClass.addDeclaration(unionValConstr);
            }
        } else {
            String uname;
            String name;
            Function fieldsConstr = new Function(Function.Type.JavaMethod, structName.clone(), null);
            fieldsConstr.setBody(new Statement.Block()).addModifiers(Modifier.Public);
            Pair<List<VariablesDeclaration>, List<VariablesDeclaration>> decls = this.getParentAndOwnDeclarations(structJavaClass, nativeStruct);
            TreeMap<Integer, String> namesById = new TreeMap<Integer, String>();
            HashSet<String> names = new HashSet<String>();
            int iArg = 0;
            for (VariablesDeclaration vd : new CompoundCollection(decls.getFirst(), decls.getSecond())) {
                String name2 = this.chooseJavaArgName(vd.getDeclarators().get(0).resolveName(), iArg, names);
                namesById.put(vd.getId(), name2);
                fieldsConstr.addArg(new Arg(name2, vd.getValueType().clone()));
                ++iArg;
            }
            Expression.FunctionCall superCall = ElementsHelper.methodCall("super", new Expression[0]);
            for (VariablesDeclaration vd : decls.getFirst()) {
                name = vd.getDeclarators().get(0).resolveName();
                uname = (String)namesById.get(vd.getId());
                Struct parent = (Struct)vd.getParentElement();
                Identifier parentTgName = this.result.getTaggedTypeIdentifierInJava(parent);
                if (!this.result.config.noComments) {
                    fieldsConstr.addToCommentBefore("@param " + name + " @see " + parentTgName + "#" + vd.getDeclarators().get(0).resolveName());
                }
                superCall.addArgument(ElementsHelper.varRef(uname));
            }
            fieldsConstr.getBody().addStatement(ElementsHelper.stat(superCall));
            for (VariablesDeclaration vd : decls.getSecond()) {
                name = vd.getDeclarators().get(0).resolveName();
                uname = (String)namesById.get(vd.getId());
                if (!this.result.config.noComments && vd.getCommentBefore() != null) {
                    fieldsConstr.addToCommentBefore("@param " + uname + " " + vd.getCommentBefore());
                }
                if (vd.getValueType() instanceof TypeRef.ArrayRef) {
                    fieldsConstr.getBody().addStatement(this.throwIfArraySizeDifferent(uname));
                }
                fieldsConstr.getBody().addStatement(ElementsHelper.stat(new Expression.AssignmentOp(ElementsHelper.memberRef(ElementsHelper.thisRef(), Expression.MemberRefStyle.Dot, ElementsHelper.ident(name)), Expression.AssignmentOperator.Equal, ElementsHelper.varRef(uname))));
            }
            int nArgs = fieldsConstr.getArgs().size();
            if (nArgs == 0) {
                System.err.println("Struct with no field : " + structName);
            }
            if (nArgs > 0 && nArgs < this.result.config.maxConstructedFields && signatures.add(fieldsConstr.computeSignature(false))) {
                structJavaClass.addDeclaration(fieldsConstr);
            }
        }
    }

    private boolean isField(VariablesDeclaration vd) {
        List<Modifier> mods = vd.getModifiers();
        if (Modifier.Final.isContainedBy(mods)) {
            return false;
        }
        return vd.getValueType() != null && !vd.getValueType().toString().equals(VirtualTablePointer.class.getName());
    }

    Statement throwIfArraySizeDifferent(String varAndFieldName) {
        return new Statement.If(ElementsHelper.expr(ElementsHelper.memberRef(ElementsHelper.varRef(varAndFieldName), Expression.MemberRefStyle.Dot, "length"), Expression.BinaryOperator.IsDifferent, ElementsHelper.memberRef(ElementsHelper.memberRef(ElementsHelper.thisRef(), Expression.MemberRefStyle.Dot, varAndFieldName), Expression.MemberRefStyle.Dot, "length")), new Statement.Throw(new Expression.New(ElementsHelper.typeRef(IllegalArgumentException.class), ElementsHelper.expr("Wrong array size !"))), null);
    }

    void addConstructor(Struct s, Function f) {
        Identifier structName = this.getActualTaggedTypeName(s);
        f.setName(structName);
        s.addDeclaration(f);
    }

    String getFileCommentContent(File file, Element e) {
        if (file != null) {
            Struct parent;
            Function fc;
            String path = this.result.config.relativizeFileForSourceComments(file.getAbsolutePath());
            String inCategoryStr = "";
            if (e instanceof Function && (fc = (Function)e).getType() == Function.Type.ObjCMethod && (parent = SyntaxUtils.as(fc.getParentElement(), Struct.class)) != null && parent.getCategoryName() != null) {
                inCategoryStr = "from " + parent.getCategoryName() + " ";
            }
            return "<i>" + inCategoryStr + "native declaration : " + path + (e == null || e.getElementLine() < 0 ? "" : ":" + e.getElementLine()) + "</i>";
        }
        if (e != null && e.getElementLine() >= 0) {
            return "<i>native declaration : <input>:" + e.getElementLine() + "</i>";
        }
        return null;
    }

    String getFileCommentContent(Element e) {
        if (this.result.config.limitComments) {
            return null;
        }
        String f = Element.getFileOfAscendency(e);
        if (f == null && e != null && e.getElementLine() >= 0) {
            return "<i>native declaration : line " + e.getElementLine() + "</i>";
        }
        return f == null ? null : this.getFileCommentContent(new File(f), e);
    }

    public List<Define> reorderDefines(Collection<Define> defines) {
        ArrayList<Define> reordered = new ArrayList<Define>(defines.size());
        HashSet<Identifier> added = new HashSet<Identifier>();
        HashSet<Identifier> all = new HashSet<Identifier>();
        HashMap<String, Pair<Define, TreeSet<Identifier>>> pending = new HashMap<String, Pair<Define, TreeSet<Identifier>>>();
        for (Define define : defines) {
            TreeSet<Identifier> dependencies = new TreeSet<Identifier>();
            this.computeVariablesDependencies(define.getValue(), dependencies);
            all.add(ElementsHelper.ident(define.getName()));
            if (dependencies.isEmpty()) {
                reordered.add(define);
                added.add(ElementsHelper.ident(define.getName()));
                continue;
            }
            pending.put(define.getName(), new Pair<Define, TreeSet<Identifier>>(define, dependencies));
        }
        int i = 3;
        while (i-- != 0 && !pending.isEmpty()) {
            Iterator it = pending.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Set dependencies = (Set)((Pair)e.getValue()).getSecond();
                String name = (String)e.getKey();
                boolean missesDep = false;
                for (Identifier dependency : dependencies) {
                    if (added.contains(dependency)) continue;
                    missesDep = true;
                    if (all.contains(dependency)) break;
                    it.remove();
                    all.remove(name);
                    break;
                }
                if (missesDep) continue;
                it.remove();
                reordered.add((Define)((Pair)e.getValue()).getFirst());
            }
        }
        return reordered;
    }

    public void computeVariablesDependencies(Element e, final Set<Identifier> names) {
        e.accept(new Scanner(){

            @Override
            public void visitVariableRef(Expression.VariableRef variableRef) {
                names.add(variableRef.getName());
            }
        });
    }

    private String chooseJavaArgName(String name, int iArg, Set<String> names) {
        String argName;
        Identifier jan = this.result.typeConverter.getValidJavaArgumentName(ElementsHelper.ident(name));
        String baseArgName = jan == null ? null : jan.toString();
        int i = 1;
        if (baseArgName == null) {
            baseArgName = "arg";
        }
        do {
            argName = baseArgName + (i == 1 ? "" : i + "");
            ++i;
        } while (names.contains(argName) || this.result.typeConverter.isJavaKeyword(argName));
        names.add(argName);
        return argName;
    }

    public static class DeclarationsOutput {
        Map<String, DeclarationsHolder> holders = new HashMap<String, DeclarationsHolder>();

        public void add(Declaration d, String libraryName) {
        }

        public void set(String libraryName, DeclarationsHolder holder) {
        }
    }

    static class EnumItemResult {
        public Enum.EnumItem originalItem;
        public Expression value;
        public String comments;
        public String exceptionMessage;
        public Declaration errorElement;

        EnumItemResult() {
        }
    }
}

