/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.JNAeratorUtils;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierKind;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;

public class CToJavaPreScanner
extends Scanner {
    @Override
    public void visitStruct(Struct struct) {
        Element parent;
        super.visitStruct(struct);
        if (struct.isForwardDeclaration() && struct.getTag() != null && !((parent = struct.getParentElement()) instanceof TaggedTypeRefDeclaration)) {
            TypeRef.SimpleTypeRef tr = new TypeRef.SimpleTypeRef(struct.getTag());
            for (Modifier mod : struct.getModifiers()) {
                if (!mod.isA(ModifierKind.StorageClassSpecifier)) continue;
                ((TypeRef)tr).addModifiers(mod);
            }
            struct.replaceBy(tr);
            ((ModifiableElement)tr).accept(this);
        }
    }

    @Override
    public void visitFunctionSignature(TypeRef.FunctionSignature functionSignature) {
        super.visitFunctionSignature(functionSignature);
    }

    @Override
    public void visitTaggedTypeRefDeclaration(TaggedTypeRefDeclaration taggedTypeRefDeclaration) {
        super.visitTaggedTypeRefDeclaration(taggedTypeRefDeclaration);
        TypeRef.TaggedTypeRef tr = taggedTypeRefDeclaration.getTaggedTypeRef();
        if (tr != null) {
            String before = tr.getCommentBefore();
            tr.setCommentBefore(taggedTypeRefDeclaration.getCommentBefore());
            tr.addToCommentBefore(before);
            taggedTypeRefDeclaration.setCommentBefore(null);
        }
    }

    @Override
    public void visitTypeDef(StoredDeclarations.TypeDef v) {
        super.visitTypeDef(v);
        StoredDeclarations.TypeDef toAddAfter = v;
        TypeRef valueType = v.getValueType();
        String bestName = null;
        String origName = null;
        TypeRef.TaggedTypeRef ttr = null;
        if (valueType instanceof TypeRef.TaggedTypeRef) {
            ttr = (TypeRef.TaggedTypeRef)valueType;
            bestName = JNAeratorUtils.findBestPlainStorageName(v);
            if (bestName != null) {
                origName = ttr.getTag() != null ? ttr.getTag().toString() : null;
            }
        }
        for (Declarator vs : v.getDeclarators()) {
            if (vs == null) continue;
            String name = vs.resolveName();
            if (vs instanceof Declarator.DirectDeclarator && name.equals(bestName) && ttr != null && origName != null) {
                Declarator.DirectDeclarator rep = new Declarator.DirectDeclarator(origName);
                vs.replaceBy(rep);
                ttr.setTag(ElementsHelper.ident(bestName));
                vs = rep;
                name = origName;
            }
            StoredDeclarations.TypeDef decl = null;
            Declarator.MutableByDeclarator type = vs.mutateType(v.getValueType());
            if (!(type instanceof TypeRef)) continue;
            TypeRef tr = (TypeRef)type;
            decl = new StoredDeclarations.TypeDef(tr, new Declarator.DirectDeclarator(name, vs.getBits()));
            decl.importDetails(v, false);
            decl.importDetails(vs, false);
            decl.importDetails(tr, true);
            toAddAfter.insertSibling(decl, false);
            toAddAfter = decl;
        }
        if (toAddAfter != v) {
            v.replaceBy(null);
        }
    }

    @Override
    public void visitArg(Arg arg) {
        Declarator d = arg.getDeclarator();
        if (d != null && !(d instanceof Declarator.DirectDeclarator)) {
            Declarator.MutableByDeclarator type = d.mutateType(arg.getValueType());
            if (type instanceof TypeRef) {
                arg.setValueType((TypeRef)type);
                arg.setDeclarator(new Declarator.DirectDeclarator(d.resolveName(), d.getBits()));
            } else {
                Object var3_3 = null;
            }
        }
        super.visitArg(arg);
    }

    @Override
    public void visitVariablesDeclaration(VariablesDeclaration v) {
        super.visitVariablesDeclaration(v);
        Declaration toAddAfter = v;
        int nDecl = v.getDeclarators().size();
        for (Declarator vs : v.getDeclarators()) {
            if (vs == null || vs instanceof Declarator.DirectDeclarator && nDecl == 1) continue;
            Declaration decl = null;
            Declarator.MutableByDeclarator type = vs.mutateType(v.getValueType());
            if (type instanceof TypeRef) {
                TypeRef tr = (TypeRef)type;
                decl = new VariablesDeclaration(tr, new Declarator.DirectDeclarator(vs.resolveName(), vs.getBits()));
                decl.importDetails(v, false);
                decl.importDetails(vs, false);
                decl.importDetails(tr, true);
            } else if (type instanceof Function) {
                Function f = (Function)type;
                f.setName(new Identifier.SimpleIdentifier(vs.resolveName(), new Expression[0]));
                decl = (Function)type;
                decl.importDetails(v, false);
                decl.importDetails(vs, false);
            } else {
                if (!(type instanceof Declaration)) continue;
                decl = (Declaration)((Object)type);
            }
            toAddAfter.insertSibling(decl, false);
            toAddAfter = decl;
            decl.accept(this);
        }
        if (toAddAfter != v) {
            v.replaceBy(null);
        }
    }
}

