/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.JNAeratorParser;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ObjCDemanglingLexer;
import com.ochafik.lang.jnaerator.parser.ObjCDemanglingParser;
import com.ochafik.lang.jnaerator.parser.ObjCppParser;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.xml.XMLUtils;
import com.ochafik.xml.XPathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import javax.xml.xpath.XPathExpressionException;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BridgeSupportParser {
    final Result result;
    SourceFiles sourceFiles;

    public BridgeSupportParser(Result result, SourceFiles sourceFiles) {
        this.result = result;
        this.sourceFiles = sourceFiles;
    }

    public static void main(String[] args) {
        try {
            JNAeratorConfig config = new JNAeratorConfig();
            config.verbose = true;
            Result result = new Result(config, null, null);
            SourceFiles sourceFiles = new SourceFiles();
            File file = new File("/System/Library/Frameworks/Foundation.framework/Resources/BridgeSupport/FoundationFull.bridgesupport");
            new BridgeSupportParser(result, sourceFiles).parseBridgeSupportFile(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseBridgeSupportFiles() throws FileNotFoundException {
        SourceFiles sfs;
        block9: {
            block10: {
                sfs = new SourceFiles();
                try {
                    for (File bsf : this.result.config.bridgeSupportFiles) {
                        try {
                            sfs.add(this.parseBridgeSupportFile(bsf));
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.result.config.bridgesupportOutFile == null) break block9;
                    if (!this.result.config.verbose) break block10;
                    System.out.println("Writing bridgesupport definitions to " + this.result.config.bridgesupportOutFile.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    if (this.result.config.bridgesupportOutFile != null) {
                        if (this.result.config.verbose) {
                            System.out.println("Writing bridgesupport definitions to " + this.result.config.bridgesupportOutFile.getAbsolutePath());
                        }
                        PrintWriter pw = new PrintWriter(this.result.config.bridgesupportOutFile);
                        pw.println(sfs);
                        pw.close();
                    }
                    for (SourceFile sf : sfs.getSourceFiles()) {
                        this.sourceFiles.add(sf);
                    }
                    throw throwable;
                }
            }
            PrintWriter pw = new PrintWriter(this.result.config.bridgesupportOutFile);
            pw.println(sfs);
            pw.close();
        }
        for (SourceFile sf : sfs.getSourceFiles()) {
            this.sourceFiles.add(sf);
        }
    }

    private SourceFile parseBridgeSupportFile(File bsf) throws Exception {
        String framework = bsf.getName();
        if (framework.toLowerCase().endsWith(".bridgesupport")) {
            framework = framework.substring(0, framework.length() - ".bridgesupport".length());
        }
        Document xml = XMLUtils.readXML(bsf);
        String sourceFilePath = bsf.toString();
        Node signatures = XMLUtils.getFirstNamedNode(xml, "signatures");
        if (signatures == null) {
            return null;
        }
        SourceFile sf = new SourceFile();
        sf.setElementFile(sourceFilePath);
        this.parseStructs(signatures, sf);
        this.parseEnums(signatures, sf);
        this.parseConstants(signatures, sf);
        this.parseClasses(framework, signatures, sf);
        this.parseStringConstants(framework, signatures, sf);
        this.parseFunctions(framework, signatures, sf);
        return sf;
    }

    private void parseEnums(Node signatures, SourceFile sf) {
        for (Node en : XMLUtils.getChildrenByName(signatures, "enum")) {
            String name = XMLUtils.getAttribute(en, "name");
            String value = XMLUtils.getAttribute(en, "value");
            if (value == null) continue;
            try {
                try {
                    int i = value.matches(".*?\\.0+$") ? value.lastIndexOf(46) : -1;
                    String v = i > 0 ? value.substring(0, i) : value;
                    sf.addDeclaration(new VariablesDeclaration((TypeRef)ElementsHelper.typeRef("int").addModifiers(new Modifier[]{Modifier.Const}), new Declarator.DirectDeclarator(name, ElementsHelper.expr(Integer.parseInt(v)))));
                }
                catch (NumberFormatException fex) {
                    sf.addDeclaration(new VariablesDeclaration((TypeRef)ElementsHelper.typeRef("double").addModifiers(new Modifier[]{Modifier.Const}), new Declarator.DirectDeclarator(name, ElementsHelper.expr(Double.parseDouble(value)))));
                }
            }
            catch (Exception ex) {
                System.err.println("Parsing of enum " + name + " with value '" + value + "' failed : " + ex);
            }
        }
    }

    private void parseConstants(Node signatures, SourceFile sf) {
        for (Node cn : XMLUtils.getChildrenByName(signatures, "constant")) {
            String name = XMLUtils.getAttribute(cn, "name");
            try {
                TypeRef tr = this.parseType(cn);
                if (tr == null) continue;
                sf.addDeclaration(new VariablesDeclaration(tr.addModifiers(Modifier.Extern, Modifier.Const), new Declarator.DirectDeclarator(name)));
            }
            catch (Exception ex) {
                System.err.println("Parsing of constant " + name + " failed : " + ex);
            }
        }
    }

    private void parseClasses(String framework, Node signatures, SourceFile sf) throws XPathExpressionException {
        Struct cs;
        for (Node classe : XMLUtils.getChildrenByName(signatures, "class")) {
            cs = this.parseClasse(classe, Struct.Type.ObjCClass, sf);
            if (cs == null || "NSObject".equals(String.valueOf(cs.getTag().toString()))) continue;
            cs.setParents(ElementsHelper.typeRef(ElementsHelper.ident("NSObject")));
        }
        for (Node classe : XMLUtils.getChildrenByName(signatures, "informal_protocol")) {
            cs = this.parseClasse(classe, Struct.Type.ObjCClass, sf);
            if (cs == null) continue;
            cs.setCategoryName(cs.getTag() == null ? null : cs.getTag().toString());
            cs.setTag(ElementsHelper.ident("NSObject"));
        }
    }

    private Struct parseClasse(Node classe, Struct.Type type, SourceFile sf) throws XPathExpressionException {
        Struct cs = new Struct();
        cs.setType(type);
        String name = XMLUtils.getAttribute(classe, "name");
        if (this.result.config.verbose) {
            System.out.println("Parsing class " + name);
        }
        cs.setTag(ElementsHelper.ident(name));
        for (Node method : XPathUtils.findNodesIterableByXPath("method", classe)) {
            try {
                cs.addDeclaration(this.parseFunction(Function.Type.ObjCMethod, method, sf));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        sf.addDeclaration(new TaggedTypeRefDeclaration(cs));
        return cs;
    }

    private void parseFunctions(String framework, Node signatures, SourceFile sf) throws XPathExpressionException {
        for (Node function : XMLUtils.getChildrenByName(signatures, "function")) {
            String already_retained;
            String name = XMLUtils.getAttribute(function, "name");
            Node retval = XMLUtils.getFirstNamedNode(function, "retval");
            String string = already_retained = retval != null ? XMLUtils.getAttribute(retval, "already_retained") : null;
            if (already_retained != null && (already_retained = already_retained.trim()).length() > 0) {
                boolean alreadyRetained = "true".equals(already_retained);
                Result.getMap(this.result.retainedRetValFunctions, framework).put(name, alreadyRetained);
            }
            if ("true".equals(XMLUtils.getAttribute(function, "inline"))) continue;
            try {
                Function f = this.parseFunction(Function.Type.CFunction, function, sf);
                if (f == null) continue;
                sf.addDeclaration(f);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public TypeRef parseType(Node node) throws XPathExpressionException, RecognitionException, IOException {
        if (node == null) {
            return null;
        }
        TypeRef declaredType = null;
        try {
            String dt = XMLUtils.getAttribute(node, "declared_type");
            if (dt != null) {
                ObjCppParser parser = JNAeratorParser.newObjCppParser(this.result.typeConverter, dt, false);
                parser.setupSymbolsStack();
                declaredType = parser.mutableTypeRef();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TypeRef inferredType = null;
        if ((declaredType == null || declaredType instanceof TypeRef.SimpleTypeRef) && (inferredType = this.parseAndReconciliateType(XMLUtils.getAttribute(node, "type"), XMLUtils.getAttribute(node, "type64"))) != null && declaredType instanceof TypeRef.SimpleTypeRef && !inferredType.toString().equals(declaredType.toString())) {
            String sn = ((TypeRef.SimpleTypeRef)declaredType).getName().toString();
            this.result.addWeakTypeDef(inferredType.clone(), sn);
        }
        return declaredType != null ? declaredType : inferredType;
    }

    private Function parseFunction(Function.Type cfunction, Node function, SourceFile sf) throws XPathExpressionException, RecognitionException, IOException {
        TypeRef tr = this.parseType(XMLUtils.getFirstNamedNode(function, "retval"));
        String selector = XMLUtils.getAttribute(function, "selector");
        String[] splitSelector = selector == null ? null : selector.split(":");
        String name = XMLUtils.getAttribute(function, "name");
        if (name == null && splitSelector != null && splitSelector.length > 0) {
            name = splitSelector[0];
        }
        String type = XMLUtils.getAttribute(function, "type");
        String type64 = XMLUtils.getAttribute(function, "type64");
        Function methodType = null;
        if (type != null) {
            methodType = this.parseAndReconciliateMethods(type, type64);
            if (tr == null) {
                tr = methodType.getValueType();
            }
        }
        Function f = new Function(cfunction, ElementsHelper.ident(name), tr);
        String class_method = XMLUtils.getAttribute(function, "class_method");
        if ("true".equals(class_method)) {
            f.addModifiers(Modifier.Static);
        }
        int iArg = 0;
        for (Node arg : XMLUtils.getChildrenByName(function, "arg")) {
            TypeRef at = this.parseType(arg);
            if (at == null && methodType != null) {
                at = iArg < methodType.getArgs().size() ? methodType.getArgs().get(iArg).getValueType() : null;
            }
            if (at == null) {
                return null;
            }
            Arg a = new Arg();
            a.setName(XMLUtils.getAttribute(arg, "name"));
            a.setValueType(at);
            a.setSelector(splitSelector == null || iArg >= splitSelector.length ? null : splitSelector[iArg]);
            f.addArg(a);
            ++iArg;
        }
        return f;
    }

    TypeRef parseType(String mangled) throws RecognitionException, IOException {
        return BridgeSupportParser.newObjCDemangler(mangled, true).mangledTypeEOF();
    }

    Function parseMethod(String mangled) throws RecognitionException, IOException {
        return BridgeSupportParser.newObjCDemangler(mangled, true).methodType();
    }

    TypeRef parseAndReconciliateType(String mangled32, String mangled64) throws RecognitionException, IOException {
        if (mangled32 == null) {
            return null;
        }
        TypeRef tr32 = this.parseType(mangled32);
        if (mangled64 != null && mangled64.trim().length() > 0 && !mangled32.equals(mangled64)) {
            TypeRef tr64 = this.parseType(mangled64);
            try {
                return (TypeRef)this.result.universalReconciliator.reconciliate32bitsAnd64bits(tr32, tr64);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return tr32;
    }

    Function parseAndReconciliateMethods(String mangled32, String mangled64) throws RecognitionException, IOException {
        if (mangled32 == null) {
            return null;
        }
        Function tr32 = this.parseMethod(mangled32);
        if (mangled64 != null && mangled64.trim().length() > 0 && !mangled32.equals(mangled64)) {
            Function tr64 = this.parseMethod(mangled64);
            try {
                return (Function)this.result.universalReconciliator.reconciliate32bitsAnd64bits(tr32, tr64);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return tr32;
    }

    private void parseStructs(Node signatures, SourceFile sf) throws XPathExpressionException {
        for (Node function : XMLUtils.getChildrenByName(signatures, "struct")) {
            String name = XMLUtils.getAttribute(function, "name");
            String type32 = XMLUtils.getAttribute(function, "type");
            String type64 = XMLUtils.getAttribute(function, "type64");
            try {
                try {
                    TypeRef tr = this.parseAndReconciliateType(type32, type64);
                    StoredDeclarations.TypeDef td = new StoredDeclarations.TypeDef(tr, new Declarator.DirectDeclarator(name));
                    sf.addDeclaration(td);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static ObjCDemanglingParser newObjCDemangler(String s, final boolean verbose) throws IOException {
        return new ObjCDemanglingParser((TokenStream)new CommonTokenStream(new ObjCDemanglingLexer(new ANTLRReaderStream(new StringReader(s))))){

            @Override
            public void reportError(RecognitionException arg0) {
                if (verbose) {
                    super.reportError(arg0);
                }
            }
        };
    }

    private void parseStringConstants(String framework, Node signatures, SourceFile sf) throws XPathExpressionException {
        for (Node string_constant : XMLUtils.getChildrenByName(signatures, "string_constant")) {
            String name = XMLUtils.getAttribute(string_constant, "name");
            String value = XMLUtils.getAttribute(string_constant, "value");
            if (value == null) continue;
            Result.getMap(this.result.stringConstants, framework).put(name, value);
        }
    }
}

